#!/bin/sh
#####
# compare-version-test
#

compare(){
	testname=$1 ;
	echo "compare: ./${testname} ./OK/${testname}.OK"
	if diff ./${testname} ./OK/${testname}.OK ; then
		echo "ok" 
	else
		echo "diff" ; exit 1 ;
	fi
}

compare_version(){
	echo "perl ../src/compare-version"
	if perl ../src/compare-version $2 $3 ; then
		echo "$2 >= $3" | tee ./compare-version-test.result${1}
	else
		echo "$2 < $3" | tee ./compare-version-test.result${1}
	fi
	compare compare-version-test.result${1}
}

rm -f compare-version.result*

echo "perl ../src/compare-version"
perl ../src/compare-version 2>&1 | tee ./compare-version-test.result1
compare compare-version-test.result1

compare_version 2 0.0.0 0.0.0
compare_version 3 1.2.3 3.2.1
compare_version 4 10.0 9.999.999
compare_version 5 4 5

exit 0 ;

