/*****************************************************************************
 * pce                                                                       *
 *****************************************************************************/

/*****************************************************************************
 * File name:   src/arch/macplus/traps.c                                     *
 * Created:     2007-11-22 by Hampa Hug <hampa@hampa.ch>                     *
 * Copyright:   (C) 2007-2012 Hampa Hug <hampa@hampa.ch>                     *
 *****************************************************************************/

/*****************************************************************************
 * This program is free software. You can redistribute it and / or modify it *
 * under the terms of the GNU General Public License version 2 as  published *
 * by the Free Software Foundation.                                          *
 *                                                                           *
 * This program is distributed in the hope  that  it  will  be  useful,  but *
 * WITHOUT  ANY   WARRANTY,   without   even   the   implied   warranty   of *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  General *
 * Public License for more details.                                          *
 *****************************************************************************/


#include "main.h"
#include "traps.h"

#include <stdlib.h>


typedef struct {
	unsigned short trap;
	const char     *name;
} trap_list_t;


static
trap_list_t trap_list[] = {
	{ 0xa000, "Open" },
	{ 0xa001, "Close" },
	{ 0xa002, "Read" },
	{ 0xa003, "Write" },
	{ 0xa004, "Control" },
	{ 0xa005, "Status" },
	{ 0xa006, "KillIO" },
	{ 0xa007, "GetVolInfo" },
	{ 0xa008, "Create" },
	{ 0xa009, "Delete" },
	{ 0xa00a, "OpenRF" },
	{ 0xa00b, "Rename" },
	{ 0xa00c, "GetFileInfo" },
	{ 0xa00d, "SetFileInfo" },
	{ 0xa00e, "UnmountVol" },
	{ 0xa00f, "MountVol" },
	{ 0xa010, "Allocate" },
	{ 0xa011, "GetEOF" },
	{ 0xa012, "SetEOF" },
	{ 0xa013, "FlushVol" },
	{ 0xa014, "GetVol" },
	{ 0xa015, "SetVol" },
	{ 0xa016, "InitQueue" },
	{ 0xa017, "Eject" },
	{ 0xa018, "GetFPos" },
	{ 0xa019, "InitZone" },
	{ 0xa01a, "GetZone" },
	{ 0xa01b, "SetZone" },
	{ 0xa01c, "FreeMem" },
	{ 0xa01d, "MaxMem" },
	{ 0xa01e, "NewPtr" },
	{ 0xa01f, "DisposPtr" },
	{ 0xa020, "SetPtrSize" },
	{ 0xa021, "GetPtrSize" },
	{ 0xa022, "NewHandle" },
	{ 0xa023, "DisposHandle" },
	{ 0xa024, "SetHandleSize" },
	{ 0xa025, "GetHandleSize" },
	{ 0xa026, "HandleZone" },
	{ 0xa027, "ReallocHandle" },
	{ 0xa028, "RecoverHandle" },
	{ 0xa029, "HLock" },
	{ 0xa02a, "HUnlock" },
	{ 0xa02b, "EmptyHandle" },
	{ 0xa02c, "InitApplZone" },
	{ 0xa02d, "SetApplLimit" },
	{ 0xa02e, "BlockMove" },
	{ 0xa02f, "PostEvent" },
	{ 0xa030, "OSEventAvail" },
	{ 0xa031, "GetOSEvent" },
	{ 0xa032, "FlushEvents" },
	{ 0xa033, "VInstall" },
	{ 0xa034, "VRemove" },
	{ 0xa035, "Offline" },
	{ 0xa036, "MoreMasters" },
	{ 0xa038, "WriteParam" },
	{ 0xa039, "ReadDateTime" },
	{ 0xa03a, "SetDateTime" },
	{ 0xa03b, "Delay" },
	{ 0xa03c, "CmpString" },
	{ 0xa03d, "DrvrInstall" },
	{ 0xa03e, "DrvrRemove" },
	{ 0xa03f, "InitUtil" },
	{ 0xa040, "ResrvMem" },
	{ 0xa041, "SetFilLock" },
	{ 0xa042, "RstFilLock" },
	{ 0xa043, "SetFilType" },
	{ 0xa044, "SetFPos" },
	{ 0xa045, "FlushFile" },
	{ 0xa046, "GetTrapAddress" },
	{ 0xa047, "SetTrapAddress" },
	{ 0xa048, "PtrZone" },
	{ 0xa049, "HPurge" },
	{ 0xa04a, "HNoPurge" },
	{ 0xa04b, "SetGrowZone" },
	{ 0xa04c, "CompactMem" },
	{ 0xa04d, "PurgeMem" },
	{ 0xa04e, "AddDrive" },
	{ 0xa04f, "RDrvrInstall" },
	{ 0xa050, "RelString" },
	{ 0xa054, "UprString" },
	{ 0xa055, "StripAddress" },
	{ 0xa057, "SetAppBase" },
	{ 0xa058, "InsTime" },
	{ 0xa059, "RmvTime" },
	{ 0xa05a, "PrimeTime" },
	{ 0xa05d, "SwapMMUMode" },
	{ 0xa060, "HFSDispatch" },
	{ 0xa061, "MaxBlock" },
	{ 0xa062, "PurgeSpace" },
	{ 0xa063, "MaxApplZone" },
	{ 0xa064, "MoveHHi" },
	{ 0xa065, "StackSpace" },
	{ 0xa066, "NewEmptyHandle" },
	{ 0xa067, "HSetRBit" },
	{ 0xa068, "HClrRBit" },
	{ 0xa069, "HGetState" },
	{ 0xa06a, "HSetState" },
	{ 0xa06e, "SlotManager" },
	{ 0xa06f, "SlotVInstall" },
	{ 0xa070, "SlotVRemove" },
	{ 0xa071, "AttachVBL" },
	{ 0xa072, "DoVBLTask" },
	{ 0xa075, "SIntInstall" },
	{ 0xa076, "SIntRemove" },
	{ 0xa077, "CountADBs" },
	{ 0xa078, "GetIndADB" },
	{ 0xa079, "GetADBInfo" },
	{ 0xa07a, "SetADBInfo" },
	{ 0xa07b, "ADBReInit" },
	{ 0xa07c, "ADBOp" },
	{ 0xa07d, "GetDefaultStartup" },
	{ 0xa07e, "SetDefaultStartup" },
	{ 0xa07f, "InternalWait" },
	{ 0xa080, "GetVideoDefault" },
	{ 0xa081, "SetVideoDefault" },
	{ 0xa082, "DTInstall" },
	{ 0xa083, "SetOSDefault" },
	{ 0xa084, "GetOSDefault" },
	{ 0xa090, "SysEnvirons" },
	{ 0xa808, "InitProcMenu" },
	{ 0xa809, "GetCVariant" },
	{ 0xa80a, "GetWVariant" },
	{ 0xa80b, "PopUpMenuSelect" },
	{ 0xa80c, "RGetResource" },
	{ 0xa80d, "Count1Resources" },
	{ 0xa80e, "Get1IxResource" },
	{ 0xa80f, "Get1IxType" },
	{ 0xa810, "Unique1ID" },
	{ 0xa811, "TESelView" },
	{ 0xa812, "TEPinScroll" },
	{ 0xa813, "TEAutoView" },
	{ 0xa815, "SCSIDispatch" },
	{ 0xa816, "Pack8" },
	{ 0xa817, "CopyMask" },
	{ 0xa818, "FixAtan2" },
	{ 0xa81c, "Count1Types" },
	{ 0xa81f, "Get1Resource" },
	{ 0xa820, "Get1NamedResource" },
	{ 0xa821, "MaxSizeRsrc" },
	{ 0xa826, "InsMenuItem" },
	{ 0xa827, "HideDItem" },
	{ 0xa828, "ShowDItem" },
	{ 0xa82b, "Pack9" },
	{ 0xa82c, "Pack10" },
	{ 0xa82d, "Pack11" },
	{ 0xa82e, "Pack12" },
	{ 0xa82f, "Pack13" },
	{ 0xa830, "Pack14" },
	{ 0xa831, "Pack15" },
	{ 0xa834, "SetFScaleDisable" },
	{ 0xa835, "FontMetrics" },
	{ 0xa837, "MeasureText" },
	{ 0xa838, "CalcMask" },
	{ 0xa839, "SeedFill" },
	{ 0xa83a, "ZoomWindow" },
	{ 0xa83b, "TrackBox" },
	{ 0xa83c, "TEGetOffset" },
	{ 0xa83d, "TEDispatch" },
	{ 0xa83e, "TEStyleNew" },
	{ 0xa83f, "Long2Fix" },
	{ 0xa840, "Fix2Long" },
	{ 0xa841, "Fix2Frac" },
	{ 0xa842, "Frac2Fix" },
	{ 0xa843, "Fix2X" },
	{ 0xa844, "X2Fix" },
	{ 0xa845, "Frac2X" },
	{ 0xa846, "X2Frac" },
	{ 0xa847, "FracCos" },
	{ 0xa848, "FracSin" },
	{ 0xa849, "FracSqrt" },
	{ 0xa84a, "FracMul" },
	{ 0xa84b, "FracDiv" },
	{ 0xa84d, "FixDiv" },
	{ 0xa84e, "GetItemCmd" },
	{ 0xa84f, "SetItemCmd" },
	{ 0xa850, "InitCursor" },
	{ 0xa851, "SetCursor" },
	{ 0xa852, "HideCursor" },
	{ 0xa853, "ShowCursor" },
	{ 0xa855, "ShieldCursor" },
	{ 0xa856, "ObscureCursor" },
	{ 0xa858, "BitAnd" },
	{ 0xa859, "BitXor" },
	{ 0xa85a, "BitNot" },
	{ 0xa85b, "BitOr" },
	{ 0xa85c, "BitShift" },
	{ 0xa85d, "BitTst" },
	{ 0xa85e, "BitSet" },
	{ 0xa85f, "BitClr" },
	{ 0xa860, "WaitNextEvent" },
	{ 0xa861, "Random" },
	{ 0xa862, "ForeColor" },
	{ 0xa863, "BackColor" },
	{ 0xa864, "ColorBit" },
	{ 0xa865, "GetPixel" },
	{ 0xa866, "StuffHex" },
	{ 0xa867, "LongMul" },
	{ 0xa868, "FixMul" },
	{ 0xa869, "FixRatio" },
	{ 0xa86a, "HiWord" },
	{ 0xa86b, "LoWord" },
	{ 0xa86c, "FixRound" },
	{ 0xa86d, "InitPort" },
	{ 0xa86e, "InitGraf" },
	{ 0xa86f, "OpenPort" },
	{ 0xa870, "LocalToGlobal" },
	{ 0xa871, "GlobalToLocal" },
	{ 0xa872, "GrafDevice" },
	{ 0xa873, "SetPort" },
	{ 0xa874, "GetPort" },
	{ 0xa875, "SetPBits" },
	{ 0xa876, "PortSize" },
	{ 0xa877, "MovePortTo" },
	{ 0xa878, "SetOrigin" },
	{ 0xa879, "SetClip" },
	{ 0xa87a, "GetClip" },
	{ 0xa87b, "ClipRect" },
	{ 0xa87c, "BackPat" },
	{ 0xa87d, "CloseCPort" },
	{ 0xa87d, "ClosePort" },
	{ 0xa87e, "AddPt" },
	{ 0xa87f, "SubPt" },
	{ 0xa880, "SetPt" },
	{ 0xa881, "EqualPt" },
	{ 0xa882, "StdText" },
	{ 0xa883, "DrawChar" },
	{ 0xa884, "DrawString" },
	{ 0xa885, "DrawText" },
	{ 0xa886, "TextWidth" },
	{ 0xa887, "TextFont" },
	{ 0xa888, "TextFace" },
	{ 0xa889, "TextMode" },
	{ 0xa88a, "TextSize" },
	{ 0xa88b, "GetFontInfo" },
	{ 0xa88c, "StringWidth" },
	{ 0xa88d, "CharWidth" },
	{ 0xa88e, "SpaceExtra" },
	{ 0xa890, "StdLine" },
	{ 0xa891, "LineTo" },
	{ 0xa892, "Line" },
	{ 0xa893, "MoveTo" },
	{ 0xa894, "Move" },
	{ 0xa895, "Shutdown" },
	{ 0xa896, "HidePen" },
	{ 0xa897, "ShowPen" },
	{ 0xa898, "GetPenState" },
	{ 0xa899, "SetPenState" },
	{ 0xa89a, "GetPen" },
	{ 0xa89b, "PenSize" },
	{ 0xa89c, "PenMode" },
	{ 0xa89d, "PenPat" },
	{ 0xa89e, "PenNormal" },
	{ 0xa8a0, "StdRect" },
	{ 0xa8a1, "FrameRect" },
	{ 0xa8a2, "PaintRect" },
	{ 0xa8a3, "EraseRect" },
	{ 0xa8a4, "InverRect" },
	{ 0xa8a5, "FillRect" },
	{ 0xa8a6, "EqualRect" },
	{ 0xa8a7, "SetRect" },
	{ 0xa8a8, "OffsetRect" },
	{ 0xa8a9, "InsetRect" },
	{ 0xa8aa, "SectRect" },
	{ 0xa8ab, "UnionRect" },
	{ 0xa8ac, "Pt2Rect" },
	{ 0xa8ad, "PtInRect" },
	{ 0xa8ae, "EmptyRect" },
	{ 0xa8af, "StdRRect" },
	{ 0xa8b1, "PaintRoundRect" },
	{ 0xa8b2, "EraseRoundRect" },
	{ 0xa8b3, "InverRoundRect" },
	{ 0xa8b4, "FillRoundRect" },
	{ 0xa8b5, "ScriptUtil" },
	{ 0xa8b6, "StdOval" },
	{ 0xa8b7, "FrameOval" },
	{ 0xa8b8, "PaintOval" },
	{ 0xa8b9, "EraseOval" },
	{ 0xa8ba, "InvertOval" },
	{ 0xa8bb, "FillOval" },
	{ 0xa8bc, "SlopeFromAngle" },
	{ 0xa8bd, "StdArc" },
	{ 0xa8be, "FrameArc" },
	{ 0xa8bf, "PaintArc" },
	{ 0xa8c0, "EraseArc" },
	{ 0xa8c1, "InvertArc" },
	{ 0xa8c2, "FillArc" },
	{ 0xa8c3, "PtToAngle" },
	{ 0xa8c4, "AngleFromSlope" },
	{ 0xa8c5, "StdPoly" },
	{ 0xa8c6, "FramePoly" },
	{ 0xa8c7, "PaintPoly" },
	{ 0xa8c8, "ErasePoly" },
	{ 0xa8c9, "InvertPoly" },
	{ 0xa8ca, "FillPoly" },
	{ 0xa8cb, "OpenPoly" },
	{ 0xa8cc, "ClosePgon" },
	{ 0xa8cd, "KillPoly" },
	{ 0xa8ce, "OffsetPoly" },
	{ 0xa8cf, "PackBits" },
	{ 0xa8d0, "UnpackBits" },
	{ 0xa8d1, "StdRgn" },
	{ 0xa8d2, "FrameRgn" },
	{ 0xa8d3, "PaintRgn" },
	{ 0xa8d4, "EraseRgn" },
	{ 0xa8d5, "InverRgn" },
	{ 0xa8d6, "FillRgn" },
	{ 0xa8d8, "NewRgn" },
	{ 0xa8d9, "DisposRgn" },
	{ 0xa8da, "OpenRgn" },
	{ 0xa8db, "CloseRgn" },
	{ 0xa8dc, "CopyRgn" },
	{ 0xa8dd, "SetEmptyRgn" },
	{ 0xa8de, "SetRecRgn" },
	{ 0xa8df, "RectRgn" },
	{ 0xa8e0, "OfsetRgn" },
	{ 0xa8e1, "InsetRgn" },
	{ 0xa8e2, "EmptyRgn" },
	{ 0xa8e3, "EqualRgn" },
	{ 0xa8e4, "SectRgn" },
	{ 0xa8e5, "UnionRgn" },
	{ 0xa8e6, "DiffRgn" },
	{ 0xa8e7, "XorRgn" },
	{ 0xa8e8, "PtInRgn" },
	{ 0xa8e9, "RectInRgn" },
	{ 0xa8ea, "SetStdProcs" },
	{ 0xa8eb, "StdBits" },
	{ 0xa8ec, "CopyBits" },
	{ 0xa8ed, "StdTxMeas" },
	{ 0xa8ee, "StdGetPic" },
	{ 0xa8ef, "ScrollRect" },
	{ 0xa8f0, "StdPutPic" },
	{ 0xa8f1, "StdComment" },
	{ 0xa8f2, "PicComment" },
	{ 0xa8f3, "OpenPicture" },
	{ 0xa8f4, "ClosePicture" },
	{ 0xa8f5, "KillPicture" },
	{ 0xa8f6, "DrawPicture" },
	{ 0xa8f8, "ScalePt" },
	{ 0xa8f9, "MapPt" },
	{ 0xa8fa, "MapRect" },
	{ 0xa8fb, "MapRgn" },
	{ 0xa8fc, "MapPoly" },
	{ 0xa8fe, "InitFonts" },
	{ 0xa8ff, "GetFName" },
	{ 0xa900, "GetFNum" },
	{ 0xa901, "FMSwapFont" },
	{ 0xa902, "RealFont" },
	{ 0xa903, "SetFontLock" },
	{ 0xa904, "DrawGrowIcon" },
	{ 0xa905, "DragGrayRgn" },
	{ 0xa906, "NewString" },
	{ 0xa907, "SetString" },
	{ 0xa908, "ShowHide" },
	{ 0xa909, "CalcVis" },
	{ 0xa90a, "CalcVBehind" },
	{ 0xa90b, "ClipAbove" },
	{ 0xa90c, "PaintOne" },
	{ 0xa90d, "PaintBehind" },
	{ 0xa90e, "SaveOld" },
	{ 0xa90f, "DrawNew" },
	{ 0xa910, "GetWMgrPort" },
	{ 0xa911, "CheckUpdate" },
	{ 0xa912, "InitWindows" },
	{ 0xa913, "NewWindow" },
	{ 0xa914, "DisposWindow" },
	{ 0xa915, "ShowWindow" },
	{ 0xa916, "HideWindow" },
	{ 0xa917, "GetWRefCon" },
	{ 0xa918, "SetWRefCon" },
	{ 0xa919, "GetWTitle" },
	{ 0xa91a, "SetWTitle" },
	{ 0xa91b, "MoveWindow" },
	{ 0xa91c, "HiliteWindow" },
	{ 0xa91d, "SizeWindow" },
	{ 0xa91e, "TrackGoAway" },
	{ 0xa91f, "SelectWindow" },
	{ 0xa920, "BringToFront" },
	{ 0xa921, "SendBehind" },
	{ 0xa922, "BeginUpdate" },
	{ 0xa923, "EndUpdate" },
	{ 0xa924, "FrontWindow" },
	{ 0xa925, "DragWindow" },
	{ 0xa926, "DragTheRgn" },
	{ 0xa927, "InvalRgn" },
	{ 0xa928, "InvalRect" },
	{ 0xa929, "ValidRgn" },
	{ 0xa92a, "ValidRect" },
	{ 0xa92b, "GrowWindow" },
	{ 0xa92c, "FindWindow" },
	{ 0xa92d, "CloseWindow" },
	{ 0xa92e, "SetWindowPic" },
	{ 0xa92f, "GetWindowPic" },
	{ 0xa930, "InitMenus" },
	{ 0xa931, "NewMenu" },
	{ 0xa932, "DisposMenu" },
	{ 0xa933, "AppendMenu" },
	{ 0xa934, "ClearMenuBar" },
	{ 0xa935, "InsertMenu" },
	{ 0xa936, "DeleteMenu" },
	{ 0xa937, "DrawMenuBar" },
	{ 0xa938, "HiliteMenu" },
	{ 0xa939, "EnableItem" },
	{ 0xa93a, "DisableItem" },
	{ 0xa93b, "GetMenuBar" },
	{ 0xa93c, "SetMenuBar" },
	{ 0xa93d, "MenuSelect" },
	{ 0xa93e, "MenuKey" },
	{ 0xa93f, "GetItmIcon" },
	{ 0xa940, "SetItmIcon" },
	{ 0xa941, "GetItmStyle" },
	{ 0xa942, "SetItmStyle" },
	{ 0xa943, "GetItmMark" },
	{ 0xa944, "SetItmMark" },
	{ 0xa945, "CheckItem" },
	{ 0xa946, "GetItem" },
	{ 0xa947, "SetItem" },
	{ 0xa948, "CalcMenuSize" },
	{ 0xa949, "GetMHandle" },
	{ 0xa94a, "SetMFlash" },
	{ 0xa94b, "PlotIcon" },
	{ 0xa94c, "FlashMenuBar" },
	{ 0xa94d, "AddResMenu" },
	{ 0xa94e, "PinRect" },
	{ 0xa94f, "DeltaPoint" },
	{ 0xa950, "CountMItems" },
	{ 0xa951, "InsertResMenu" },
	{ 0xa952, "DelMenuItem" },
	{ 0xa953, "UpdtControl" },
	{ 0xa954, "NewControl" },
	{ 0xa955, "DisposControl" },
	{ 0xa956, "KillControls" },
	{ 0xa957, "ShowControl" },
	{ 0xa958, "HideControl" },
	{ 0xa959, "MoveControl" },
	{ 0xa95a, "GetCRefCon" },
	{ 0xa95b, "SetCRefCon" },
	{ 0xa95c, "SizeControl" },
	{ 0xa95d, "HiliteControl" },
	{ 0xa95e, "GetCTitle" },
	{ 0xa95f, "SetCTitle" },
	{ 0xa960, "GetCtlValue" },
	{ 0xa961, "GetMinCtl" },
	{ 0xa962, "GetMaxCtl" },
	{ 0xa963, "SetCtlValue" },
	{ 0xa964, "SetMinCtl" },
	{ 0xa965, "SetMaxCtl" },
	{ 0xa966, "TestControl" },
	{ 0xa967, "DragControl" },
	{ 0xa968, "TrackControl" },
	{ 0xa969, "DrawControls" },
	{ 0xa96a, "GetCtlAction" },
	{ 0xa96b, "SetCtlAction" },
	{ 0xa96c, "FindControl" },
	{ 0xa96d, "Draw1Control" },
	{ 0xa96e, "Dequeue" },
	{ 0xa96f, "Enqueue" },
	{ 0xa970, "GetNextEvent" },
	{ 0xa971, "EventAvail" },
	{ 0xa972, "GetMouse" },
	{ 0xa973, "StillDown" },
	{ 0xa974, "Button" },
	{ 0xa975, "TickCount" },
	{ 0xa976, "GetKeys" },
	{ 0xa977, "WaitMouseUp" },
	{ 0xa978, "UpdtDialog" },
	{ 0xa979, "CouldDialog" },
	{ 0xa97a, "FreeDialog" },
	{ 0xa97b, "InitDialogs" },
	{ 0xa97c, "GetNewDialog" },
	{ 0xa97d, "NewDialog" },
	{ 0xa97e, "SelIText" },
	{ 0xa97f, "IsDialogEvent" },
	{ 0xa980, "DialogSelect" },
	{ 0xa981, "DrawDialog" },
	{ 0xa982, "CloseDialog" },
	{ 0xa983, "DisposDialog" },
	{ 0xa984, "FindDItem" },
	{ 0xa985, "Alert" },
	{ 0xa986, "StopAlert" },
	{ 0xa987, "NoteAlert" },
	{ 0xa988, "CautionAlert" },
	{ 0xa989, "CouldAlert" },
	{ 0xa98a, "FreeAlert" },
	{ 0xa98b, "ParamText" },
	{ 0xa98c, "ErrorSound" },
	{ 0xa98d, "GetDItem" },
	{ 0xa98e, "SetDItem" },
	{ 0xa98f, "SetIText" },
	{ 0xa990, "GetIText" },
	{ 0xa991, "ModalDialog" },
	{ 0xa992, "DetachResource" },
	{ 0xa993, "SetResPurge" },
	{ 0xa994, "CurResFile" },
	{ 0xa995, "InitResources" },
	{ 0xa996, "RsrcZoneInit" },
	{ 0xa997, "OpenResFile" },
	{ 0xa998, "UseResFile" },
	{ 0xa999, "UpdateResFile" },
	{ 0xa99a, "CloseResFile" },
	{ 0xa99b, "SetResLoad" },
	{ 0xa99c, "CountResources" },
	{ 0xa99d, "GetIndResource" },
	{ 0xa99e, "CountTypes" },
	{ 0xa99f, "GetIndType" },
	{ 0xa9a0, "GetResource" },
	{ 0xa9a1, "GetNamedResource" },
	{ 0xa9a2, "LoadResource" },
	{ 0xa9a3, "ReleaseResource" },
	{ 0xa9a4, "HomeResFile" },
	{ 0xa9a5, "SizeRsrc" },
	{ 0xa9a6, "GetResAttrs" },
	{ 0xa9a7, "SetResAttrs" },
	{ 0xa9a8, "GetResInfo" },
	{ 0xa9a9, "SetResInfo" },
	{ 0xa9aa, "ChangedResource" },
	{ 0xa9ab, "AddResource" },
	{ 0xa9ac, "AddReference" },
	{ 0xa9ad, "RmveResource" },
	{ 0xa9ae, "RmveReference" },
	{ 0xa9af, "ResError" },
	{ 0xa9b0, "FrameRoundRect" },
	{ 0xa9b0, "WriteResource" },
	{ 0xa9b1, "CreateResFile" },
	{ 0xa9b2, "SystemEvent" },
	{ 0xa9b3, "SystemClick" },
	{ 0xa9b4, "SystemTask" },
	{ 0xa9b5, "SystemMenu" },
	{ 0xa9b6, "OpenDeskAcc" },
	{ 0xa9b7, "CloseDeskAcc" },
	{ 0xa9b8, "GetPattern" },
	{ 0xa9b9, "GetCursor" },
	{ 0xa9ba, "GetString" },
	{ 0xa9bb, "GetIcon" },
	{ 0xa9bc, "GetPicture" },
	{ 0xa9bd, "GetNewWindow" },
	{ 0xa9be, "GetNewControl" },
	{ 0xa9bf, "GetRMenu" },
	{ 0xa9c0, "GetNewMBar" },
	{ 0xa9c1, "UniqueID" },
	{ 0xa9c2, "SysEdit" },
	{ 0xa9c3, "KeyTrans" },
	{ 0xa9c4, "OpenRFPerm" },
	{ 0xa9c5, "RsrcMapEntry" },
	{ 0xa9c6, "Secs2Date" },
	{ 0xa9c7, "Date2Sec" },
	{ 0xa9c8, "SysBeep" },
	{ 0xa9c9, "SysError" },
	{ 0xa9cb, "TEGetText" },
	{ 0xa9cc, "TEInit" },
	{ 0xa9cd, "TEDispose" },
	{ 0xa9ce, "TextBox" },
	{ 0xa9cf, "TESetText" },
	{ 0xa9d0, "TECalText" },
	{ 0xa9d1, "TESetSelect" },
	{ 0xa9d2, "TENew" },
	{ 0xa9d3, "TEUpdate" },
	{ 0xa9d4, "TEClick" },
	{ 0xa9d5, "TECopy" },
	{ 0xa9d6, "TECut" },
	{ 0xa9d7, "TEDelete" },
	{ 0xa9d8, "TEActivate" },
	{ 0xa9d9, "TEDeactivate" },
	{ 0xa9da, "TEIdle" },
	{ 0xa9db, "TEPaste" },
	{ 0xa9dc, "TEKey" },
	{ 0xa9dd, "TEScroll" },
	{ 0xa9de, "TEInsert" },
	{ 0xa9df, "TESetJust" },
	{ 0xa9e0, "Munger" },
	{ 0xa9e1, "HandToHand" },
	{ 0xa9e2, "PtrToXHand" },
	{ 0xa9e3, "PtrToHand" },
	{ 0xa9e4, "HandAndHand" },
	{ 0xa9e5, "InitPack" },
	{ 0xa9e6, "InitAllPacks" },
	{ 0xa9e7, "Pack0" },
	{ 0xa9e8, "Pack1" },
	{ 0xa9e9, "Pack2" },
	{ 0xa9ea, "Pack3" },
	{ 0xa9eb, "FP68K" },
	{ 0xa9eb, "Pack4" },
	{ 0xa9ec, "Elems68K" },
	{ 0xa9ec, "Pack5" },
	{ 0xa9ed, "Pack6" },
	{ 0xa9ee, "Pack7" },
	{ 0xa9ef, "PtrAndHand" },
	{ 0xa9f0, "LoadSeg" },
	{ 0xa9f1, "UnloadSeg" },
	{ 0xa9f2, "Launch" },
	{ 0xa9f3, "Chain" },
	{ 0xa9f4, "ExitToShell" },
	{ 0xa9f5, "GetAppParms" },
	{ 0xa9f6, "GetResFileAttrs" },
	{ 0xa9f7, "SetResFileAttrs" },
	{ 0xa9f9, "InfoScrap" },
	{ 0xa9fa, "UnlodeScrap" },
	{ 0xa9fb, "LodeScrap" },
	{ 0xa9fc, "ZeroScrap" },
	{ 0xa9fd, "GetScrap" },
	{ 0xa9fe, "PutScrap" },
	{ 0xaa00, "OpenCport" },
	{ 0xaa01, "InitCport" },
	{ 0xaa03, "NewPixMap" },
	{ 0xaa04, "DisposPixMap" },
	{ 0xaa05, "CopyPixMap" },
	{ 0xaa06, "SetCPortPix" },
	{ 0xaa07, "NewPixPat" },
	{ 0xaa08, "DisposPixPat" },
	{ 0xaa09, "CopyPixPat" },
	{ 0xaa0a, "PenPixPat" },
	{ 0xaa0b, "BackPixPat" },
	{ 0xaa0c, "GetPixPat" },
	{ 0xaa0d, "MakeRGBPat" },
	{ 0xaa0e, "FillCRect" },
	{ 0xaa0f, "FillCOval" },
	{ 0xaa10, "FillCRoundRect" },
	{ 0xaa11, "FillCArc" },
	{ 0xaa12, "FillCRgn" },
	{ 0xaa13, "FillCPoly" },
	{ 0xaa14, "RGBForeColor" },
	{ 0xaa15, "RGBBackColor" },
	{ 0xaa16, "SetCPixel" },
	{ 0xaa17, "GetCPixel" },
	{ 0xaa18, "GetCTable" },
	{ 0xaa19, "GetForeColor" },
	{ 0xaa1a, "GetBackColor" },
	{ 0xaa1b, "GetCCursor" },
	{ 0xaa1c, "SetCCursor" },
	{ 0xaa1d, "AllocCursor" },
	{ 0xaa1e, "GetCIcon" },
	{ 0xaa1f, "PlotCIcon" },
	{ 0xaa21, "OpColor" },
	{ 0xaa22, "HiliteColor" },
	{ 0xaa23, "CharExtra" },
	{ 0xaa24, "DisposCTable" },
	{ 0xaa25, "DisposCIcon" },
	{ 0xaa26, "DisposCCursor" },
	{ 0xaa27, "GetMaxDevice" },
	{ 0xaa29, "GetDeviceList" },
	{ 0xaa2a, "GetMainDevice" },
	{ 0xaa2b, "GetNextDevice" },
	{ 0xaa2c, "TestDeviceAttribute" },
	{ 0xaa2d, "SetDeviceAttribute" },
	{ 0xaa2e, "InitGDevice" },
	{ 0xaa2f, "NewGDevice" },
	{ 0xaa30, "DisposGDevice" },
	{ 0xaa31, "SetGDevice" },
	{ 0xaa32, "GetGDevice" },
	{ 0xaa33, "Color2Index" },
	{ 0xaa34, "Index2Color" },
	{ 0xaa35, "InvertColor" },
	{ 0xaa36, "RealColor" },
	{ 0xaa37, "GetSubTable" },
	{ 0xaa39, "MakeITable" },
	{ 0xaa3a, "AddSearch" },
	{ 0xaa3b, "AddComp" },
	{ 0xaa3c, "SetClientID" },
	{ 0xaa3d, "ProtectEntry" },
	{ 0xaa3e, "ReserveEntry" },
	{ 0xaa3f, "SetEntries" },
	{ 0xaa40, "QDError" },
	{ 0xaa41, "SetWinColor" },
	{ 0xaa42, "GetAuxWin" },
	{ 0xaa43, "SetCtlColor" },
	{ 0xaa44, "GetAuxCtl" },
	{ 0xaa45, "NewCWindow" },
	{ 0xaa46, "GetNewCWindow" },
	{ 0xaa47, "SetDeskCPat" },
	{ 0xaa48, "GetCWMgrPort" },
	{ 0xaa49, "SaveEntries" },
	{ 0xaa4a, "RestoreEntries" },
	{ 0xaa4b, "NewCDialog" },
	{ 0xaa4c, "DelSearch" },
	{ 0xaa4d, "DelComp" },
	{ 0xaa4f, "CalcCMask" },
	{ 0xaa50, "SeedCFill" },
	{ 0xaa60, "DelMCEntries" },
	{ 0xaa61, "GetMCInfo" },
	{ 0xaa62, "SetMCInfo" },
	{ 0xaa63, "DispMCEntries" },
	{ 0xaa64, "GetMCEntry" },
	{ 0xaa65, "SetMCEntries" },
	{ 0xaa66, "MenuChoice" },
	{ 0x0000, NULL }
};


const char *mac_get_trap_name (unsigned trap)
{
	unsigned i;
	unsigned base, mask;

	if ((trap & 0xf000) != 0xa000) {
		return (NULL);
	}

	if (trap & 0x0800) {
		mask = 0xf800 | 0x03ff;
	}
	else {
		mask = 0xf800 | 0x00ff;
	}

	base = trap & mask;

	i = 0;
	while (trap_list[i].name != NULL) {
		if ((trap_list[i].trap & mask) == base) {
			return (trap_list[i].name);
		}

		i += 1;
	}

	return (NULL);
}
