/* pgfig -- low level pgraf routines using fig 3.2 */
#include <math.h>
#include <stdio.h>

#define SFACTOR 420.
#define YOFFSET 4501

static int figtype,ixold,iyold,ix,iy;

/* initialize graphics device */
pginit()
{
  printf("#FIG 3.2\nPortrait\nCenter\nInches\nLetter\n100.00\nSingle\n-2\n1200 2\n");
}

/* flush graphics device */
pgflsh()
{
  fflush(stdout);
}

/* move with pen up */
pgmove(x,y)
float x,y;
{
  ix = SFACTOR*x + .5;
  iy = SFACTOR*y + .5;
  iy = YOFFSET - iy;
}

/* draw a line */
pgdraw(x,y,linetype)
float x,y;
int linetype;
{
  int color;
  color = 0;
  while (linetype < 1) {
    linetype += 4;
    color--;
  }
  while (linetype > 4) {
    linetype -= 4;
    color++;
  }
  ixold = ix;
  iyold = iy;
  ix = SFACTOR*x + .5;
  iy = SFACTOR*y + .5;
  iy = YOFFSET - iy;
  figtype = linetype - 1;
  if (figtype < 0) figtype = 0;
  if (figtype > 2) figtype = 0;
  if (figtype == 0) printf("2 1 0 1 -1 -1 0 0 -1 0.0 0 0 0 0 0 2\n");
  if (figtype == 1) printf("2 1 1 1 -1 -1 0 0 -1 4.0 -143095960 0 0 0 0 2\n");
  if (figtype == 2) printf("2 1 2 1 -1 -1 0 0 -1 4.0 -143095960 0 0 0 0 2\n");
  printf("  %d %d %d %d\n",ixold,iyold,ix,iy);
}

/* write text */
pgtext(x,y,text)
float x,y;
char *text;
{
  int i,ix1,ix2,iy1,iy2;
  while ((i = strlen(text)) > 0 && text[i - 1] < ' ') text[i - 1] = '\0';
  ix = SFACTOR*x + .5;
  iy = SFACTOR*y + .5;
  iy -= 4;
  iy = YOFFSET - iy;
  ix1 = ix;
  iy1 = iy - 15*9;
  ix2 = ix1 + 15*5.5*strlen(text);
  iy2 = iy1 + 15*11;
  printf("4 0 -1 0 0 0 12 0.0 4 %d %d %d %d %s\\001\n",
	 (ix2 - ix1),(iy2 - iy1),ix,iy,text);
}

/* return character cell size information */
pginfo(dcx,dcy)
float *dcx,*dcy;
{
  *dcx = 15.*6./SFACTOR;
  *dcy = 15.*9./SFACTOR;
}
