/*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	PICOPBC_AST_H
#define	PICOPBC_AST_H

#include <stdbool.h>
#include <stddef.h>
#include <stdint.h>

#include "strung.h"

struct ast_srcloc {
	const char	*filename;
	size_t		lineno;
	size_t		column;
};

struct ast_id {
	struct ast_srcloc	loc;
	struct string		id;
};

/* XXX Move!  */
typedef uint32_t field_tag_t;
#define	PRI_field_tag	PRIu32
#define	FIELD_TAG_MIN	1
#define	FIELD_TAG_MAX	UINT32_MAX

struct ast_optpart {
	union {
		struct string		normal;
		struct string		extension;
	}			u;
	enum {
		AST_OPTPART_NORMAL,
		AST_OPTPART_EXTENSION,
	}			t;
};

struct ast_optname {
	struct ast_optpart	*parts;
	size_t			nparts;
};

struct ast_optval {
	union {
		struct string		id;
		uintmax_t		uint;
		intmax_t		sint;
		double			real;
		bool			boolean;
		struct string		string;
#ifdef notyet
		...		block;
#endif
	}			u;
	enum {
		AST_OPTVAL_ID,
		AST_OPTVAL_UINT,
		AST_OPTVAL_SINT,
		AST_OPTVAL_REAL,
		AST_OPTVAL_BOOLEAN,
		AST_OPTVAL_STRING,
#ifdef notyet
		AST_OPTVAL_BLOCK,
#endif
	}			t;
};

struct ast_option {
	struct ast_srcloc	loc;
	struct ast_optname	name;
	struct ast_optval	value;
};

struct ast_type {
	struct string	text;
};

struct ast_enumerand {
	struct ast_srcloc	loc;
	struct string		id;
	int32_t			value;
	struct ast_enumerand_options {
		struct ast_option	*options;
		size_t			noptions;
	}			options;
};

struct ast_enumeration {
	struct ast_srcloc	loc;
	struct string		id;
	struct ast_enum_stmts {
		struct ast_enum_stmt	*stmts;
		size_t			nstmts;
	}			stmts;
};

struct ast_enum_stmt {
	union {
		struct ast_option	option;
		struct ast_enumerand	enumerand;
	}			u;
	enum {
		AST_ENUM_STMT_NULL,
		AST_ENUM_STMT_OPTION,
		AST_ENUM_STMT_ENUMERAND,
	}			t;
};

struct ast_rpc {
	struct ast_srcloc	loc;
	struct string		id;
	struct ast_type		intype;
	struct ast_type		outtype;
	struct ast_rpc_options {
		struct ast_option	*options;
		size_t			noptions;
	}			options;
};

struct ast_service {
	struct ast_srcloc	loc;
	struct string		id;
	struct ast_service_stmts {
		struct ast_service_stmt	*stmts;
		size_t			nstmts;
	}			stmts;
};

struct ast_service_stmt {
	union {
		struct ast_option	option;
		struct ast_rpc		rpc;
	}			u;
	enum {
		AST_SERVICE_STMT_NULL,
		AST_SERVICE_STMT_OPTION,
		AST_SERVICE_STMT_RPC,
	}			t;
};

struct ast_package {
	struct ast_srcloc	loc;
	struct string		name;	/* dotted */
};

struct ast_import {
	struct ast_srcloc	loc;
	enum ast_import_qual {
		AST_IQ_DEFAULT,
		AST_IQ_PUBLIC,
		AST_IQ_WEAK,
	}			qual;
	struct string		pathname;
};

struct ast_extension_range {
	field_tag_t		min;
	field_tag_t		max;
};

struct ast_extensions {
	struct ast_srcloc	loc;
	struct ast_extension_ranges {
		struct ast_extension_range	*ranges;
		size_t				nranges;
	}			ranges;
};

struct ast_fieldval {
	struct ast_srcloc	loc;
	union {
		uint64_t		uint;
		int64_t			sint;
		double			real;
		bool			boolean;
		struct string		string;
		struct string		id;
	}			u;
	enum {
		AST_FIELDVAL_UINT,
		AST_FIELDVAL_SINT,
		AST_FIELDVAL_REAL,
		AST_FIELDVAL_BOOLEAN,
		AST_FIELDVAL_STRING,
		AST_FIELDVAL_ID,
	}			t;
};

struct ast_field {
	struct ast_srcloc	loc;
	enum ast_field_quant {
		AST_FQ_REQUIRED,
		AST_FQ_OPTIONAL,
		AST_FQ_REPEATED,
	}			quant;
	struct ast_type		type;
	struct string		id;
	field_tag_t		tag;
	struct ast_field_options {
		bool			default_present;
		struct ast_fieldval	default_value;
		struct ast_option	*options;
		size_t			noptions;
	}			options;
};

struct ast_field_quant_loc {
	struct ast_srcloc	loc;
	enum ast_field_quant	quant;
};

struct ast_extend {
	struct ast_srcloc	loc;
	struct ast_type		type;
	struct ast_extend_fields {
		struct ast_field	*fields;
		size_t			nfields;
	}			fields;
};

struct ast_message {
	struct ast_srcloc	loc;
	struct string		id;
	struct ast_message_stmts {
		struct ast_message_stmt	*stmts;
		size_t			nstmts;
	}			stmts;
};

struct ast_message_stmt {
	union {
		struct ast_message	message;
		struct ast_enumeration	enumeration;
		struct ast_extend	extend;
		struct ast_option	option;
		struct ast_extensions	extensions;
		struct ast_field	field;
	}			u;
	enum {
		AST_MESSAGE_STMT_NULL,
		AST_MESSAGE_STMT_MESSAGE,
		AST_MESSAGE_STMT_ENUMERATION,
		AST_MESSAGE_STMT_EXTEND,
		AST_MESSAGE_STMT_OPTION,
		AST_MESSAGE_STMT_EXTENSIONS,
		AST_MESSAGE_STMT_FIELD,
	}			t;
};

struct ast_proto {
	struct ast_proto_stmts {
		struct ast_proto_stmt 	*stmts;
		size_t			nstmts;
	}		stmts;
};

struct ast_proto_stmt {
	union {
		struct ast_message	message;
		struct ast_enumeration	enumeration;
		struct ast_service	service;
		struct ast_extend	extend;
		struct ast_import	import;
		struct ast_package	package;
		struct ast_option	option;
	}			u;
	enum {
		AST_PROTO_STMT_NULL,
		AST_PROTO_STMT_MESSAGE,
		AST_PROTO_STMT_ENUMERATION,
		AST_PROTO_STMT_SERVICE,
		AST_PROTO_STMT_EXTEND,
		AST_PROTO_STMT_IMPORT,
		AST_PROTO_STMT_PACKAGE,
		AST_PROTO_STMT_OPTION,
	}			t;
};

#endif
