/*-
 * Copyright (c) 2015 Taylor R. Campbell
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef	PICOPBC_QUEUE_H
#define	PICOPBC_QUEUE_H

#include <stddef.h>

#define	SIMPLEQ_HEAD(HEAD_TAG, ELEMENT_TAG)				      \
	struct HEAD_TAG {						      \
		struct ELEMENT_TAG	*sqh_first;			      \
		struct ELEMENT_TAG	**sqh_last;			      \
	}

#define	SIMPLEQ_ENTRY(ELEMENT_TAG)					      \
	struct {							      \
		struct ELEMENT_TAG	*sqe_next;			      \
	}

#define	SIMPLEQ_INIT(HEAD) do						      \
{									      \
	(HEAD)->sqh_first = NULL;					      \
	(HEAD)->sqh_last = &(HEAD)->sqh_first;				      \
} while (0)

#define	SIMPLEQ_INSERT_TAIL(HEAD, ELEMENT, FIELD) do			      \
{									      \
	(ELEMENT)->FIELD.sqe_next = NULL;				      \
	*(HEAD)->sqh_last = (ELEMENT);					      \
	(HEAD)->sqh_last = &(ELEMENT)->FIELD.sqe_next;			      \
} while (0)

#define	SIMPLEQ_FIRST(HEAD)		((HEAD)->sqh_first)
#define	SIMPLEQ_NEXT(ELEMENT, FIELD)	((ELEMENT)->FIELD.sqe_next)

#define	SIMPLEQ_FOREACH(ELEMENT, HEAD, FIELD)				      \
	for ((ELEMENT) = SIMPLEQ_FIRST((HEAD));				      \
	     (ELEMENT) != NULL;						      \
	     (ELEMENT) = SIMPLEQ_NEXT((ELEMENT), FIELD))

#endif	/* PICOPBC_QUEUE_H */
