//// CHRON - do a graph over time 


//// set defaults..

// date1-specific parameters
#setifnotgiven datefmt = "mmddyy"
#setifnotgiven mode = bars
#setifnotgiven barwidth = ""
#setifnotgiven color = orange
#setifnotgiven outline = no
#setifnotgiven linedet = "color=green"
#setifnotgiven step = "no"
#setifnotgiven tab = ""
#setifnotgiven tabmode = "mid"
#setifnotgiven xyears = ""
#setifnotgiven curve = ""
#setifnotgiven order = "5"
#setifnotgiven omitweekends = "no"
#setifnotgiven unittype = date
#setifnotgiven timefld = ""
#if @timefld != ""
  #set unittype = datetime
#endif
#if @unittype = time
  #setifnotgiven nearest = hour
  #setifnotgiven stubfmt = HHA
#else
  #setifnotgiven nearest = day
  #setifnotgiven stubfmt = "MMMdd"
#endif
#setifnotgiven crossover = ""
// #setifnotgiven legend = "min+0.5 max+0.5"

// standard parameters..
#setifnotgiven y = ""
#setifnotgiven title = ""
#setifnotgiven yrange = ""
#setifnotgiven xinc = "7"
#setifnotgiven yinc = ""
#setifnotgiven xlbl = ""
#setifnotgiven ylbl = ""
#setifnotgiven delim = ""
#setifnotgiven comment = ""
#setifnotgiven ygrid = ""
#setifnotgiven xgrid = ""
#setifnotgiven xrange = ""
#setifnotgiven xlbldet = ""
#setifnotgiven ylbldet = ""
#setifnotgiven titledet = ""
#setifnotgiven ylog = ""
#setifnotgiven select = ""
#setifnotgiven include1 = ""
#setifnotgiven include2 = ""


#musthave data

#proc datesettings
format: @datefmt
omitweekends: @omitweekends


//// read data file..
#proc getdata
file: @data
#if @data = stdin
  standardinput: yes
#endif
#if @delim != ""
  delim: @delim
#endif
#if @header = yes
  fieldnameheader: yes
#endif
#if @comment != ""
  commentchar: @comment
#endif
select: @select
#if @tab != ""
  #if @y != ""
    filter: ##set DT = $ref(@x)
    #if @timefld != ""
	      ##set TM = $ref(@timefld)
              ##set DT = @DT "." @TM
    #endif
	    ##set VAL = $ref(@y)
	    ##set ADJ = $dategroup( @tab, @tabmode, @@DT )
	    ##print @@ADJ @@VAL

    #set x = 1
    #set y = 2
  #else
    filter: ##set DT = $ref(@x)
    #if @timefld != ""
	      ##set TM = $ref(@timefld)
              ##set DT = @DT "." @TM
    #endif
	    ##set ADJ = $dategroup( @tab, @tabmode, @@DT )
	    ##print @@ADJ

    #set x = 1
  #endif
#endif
// showresults: yes 
#proc endproc


#musthave x 



#if @NRECORDS = 0
  #exit
#endif

#proc print
label: Got @NRECORDS records, @NFIELDS fields per record.

#if @tab = "" && @y = ""
  #write stderr
    Error: 'y' is required unless 'tab' is being used.
  #endwrite noclose
  #exit
#endif


#if @tab != ""
  #proc processdata
  action: count
  #if @y = ""
    fields: @x
  #else 
    fields: @x @y
  #endif
  //showresults: yes
  #proc endproc

  #set x = 1
  #set y = 2

#endif

//// set default grid
#if @xgrid = yes
  #set xgrid = "color=tan1"
#endif
#if @ygrid = yes
  #set ygrid = "color=tan1"
#endif


//// set up plotting area..
#proc areadef
rectangle: 1 2 5.5 4
xscaletype: @unittype
#if @ylog != ""
  yscaletype: @ylog
#endif
#if @autow = yes
  autowidth: 0.5 4.0 8.0
#endif
#if @xrange = ""
  xautorange: datafield=@x  nearest=@nearest
#else
  xrange: @xrange
#endif


#if @yrange = ""
  yautorange: datafields=@y incmult=2.0 
#elseif @yrange = "0"
  yautorange: datafields=@y incmult=2.0 lowfix=0
#else
  yrange: @yrange
#endif

#proc yaxis
stubs: inc @yinc
stubcull: yes
label: @ylbl
labeldetails: @ylbldet
#if @ygrid != ""
  grid: @ygrid
#endif

#proc xaxis
label: @xlbl
labeldetails: @xlbldet
stubs: inc @xinc
stubformat: @stubfmt
stubrange: @XMIN
#if @stubvert = yes
  stubvert: yes
#endif
// stubcull: yes
#if @xgrid != ""
  grid: @ygrid
#endif
autoyears: @xyears



//// do title..
#if @title != ""
  #proc annotate
  #set XCENTER = $arith(@AREARIGHT-@AREALEFT/2.0)
  #set XCENTER = $arith(@AREALEFT+@XCENTER)
  location: @XCENTER 4.2
  textdetails: @titledet 
  text: @title
#endif


#if @include2 != ""
  #include include2
#endif

//// do curve fit..
#if @curve != ""
  #if @curve = "yes"
    #set curve = "color=pink width=0.5"
  #endif
  #proc curvefit
  xfield: @x
  yfield: @y
  linedetails: @curve
  order: @order
#endif


//// do bars or line..
#if @mode = bars
  #proc bars
  locfield: @x
  lenfield: @y
  color: @color
  outline: @outline
  #if @barwidth = line
    thinbarline: color=@color
  #elseif @barwidth != ""
    barwidth: @barwidth
  #endif
  #if @crossover != ""
    crossover: @crossover
  #endif

#elseif @mode = line
  #proc lineplot
  xfield: @x
  yfield: @y
  linedetails: @linedet
  stairstep: @step
#endif

//// crossover line..
#if @crossover != ""
  #proc line
  linedetails: width=0.5
  points: min @crossover(s) max @crossover(s)
#endif


#if @include2 != ""
  #include include2
#endif
