//// SCAT - do a scatterplot of two variables with pearson coefficient and regression line

//// set defaults..
#setifnotgiven title = ""
#setifnotgiven id = ""
#setifnotgiven xrange = ""
#setifnotgiven yrange = ""
#setifnotgiven xinc = ""
#setifnotgiven yinc = ""
#setifnotgiven xlbl = ""
#setifnotgiven ylbl = ""
#setifnotgiven delim = ""
#setifnotgiven comment = ""
#setifnotgiven ptsym = "circle"
#setifnotgiven ptcolor = "blue"
#setifnotgiven ptsize = "0.04"
#setifnotgiven corrcolor = "green"
#setifnotgiven err = ""
#setifnotgiven xerr = ""
#setifnotgiven errcolor = "gray(0.7)"
#setifnotgiven xgrid = ""
#setifnotgiven ygrid = ""
#setifnotgiven idcolor = "orange"
#setifnotgiven xlbldet = ""
#setifnotgiven ylbldet = ""
#setifnotgiven titledet = ""
#setifnotgiven xlog = ""
#setifnotgiven ylog = ""
#setifnotgiven select = ""
#setifnotgiven include1 = ""
#setifnotgiven include2 = ""



#musthave data

//// read data file..
#proc getdata
file: @data
#if @data = stdin
  standardinput: yes
#endif
#if @delim != ""
  delim: @delim
#endif
#if @header = yes
  fieldnameheader: yes
#endif
#if @comment != ""
  commentchar: @comment
#endif
select: @select
  
#proc endproc

#musthave x, y

#if @NRECORDS = 0
  #exit
#endif

#proc print
label: Got @NRECORDS records, @NFIELDS fields per record.

//// set default grid
#if @xgrid = yes
  #set xgrid = "color=tan1"
#endif
#if @ygrid = yes
  #set ygrid = "color=tan1"
#endif



//// set up plotting area..
#proc areadef
#if @xlog != ""
  xscaletype: @xlog
#endif
#if @ylog != ""
  yscaletype: @ylog
#endif
rectangle: 1 1 4 4
#if @xrange != ""
  xrange: @xrange
#elseif @cats = yes
  xscaletype: categories
  xcategories: @x
#else
  xautorange: datafield=@x incmult=2.0
#endif
#if @yrange != ""
  yrange: @yrange
#else
  yautorange: datafield=@y incmult=2.0
#endif
xaxis.stubs: inc @xinc
xaxis.stubcull: yes
#if @stubvert = yes
  xaxis.stubvert: yes
#endif
yaxis.stubs: inc @yinc
yaxis.stubcull: yes
xaxis.label: @xlbl
xaxis.labeldetails: @xlbldet
yaxis.label: @ylbl
yaxis.labeldetails: @ylbldet
yaxis.labeldistance: 0.55
#if @xgrid != ""
  xaxis.grid: @xgrid
#endif
#if @ygrid != ""
  yaxis.grid: @ygrid
#endif



//// do title..
#if @title != ""
  #proc annotate
  #set XCENTER = $arith(@AREARIGHT-@AREALEFT/2.0)
  #set XCENTER = $arith(@AREALEFT+@XCENTER)
  location: @XCENTER 4.2
  textdetails: @titledet
  text: @title
#endif

#if @include1 != ""
  #include @include1
#endif


//// do regression line and correlation..
#if @corr = yes
  #proc curvefit
  curvetype: regression
  xfield: @x
  yfield: @y
  linedetails: color=@corrcolor width=0.5

  #proc annotate
  location: max min-0.6
  textdetails: align=R size=8 color=@corrcolor
  text: r = @CORRELATION
	@REGRESSION_LINE
#endif


//// do scatterplot..
#if @id != ""
  #proc scatterplot
  xfield: @x
  yfield: @y
  labelfield: @id
  textdetails: size=6 color=@idcolor adjust=0,0.07
#endif



//// do error bars..
#if @err != ""
 #proc bars
  locfield: @x
  lenfield: @y
  errbarfield: @err
  thinbarline: color=@errcolor width=0.5
  tails: 0.02
  truncate: yes
#endif
  
#if @xerr != ""
  #proc bars
  locfield: @y
  lenfield: @x
  horizontalbars: yes
  errbarfield: @xerr
  thinbarline: color=@errcolor width=0.5
  tails: 0.02
  truncate: yes
#endif


//// do the data points last so they are on top of the rest of the stuff..
#proc scatterplot
xfield: @x
yfield: @y
symbol: shape=@ptshape style=filled radius=@ptsize fillcolor=@ptcolor

#if @include2 != ""
  #include @include2
#endif
