#ifndef _ftp_h_
#define _ftp_h_

#include "bool.h"

class rfsv;
class bufferStore;
class bufferArray;

class ftp {
public:
  ftp();
  ~ftp();
  int session(rfsv &a);

private:
  bool getCommand(char* buf, int bufLen) const;
  bool wildcardMatch(const char* wild, const char* file) const;

  // Unix utilities
  bool unixDirExists(const char* dir);
  void getUnixDir(bufferArray &files);
  void resetUnixPwd();
  
  void cd(const char *source, const char* cdto, char *dest);
  
  char localDir[1024];
  char psionDir[1024];
};

#endif

