
/*  A Bison parser, made from conf-parse.y
    by GNU Bison version 1.28  */

#define YYBISON 1  /* Identify Bison output.  */

#define	IDENTIFIER	257
#define	STRING	258
#define	MACRO	259
#define	HMACRO	260
#define	COMMAND	261
#define	DEVICE	262
#define	ALIAS	263
#define	TTY	264
#define	DAEMON_SOCKET	265
#define	DAEMON_MONITOR_SOCKET	266
#define	RUN	267
#define	INTEGER	268
#define	HOUSECODE	269
#define	DAEMON_DIR	270
#define	DAEMON_COMMAND_TIMEOUT	271
#define	IF	272
#define	ELSE	273
#define	ALL_UNITS_OFF	274
#define	ALL_LIGHTS_ON	275
#define	ON	276
#define	OFF	277
#define	DIM	278
#define	BRIGHT	279
#define	ALL_LIGHTS_OFF	280
#define	EXTENDED_CODE	281
#define	HAIL_REQUEST	282
#define	HAIL_ACKNOWLEDGE	283
#define	PRESET_DIM1	284
#define	PRESET_DIM2	285
#define	EXTENDED_DATA_TRANSFER	286
#define	STATUS_ON	287
#define	STATUS_OFF	288
#define	STATUS_REQUEST	289
#define	COMMA	290
#define	COLON	291
#define	BRACE_LEFT	292
#define	BRACE_RIGHT	293
#define	PAREN_LEFT	294
#define	PAREN_RIGHT	295
#define	SEMI	296
#define	LAMP	297
#define	APPLIANCE	298
#define	MOTION_DETECTOR	299
#define	SIGNAL	300
#define	TRANSCEIVER	301
#define	EXAMPLE	302

#line 1 "conf-parse.y"

/*
 * Bison parser for the configuration file.
 * Copyright (C) 1999  Steven Brown
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Steven Brown <swbrown@ucsd.edu>
 *
 * $Id: conf-parse.y,v 1.10 1999/09/19 18:43:46 kefka Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <pwd.h>
#include <grp.h>
#include <sys/types.h>
#include <errno.h>
#include "conf.h"
#include "conf-proto.h"
#include "x10.h"
#include "error.h"
#include "stacklist.h"
#include "table.h"

extern int yylex(void);

#define YYERROR_VERBOSE


#line 46 "conf-parse.y"
typedef union {
	char *identifier;
	char *string;
	int integer;
	
	/* Elements for passing up in the stack. */
	struct device *device;
	struct alias *alias;
	struct stacklist stacklist;
	struct function function;
	struct state state;
	struct macro_commands macro_commands;
	struct macro_command macro_command;
	struct table *table;
	struct expression expression;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		98
#define	YYFLAG		-32768
#define	YYNTBASE	49

#define YYTRANSLATE(x) ((unsigned)(x) <= 302 ? yytranslate[x] : 66)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    36,
    37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
    47,    48
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     3,     6,     8,    12,    15,    19,    22,    27,
    32,    39,    42,    45,    47,    49,    50,    52,    54,    56,
    58,    60,    62,    66,    68,    72,    76,    79,    81,    84,
    86,    89,    92,    98,   101,   102,   106,   108,   110,   114,
   116,   118,   120,   122,   124,   126,   130,   134,   136,   138,
   140,   142,   144,   146,   152,   154,   156
};

static const short yyrhs[] = {    50,
     0,     0,    50,    51,     0,    51,     0,     8,    63,    54,
     0,    15,     3,     0,     9,    61,     3,     0,    10,     4,
     0,    11,    14,     4,     4,     0,    12,    14,     4,     4,
     0,     5,    52,    40,    55,    41,    57,     0,    16,     4,
     0,    17,    14,     0,    48,     0,    53,     0,     0,     3,
     0,    43,     0,    44,     0,    45,     0,    46,     0,    47,
     0,    55,    42,    56,     0,    56,     0,    61,    37,    65,
     0,    38,    58,    39,     0,    38,    39,     0,    59,     0,
    58,    57,     0,    57,     0,     7,    56,     0,    13,     4,
     0,    18,    40,    60,    41,    57,     0,    19,    57,     0,
     0,    61,    36,    62,     0,    62,     0,     3,     0,    63,
    36,    64,     0,    64,     0,     3,     0,    20,     0,    21,
     0,    22,     0,    23,     0,    24,    37,    14,     0,    25,
    37,    14,     0,    26,     0,    27,     0,    28,     0,    29,
     0,    30,     0,    31,     0,    32,    37,    14,    37,    14,
     0,    33,     0,    34,     0,    35,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   130,   131,   133,   134,   136,   174,   195,   231,   242,   271,
   300,   321,   332,   343,   353,   354,   356,   358,   359,   360,
   361,   362,   364,   369,   378,   408,   411,   417,   428,   449,
   453,   459,   465,   472,   479,   484,   489,   498,   513,   518,
   527,   564,   565,   566,   567,   568,   582,   596,   597,   598,
   599,   600,   601,   602,   622,   623,   624
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","IDENTIFIER",
"STRING","MACRO","HMACRO","COMMAND","DEVICE","ALIAS","TTY","DAEMON_SOCKET","DAEMON_MONITOR_SOCKET",
"RUN","INTEGER","HOUSECODE","DAEMON_DIR","DAEMON_COMMAND_TIMEOUT","IF","ELSE",
"ALL_UNITS_OFF","ALL_LIGHTS_ON","ON","OFF","DIM","BRIGHT","ALL_LIGHTS_OFF","EXTENDED_CODE",
"HAIL_REQUEST","HAIL_ACKNOWLEDGE","PRESET_DIM1","PRESET_DIM2","EXTENDED_DATA_TRANSFER",
"STATUS_ON","STATUS_OFF","STATUS_REQUEST","COMMA","COLON","BRACE_LEFT","BRACE_RIGHT",
"PAREN_LEFT","PAREN_RIGHT","SEMI","LAMP","APPLIANCE","MOTION_DETECTOR","SIGNAL",
"TRANSCEIVER","EXAMPLE","conf","declaration_statements","declaration_statement",
"opt_name","name","type","state_list","state","commands","commands_braced","command_statement",
"expression","alias_list","alias","device_list","device","function", NULL
};
#endif

static const short yyr1[] = {     0,
    49,    49,    50,    50,    51,    51,    51,    51,    51,    51,
    51,    51,    51,    51,    52,    52,    53,    54,    54,    54,
    54,    54,    55,    55,    56,    57,    57,    57,    58,    58,
    59,    59,    59,    59,    60,    61,    61,    62,    63,    63,
    64,    65,    65,    65,    65,    65,    65,    65,    65,    65,
    65,    65,    65,    65,    65,    65,    65
};

static const short yyr2[] = {     0,
     1,     0,     2,     1,     3,     2,     3,     2,     4,     4,
     6,     2,     2,     1,     1,     0,     1,     1,     1,     1,
     1,     1,     3,     1,     3,     3,     2,     1,     2,     1,
     2,     2,     5,     2,     0,     3,     1,     1,     3,     1,
     1,     1,     1,     1,     1,     3,     3,     1,     1,     1,
     1,     1,     1,     5,     1,     1,     1
};

static const short yydefact[] = {     2,
    16,     0,     0,     0,     0,     0,     0,     0,     0,    14,
     1,     4,    17,     0,    15,    41,     0,    40,    38,     0,
    37,     8,     0,     0,     6,    12,    13,     3,     0,     0,
    18,    19,    20,    21,    22,     5,     7,     0,     0,     0,
     0,    24,     0,    39,    36,     9,    10,     0,     0,     0,
     0,     0,     0,     0,     0,    11,    28,    23,    42,    43,
    44,    45,     0,     0,    48,    49,    50,    51,    52,    53,
     0,    55,    56,    57,    25,    31,    32,    35,    34,    27,
    30,     0,     0,     0,     0,     0,    26,    29,    46,    47,
     0,     0,     0,    33,    54,     0,     0,     0
};

static const short yydefgoto[] = {    96,
    11,    12,    14,    15,    36,    41,    42,    56,    82,    57,
    86,    43,    21,    17,    18,    75
};

static const short yypact[] = {    -5,
    17,    20,    29,    31,    22,    23,    37,    38,    24,-32768,
    -5,-32768,-32768,   -31,-32768,-32768,    35,-32768,-32768,     5,
-32768,-32768,    44,    45,-32768,-32768,-32768,-32768,    29,    20,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,    29,    46,    47,
   -24,-32768,    -6,-32768,-32768,-32768,-32768,    15,    29,    34,
    29,    48,    30,    15,     6,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,    36,    39,-32768,-32768,-32768,-32768,-32768,-32768,
    40,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,     8,    58,    60,    61,    42,-32768,-32768,-32768,-32768,
    49,    15,    70,-32768,-32768,    85,    87,-32768
};

static const short yypgoto[] = {-32768,
-32768,    77,-32768,-32768,-32768,-32768,   -35,   -53,-32768,-32768,
-32768,    86,    52,-32768,    62,-32768
};


#define	YYLAST		92


static const short yytable[] = {     1,
    79,    81,     2,     3,     4,     5,     6,    37,    29,     7,
     8,     9,    51,    58,    51,    76,    48,    49,    52,    13,
    52,    51,    16,    53,    54,    53,    54,    52,    88,    38,
    50,    19,    53,    54,    22,    23,    24,    27,    94,    25,
    38,    26,    10,    55,    80,    55,    87,    39,    40,    46,
    47,    77,    55,    59,    60,    61,    62,    63,    64,    65,
    66,    67,    68,    69,    70,    71,    72,    73,    74,    78,
    30,    89,    83,    90,    91,    84,    85,    31,    32,    33,
    34,    35,    92,    95,    97,    93,    98,    28,    20,    45,
     0,    44
};

static const short yycheck[] = {     5,
    54,    55,     8,     9,    10,    11,    12,     3,    40,    15,
    16,    17,     7,    49,     7,    51,    41,    42,    13,     3,
    13,     7,     3,    18,    19,    18,    19,    13,    82,    36,
    37,     3,    18,    19,     4,    14,    14,    14,    92,     3,
    36,     4,    48,    38,    39,    38,    39,     4,     4,     4,
     4,     4,    38,    20,    21,    22,    23,    24,    25,    26,
    27,    28,    29,    30,    31,    32,    33,    34,    35,    40,
    36,    14,    37,    14,    14,    37,    37,    43,    44,    45,
    46,    47,    41,    14,     0,    37,     0,    11,     3,    38,
    -1,    30
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"
/* This file comes from bison-1.28.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 217 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 5:
#line 136 "conf-parse.y"
{
		Stacklist_Entry *stacklist_entry;
		Device *device;
		Alias *alias;
		char *name;
		
		/* Apply the type given to each device in the list. */
		for(stacklist_entry=yyvsp[-1].stacklist.first; stacklist_entry != NULL; stacklist_entry=stacklist_entry->previous) {
			device=(Device *) stacklist_entry->info;
			device->type=yyvsp[0].integer;
		}
		
		/* 
		 * Steal the entries from the list and add them to the
		 * devicelist.  We also need to make aliases for each so we
		 * can look them up.
		 */
		for(stacklist_entry=yyvsp[-1].stacklist.first; stacklist_entry != NULL; stacklist_entry=yyvsp[-1].stacklist.first) {
			device=(Device *) stacklist_entry->info;
			
			/* Remove the top one from the list. */
			stacklist_remove(&yyvsp[-1].stacklist, stacklist_entry);
			
			/* Insert the device to the devicelist. */
			stacklist_insert(&conf_devicelist, device);
			
			/* Create an alias for this device with its name. */
			name=strdup(device->name);
			if(!name) {
				fatal("Out of memory.");
			}
			alias=conf_alias_create(name, 1, device);
			stacklist_insert(&conf_aliaslist, alias);
		}
		
		/* Free the stacklist leftovers. */
		stacklist_free(&yyvsp[-1].stacklist);
	;
    break;}
case 6:
#line 174 "conf-parse.y"
{
		
		/* If the housecode has already been set, error. */
		if(conf_housecode != -1) {
			yyerror("HOUSECODE was already set.");
			break;
		}
		
		/* This must be a letter from 'a' to 'p'. */
		if(strlen(yyvsp[0].identifier) != 1) {
			yyerror("Invalid housecode, '%s'.", yyvsp[0].identifier);
			break;
		}
		if((tolower(yyvsp[0].identifier[0]) < 'a') && (tolower(yyvsp[0].identifier[0]) > 'p')) {
			yyerror("Invalid housecode, '%s'.", yyvsp[0].identifier);
			break;
		}
		
		/* Save its value. */
		conf_housecode=housecode_table[tolower(yyvsp[0].identifier[0])];
	;
    break;}
case 7:
#line 195 "conf-parse.y"
{
		Stacklist_Entry *stacklist_entry;
		Alias *alias;
		Alias *newalias;
		int i;
		
		/* Make sure the identifier given doesn't conflict. */
		alias=conf_aliaslist_lookup(yyvsp[0].identifier);
		if(alias) {
			yyerror("New alias name '%s' conflicts with previous definition.");
			break;
		}
		
		/* If we have no valid aliases, just skip this statement. */
		if(yyvsp[-1].stacklist.entries == 0) {
			stacklist_free(&yyvsp[-1].stacklist);
			break;
		}
		
		/* Create a new alias structure. */
		newalias=conf_alias_create(yyvsp[0].identifier, 0);
		
		/* Add the device pointers from each alias to our new alias. */
		for(stacklist_entry=yyvsp[-1].stacklist.first; stacklist_entry != NULL; stacklist_entry=stacklist_entry->previous) {
			alias=(Alias *) stacklist_entry->info;
			for(i=0; i < alias->devices; i++) {
				conf_alias_insert_device(newalias, alias->device[i]);
			}
		}
		
		/* Add this alias to the aliaslist. */
		stacklist_insert(&conf_aliaslist, newalias);
		
		/* Free the alias list. */
		stacklist_free(&yyvsp[-1].stacklist);
	;
    break;}
case 8:
#line 231 "conf-parse.y"
{
		
		/* If the tty has already been set, this is an error. */
		if(conf_tty) {
			yyerror("TTY already set to '%s'.", conf_tty);
			break;
		}
		
		/* Set this tty as the tty to use. */
		conf_tty=yyvsp[0].string;
	;
    break;}
case 9:
#line 242 "conf-parse.y"
{
		struct passwd *passwd;
		struct group *group;
		
		/* If it was already set, error. */
		if(conf_daemon_socket_uid != -1 && conf_daemon_socket_gid != -1) {
			yyerror("DAEMON_SOCKET already specified.");
			break;
		}
		
		/* Lookup the UID for the user name and save it. */
		passwd=getpwnam(yyvsp[-1].string);
		if(!passwd) {
			yyerror("Could not get the UID for passwd '%s'.", yyvsp[-1].string);
			break;
		}
		conf_daemon_socket_uid=passwd->pw_uid;
		
		/* Lookup the GID for the group name and save it. */
		group=getgrnam(yyvsp[0].string);
		if(!group) {
			yyerror("Could not get the GID for group '%s'.", yyvsp[0].string);
			break;
		}
		conf_daemon_socket_gid=group->gr_gid;
		
		/* Save the rest of the settings. */
		conf_daemon_socket_mode=yyvsp[-2].integer;
	;
    break;}
case 10:
#line 271 "conf-parse.y"
{
		struct passwd *passwd;
		struct group *group;
		
		/* If it was already set, error. */
		if(conf_daemon_monitor_socket_uid != -1 && conf_daemon_monitor_socket_gid != -1) {
			yyerror("DAEMON_MONITOR_SOCKET already specified.");
 			break;
		}
		
		/* Lookup the UID for the user name and save it. */
		passwd=getpwnam(yyvsp[-1].string);
		if(!passwd) {
			yyerror("Could not get the UID for user '%s'.", yyvsp[-1].string);
			break;
		}
		conf_daemon_monitor_socket_uid=passwd->pw_uid;
		
		/* Lookup the GID for the group name and save it. */
		group=getgrnam(yyvsp[0].string);
		if(!group) {
			yyerror("Could not get the GID for group '%s'.", yyvsp[0].string);
			break;
		}
		conf_daemon_monitor_socket_gid=group->gr_gid;
		
		/* Save the rest of the settings. */
		conf_daemon_monitor_socket_mode=yyvsp[-2].integer;
	;
    break;}
case 11:
#line 300 "conf-parse.y"
{
		Macro *macro;
		
		/* Allocate a macro structure. */
		macro=malloc(sizeof(Macro));
		if(!macro) fatal("Out of memory.");
		
		/* Fill all the fields of the macro. */
		macro->name=yyvsp[-4].string;
		macro->statetable=yyvsp[-2].table;
		macro->macro_commands=yyvsp[0].macro_commands;
		
		/* 
		 * *** 
		 * Need to make sure the macro doesn't conflict.  Names can
		 * conflict.
		 */
		
		/* Add the macro to the list. */
		stacklist_insert(&conf_macrolist, macro);
	;
    break;}
case 12:
#line 321 "conf-parse.y"
{
		
		/* If it was already set, error. */
		if(conf_daemon_dir) {
			yyerror("DAEMON_DIR already specified as '%s'.", conf_daemon_dir);
			break;
		}
		
		/* Save this value. */
		conf_daemon_dir=yyvsp[0].string;
	;
    break;}
case 13:
#line 332 "conf-parse.y"
{
		
		/* If it was already set, error. */
		if(conf_daemon_command_timeout != -1) {
			yyerror("DAEMON_COMMAND_TIMEOUT already specified as '%i'.", conf_daemon_command_timeout);
			break;
		}
		
		/* Save this value. */
		conf_daemon_command_timeout=yyvsp[0].integer;
	;
    break;}
case 14:
#line 343 "conf-parse.y"
{
		
		/* 
		 * Trying to use the example configuration without modifying
		 * it first is a bad idea. 
		 */
		yyerror("You have not yet configured ppower, please edit '%s'.", CONFIG_FILE);
		exit(1);
	;
    break;}
case 15:
#line 353 "conf-parse.y"
{yyval.string=yyvsp[0].string;;
    break;}
case 16:
#line 354 "conf-parse.y"
{yyval.string=NULL;;
    break;}
case 17:
#line 356 "conf-parse.y"
{yyval.string=yyvsp[0].identifier;;
    break;}
case 18:
#line 358 "conf-parse.y"
{yyval.integer=DEVICE_LAMP;;
    break;}
case 19:
#line 359 "conf-parse.y"
{yyval.integer=DEVICE_APPLIANCE;;
    break;}
case 20:
#line 360 "conf-parse.y"
{yyval.integer=DEVICE_MOTION_DETECTOR;;
    break;}
case 21:
#line 361 "conf-parse.y"
{yyval.integer=DEVICE_SIGNAL;;
    break;}
case 22:
#line 362 "conf-parse.y"
{yyval.integer=DEVICE_TRANSCEIVER;;
    break;}
case 23:
#line 364 "conf-parse.y"
{
		
		/* Add the state to the table. */
		table_insert(yyval.table, &yyvsp[0].state);
	;
    break;}
case 24:
#line 369 "conf-parse.y"
{
		
		/* Create a table to pass up. */
		yyval.table=table_create(sizeof(State));
		
		/* Insert this state to the table. */
		table_insert(yyval.table, &yyvsp[0].state);
	;
    break;}
case 25:
#line 378 "conf-parse.y"
{
		Stacklist_Entry *stacklist_entry;
		Alias *alias;
		
		/* Initialize the state and save the function. */
		yyval.state.devices=0;
		yyval.state.device=NULL;
		yyval.state.function=yyvsp[0].function;
		
		/* Add all the device pointers in each alias to the state. */
		for(stacklist_entry=yyvsp[-2].stacklist.first; stacklist_entry != NULL; stacklist_entry=stacklist_entry->previous) {
			alias=(Alias *) stacklist_entry->info;
			
			/* Make room for these devices. */
			yyval.state.device=realloc(yyval.state.device, (yyval.state.devices + alias->devices) * sizeof(Device *));
			if(yyval.state.device == NULL) {
				fatal("Out of memory.");
			}
			
			/* Copy the new ones in. */
			(void) memcpy(yyval.state.device + yyval.state.devices, alias->device, alias->devices * sizeof(Device *));
			
			/* Mark that we have these new ones. */
			yyval.state.devices += alias->devices;
		}
		
		/* Free the alias list. */
		stacklist_free(&yyvsp[-2].stacklist);
	;
    break;}
case 26:
#line 408 "conf-parse.y"
{
		yyval.macro_commands=yyvsp[-1].macro_commands;
	;
    break;}
case 27:
#line 411 "conf-parse.y"
{
		
		/* We have nothing. */
		yyval.macro_commands.commands=0;
		yyval.macro_commands.macro_command=NULL;
	;
    break;}
case 28:
#line 417 "conf-parse.y"
{
		
		/* We have only one statement, add it. */
		yyval.macro_commands.commands=1;
		yyval.macro_commands.macro_command=malloc(sizeof(Macro_Command));
		if(!yyval.macro_commands.macro_command) {
			fatal("Out of memory.");
		}
		yyval.macro_commands.macro_command[0]=yyvsp[0].macro_command;
	;
    break;}
case 29:
#line 428 "conf-parse.y"
{
		int i;
		
		/* Carry up the passed commands as our own. */
		yyval.macro_commands=yyvsp[-1].macro_commands;
		
		/* Make space for the new commands. */
		yyval.macro_commands.macro_command=realloc(yyval.macro_commands.macro_command, (yyval.macro_commands.commands + yyvsp[0].macro_commands.commands) * sizeof(Macro_Command));
		if(!yyval.macro_commands.macro_command) {
			fatal("Out of memory.");
		}
		
		/* Add these statements to the command list. */
		for(i=yyval.macro_commands.commands; i < yyval.macro_commands.commands + yyvsp[0].macro_commands.commands; i++) {
			yyval.macro_commands.macro_command[i]=yyvsp[0].macro_commands.macro_command[i - yyval.macro_commands.commands];
		}
		yyval.macro_commands.commands += yyvsp[0].macro_commands.commands;
		
		/* Free the cruft left on the passed commands structure. */
		free(yyvsp[0].macro_commands.macro_command);
	;
    break;}
case 30:
#line 449 "conf-parse.y"
{
		yyval.macro_commands=yyvsp[0].macro_commands;
	;
    break;}
case 31:
#line 453 "conf-parse.y"
{
		
		/* Store the state. */
		yyval.macro_command.type=MACRO_COMMAND_COMMAND;
		yyval.macro_command.info.command_command.state=yyvsp[0].state;
	;
    break;}
case 32:
#line 459 "conf-parse.y"
{
		
		/* Store the commandline. */
		yyval.macro_command.type=MACRO_COMMAND_RUN;
		yyval.macro_command.info.command_run.commandline=yyvsp[0].string;
	;
    break;}
case 33:
#line 465 "conf-parse.y"
{
		
		/* Store if's info. */
		yyval.macro_command.type=MACRO_COMMAND_IF;
		yyval.macro_command.info.command_if.expression=yyvsp[-2].expression;
		yyval.macro_command.info.command_if.macro_commands=yyvsp[0].macro_commands;
	;
    break;}
case 34:
#line 472 "conf-parse.y"
{
		
		/* Store else's info. */
		yyval.macro_command.type=MACRO_COMMAND_ELSE;
		yyval.macro_command.info.command_else.macro_commands=yyvsp[0].macro_commands;
	;
    break;}
case 35:
#line 479 "conf-parse.y"
{
		
		/* *** */
	;
    break;}
case 36:
#line 484 "conf-parse.y"
{
	
		/* If the alias didn't error, insert it. */
		if(yyvsp[0].alias != NULL) stacklist_insert(&yyval.stacklist, yyvsp[0].alias);
	;
    break;}
case 37:
#line 489 "conf-parse.y"
{
		
		/* Initialize the alias list. */
		stacklist_init(&yyval.stacklist);
		
		/* If this alias didn't error, insert it. */
		if(yyvsp[0].alias != NULL) stacklist_insert(&yyval.stacklist, yyvsp[0].alias);
	;
    break;}
case 38:
#line 498 "conf-parse.y"
{
		Alias *alias;
		
		/* Aliases alias aliases. :)  Find the alias this one specifies. */
		alias=conf_aliaslist_lookup(yyvsp[0].identifier);
		if(!alias) {
			yyerror("No such alias name, '%s'.", yyvsp[0].identifier);
			yyval.alias=NULL;
			break;
		}
		
		/* Pass this one up. */
		yyval.alias=alias;
	;
    break;}
case 39:
#line 513 "conf-parse.y"
{
	
		/* If the device didn't error, insert it. */
		if(yyvsp[0].device != NULL) stacklist_insert(&yyval.stacklist, yyvsp[0].device);
	;
    break;}
case 40:
#line 518 "conf-parse.y"
{
		
		/* Initialize the device list. */
		stacklist_init(&yyval.stacklist);
		
		/* If this device didn't error, insert it. */
		if(yyvsp[0].device != NULL) stacklist_insert(&yyval.stacklist, yyvsp[0].device);
	;
    break;}
case 41:
#line 527 "conf-parse.y"
{
		char *endptr;
		int housecode_index;
		int devicecode_index;
		
		/* 
		 * This should be a basic type like 'A2'.  Note they are case
		 * insensitive as are all identifiers.
		 */
		if(tolower(yyvsp[0].identifier[0]) < 'a' || tolower(yyvsp[0].identifier[0]) > 'p') {
			yyerror("Identifier '%s' is not a valid device.", yyvsp[0].identifier);
			yyval.device=NULL;
			break;
		}
		housecode_index=tolower(yyvsp[0].identifier[0]) - 'a';
		
		/* The digit should be between 1 and 16. */
		errno=0;
		devicecode_index=strtol(&yyvsp[0].identifier[1], &endptr, 10);
		if(errno || devicecode_index < 1 || devicecode_index > 16) {
			yyerror("Identifier '%s' is not a valid device.", yyvsp[0].identifier);
			yyval.device=NULL;
			break;
		}
		devicecode_index--;
		
		/* We shouldn't have any more identifier. */
		if(*endptr != 0) {
			yyerror("Identifier '%s' is not a valid device.", yyvsp[0].identifier);
			yyval.device=NULL;
			break;
		}
		
		/* Create this device and pass it up. */
		yyval.device=conf_device_create(yyvsp[0].identifier, housecode_table[housecode_index], devicecode_table[devicecode_index], DEVICE_UNDEFINED);
	;
    break;}
case 42:
#line 564 "conf-parse.y"
{yyval.function.command=COMMAND_ALL_UNITS_OFF;;
    break;}
case 43:
#line 565 "conf-parse.y"
{yyval.function.command=COMMAND_ALL_LIGHTS_ON;;
    break;}
case 44:
#line 566 "conf-parse.y"
{yyval.function.command=COMMAND_ON;;
    break;}
case 45:
#line 567 "conf-parse.y"
{yyval.function.command=COMMAND_OFF;;
    break;}
case 46:
#line 568 "conf-parse.y"
{
		yyval.function.command=COMMAND_DIM;
		
		/* The integer must be from 0 to 22. */
		if(yyvsp[0].integer < 0 || yyvsp[0].integer > 22) {
			
			/* Error and return the value as 0. */
			yyerror("Dim value '%i' out of range.  Must be 0-22.", yyvsp[0].integer);
			yyval.function.extended1=0;
			break;
		}
		
		yyval.function.extended1=yyvsp[0].integer;
	;
    break;}
case 47:
#line 582 "conf-parse.y"
{
		yyval.function.command=COMMAND_BRIGHT;
		
		/* The integer must be from 0 to 22. */
		if(yyvsp[0].integer < 0 || yyvsp[0].integer > 22) {
			
			/* Error and return the value as 0. */
			yyerror("Bright value '%i' out of range.  Must be 0-22.", yyvsp[0].integer);
			yyval.function.extended1=0;
			break;
		}
		
		yyval.function.extended1=yyvsp[0].integer;
	;
    break;}
case 48:
#line 596 "conf-parse.y"
{yyval.function.command=COMMAND_ALL_LIGHTS_OFF;;
    break;}
case 49:
#line 597 "conf-parse.y"
{yyval.function.command=COMMAND_EXTENDED_CODE;;
    break;}
case 50:
#line 598 "conf-parse.y"
{yyval.function.command=COMMAND_HAIL_REQUEST;;
    break;}
case 51:
#line 599 "conf-parse.y"
{yyval.function.command=COMMAND_HAIL_ACKNOWLEDGE;;
    break;}
case 52:
#line 600 "conf-parse.y"
{yyval.function.command=COMMAND_PRESET_DIM1;;
    break;}
case 53:
#line 601 "conf-parse.y"
{yyval.function.command=COMMAND_PRESET_DIM2;;
    break;}
case 54:
#line 602 "conf-parse.y"
{
		yyval.function.command=COMMAND_EXTENDED_DATA_TRANSFER;
		
		/* The extended values must be 0-255. */
		if(yyvsp[-2].integer < 0 || yyvsp[-2].integer > 255) {
			yyerror("Extended value '%i' out of range.", yyvsp[-2].integer);
			yyval.function.extended1=0;
			yyval.function.extended2=0;
			break;
		}
		if(yyvsp[0].integer < 0 || yyvsp[0].integer > 255) {
			yyerror("Extended value '%i' out of range.", yyvsp[0].integer);
			yyval.function.extended1=0;
			yyval.function.extended2=0;
			break;
		}
		
		yyval.function.extended1=yyvsp[-2].integer;
		yyval.function.extended2=yyvsp[0].integer;
	;
    break;}
case 55:
#line 622 "conf-parse.y"
{yyval.function.command=COMMAND_STATUS_ON;;
    break;}
case 56:
#line 623 "conf-parse.y"
{yyval.function.command=COMMAND_STATUS_OFF;;
    break;}
case 57:
#line 624 "conf-parse.y"
{yyval.function.command=COMMAND_STATUS_REQUEST;;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 543 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 626 "conf-parse.y"

