/*
 * Simple table data structure.
 * Copyright (C) 1999  Steven Brown
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Steven Brown <swbrown@ucsd.edu>
 *
 * $Id: table.c,v 1.2 1999/05/19 08:22:17 kefka Exp $
 */

#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "table.h"
#include "error.h"


/* Create a table. */
Table *table_create(int entry_size) {
	Table *table;
	
	/* Malloc the table. */
	table=malloc(sizeof(Table));
	if(!table) fatal("Out of memory.");
	
	/* Set the defaults. */
	table->entries=0;
	table->data=NULL;
	table->entry_size=entry_size;
	
	/* Return the table. */
	return(table);
}


/* Free a table. */
void table_free(Table *table) {
	
	/* Free it. */
	free(table->data);
	free(table);
	
	return;
}


/* Insert to the table. */
void table_insert(Table *table, void *data) {
	
	/* Make more room in the table. */
	table->data=realloc(table->data, (table->entries + 1) * table->entry_size);
	if(!table->data) fatal("Out of memory.");
	
	/* Insert to the table. */
	(void) memcpy(table->data + (table->entries * table->entry_size), data, table->entry_size);
	
	/* Mark we have another entry. */
	table->entries++;
	
	return;
}
