#ifndef __CTLR_MAP_HPP
#define __CTLR_MAP_HPP
/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  10/5/98
*
*****************************************************************************
*
* File Name:        ctlr_map.hpp
* Module:
* Contributors:     Kevin Caporaso <caporaso_kevin@dpt.com>
* Description:
* Version Control:
*
* $Revision: 17 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

#ifndef _NFILE
# define _NFILE 60
#endif

class DPTControllerMap 
{
#if !defined _DPT_MSDOS
protected:
#else
public:
#endif

#if defined _DPT_SCO || defined _DPT_NETWARE || defined _DPT_FREE_BSD || defined _DPT_MSDOS || defined _DPT_BSDI
enum PathExists_t {
    PathExists_None,
    PathExists_Exists,
    PathExists_Read,
    PathExists_Open,
    PathExists_Busy
};
#else
enum PathExists {
    PathExists_None,
    PathExists_Exists,
    PathExists_Read,
    PathExists_Open,
    PathExists_Busy
};
#endif

public:
        DPTControllerMap();
        virtual ~DPTControllerMap();

        // Methods.
        void init();
    int Realloc(unsigned char** array, unsigned* size,
        unsigned newSize, int fill);
    int Realloc(unsigned char** array, unsigned char* size,
    	unsigned newSize, int fill);
    int Realloc(char*** array, unsigned char* size,
    	unsigned newSize, int fill);
        char* Strdup(char* String);
        char* getAdapterString(int hba);
        char* getAdapterPath(int hba);
        char* getChannelString(int hba, int bus);
        char* getChannelPath(int hba, int bus); 
        char* getControllerString(int hba, int bus);
        char* getTargetString(int hba, int bus, int target, int lun, int hidden = 0);
        char* getTargetPath(int hba, int bus, int target, int lun);
        int getController(int hba, int bus);
        int getHba(int controller);
        int getBus(int controller);
        static void Reset();

private:
        // Member variables.
        static unsigned char* controller2Dpt;
        static unsigned char  controller2DptSize;
        static unsigned char* dpt2Controller;
        static unsigned char  dpt2ControllerSize;
        static char**         dpt2Path;
        static unsigned char  dpt2PathSize;

protected:
        static int            popen_pid[_NFILE];
        // Methods.
        FILE * SafePopenRead(char* commands);
        int SafePclose(FILE* fp);
#if defined _DPT_SCO || defined _DPT_NETWARE || defined _DPT_FREE_BSD || defined _DPT_MSDOS || defined _DPT_BSDI
        PathExists_t PathExists(char* path);
#else
        enum PathExists PathExists(char* path);
#endif
};

#endif //__CTLR_MAP_HPP
