//File - ENGLISTS.CPP
//***************************************************************************
//
//Description:
//
//    This file contains the function definitions for the DPT engine
//list classes.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		1/22/93
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


//Include Files -------------------------------------------------------------

#include	"allfiles.hpp"	// All engine include files
#include	"englists.hpp"
#include	"core.hpp"
#include	"raid.h"
#include	"eng_ccb.hpp"
#include	"eng_std.h"


//Definitions - Defines & Constants -----------------------------------------


//Definitions - Structure & Typedef -----------------------------------------


//Variables - External ------------------------------------------------------


//Variables - Global --------------------------------------------------------


//Variables - Static --------------------------------------------------------


//Prototypes - function -----------------------------------------------------


//Function - dptCoreList_C::getObject() - start
//===========================================================================
//
//Description:
//
//    This operator returns a pointer to an object with the specified tag.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

void *	dptCoreList_C::getObject(DPT_TAG_T tgtTag)
{


uSHORT		done = 0;
dptCore_C	*obj_P;

  // Start the search from the head element
obj_P = (dptCore_C *) reset();
while ( (obj_P!=NULL) && (!done) ) {
   if (obj_P->tag()==tgtTag) done = 1;
   else obj_P = (dptCore_C *) next();
}

return(cur());

}
//dptCoreList_C::getObject() - end


//Function - del() - start
//===========================================================================
//
//Description:
//
//    This function deletes the object pointed to by the thisEl_P
//pointer and removes the associated element from the list.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

//Function - del(void *) - start
//===========================================================================
//
//Description:
//
//    This function deletes the specified object and removes the
//associated element from the list.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

//Function - kill() - start
//===========================================================================
//
//Description:
//
//    This function deletes all objects in the list and their
//associated list elements.  After calling this routine the
//list contains no elements.
//
//Parameters:
//
//Return Value:
//
//Global Variables Affected:
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//
//---------------------------------------------------------------------------

//===========================================================================

#ifdef	DEL_TYPE
   #undef	DEL_TYPE
#endif
#define	DEL_TYPE		raidDef_S

void *	dptRAIDdefList_C :: del()
{
#include        "del1.cpp"
}

void *	dptRAIDdefList_C :: del(void *obj_P)
{
#include        "del2.cpp"
}

void	dptRAIDdefList_C :: kill()
{
#include        "kill.cpp"
}

//===========================================================================

#ifdef	DEL_TYPE
   #undef	DEL_TYPE
#endif
#define	DEL_TYPE		dptCore_C

void *	dptCoreDelList_C :: del()
{
#include        "del1.cpp"
}

void *	dptCoreDelList_C :: del(void *obj_P)
{
#include        "del2.cpp"
}

void	dptCoreDelList_C :: kill()
{
#include        "kill.cpp"
}

//===========================================================================

#ifdef	DEL_TYPE
   #undef	DEL_TYPE
#endif
#define	DEL_TYPE		engCCB_C

void *	dptCCBlist_C :: del()
{
#include        "del1.cpp"
}

void *	dptCCBlist_C :: del(void *obj_P)
{
#include        "del2.cpp"
}

void	dptCCBlist_C :: kill()
{
#include        "kill.cpp"
}

//===========================================================================


