/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  12/11/98
*
*****************************************************************************
*
* File Name:		findpath.h
* Module:
* Contributors:		Mark Salyzyn <salyzyn@dpt.com>
* Description:
* Version Control:
*
*****************************************************************************/

#if (defined(__cplusplus))
 extern "C" {
#endif

/*** INCLUDES ***/

#if (defined(NEXT))
# include <libc.h>
#elif (defined(_WIN32) || defined(_DPT_WIN_NT))
# define F_OK 0
# undef X_OK 
# define X_OK 4	/* An executable under NT is just readable */
# define W_OK 2
# define R_OK 4
# include <io.h>
#else
# include <unistd.h>
#endif

/*** PROCEDURE PROTOTYPE ***/

#if (!defined(__PMT))
# define __PMT(x)	x
#endif
#if (!defined(CONST))
# define CONST const
#endif

char * FindPath __PMT((CONST char * file, int mode));
char * AddSearchArgv __PMT((char * search));
char * AddSearch __PMT((char * searchLeft, CONST char * searchRight));
char * FindPathWithSearch __PMT((CONST char * file, int mode, CONST char * search));

#if (defined(__cplusplus))
 }
#endif
