#ifndef		__DSTATLOG_HPP
#define         __DSTATLOG_HPP

//File - DSTATLOG.HPP
//***************************************************************************
//
//Description:
//
//    This function defines the dptDevStatLog_C class.  This class is used
//to access a device's read/write statistic log page information.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		6/4/93
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


//Include Files -------------------------------------------------------------

#include	"dpt_log.hpp"


#if !defined (_SINIX)
//class - dptDevStatLog_C - start
//===========================================================================
//
//Description:
//
//    This class defines a class to manipulate the SCSI device
//statistics log page information returned by the DPT controller.
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//---------------------------------------------------------------------------

class	dptDevStatLog_C : public dptSCSIlog_C
{

protected:

// Virtual Functions..................................

     // Called from reverseAllParams() for each parameter encountered.
     //   - Allows the data portion of each parameter to be reversed
   virtual void		reverseParam();

public:

	dptDevStatLog_C() : dptSCSIlog_C()
		{
		}

};
//dptDevStatLog_C - end


//===========================================================================
//
//Description:
//
//    This class defines a class to manipulate the global HBA statistics
//log page information returned by the DPT controller.
//
//Remarks: (Side effects, Assumptions, Warnings...)
//
//---------------------------------------------------------------------------

class	dptHBAstatLog_C : public dptSCSIlog_C
{

protected:

// Virtual Functions..................................

     // Called from reverseAllParams() for each parameter encountered.
     //   - Allows the data portion of each parameter to be reversed
   virtual void		reverseParam();

public:

	dptHBAstatLog_C() : dptSCSIlog_C()
		{
		}
};
//dptHBAstatLog_C - end
#endif // sinix


#endif

