#ifndef		__STATS_H
#define		__STATS_H

//File - STATS.H
//***************************************************************************
//
//Description:
//
//    This function contains structure definitions for the HBA &
//Device statistics maintained by the DPT controllers.
//
//Copyright Distributed Processing Technology, Corp.
//	  140 Candace Dr.
//	  Maitland, Fl.	32751   USA
//	  Phone: (407) 830-5522  Fax: (407) 260-5366
//	  All Rights Reserved
//
//Author:	Doug Anderson
//Date:		6/11/93
//
//Editors:
//
//Remarks:
//
//
//***************************************************************************


#include	"osd_util.h"


//Definitions - Structure & Typedef -----------------------------------------

  // Device Read Statistics
typedef struct {
   uLONG	cmds;		// # read commands
   uLONG	notCached;	// # reads not cached
   uLONG	lookAheadCmds;	// # look ahead commands
   uLONG	lookAheadBlks;	// # blocks brought in by look aheads
   uLONG        lookAheadHits;	// # read hits due to look ahead cmds
   uLONG	blksMissed;	// # read blocks that were not cache hits
   uLONG	blksHit;	// # read blocks that were cache hits
   uLONG	seqLAblks;	// # blocks read in anticipating
				// sequential reads
   uLONG	seqLAhits;	// # hits due to seqLAblks
} readStats_S;

  // Device Write Statistics
typedef struct {
   uLONG	cmds;		// # write commands
   uLONG	notCached;	// # writes not cached
   uLONG	writeThru;	// # forced write thru commands (thru cache)
   uLONG	writeArounds;	// # forced write around commands
				//   (not thru cache)
   uLONG	softErrors;	// # recovered soft errors
   uLONG	blksHit;	// # write blocks that were cache hits
   uLONG	idleWrBacks;	// # idle write back cmds issued
   uLONG	activeWrBacks;	// # active write back cmds issued
   uLONG	wrBackBlks;	// # blocks written using write backs
   uLONG	wrCleanBlks;	// # clean blocks written back
} writeStats_S;

  // Miscellaneous Device Statistics
typedef struct {
   uLONG	disconnects;	// # of disconnects performed
   uLONG	numPassThru;	// # of non-read/write cmds issued
   uLONG	numSG;		// # of cmds utilizing scatter gather
   uLONG	numStripeXing;	// # stripe boundary crossings
//	uLONG numSpinUp;		// # of drive spin ups
//	uLONG numSpinDown;	// # of drive spin downs
} miscDevStats_S;

  // Host Read/Write Size Statistics
typedef struct {
   uLONG	num1k;		// # of 1k 	Reads or Writes
   uLONG	num2k;		// # of 2k 	Reads or Writes
   uLONG	num4k;		// # of 4k 	Reads or Writes
   uLONG	num8k;		// # of 8k 	Reads or Writes
   uLONG	num16k;		// # of 16k 	Reads or Writes
   uLONG	num32k;		// # of 32k 	Reads or Writes
   uLONG	num64k;		// # of 64k 	Reads or Writes
   uLONG	num128k;	// # of 128k 	Reads or Writes
   uLONG	num256k;	// # of 256k 	Reads or Writes
   uLONG	num512k;	// # of 512k	Reads or Writes
   uLONG	num1M;		// # of 1M	Reads or Writes
   uLONG	num1Mplus;	// # of 1Mplus	Reads or Writes
} rwSizeStats_S;

  // Physical Read/Write Size Statistics
typedef struct {
   uLONG	num1k;		// # of 1k 	Reads or Writes
   uLONG	num2k;		// # of 2k 	Reads or Writes
   uLONG	num4k;		// # of 4k 	Reads or Writes
   uLONG	num8k;		// # of 8k 	Reads or Writes
   uLONG	num16k;		// # of 16k 	Reads or Writes
   uLONG	num32k;		// # of 32k 	Reads or Writes
   uLONG	num64k;		// # of 64k 	Reads or Writes
   uLONG	num128k;	// # of 128k 	Reads or Writes
   uLONG	num256k;	// # of 256k 	Reads or Writes
   uLONG	num512k;	// # of 512k	Reads or Writes
   uLONG	num1M;		// # of 1M	Reads or Writes
   uLONG	num1Mplus;	// # of 1Mplus	Reads or Writes
   uLONG	cmds;		// # read or write commands
} rwSizeStat2_S;

  // Global HBA Statistics
typedef struct {
   uLONG	scsiResets;	// # SCSI bus resets
   uLONG	totalCacheBlks;	// # of blocks that can be cached
   uLONG	cachedBlks;	// current # of blocks in cache
   uLONG	dirtyBlks;	// # dirty blocks in cache
   uLONG	lockedBlks;	// # blocks loacked in cache
   uLONG        unalignedXfrs;	// # xfrs started on odd byte boundary
   uLONG	lookAheadBlks;	// # look ahead blocks in cache
   uLONG	badBlocks;	// # blocks reassigned due to ECC
   uLONG	cmdCount;	// HBA command count
} hbaStats_S;

  // Device Statistics
typedef struct {
   readStats_S		read;		// Read stats
   rwSizeStats_S	hostRdSize;	// Read size stats
   writeStats_S		write;		// Write stats
   rwSizeStats_S	hostWrSize;	// Write size stats
   miscDevStats_S	misc;		// Miscellaneous device stats
   rwSizeStat2_S	physRdSize;	// SCSI bus read size stats
   rwSizeStat2_S	physWrSize;	// SCSI bus write size stats
} devStats_S;

#endif

