#ifndef	ALARM_HPP
#define	ALARM_HPP

/****************************************************************************
*
* Copyright (C) 1998 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  12/18/98
*
*****************************************************************************
*
* File Name:		alarm.hpp
* Module:
* Contributors:		Kevin Caporaso <caporaso_kevin@dpt.com>
* Description:
* Version Control:
*
* $Revision: 2 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
#include "scsilist.hpp"
#include "intlist.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/

enum AlarmCommand { None, On, Off, Enable, Disable, Status };

class AlarmStatus:public Command
	{
	public:
		AlarmStatus::AlarmStatus( int hba, AlarmCommand cmd );							
		AlarmStatus( const AlarmStatus &new_AlarmStatus );
		virtual	~AlarmStatus();
		AlarmStatus	&operator = ( AlarmStatus &right );

		Dpt_Error		execute( String_List **output );
		Dpt_Error	    DoEachHBA( String_List** output, DPT_TAG_T hba );
		Dpt_Error	    GetInitialStatus( DPT_TAG_T hba );
		Dpt_Error 		SendCommandToEngine( DPT_TAG_T hba, String_List **output );
		Dpt_Error		EnableAlarm( AlarmCommand enable, DPT_TAG_T hba );
		Dpt_Error		GetAlarmStatus( DPT_TAG_T hba, String_List **output );
		Command			&Clone() const;

	private:
		AlarmCommand alarmCmd;
		int whichHBA;
		int alarmDisabled;
		int alarmOn;

	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
