#ifndef	CMD_LIST_HPP
#define	CMD_LIST_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/20/98
*
*****************************************************************************
*
* File Name:		Cmd_List.hpp
* Module:
* Contributors:		Lee Page
* Description:		This class encapsulates a list of command objects.  Unfortunately,
					I cannot use STL or templates, so I use a least-common denominator
					solution.
* Version Control:
*
* $Revision: 5 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/
class Command_List
	{
	public:
		Command_List();
		Command_List( const Command_List &right );
		~Command_List();
		Command_List	&operator += ( const Command_List &right );
		const Command_List & operator = ( const Command_List &right );

		void	add_Item( const Command &command );

		//	Fetches the nth command (0 based).  The user should not
		//	deallocate the returned command.  It is owned by the
		//	object.
		Command	&get_Item( int index ) const;

		//	Fetches the next command.  The user should not deallocate
		//	the returned command.  It is owned by the object.
		Command	&get_Next_Item();
		// FIFO.  Removes the first item from the list, and returns it.
		Command	&shift_Item();

		//	Resets the get_Next_Command index to point to the first item.
		void	reset_Next_Index();
		// returns the number of entries minus the index
		int		num_Left() const;
		int		get_Num_Items() const	{ return( num_Items ); }

	private:
		void	Destroy_Items();
		void	Copy_Items( const Command_List &right );

		int		num_Items;
		Command	**items;
		int		next_Item_Index;
	};


#endif
/*** END OF FILE ***/
