#ifndef	DELETRAD_HPP
#define	DELETRAD_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/29/98
*
*****************************************************************************
*
* File Name:		DeletRad.hpp
* Module:
* Contributors:		Lee Page
* Description:
* Version Control:
*
* $Revision: 6 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
#include "command.hpp"
#include "scsilist.hpp"
/*** CONSTANTS ***/
/*** TYPES ***/
class Delete_Raid: public Command
	{
	public:
		Delete_Raid(
				SCSI_Addr_List	*which_Raids,
				bool			del_Hiddens	// true for hot-spares, false for raids
				);
		Delete_Raid( const Delete_Raid &del_Raid );
		virtual	~Delete_Raid();

		Dpt_Error	execute( String_List **output );
		Command		&Clone() const;

	private:
		Dpt_Error	Delete_Raid_and_Children( DPT_TAG_T raid_Tag, String_List *out );
		void	Make_Address_List_of_All_Logicals( SCSI_Addr_List **ret_List );
      Dpt_Error CheckForSuppressed (DPT_TAG_T tag);

		SCSI_Addr_List	*raids_to_Del;
		bool			delete_Hiddens;
	};
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

#endif
/*** END OF FILE ***/
