#ifndef	INTLIST_HPP
#define	INTLIST_HPP

/****************************************************************************
*
* Copyright (C) 1996-98 Distributed Processing Technology.  All Rights Reserved.
*
* Created:  7/20/98
*
*****************************************************************************
*
* File Name:		IntList.hpp
* Module:
* Contributors:		Lee Page
* Description:      This file serves as a container class, holding a list of items.
* Version Control:
*
* $Revision: 7 $
* $NoKeywords: $
* $Log: $
*****************************************************************************/

/*** INCLUDES ***/
/*** CONSTANTS ***/
/*** TYPES ***/
/*** STATIC DATA ***/
/*** MACROS ***/
/*** PROTOTYPES ***/
/*** FUNCTIONS ***/

class Int_List
	{
	public:
		Int_List();
		Int_List( const Int_List &right );
		~Int_List();

		Int_List		&operator += ( const Int_List &right );
		const Int_List	&operator = ( const Int_List &right );

		void	add_Item( const long new_Int );

		void	set_Item(int item_pos, long item_value);

		//	Fetches the nth str (0 based).  The user should not
		//	deallocate the returned int.  It is owned by the
		//	object.
		long	get_Item( int index ) const;

		//	Fetches the next int.  The user should not deallocate
		//	the returned int.  It is owned by the object.
		long	get_Next_Item();
		//	Fetches the number of unique items.  The user should not deallocate
		//	the returned int.  It is owned by the object.
		long	get_Num_Uniques();
		// FIFO.  Removes the first item from the list, and returns it.
		long	shift_Item();

		//	Resets the get_Next_Int index to point to the first item.
		void	reset_Next_Index();
		// returns the number of entries minus the index
		int		num_Left() const;
		int		get_Num_Items() const	{ return( num_Items ); }

	private:
		void	Destroy_Items();
		void	Copy_Items( const Int_List &right );

		int		num_Items;
		long	*items;
		int		next_Item_Index;
	};

#endif
/*** END OF FILE ***/
