#include <osd_util.h>

  // Loads the specified run-time loadable DLL
DLL_HANDLE_T    osdLoadModule(uCHAR *name)
{
	DLL_HANDLE_T rtnVal;
	
	if ((rtnVal = (unsigned int*)LoadLibrary(name)) == 0)
		rtnVal = (DLL_HANDLE_T) -1;

	return(rtnVal);
}

  // Unloads the specified run-time loadable DLL
uSHORT          osdUnloadModule(DLL_HANDLE_T handle)
{
	return((uSHORT) !FreeLibrary((HMODULE)handle));	
}
  // Returns a pointer to a function inside a run-time loadable DLL
#if defined(_DPT_NETWARE) || defined(_WIN32)
void *          osdGetFnAddr(DLL_HANDLE_T handle,uCHAR *fnName)
#else
dummyFn         osdGetFnAddr(DLL_HANDLE_T handle,uCHAR *fnName)
#endif
{
	return((void *) GetProcAddress((HMODULE)handle, fnName));
}
