#ifndef		_OSD_DEFS_H
#define		_OSD_DEFS_H

/*File - OSD_DEFS.H
 ****************************************************************************
 *
 *Description:
 *
 *	This file contains the OS dependent defines.  This file is included
 *in osd_util.h and provides the OS specific defines for that file.
 *
 *Copyright Distributed Processing Technology, Corp.
 *	  140 Candace Dr.
 *	  Maitland, Fl.	32751   USA
 *	  Phone: (407) 830-5522  Fax: (407) 260-5366
 *	  All Rights Reserved
 *
 *Author:	Doug Anderson
 *Date:		1/31/94
 *
 *Editors:
 *
 *Remarks:
 *
 *
 *****************************************************************************/


/*Definitions - Defines & Constants ----------------------------------------- */

  /* Define the operating system */
#if (defined(__linux__))
# define _DPT_LINUX
#elif (defined(__bsdi__) && !defined(_DPT_BSDI))
# define _DPT_BSDI
#elif (defined(__FreeBSD__) && !defined(_DPT_FREE_BSD))
# define _DPT_FREE_BSD
#elif (defined(_DPT_SOLARIS))
# define _DPT_ERGO
#else
# define _DPT_SCO
#endif

#if defined (ZIL_CURSES)
#define		_DPT_CURSES
#else
#define         _DPT_MOTIF
#endif

  /* Redefine 'far' to nothing - no far pointer type required in UNIX */
#define		far

  /* Define the mutually exclusive semaphore type */
#define		SEMAPHORE_T	unsigned int *
  /* Define a handle to a DLL */
#define		DLL_HANDLE_T	unsigned int *

#if defined _DPT_SCO
#define min(a,b) ( (a) < (b) ? (a) : (b) )
#if !defined true
#define true TRUE
#endif // true
#endif // _DPT_SCO

#endif
