//-------------------
// RAID Specific Info
//-------------------

// Note:
//   FLG_DEV_VALID_RAID must be set for any of the below
//   data to be valid!
#undef PACK
#if (defined(__GNUC__))
# define PACK __attribute__ ((packed))
#else
#define PACK
#endif

   uSHORT		raidType;	// RAID type:
					//   0,1,3,5...
					//   0xfe = Hot Spare
					//   0xffff = No RAID
#if defined (_DPT_STRICT_ALIGN)
   uSHORT		sniAdjust2;
#endif
   uLONG		maxCompStripe PACK; // Largest component stripe size
   uLONG		minCompStripe PACK; // Smallest component stripe size
   uLONG		masterStripe PACK;  // Sum of all component stripes
					// (Only valid for RAID-0)

// Note:
//   FLG_DEV_RAID_NEXT must be set for nextRAIDmgr to be valid!

   DPT_TAG_T		nextRAIDmgr PACK; // Next manager that can use this
					// device as a RAID component

// ----- Data associated with RAID parent device -----

// Note:
//   FLG_DEV_RAID_COMPONENT must be set for any of the below
//   data to be valid!

   DPT_TAG_T		raidParent PACK; // Parent RAID device
   uLONG		stripeSize PACK; // Stripe size used by parent
   uLONG		numStripes PACK; // # stripes used by parent

