/*
 * nasd_dux_platform.h
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_DUX_PLATFORM_H_
#define _NASD__NASD_DUX_PLATFORM_H_

#ifndef KERNEL
#define _SOCKADDR_LEN
#endif /* !KERNEL */

#ifdef KERNEL
#include <track_idle.h>
#include <nasd_server.h>
#ifdef NASD_SECURE_RPCS_ENABLE
#undef NASD_SECURE_RPCS_ENABLE
#endif /* NASD_SECURE_RPCS_ENABLE */
#include <nasd_secure_rpcs_enable.h>
#include <sys/utctime.h>
#else /* KERNEL */
#include <timers.h>
#if NASD_CMU_PDL > 0
#include <pdllib.h>
#endif /* NASD_CMU_PDL > 0 */
#endif /* KERNEL */

#define nasd_int64cast(_n_)   _n_##L
#define nasd_uint64cast(_n_)  _n_##UL
#define NASD_64s_FMT          "ld"
#define NASD_64u_FMT          "lu"
#define NASD_64x_FMT          "lx"
#define NASD_64X_FMT          "lX"
#define NASD_ID_FMT           "016lx"

typedef const void * nasd_qsort_arg_type_t;

#define NASD_INLINE __inline

#define nasd_printf printf

#ifndef KERNEL

/*
 * I'm so bloody glad that sys/ioctl.h prototypes ioctl
 * _OUTSIDE_ the multiple inclusion protection under dux.
 * FREAKS.
 */
#ifdef __GNUC__
extern int ioctl(int, int, ...);
#endif /* __GNUC__ */

extern void sync(void);

#if NASD_CMU_PDL > 0
#define NASD_IDLE_SUPPORT 1
#endif /* NASD_CMU_PDL > 0 */

#endif /* !KERNEL */

#ifdef KERNEL

#if TRACK_IDLE > 0
#define NASD_IDLE_SUPPORT 1
#endif /* TRACK_IDLE > 0 */

#define NASD_USE_DUX_RW_LOCKS 1

#endif /* KERNEL */

#endif /* !_NASD__NASD_DUX_PLATFORM_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
