/*
 * nasd_generic_drive.h
 *
 * Digital Unix specific drive code
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_GENERIC_DRIVE_H_
#define _NASD__NASD_GENERIC_DRIVE_H_

/*
 * !!! This must be <= UIO_MAXIOV
 *
 * Erik's numbers suggest that 8 is an optimal value here
 * (that means that we try to achieve 64k I/Os).
 */
#define NASD_IO_MAX_COALESCE 8

#define nasd_odc_io_ent_swap_bufs(_ent1_,_ent2_) { \
  void  *_tmp_buf; \
  _tmp_buf = (_ent1_)->data.buf; \
  (_ent1_)->data.buf = (_ent2_)->data.buf; \
  (_ent2_)->data.buf = _tmp_buf; \
}

#define NASD_ODC_IO_ENT_CLEAR_PAGE(_ent_) { \
  (_ent_)->data.buf = NULL; \
}

#define NASD_ODC_IO_ENT_ASSERT_NO_PAGE(_ent_) { \
  NASD_ASSERT((_ent_)->data.buf == NULL); \
}

extern nasd_status_t nasd_od_io_init(char *devname, nasd_od_config_t *config);

#endif /* !_NASD__NASD_GENERIC_DRIVE_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
