/*
 * nasd_linux_srpc.h
 *
 * Header info for unix user-level SRPC
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD__NASD_LINUX_SRPC_H_
#define _NASD__NASD_LINUX_SRPC_H_

#define NASD_SRPC_SYS_CONN_DEFER_QUEUE      0x0001
#define NASD_SRPC_SYS_CONN_DEFER_DATAAVAIL  0x0002
#define NASD_SRPC_SYS_CONN_DEFER_DEAD       0x0004
#define NASD_SRPC_SYS_CONN_DEFER_MARKIDLE   0x0008

struct nasd_srpc_sys_conn_s {
  nasd_srpc_listener_t  *listener;
  int                    defer_state;
  nasd_srpc_conn_t      *defer_next;
};

struct nasd_srpc_sys_listener_s {
  NASD_DECLARE_MUTEX(lock)
  NASD_DECLARE_COND(conn_active_cond)
  NASD_DECLARE_COND(dead_cond)

  struct wait_queue   *defer_wq;

  struct socket       *listen_sock;
  nasd_srpc_conn_t    *defer_queue;
  nasd_srpc_conn_t    *defer_queue_tail;

  nasd_thread_t        defer_thread;
  nasd_threadgroup_t   defer_group;

  int                  stopped;
};

#define NASD_SRPC_SYS_LOCK_LISTENER(_lis_) { \
  NASD_LOCK_MUTEX((_lis_)->sys_listener.lock); \
}

#define NASD_SRPC_SYS_TRY_LOCK_LISTENER(_lis_) { \
  NASD_TRY_LOCK_MUTEX((_lis_)->sys_listener.lock); \
}

#define NASD_SRPC_SYS_UNLOCK_LISTENER(_lis_) { \
  NASD_UNLOCK_MUTEX((_lis_)->sys_listener.lock); \
}

#define NASD_SRPC_SYS_LISTENER_WAIT_FOR_DEAD(_lis_) { \
  NASD_WAIT_COND(listener->sys_listener.dead_cond, \
    listener->sys_listener.lock); \
}

#define NASD_SRPC_SYS_LISTENER_WAIT_ACTIVE_CONN(_lis_,_conn_) { \
  NASD_WAIT_COND(listener->sys_listener.conn_active_cond, \
    listener->sys_listener.lock); \
}

#define NASD_SRPC_SYS_LISTENER_SIGNAL_DEAD_COND(_lis_) { \
  NASD_SIGNAL_COND(listener->sys_listener.dead_cond); \
}

#define NASD_SRPC_SYS_LISTENER_BROADCAST_DEAD_COND(_lis_) { \
  NASD_BROADCAST_COND(listener->sys_listener.dead_cond); \
}

#define NASD_SRPC_SYS_LISTENER_SIGNAL_CONN_ACTIVE_COND(_lis_) { \
  NASD_SIGNAL_COND(listener->sys_listener.conn_active_cond); \
}

#define NASD_SRPC_SYS_LISTENER_BROADCAST_CONN_ACTIVE_COND(_lis_) { \
  NASD_BROADCAST_COND(listener->sys_listener.conn_active_cond); \
}

#endif /* !_NASD__NASD_LINUX_SRPC_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
