/*
 * nasd_cheops_mgr_internal.h
 *
 * Function prototypes and constants used by the Cheops Manager
 */
/*
 * Author: Sean Levy
 *
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#ifndef _NASD_CHEOPS_MGR_INTERNAL_H_
#define _NASD_CHEOPS_MGR_INTERNAL_H_

#include <nasd/nasd_options.h>
#include <nasd/nasd_freelist.h>
#include <nasd/nasd_types.h>
#include <nasd/nasd_itypes.h>
#include <nasd/nasd_timer.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_common.h>
#include <nasd/nasd_cheops_common.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_mgr.h>
#include <nasd/nasd_cheops_mgr_common.h>
#include <nasd/nasd_cheops_mgr_structs.h>
#include <nasd/nasd_cheops_rpc.h>
#include <nasd/nasd_marshall.h>
#include <nasd/nasd_timeout.h>
#include <nasd/nasd_shutdown.h>
#include <sys/errno.h>
#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
# include <dce/dce_error.h>
# include <rpc/rpc.h>
# include <dce/stubbase.h>
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#define NASD_CHEOPS_DEFAULT_DRIVE_RESOURCE_FILE "./cheops.dtab"
#define NASD_CHEOPS_DEFAULT_DMAP_FILE "./cheops.dmap"
#define NASD_CHEOPS_DEFAULT_PARTSIZE 1024*100 /* x 8K block size = 800 MB */
#define NASD_CHEOPS_DEFAULT_IMAP_FILE "./imap"

#define NASD_CHEOPS_PAGE_SIZE 4096

extern int Drive_Stripe_Unit;
extern int Drive_Stripe_Width;
extern nasd_cheops_raid_level_t Default_RAID_Level;
extern int NumDrives;
extern nasd_shutdown_list_t *nasd_cheops_mgr_shutdown_list;

/* init.c */
extern int dmap_alloc_chunk(
  nasd_cheops_dmap_t    *dmap,
  int                    g,
  nasd_disk_ident_t     *dr_id,
  int                   *dr_index);

/* qos.c */
extern int
nasd_cheops_bs_req_to_layout(
  nasd_cheops_qos_req_t *,
  nasd_cheops_bs_layout_t *);
extern int
nasd_cheops_bs_qos_init(
  void);

/* bsdir.c */
extern int
nasd_cheops_bsdir_cache_init(
  char          *imap_fname);
extern int
nasd_cheops_bsdir_cache_shutdown(
  void);
extern int
nasd_cheops_bs_create(
  nasd_boolean_t            do_qos,
  nasd_cheops_qos_req_t    *qos_req, 
  nasd_cheops_bs_handle_t  *bs_handle);
extern int 
nasd_cheops_bs_remove(
  nasd_identifier_t    bsid);
extern int
nasd_cheops_bs_lookup(
  nasd_identifier_t         bsid,
  nasd_cheops_bs_handle_t  *bs_handle);
extern int
nasd_cheops_bs_getattr(
  nasd_identifier_t      bsid,
  nasd_attribute_t      *attr);
extern int
nasd_cheops_bs_setattr(
  nasd_identifier_t      bsid,
  nasd_attribute_t       attr);
extern int
nasd_cheops_dr_lookup(
  nasd_disk_ident_t        dr_id,
  nasd_cheops_cl_dinfo_t  *clinfo);
extern int
nasd_cheops_mgr_lookup(
  nasd_identifier_t              bsid,
  nasd_cheops_mgr_info_t        *manager_info);

/* sec.c */
#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE
extern int
nasd_cheops_mgr_check_cookie(
  handle_t          client_handle,
  nasd_cookie_t     cookie, 
  nasd_identifier_t identifier, 
  nasd_cheops_mgr_op_t  op);
extern rpc_if_handle_t nasd_cheops_mgr_v0_2_s_ifspec; /* from mgr_sstub.c */
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_DCE */

#if NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC
# include <nasd/nasd_srpc.h>
extern int
nasd_cheops_mgr_check_cookie(
  nasd_srpc_listener_t *foo,
  nasd_srpc_conn_t *bar,
  nasd_srpc_server_call_t *baz,
  nasd_cookie_t quux,
  nasd_identifier_t quid,
  nasd_cheops_mgr_op_t quark);
#endif /* NASD_RPC_PACKAGE == NASD_RPC_PACKAGE_SRPC */

/* sst.c */
extern int
nasd_cheops_sst_mgr_init(
  void);
extern int
nasd_cheops_sst_mgr_shutdown(
  void);

/* ops.c */
extern void nasd_cheops_mgr_begin_rpc(void);
extern void nasd_cheops_mgr_end_rpc(void);
extern void nasd_cheops_mgr_timeout_shutdown_rpc(
  nasd_timeout_handle_t  tmh,
  void                  *arg1,
  void                  *arg2);
extern void nasd_cheops_mgr_wait_shutdown_rpc(void);
extern void nasd_cheops_mgr_shutdown_rpc(
  void          *ignored);
extern nasd_status_t nasd_cheops_mgr_rpc_init(void);
extern nasd_status_t nasd_cheops_mgr_startup_rpc(void);
extern void nasd_cheops_mgr_stop_rpc(void);
extern nasd_status_t nasd_cheops_mgr_rpc_listen(
  int           service_threads,
  nasd_uint16   port);
extern nasd_status_t nasd_cheops_mgr_rpc_set_stacksize(
  int           stacksize);
extern nasd_status_t nasd_cheops_mgr_really_shutdown(void);
nasd_status_t nasd_cheops_mgr_rpc_specific_init(void);
nasd_status_t nasd_cheops_mgr_rpc_specific_startup(void);
void nasd_cheops_mgr_rpc_specific_stop(void);
nasd_status_t nasd_cheops_mgr_rpc_specific_listen(int, nasd_uint16);
nasd_status_t nasd_cheops_mgr_rpc_specific_set_stacksize(int);

#endif /* !_NASD_CHEOPS_MGR_INTERNAL_H_ */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
