/*
 * nasd_cheops_mgr_structs.h
 *
 * Byte-segment inode definition
 *
 * Author: Khalil Amiri, CMU SCS/ECE, July 18 1997
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1996,1997,1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */

#ifndef  _NASD_CHEOPS_MGR_STRUCTS_H_
#define  _NASD_CHEOPS_MGR_STRUCTS_H_

#include <nasd/nasd_types.h>
#include <nasd/nasd_mem.h>
#include <nasd/nasd_threadstuff.h>
#include <nasd/nasd_cheops_types.h>
#include <nasd/nasd_cheops_common.h>

#define NASD_CHEOPS_BSINODE_USED       (1<<0) /* inode is used */
#define NASD_CHEOPS_BSINODE_REMOVED    (1<<1) /* object this inode is pointing to has been removed */
#define NASD_CHEOPS_BSINODE_FREE       (1<<2) /* inode is free */
#define NASD_CHEOPS_BSINODE_ISMIG      (1<<3) /* object is undergoing migration */
#define NASD_CHEOPS_BSINODE_RECON      (1<<4) /* object is undergoing reconstruction */

typedef struct nasd_cheops_supermap_s {
  nasd_identifier_t        lastID;
} nasd_cheops_supermap_t;

typedef struct nasd_cheops_bs_inode_s {
  int		      flags;
  nasd_identifier_t     bsg_id;
  nasd_identifier_t     bsid;
  nasd_cookie_t         create_cookie;
  nasd_cheops_raid_level_t     raid_level;
  int                   num_col;
  int                   num_data_col;
  int                   stripe_unit_size;
  nasd_disk_ident_t     drive_id[NASD_CHEOPS_MAX_STRIPE_SIZE];
  nasd_identifier_t     object_id[NASD_CHEOPS_MAX_STRIPE_SIZE];
} nasd_cheops_bs_inode_t;

/* cheops drive info structure: local to manager */
typedef struct nasd_cheops_dinfo_s {
  nasd_drive_handle_t  h;
  nasd_disk_ident_t    dr_id;
  char		       dr_name[NASD_CHEOPS_DR_NAMELEN];
  char		       dr_port[NASD_CHEOPS_DR_NAMELEN];
  nasd_partnum_t       partnum;
  long		       used_capacity;
  long		       max_capacity;
} nasd_cheops_dinfo_t;

typedef struct nasd_cheops_dmap_s {
  int		      num_drives;
  int		      lastID; 
  nasd_cheops_dinfo_t   dinfo[MAX_NUM_DRIVES];	
} nasd_cheops_dmap_t;

#endif /* NASD_CHEOPS_MGR_STRUCTS_H_  */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
