/*
 * nasd_linux_drive.c
 *
 * NASD Drive Linux Kernel Module
 *
 * Authors: Jim Zelenka, Sean Levy
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>

#if defined(LINUX) && defined(KERNEL) && defined(MODULE) /* should always be */

#include <linux/module.h>
#include <nasd/nasd_sys.h>

#define NASD_EXPORT_SYMBOL(_symname_) EXPORT_SYMBOL(_symname_)

#include <nasd/nasd_linux_drive_syms.ver.h>

MODULE_AUTHOR("Jim Zelenka <jimz+@cs.cmu.edu>");
MODULE_DESCRIPTION("NASD Drive");

extern int nasd_linux_psrv_go(nasd_svinfo_t *, void *);

/* It's well-named. Really. */
extern void nasd_od_linux_evil_init(void);

/*
 * Yes, incrementing the mod count here means that if the drive
 * crashes, you can't unload the module. If we didn't, when the
 * drive crashed, unloading the module would hang the kernel.
 * ("Experimental evidence".) So don't bother trying.
 */

void
nasd_linux_drive_module_start()
{
  MOD_INC_USE_COUNT;
}

void
nasd_linux_drive_module_stop()
{
  MOD_DEC_USE_COUNT;
}

int
init_module()
{
  nasd_linux_set_drive_launch(nasd_linux_psrv_go, 0);
  nasd_od_linux_evil_init();
  return(0);
}

void
cleanup_module()
{
  nasd_linux_set_drive_launch(NULL, 0);
}

#endif /* LINUX && KERNEL && MODULE */

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
