/*
 * saytime.c
 *
 * Print the current time (test nasd_gettime())
 *
 * Author: Jim Zelenka
 */
/*
 * Copyright (c) of Carnegie Mellon University, 1998,1999.
 *
 * Permission to reproduce, use, and prepare derivative works of
 * this software for internal use is granted provided the copyright
 * and "No Warranty" statements are included with all reproductions
 * and derivative works. This software may also be redistributed
 * without charge provided that the copyright and "No Warranty"
 * statements are included in all redistributions.
 *
 * NO WARRANTY. THIS SOFTWARE IS FURNISHED ON AN "AS IS" BASIS.
 * CARNEGIE MELLON UNIVERSITY MAKES NO WARRANTIES OF ANY KIND, EITHER
 * EXPRESSED OR IMPLIED AS TO THE MATTER INCLUDING, BUT NOT LIMITED
 * TO: WARRANTY OF FITNESS FOR PURPOSE OR MERCHANTABILITY, EXCLUSIVITY
 * OF RESULTS OR RESULTS OBTAINED FROM USE OF THIS SOFTWARE. CARNEGIE
 * MELLON UNIVERSITY DOES NOT MAKE ANY WARRANTY OF ANY KIND WITH RESPECT
 * TO FREEDOM FROM PATENT, TRADEMARK, OR COPYRIGHT INFRINGEMENT.
 */


#include <nasd/nasd_options.h>
#include <nasd/nasd_getopt.h>
#include <nasd/nasd_timeout.h>
#include <nasd/nasd_pdev.h>
#include <nasd/nasd_mem.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>

char *progname;

#define DEF_NTIMES 1
int ntimes = DEF_NTIMES;

void
usage()
{
  fprintf(stderr, "USAGE: %s [options]\n", progname);
  fprintf(stderr, "Options:\n");
  fprintf(stderr, "  -n niterations [default %d]\n", DEF_NTIMES);
  fflush(stderr);
  exit(1);
}

int
main(
  int     argc,
  char  **argv)
{
  nasd_timespec_t ts;
  nasd_status_t rc;
  char c;
  int i;

  progname = argv[0];

  while (nasd_getopt(argc, argv, "n:", &c)) {
    switch(c) {
      case 'n':
        if (sscanf(nasd_optarg, "%d", &ntimes) != 1)
          usage();
        break;
      default:
        fprintf(stderr, "Unknown option '%c'\n", nasd_optopt);
        usage();
    }
  }

  if (nasd_optind < argc)
    usage();

  if (ntimes < 1)
    usage();

  rc = nasd_threads_init();
  if (rc) {
    fprintf(stderr, "ERROR: got 0x%x (%s) from nasd_threads_init()\n",
      rc, nasd_error_string(rc));
    fflush(stderr);
    exit(1);
  }

  for(i=0;i<ntimes;i++) {
    nasd_gettime(&ts);
    printf("%d:%09d  (#%d)\n", ts.ts_sec, ts.ts_nsec, i);
  }

  nasd_threads_shutdown();

  exit(0);
}

/* Local Variables:  */
/* indent-tabs-mode: nil */
/* tab-width: 2 */
/* End: */
