#ifndef NETCONFIG_H
#define NETCONFIG_H

#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <stdlib.h>
#include <sys/time.h>
/* Network includes */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/param.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netdb.h>
#include <signal.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#ifdef LINUX
#include <pcap/pcap.h>
#else
#include <pcap.h>
#endif

#define SUCCESS 0
#define FAILURE 1
#define VERSION "$Revision: 1.6 $"

/*
 * Memory for miscellaneous buffers
 */
#define BUFSIZE 512

/*
 * Where to read config data of what to send/recv
 */
#define DEFAULT_YYIN "rid.conf"

/*
 * designed for struct timeval where u_sec is in microsecs
 */
#define TIMEVAL_SUBTRACT(a,b) (((a).tv_sec - (b).tv_sec) * 1000000 + (a).tv_usec - (b).tv_usec)



/* 
 *  This is the maximum hdr size for any tcp/ip protocol.  I just picked
 *  a large size at random on the safe side 
 */
#define MAX_PACK IP_MAXPACKET - 1024

/* 
 *   This ends up being a snap length, which to be safe should be your 
 *   maximum network MTU.  1500 is pretty standard 
 */
#define DEFAULT_MAXMTU 1500

/* 
 * default batch size of packets to send out at once before pause
 */
#define DEFAULT_BATCHSIZE 128

/* 
 * Default pause between sending batches - Designed not to flood network
 * This is in usec
 */
#define DEFAULT_SENDPAUSE 4

/* 
 * Default timeout for pcap_open_live command. From PCAP man page:
 * "specifies the read timeout in  milliseconds" though nothing
 * seems to really obey this.
 */
#define DEFAULT_PCAPTO 20

/*
 * Default timeout for select calls.  This is in microseconds (10^-6)
 */
#define DEFAULT_TO 1000000

/* 
 * Default time to sleep waiting for replies
 *
 */
#define DEFAULT_SLEEP 30

/* 
 * Default Number of ICMP's needed to determine whether a host is 
 * alive. Increasing this number yields better chance of hitting all
 * hosts
 */
#define DEFAULT_NUMPINGS 3
#define DEFAULT_NUMSENDS 1

/*
 * Maximum receive size.  This is large on some systems, but solaris
 * defaults to this.  So I went with the least common denominator
 * Right now that's openbsd 2.6. (2/26/00 - djb)
 */
#define MAX_RECV_BUF 1024*240

/* 
 * Simple link list to keep track of all icmp packets we're sending
 * and what we're looking for in icmp packets we're receiving.
 */

struct icmp_item {
        char name[BUFSIZE];	/* Name of check */
	char *string;		/* What data to set/look for */
	long seq, id, type, code;	/* What options to set/look for */
	long nmatch;		/* Number of matches needed for positive */
        struct icmp_item *Next;	 /* Next item in link list */
};

/* 
 * Simple link list to keep track of all udp packets we're sending
 * and what we're looking for in a udp packet we receive
 */

struct udp_item {
	char name[BUFSIZE];	/* Name of check */
	char *string;		/* Data we set/look for */
	long sport, dport;	/* What options to set/look for */
	long nmatch;		/* Number of matches needed for positive */
	struct udp_item *Next;	/* Next item in link list */
};

/* 
 * Simple link list to keep track of all tcp packets we're sending
 * and what we're looking for in a tcp packet we receive
 * Fairely minimal right now, might add more later.
 */

struct tcp_item {
	char name[BUFSIZE];	/* Name of check */
	char *string;		/* Data we set/look for */
	long sport, dport;	/* What options to set/look for */
	long nmatch;		/* Number of matches needed for positive */
	struct tcp_item *Next;	/* Next item in link list */
};

/* 
 * Define a simple link list of hosts that are alive. 
 */
struct host {
        struct sockaddr_in sad; /* Socket address */
        int alive;  	        /* Is it alive */
        struct host *Next;      /* Guess what */
};


/* Fix udp header information to be what we expect */
#ifdef __LINUX
typedef struct udphdr_bsd {
	unsigned short uh_sport;
	unsigned short uh_dport;
	unsigned short uh_ulen;
	unsigned short uh_sum;
} udphdr_bsd;
#else
  typedef struct udphdr udphdr_bsd;
#endif

/* CIDR Format masks */
static unsigned long MaskBits[] = {
  0x00000000,                   /* /0 */
  0x00000000,                   /* /1 */
  0x00000000,                   /* /2 */
  0x00000000,                   /* /3 */
  0x00000000,                   /* /4 */
  0x00000000,                   /* /5 */
  0x00000000,                   /* /6 */
  0x00000000,                   /* /7 */
  0x00000000,                   /* /8 */
  0x00000000,                   /* /9 */
  0x00000000,                   /* /10 */
  0x00000000,                   /* /11 */
  0x00000000,                   /* /12 */
  0x00000000,                   /* /13 */
  0x00000000,                   /* /14 */
  0x00000000,                   /* /15 */
  0xffff0000,                   /* /16, Class B */
  0xffff8000,                   /* /17, 128 * Class C */
  0xffffc000,                   /* /18, 64 * Class C */
  0xffffe000,                   /* /19, 32 * Class C */
  0xfffff000,                   /* /20, 16 * Class C */
  0xfffff800,                   /* /21, 8 * Class C */
  0xfffffc00,                   /* /22, 4 * Class C */
  0xfffffe00,                   /* /23, 2* Class C */
  0xffffff00,                   /* /24, Class C */
  0xffffff80,                   /* /25, 128 hosts */
  0xffffffc0,                   /* /26, 64 hosts */
  0xffffffe0,                   /* /27, 32 hosts */
  0xfffffff0,                   /* /28, 16 hosts */
  0xfffffff8,                   /* /29, 8 hosts */
  0xfffffffc,                   /* /30, 4 hosts (PPP link) */
  0xfffffffe,                   /* /31, invalid */
  0xffffffff,                   /* /32, host */
};

static int NumHosts[] = {
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,
  0, 0, 0, 0,                   /* don't scan more than a /16 */
  65534,                        /* These are all -2 so that we don't
                                   scan the broadcast addr or the
                                   network addr */
  32766,
  16382,
  8190,
  4094,
  2046,
  1022,
  510,
  254,
  126,
  62,
  30,
  14,
  6,
  2,
  0,
  1,
};


#ifdef LINUX
#define __FAVOR_BSD
#endif

#endif
