#!@PERL@
#
# @(#)proc-httpd-errors.pl,v 1.8 2004/12/29 03:37:53 kim Exp
#
# Summarize web errors
#
# 1996-07-30  Kimmo Suominen
#
while (<>) {
    next if (m!\s+(SIGHUP received|caught SIGTERM|resuming normal operations|Accept mutex: |Starting as|killing CGI|((body|close|line|lingering|output|read|request|script|send|SSI)(\s+|_))+(lost connection|aborted|timed out)|no acceptable variant|erroneous characters after protocol string|Directory index forbidden by rule|client denied by server configuration|\(System error follows\)|Connection reset by peer|File does not exist|not found or unable to stat|file permissions deny server access|Digest: (generating secret for |done$)|child process \d+ did not exit, sending another |\(?Broken pipe)!);
    # Apache::Gallery
    next if (m!\s+(not found in picture info)!);
    if (m!\s+access\s+to\s+(.+)\s+failed\s+for\s+.*\s+reason:\s+(.*)!) {
	$url = $1;
	# We don't care about mirrored content
	next if $url =~ m!^/proj/(ftp|www-mirror)/!;
	# This is caused by MSIE5 bookmarking
	next if $url =~ m!/favicon\.ico$!;
	$emsg = $2;
	# Let's tweak the message for NCSA
	$emsg =~ s/\s+from\s+[^\s]+$//;
	$emsg =~ s/(\s+URL):.*/$1/;
	$emsg =~ s/^\([0-9]+\)\s+//;
	# Don't collect usernames (they could be passwords)
	$emsg =~ s/^user\s+\S+:/User/;
	$err{$emsg}++;
	$doc{$emsg}{$url}++;
	next;
    }
    # Remove PID
    s/ child process \d+ / child process /;
    next if m!File does not exist:!;
    if (m!^\[.*\]\s+(.*)!) {
	$unk{$1}++;
    } else {
	chomp;
	$unk{$_}++;
    }
}

if (defined(%err)) {
    &printit("ACCESS FAILURES", *err, *doc);
}
if (defined(%unk)) {
    printf "Unknown errors\n";
    $total = 0;
    printf "----- ------------------------------------------------\n";
    foreach $i (sort {$unk{$b} <=> $unk{$a} || $a cmp $b} (keys %unk)) {
	$total += $unk{$i};
	printf "%5d %-s\n", $unk{$i}, $i;
    }
    printf "----- ------------------------------------------------\n";
    printf "%5d %-s\n", $total, "TOTAL";
    printf "\n";
}
exit 0;

sub printit {
    local($title) = shift(@_);
    local(*cat) = shift(@_);
    local(*itm) = shift(@_);

    local($total) = 0;
    local($i, $j);

    printf "$title\n\n";
    foreach $i (sort {$cat{$b} <=> $cat{$a}} (keys %cat)) {
	$total += $cat{$i};
	printf "%-s\n", $i;
	printf "----- ------------------------------------------------\n";
	foreach $j (sort {$itm{$i}{$b} <=> $itm{$i}{$a} || $a cmp $b} (keys %{$itm{$i}})) {
	    printf "%5d %-s\n", $itm{$i}{$j}, $j;
	}
	printf "----- ------------------------------------------------\n";
	printf "%5d %-s\n", $cat{$i}, "TOTAL";
	printf "\n";
    }
    printf "%5d %-s\n", $total, $title;
    printf "\n\n";
}
