/* mkbin2.c */
/* generates the header file for bin2c
   Copyright (C) 1999 Darren Salt
   All Rights Reserved

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include <stdio.h>

int
main (void)
{
  struct {
    int i;
    char c;
  } ic;
  short s = (short)65535;
  long l = (long)4294967295ul;
#if defined HAVE_LONG_LONG
  long long ll = 0xFFFFFFFFFFFFFFFFll;
#else /* We're going to have to fake it...  */
  long ll = l;
#endif

  puts ("/* Header file generated by mkbin2c */");
  puts ("/* Copyright (C) 1999 Darren Salt */");

  ic.c = 255;
  printf ("#define do_char     do_%cchar\n", ic.c < 0 ? 's' : 'u');
  printf ("#define do_short    do_%cshort\n", s < 0 ? 's' : 'u');
  printf ("#define do_long     do_%clong\n", l < 0 ? 's' : 'u');
  printf ("#define do_longlong do_%clonglong\n", ll < 0 ? 's' : 'u');
#if defined HAVE_LONG_LONG
  printf ("#define HAVE_LONG_LONG\n");
#endif

  ic.i = 255;
  if (ic.c == 0)
    puts ("#define BIG_ENDIAN");

  return 0;
}
