# MD034 - URLs should be formatted as links

Aliases: `no-bare-urls`

## What this rule does

Ensures URLs are properly formatted with angle brackets or as clickable links, not pasted as plain text.

## Why this matters

- **Clickability**: Not all Markdown renderers make plain URLs clickable
- **Consistency**: Mixed URL formats look unprofessional
- **Control**: Proper link formatting lets you customize the display text

## Examples

### ✅ Correct

```markdown
For more information, see <https://example.com>.

Visit [our website](https://example.com) for details.

Email us at <contact@example.com>

Chat with me at <xmpp:user@example.com>
```

### ❌ Incorrect

<!-- rumdl-disable MD034 -->

```markdown
For more information, see https://example.com.

Email us at contact@example.com

Chat with me at xmpp:user@example.com
```

<!-- rumdl-enable MD034 -->

### 🔧 Fixed

```markdown
For more information, see <https://example.com>.

Email us at <contact@example.com>

Chat with me at <xmpp:user@example.com>
```

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule automatically wraps plain URLs, email addresses, and XMPP URIs in angle brackets (`<` and `>`).

## GFM extended autolinks

This rule supports GFM (GitHub Flavored Markdown) extended autolinks, including:

- HTTP/HTTPS URLs: `https://example.com`
- FTP URLs: `ftp://files.example.com`
- Email addresses: `user@example.com`
- XMPP URIs: `xmpp:user@example.com` or `xmpp:user@example.com/resource`
- WWW URLs without protocol: `www.example.com`

## Learn more

- [CommonMark autolinks](https://spec.commonmark.org/0.31.2/#autolinks) - Technical specification for URL formatting
- [GFM autolinks extension](https://github.github.com/gfm/#autolinks-extension-) - GFM extended autolinks specification
- [Markdown Guide - Links](https://www.markdownguide.org/basic-syntax/#links) - Best practices for links

## Related rules

- [MD039](md039.md) - No spaces inside link text
- [MD042](md042.md) - No empty links
- [MD051](md051.md) - Link anchors should exist
