# MD053 - Remove unused link definitions

Aliases: `link-image-reference-definitions`

## What this rule does

Finds link and image reference definitions that aren't used anywhere in your document and removes them to keep your content clean.

## Why this matters

- **Reduces clutter**: Unused definitions make documents harder to maintain
- **Prevents confusion**: Developers might wonder why certain definitions exist
- **Improves readability**: Less scrolling through unused references at the bottom of files
- **Easier maintenance**: Fewer references to check when updating links

## Examples

### ✅ Correct

```markdown
# My Document

Check out [our website][site] and view the [documentation][docs].

See our ![company logo][logo] for branding guidelines.

[site]: https://example.com
[docs]: https://docs.example.com
[logo]: /images/logo.png
```

### ❌ Incorrect

```markdown
# My Document

Check out [our website](https://example.com) directly.

[site]: https://example.com
[docs]: https://docs.example.com
[unused]: https://old.example.com
[legacy]: https://legacy.example.com
```

### 🔧 Fixed

```markdown
# My Document

Check out [our website](https://example.com) directly.
```

## Configuration

```toml
[MD053]
ignored-definitions = []  # List of reference names to keep even if unused
```

### Example with ignored definitions

```toml
[MD053]
ignored-definitions = ["todo", "draft", "template"]
```

This keeps reference definitions with names like "todo", "draft", or "template" even if they're not currently used.

## Comment-Style References

rumdl automatically recognizes and ignores common community patterns for adding comments using reference-style syntax. These patterns are **not part of any official Markdown specification**
(CommonMark, GFM), but are widely used across 23+ Markdown implementations.

### Recognized Comment Patterns

The following patterns are automatically ignored and won't be flagged as unused:

```markdown
[//]: # (This is a comment - most popular pattern)
[comment]: # (This is a semantic comment)
[note]: # (This is a note for documentation)
[todo]: # (Add more examples here)
[fixme]: # (This needs to be fixed)
[hack]: # (Temporary workaround)
```

Any reference definition with just `#` as the URL is also treated as a comment:

```markdown
[anything]: # (This will be treated as a comment)
[ref]: # "Also a comment"
```

### Why These Work

These patterns exploit valid Markdown link reference syntax:

- The label (e.g., `[//]`) is technically valid
- The `#` is a valid URL (just a fragment/anchor)
- Since the reference is never used, it doesn't render

### When to Use

**Use HTML comments for standard commenting:**

```markdown
<!-- This is the recommended way to add comments -->
```

**Use reference-style comments when:**

- Your documentation tool strips HTML comments
- You prefer a less HTML-like syntax
- You're following project conventions that use this pattern
- You need comments that won't appear in page source

### Real vs. Comment References

rumdl distinguishes between comment patterns and real references:

```markdown
[//]: # (This is ignored - it's a comment)
[real-link]: https://example.com  <!-- This WILL be flagged if unused -->
```

Only the real reference definition will trigger MD053 if it's not used in the document.

## Automatic fixes

This rule can automatically fix issues by:

- Removing entire lines containing unused reference definitions
- Preserving any definitions listed in `ignored_definitions`
- Cleaning up extra blank lines left behind

## Learn more

- [Markdown Guide: Reference-style Links](https://www.markdownguide.org/basic-syntax/#reference-style-links)
- [CommonMark: Link reference definitions](https://spec.commonmark.org/0.31.2/#link-reference-definitions)

## Related rules

- [MD052 - Fix broken reference links and images](md052.md)
- [MD054 - Use consistent link and image style](md054.md)
- [MD042 - Ensure links have content](md042.md)
