# MD003 - Heading style should be consistent

Aliases: `heading-style`

## What this rule does

Ensures all headings in your document use the same formatting style.

## Why this matters

- **Readability**: Consistent heading styles make documents easier to scan and navigate
- **Professionalism**: Mixed heading styles look unprofessional and unpolished
- **Tool compatibility**: Some tools expect consistent heading formats for navigation features

## Examples

### ✅ Correct (using # style)

```markdown
# First Level Heading
## Second Level Heading
### Third Level Heading
```

### ✅ Correct (using underline style)

```markdown
First Level Heading
==================

Second Level Heading
------------------
```

### ✅ Correct (using setext_with_atx style)

```markdown
First Level Heading
==================

Second Level Heading
------------------

### Third Level Heading
#### Fourth Level Heading
```

### ✅ Correct (using setext_with_atx_closed style)

```markdown
First Level Heading
==================

Second Level Heading
------------------

### Third Level Heading ###
#### Fourth Level Heading ####
```

### ❌ Incorrect (mixed styles)

<!-- rumdl-disable MD003 -->

```markdown
# First Level Heading

Second Level Heading
------------------

### Third Level Heading
```

<!-- rumdl-enable MD003 -->

### 🔧 Fixed

```markdown
# First Level Heading
## Second Level Heading
### Third Level Heading
```

## Configuration

```toml
[MD003]
style = "consistent"  # Options: "consistent", "atx", "atx_closed", "setext", "setext_with_atx", "setext_with_atx_closed"
```

### Style options explained

- `"consistent"` (default): Use the most prevalent style in your document (in case of a tie, ATX style is preferred as it's most widely supported)
- `"atx"`: Use # symbols (`# Heading`)
- `"atx_closed"`: Use # symbols at both ends (`# Heading #`)
- `"setext"`: Use underlines (equals for level 1, dashes for level 2)
- `"setext_with_atx"`: Use underlines for level 1-2, # symbols for level 3-6
- `"setext_with_atx_closed"`: Use underlines for level 1-2, # symbols with closing # for level 3-6

> **Note**: Underline style only works for level 1 and 2 headings. Level 3 and below must use # symbols.

## Automatic fixes

This rule can automatically convert all headings to match your configured style or the most prevalent style in the document.

## Learn more

- [CommonMark specification for headings](https://spec.commonmark.org/0.31.2/#atx-headings) - Technical details about heading syntax
- [Setext headings](https://spec.commonmark.org/0.31.2/#setext-headings) - Details about underline-style headings

## Related rules

- [MD001](md001.md) - Heading levels should only increment by one
- [MD022](md022.md) - Headings should be surrounded by blank lines
- [MD023](md023.md) - Headings must start at the beginning of the line
