# MD052 - Fix broken reference links and images

Aliases: `reference-links-images`

## What this rule does

Checks that all reference-style links and images point to definitions that actually exist in your document.

## Why this matters

- **Prevents broken links**: Readers can't follow links that don't have destinations
- **Avoids confusion**: Missing references leave readers wondering where links should go
- **Maintains trust**: Broken links make your documentation appear unmaintained
- **Ensures completeness**: All referenced content is properly defined

## Examples

### ✅ Correct

```markdown
This is a [reference link][example] and here's an [image reference][pic].

You can also use [numbered references][1].

[example]: https://example.com
[pic]: /images/photo.jpg
[1]: https://docs.example.com
```

### ❌ Incorrect

```markdown
This is a [broken link][missing] and an [undefined image][nopic].

Here's a [shortcut reference] with no definition.

[other]: https://example.com
```

### 🔧 Fixed

```markdown
This is a [broken link][missing] and an [undefined image][nopic].

Here's a [shortcut reference] with no definition.

[missing]: https://example.com/page
[nopic]: /images/default.jpg
[shortcut reference]: https://example.com/shortcut
[other]: https://example.com
```

## Configuration

| Option            | Type     | Default | Description                                  |
| ----------------- | -------- | ------- | -------------------------------------------- |
| `shortcut-syntax` | boolean  | `false` | Check shortcut reference syntax `[text]`     |
| `ignore`          | string[] | `[]`    | Reference names to ignore (case-insensitive) |

By default, shortcut reference syntax (`[text]` without a label) is not checked because it can produce false positives when the text resembles other markdown constructs.

```toml
[MD052]
shortcut-syntax = true  # Enable checking of shortcut references
```

### Ignoring specific references

Use the `ignore` option to specify reference names that should not be flagged as undefined. This is useful when you have references that are intentionally undefined (e.g., Rust documentation where
`[Vec]` links are resolved by rustdoc).

```toml
[MD052]
ignore = ["Vec", "HashMap", "Option", "Result"]
```

Matching is case-insensitive since reference IDs are normalized to lowercase during parsing.

## Automatic fixes

This rule cannot automatically fix issues because it can't know what URL you intended for missing references. You must manually:

1. Add the missing reference definition at the bottom of your document
2. Or change the reference to use an existing definition
3. Or convert to an inline link if a reference isn't needed

## Learn more

- [Markdown Guide: Reference-style Links](https://www.markdownguide.org/basic-syntax/#reference-style-links)
- [CommonMark: Link reference definitions](https://spec.commonmark.org/0.31.2/#link-reference-definitions)

## Related rules

- [MD051 - Fix broken link fragments](md051.md)
- [MD053 - Remove unused link definitions](md053.md)
- [MD054 - Use consistent link and image style](md054.md)
