# MD055 - Keep table formatting consistent

Aliases: `table-pipe-style`

## What this rule does

Ensures all rows in your tables use the same style for leading and trailing pipe characters (|).

## Why this matters

- **Visual consistency**: Mixed pipe styles make tables look messy and unprofessional
- **Easier editing**: Consistent formatting makes it easier to add or modify table rows
- **Better alignment**: Uniform pipe placement helps maintain column alignment
- **Parser compatibility**: Some Markdown parsers require specific pipe styles

## Examples

<!-- rumdl-disable MD055 -->

### ✅ Correct (with leading and trailing pipes)

```markdown
| Name     | Role      | Department |
| -------- | --------- | ---------- |
| Alice    | Manager   | Sales      |
| Bob      | Developer | IT         |
```

### ✅ Correct (without leading and trailing pipes)

```markdown
Name     | Role      | Department
-------- | --------- | ----------
Alice    | Manager   | Sales
Bob      | Developer | IT
```

### ❌ Incorrect (mixed styles)

```markdown
| Name     | Role      | Department |
| -------- | --------- | ---------- |
Alice    | Manager   | Sales
| Bob      | Developer | IT         |
```

### 🔧 Fixed

```markdown
| Name     | Role      | Department |
| -------- | --------- | ---------- |
| Alice    | Manager   | Sales      |
| Bob      | Developer | IT         |
```

<!-- rumdl-enable MD055 -->

## Configuration

```toml
[MD055]
style = "consistent"  # Options: see below
```

### Style options

- **`consistent`** (default): Use the most prevalent style in the table (in case of a tie, `leading-and-trailing` is preferred as it's most widely used)
- **`leading-and-trailing`**: Require pipes at start and end: `| cell |`
- **`leading-only`**: Require pipes only at start: `| cell`
- **`trailing-only`**: Require pipes only at end: `cell |`
- **`no-leading-or-trailing`**: No pipes at start or end: `cell`

## Automatic fixes

This rule can automatically fix issues by:

- Adding missing leading pipes when required
- Adding missing trailing pipes when required
- Removing extra pipes when not allowed
- Making all rows match the configured style

## Learn more

- [Markdown Guide: Tables](https://www.markdownguide.org/extended-syntax/#tables)
- [GitHub Flavored Markdown: Tables](https://github.github.com/gfm/#tables-extension-)

## Related rules

- [MD056 - Keep table column count consistent](md056.md)
- [MD058 - Add blank lines around tables](md058.md)
