# MD064 - No Multiple Consecutive Spaces

Aliases: `no-multiple-consecutive-spaces`

## Rule Details

This rule is triggered when multiple consecutive spaces (2 or more) are found
in markdown content. Multiple spaces between words serve no purpose in markdown
and typically indicate formatting issues or copy-paste artifacts.

## Rationale

Multiple consecutive spaces in markdown:

1. **Render as single space**: Most markdown renderers collapse multiple spaces
   into a single space, so extra spaces have no visual effect
2. **Indicate potential issues**: Often result from copy-paste errors or
   accidental keystrokes
3. **Reduce readability**: Make the source markdown harder to read

## Examples

### Incorrect

```text
This is   a sentence with extra spaces.

- List   item with extra spaces

> Quote   with extra spaces
```

### Correct

```markdown
This is a sentence with single spaces.

- List item with single spaces

> Quote with single spaces
```

## Exceptions

This rule does NOT flag spaces in the following contexts:

### 1. Inline Code Spans

Spaces inside inline code are intentional and preserved:

```markdown
Use `code   with   spaces` for formatting.
```

### 2. Fenced/Indented Code Blocks

Code block content is not processed:

````text
```
code   with   intentional   spaces
```
````

### 3. Leading Indentation

Leading whitespace for structure is preserved:

```markdown
    Indented paragraph (4 spaces)
```

### 4. Trailing Spaces

All trailing spaces are handled by MD009 and are not flagged by this rule:

```markdown
Line with trailing spaces
Another line with trailing spaces
```

Use MD009 to control trailing space behavior.

### 5. Front Matter

YAML/TOML/JSON front matter is not processed:

```markdown
---
title:   Document Title
author:   John Doe
---
```

### 6. HTML Comments

Content inside HTML comments is not processed:

```markdown
<!-- comment   with   spaces -->
```

### 7. HTML Blocks

Content inside HTML block elements is not processed.

### 8. Table Rows

Table rows with alignment padding are not flagged:

```markdown
| Header 1 | Header 2 |
| -------- | -------- |
| Cell 1   | Cell 2   |
```

GFM-style tables without leading/trailing pipes are also skipped:

```text
Header 1  | Header 2  | Header 3
--------- | --------- | ---------
Cell 1    | Cell 2    | Cell 3
```

The spaces used for visual alignment in tables are intentional.

### 9. List Marker Spacing

Spaces after list markers are handled by MD030, not MD064:

```text
*   Item with extra space after marker
1.  Numbered item with extra space
```

### 10. Blockquote Marker Spacing

Spaces after blockquote markers are handled by MD027:

```text
>  Quote with extra space after marker
>>  Nested blockquote
```

### 11. Reference Link Definitions

Spaces after the colon in reference link definitions:

```text
[ref]:  https://example.com
[link]:   https://example.com "Title"
```

### 12. Footnote Markers

Spaces after footnote markers:

```text
[^1]:  Footnote text
[^note]:   Extended footnote
```

### 13. Definition List Markers

Spaces after definition list markers (PHP Markdown Extra / Pandoc):

```markdown
Term
:   Definition text
```

### 14. Task List Checkboxes

Spaces after task list checkboxes:

```markdown
- [ ]  Unchecked task
- [x]  Checked task
```

## Fix

The automatic fix collapses multiple consecutive spaces to a single space.

Before:

```text
This is   a sentence   with extra   spaces.
```

After:

```markdown
This is a sentence with extra spaces.
```

When `allow-sentence-double-space` is enabled, the fix preserves exactly 2
spaces after sentence boundaries while collapsing other multiple spaces to 1.

## Configuration

| Option                       | Type    | Default | Description                                              |
| ---------------------------- | ------- | ------- | -------------------------------------------------------- |
| `allow-sentence-double-space`| boolean | false   | Allow exactly 2 spaces after sentence-ending punctuation |

### allow-sentence-double-space

The `allow-sentence-double-space` option enables the traditional typographical
convention of using two spaces after sentence-ending punctuation (`.`, `!`, `?`)
while still flagging multiple spaces elsewhere:

```toml
[MD064]
allow-sentence-double-space = true
```

With this configuration:

```text
End of sentence.  Start of next sentence.       <- OK (2 spaces after period)
Multiple  spaces  in middle of sentence.        <- Flagged (not after sentence)
What a question!  Here's the answer.            <- OK (2 spaces after !)
Really?  Yes, really.                           <- OK (2 spaces after ?)
```

#### Recognized Sentence Boundaries

The rule recognizes sentences ending with:

- **Period (.)** followed by spaces (not part of ellipsis or abbreviation)
- **Exclamation mark (!)**
- **Question mark (?)**

Closing punctuation after the sentence-ending punctuation is handled correctly:

```text
"End quote."  Next sentence.                    <- OK (period inside quotes)
She said "Hello!"  He replied.                  <- OK (! inside quotes)
(See appendix.)  More content.                  <- OK (period inside parens)
The book [2024].  Next reference.               <- OK (period inside brackets)
```

#### Ellipsis Handling

Ellipsis (`...`) is treated as a sentence boundary, allowing double space after:

```text
And so it goes...  The story continues.         <- OK (after ellipsis)
```

### Disabling the Rule

To disable this rule entirely:

```toml
[global]
disable = ["MD064"]
```

## Related Rules

- [MD009](md009.md) - Trailing spaces (handles trailing whitespace)
- [MD010](md010.md) - Hard tabs (handles tab characters)
- [MD012](md012.md) - Multiple consecutive blank lines
- [MD027](md027.md) - Multiple spaces after blockquote symbol
- [MD030](md030.md) - Spaces after list markers

## Version

Added in rumdl v0.0.196.
