# MD067 - Footnote definition order

Aliases: `footnote-definition-order`

## What this rule does

Checks that footnote definitions appear in the same order as their first references in the document.

## Why this matters

- **Improves readability**: Readers expect footnotes in the order they encounter them
- **Reduces confusion**: Out-of-order footnotes make it harder to follow the document
- **Maintains consistency**: Ordered footnotes are easier to review and maintain

## Examples

### Correct

```markdown
Text with first[^1] and then second[^2] reference.

[^1]: Referenced first, defined first.
[^2]: Referenced second, defined second.
```

### Incorrect

```markdown
Text with first[^2] and then second[^1] reference.

[^1]: This is defined first but referenced second.
[^2]: This is defined second but referenced first.
```

**Warning**: `Footnote [^1] is defined before [^2] but referenced after it`

## Configuration

This rule has no configuration options.

## Automatic fixes

This rule supports automatic fixing. Running `rumdl fix` will reorder footnote definitions to match their reference order.

## Note on numbered footnotes

This rule checks definition order, not the footnote identifiers themselves.
You can use any identifiers you like (`[^1]`, `[^note]`, `[^ref-2024]`),
as long as the definitions appear in the order the references first occur.

## Related rules

- [MD066 - Footnote validation](md066.md)
- [MD068 - Empty footnote definitions](md068.md)
