#include "stralloc.h"
#include "sig.h"
#include "exit.h"
#include "fmt.h"
#include "case.h"
#include "str.h"
#include "tai.h"
#include "httpdate.h"
#include "timeoutread.h"
#include "timeoutwrite.h"
#include "buffer.h"
#include "error.h"
#include "env.h"
#include "scan.h"
#include "formdata.h"
#include "getln.h"
#include "wait.h"
#include "fd.h"
#include "fork.h"
#include "pathexec.h"

stralloc filter = {0};
stralloc data = {0};
stralloc query = {0};
int flagdata;
int flagfilter;
char *p[4] = { "wrapcr", 0, "20", 0 };

formdata h = FORMDATA;
formdata_action a[] = {
  { "filter", &flagfilter, &filter }
, { "data", &flagdata, &data }
, { 0, 0, 0 }
} ;

stralloc line = {0};
int match;

stralloc uri = {0};

int saferead(int fd,char *buf,int len)
{
  int r;
  r = timeoutread(60,fd,buf,len);
  if (r <= 0) _exit(0);
  return r;
}

char inbuf[512];
buffer in = BUFFER_INIT(saferead,0,inbuf,sizeof inbuf);

int safewrite(int fd,const char *buf,int len)
{
  int r;
  r = timeoutwrite(60,fd,buf,len);
  if (r <= 0) _exit(0);
  return r;
}

char outbuf[1024];
buffer out = BUFFER_INIT(safewrite,1,outbuf,sizeof outbuf);

void out_put(const char *s,int len)
{
  buffer_put(&out,s,len);
}

void out_puts(const char *s)
{
  buffer_puts(&out,s);
}

void out_data(const char *s,int len)
{
  int i;
  char ch;

  for (i = 0;i < len;++i) {
    ch = s[i];
    if (ch == '<') { buffer_puts(&out,"&lt;"); continue; }
    if (ch == '>') { buffer_puts(&out,"&gt;"); continue; }
    if (ch == '&') { buffer_puts(&out,"&amp;"); continue; }
    buffer_put(&out,&ch,1);
  }
}

void out_lines(const char *s) {
  out_puts(s);
  out_puts("\r\n");
}

void out_button(const char *t,const char *v) {
  out_puts("<INPUT name=\"filter\" type=\"radio\" value=\"");
  out_puts(v); out_puts("\"");
  if (flagfilter)
    if (filter.len == str_len(v))
      if (!byte_diff(filter.s,filter.len,v))
	out_puts(" checked=");
  out_puts(">"); out_puts(t); out_lines("<BR>");
}

void out_flush(void)
{
  buffer_flush(&out);
}

char strnum[FMT_ULONG];

int protocolnum;
int flagpost;
int flagbody;

struct tai now;
stralloc nowstr = {0};
unsigned int len;

void header(const char *code,const char *message)
{
  if (protocolnum == 1)
    out_puts("HTTP/1.0 ");
  else
    out_puts("HTTP/1.1 ");
  out_puts(code);
  out_puts(message);
  out_puts("\r\nServer: cgi-example\r\nDate:");
  if (!httpdate(&nowstr,&now)) _exit(21);
  out_put(nowstr.s,nowstr.len);
  out_puts("\r\n");
}

void barf(const char *code,const char *message)
{
  if (protocolnum > 0) {
    tai_now(&now);
    header(code,message);
    out_puts("Content-Length: ");
    out_put(strnum,fmt_ulong(strnum,str_len(message) + 28));
    out_puts("\r\n");
    if (protocolnum == 2)
      out_puts("Connection: close\r\n");
    out_puts("Content-Type: text/html\r\n\r\n");
  }
  if (flagbody) {
    out_puts("<html><body>");
    out_puts(message);
    out_puts("</body></html>\r\n");
  }
  out_flush();
  if (protocolnum >= 2) {
    shutdown(1,1);
    sleep(1); /* XXX */
  }
  _exit(0);
}

main()
{
  char *s;
  char ch;
  int flagcr;
  int n;
  char *x;
  int pfi[2];
  int pfo[2];
  int pido;
  int pidf;
  int wstat;

  protocolnum = 2;
  s = env_get("SERVER_PROTOCOL");
  if (s) {
    if (case_equals(s,"http/1.0"))
      protocolnum = 1;
    else
      if (case_equals(s,"http/0.9"))
	protocolnum = 0;
  }

  flagbody = 0;
  flagpost = 0;
  s = env_get("REQUEST_METHOD");
  if (!s) _exit(21);
  if (!str_equal(s,"HEAD")) {
    flagbody = 1;
    if (!str_equal(s,"GET"))
      if (!str_equal(s,"POST"))
	barf("400 ","Bad request");
      else
	flagpost = 1;
  }

  if (!formdata_init(&h,&a)) _exit(21);
  if (flagpost) {
    s = env_get("CONTENT_TYPE");
    if (!s) _exit(21);
    if (str_diff(s,"application/x-www-form-urlencoded"))
      barf("415 ","Unsupported media type");

    s = env_get("CONTENT_LENGTH");
    if (!s) _exit(21);
    scan_uint(s,&len);
    if (!stralloc_ready(&query,len)) _exit(21);
    query.len = len;
    if (buffer_get(&in,query.s,query.len) != query.len) _exit(23);
    if (!stralloc_0(&query)) _exit(21);
    s = query.s;	
  }
  else {
    s = env_get("QUERY_STRING");
    if (!s) _exit(21);
  }
  len = 0;
  for (;;) {
    n = str_chr(s + len,'&');
    if (!stralloc_copyb(&line,s + len,n)) _exit(21);
    if (!formdata_field(&h,&line)) _exit(21);
    len += n;
    if (!s[len]) break;
    ++len;
  }

  if (pipe(pfo) == -1) _exit(21);
  pido = fork();
  if (pido == -1) _exit(21);
  if (pido == 0) {
    close(pfo[1]);
    if (fd_move(0,pfo[0]) == -1) _exit(21);
    if (!stralloc_copys(&uri,"http://")) _exit(21);
    s = env_get("SERVER_NAME");
    if (!s) _exit(21);
    if (!stralloc_cats(&uri,s)) _exit(21);
    s = env_get("SERVER_PORT");
    if (s)
      if (str_diff(s,"80")) {
	if (!stralloc_cats(&uri,":")) _exit(21);
	if (!stralloc_cats(&uri,s)) _exit(21);
      }
    s = env_get("SCRIPT_NAME");
    if (s)
      if (!stralloc_cats(&uri,s)) _exit(21);
    s = env_get("SCRIPT_INFO");
    if (s)
      if (!stralloc_cats(&uri,s)) _exit(21);

    tai_now(&now);
    header("200 ","OK");
    if (protocolnum == 2)
      out_lines("Connection: close");
    out_lines("Content-type: text/html");
    out_lines("");
    if (!flagbody) {
      out_flush();
      _exit(0);
    }
    out_lines("<HTML><HEAD><TITLE>CGI Example</TITLE></HEAD><BODY>");
    out_lines("<H1>CGI Example</H1>");
    out_lines("<P>Choose a filter from the list below, and type some text into");
    out_lines("the input area.  Submit the form to apply the filter to the text.");
    out_lines("In response, you'll receive another page like this one,");
    out_lines("with the text in the input area modified by the filter.");
    out_lines("<H2>Filters</H2>");
    out_lines("<DL><DT><STRONG>rot13</STRONG>");
    out_lines("<DD>Exchange each character in the English alphabet with the");
    out_lines("character 13 positions removed, preserving case. Applying this");
    out_lines("filter twice yields the original text.");
    out_lines("<DT><STRONG>revline</STRONG>");
    out_lines("<DD>Reverse the order of characters in each line of input.");
    out_lines("Applying this filter twice yields the original text.");
    out_lines("<DT><STRONG>foldlines</STRONG>");
    out_lines("<DD>Truncate input lines to 20 characters in width.");
    out_lines("</DL>");

    out_puts("<FORM action=\""); out_put(uri.s,uri.len); out_lines("\" method=\"POST\">");
    out_lines("<P>");
    out_button("rot13","rot13");
    out_button("revline","revline");
    out_button("foldlines","foldlines");
    out_lines("<TEXTAREA name=\"data\" rows=\"10\" cols=\"40\">");
    for (;;) {
      n = buffer_feed(buffer_0);
      if (n < 0) _exit(111);
      if (!n) break;
      x = buffer_PEEK(buffer_0);
      buffer_SEEK(buffer_0,n);
      out_data(x,n);
    }
    out_lines("</TEXTAREA><BR>");
    out_lines("<INPUT type=\"submit\" value=\"Submit\">");
    out_lines("</FORM></BODY></HTML>");
    out_flush();
    _exit(0);
  }
  close(pfo[0]);

  sig_ignore(sig_pipe);

  if (pipe(pfi) == -1) _exit(21);
  pidf = fork();
  if (pidf == -1) _exit(21);
  if (pidf == 0) {
    close(pfi[1]);
    if (!flagfilter) {
      close(pfo[1]); close(pfi[0]);
      _exit(0);
    }
    if (fd_move(1,pfo[1]) == -1) _exit(111);
    if (fd_move(0,pfi[0]) == -1) _exit(111);
    if (!stralloc_0(&filter)) _exit(111);
    p[1] = filter.s;
    pathexec(p);
    if (error_temp(errno)) _exit(111);
    _exit(100);
  }
  close(pfi[0]); close(pfo[1]);

  sig_uncatch(sig_pipe);
  if (fd_move(1,pfi[1]) == -1) _exit(111);
  if (flagdata) {
    buffer_put(buffer_1,data.s,data.len);
    buffer_flush(buffer_1);
  }
  close(1);

  if (wait_pid(&wstat,pidf) == -1) _exit(23);
  if (wait_crashed(wstat)) _exit(23);
  switch(wait_exitcode(wstat)) {
    case 0: _exit(0);
    case 111: _exit(21);
    default: _exit(23);
  }
}
