/*
 * KAKASI (Kanji Kana Simple inversion program)
 * $Header: K2.c,v 2.0 92/07/18 12:07:02 takahasi Exp $
 * Copyright (C) 1992
 * Hironobu Takahashi (takahasi@tiny.or.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either versions 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with KAKASI, see the file COPYING.  If not, write to the Free
 * Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
/* $Log:	K2.c,v $
 * Revision 2.0  92/07/18  12:07:02  takahasi
 * *** empty log message ***
 * 
*/
#include <stdio.h>
#include <string.h>
#include "kakasi.h"

struct K2rom_tbl {
    unsigned char kana[10];
    char romaji[7];
}
K2rom_h_table[] = { 

    "", "a", "", "a", "", "i", "", "i", "", "u", "", "u",
    "", "e", "", "e", "", "o", "", "o",

    "", "ka", "", "ga", "", "ki", "", "kya", "", "kyu",
    "", "kyo", "", "gi", "", "gya", "", "gyu", "", "gyo",
    "", "ku", "", "gu", "", "ke", "", "ge", "", "ko", "", "go",

    "", "sa", "", "za", "", "shi", "", "sha", "", "shu",
    "", "sho", "", "ji", "", "ja", "", "ju", "", "jo",
    "", "su", "", "zu", "", "se", "", "ze", "", "so", "", "zo",

    "", "ta", "", "da", "", "chi", "", "cha", "", "chu",
    "", "cho", "", "di", "¥", "dya", "¥", "dyu", "¥", "dyo",

    "", "tsu", "å", "kka", "å", "gga", "å", "kki", "å", "kkya",
    "å", "kkyu", "å", "kkyo", "å", "ggi", "å", "ggya",
    "å", "ggyu", "å", "ggyo", "å", "kku", "å", "ggu",
    "å", "kke", "å", "gge", "å", "kko", "å", "ggo", "å", "ssa",
    "å", "zza", "å", "sshi", "å", "ssha",
    "å", "sshu", "å", "ssho",
    "å", "jji", "å", "jja", "å", "jju", "å", "jjo",
    "å", "ssu", "å", "zzu", "å", "sse", "å", "zze", "å", "sso",
    "å", "zzo", "å", "tta", "å", "dda", "å", "cchi",
    "å", "ccha", "å", "cchu", "å", "ccho", "å", "ddi",
    "å¥", "ddya", "å¥", "ddyu", "å¥", "ddyo", "å", "ttsu",
    "å", "ddu", "å", "tte", "å", "dde", "å", "tto", "å", "ddo",
    "å", "hha", "å", "bba", "å", "ppa", "å", "hhi",
    "åҥ", "hhya", "åҥ", "hhyu", "åҥ", "hhyo", "å", "bbi",
    "åӥ", "bbya", "åӥ", "bbyu", "åӥ", "bbyo", "å", "ppi",
    "åԥ", "ppya", "åԥ", "ppyu", "åԥ", "ppyo", "å", "ffu",
    "åե", "ffa", "åե", "ffi", "åե", "ffe", "åե", "ffo",
    "å", "bbu", "å", "ppu", "å", "hhe", "å", "bbe", "å", "ppe",
    "å", "hho", "å", "bbo", "å", "ppo", "å", "yya", "å", "yyu",
    "å", "yyo", "å", "rra", "å", "rri", "å", "rrya",
    "å", "rryu", "å", "rryo", "å", "rru", "å", "rre",
    "å", "rro", "å", "vvu", "å", "vva", "å", "vvi",
    "å", "vve", "å", "vvo",

    "", "tsu", "", "du", "", "te", "", "de", "", "to", "", "do",

    "", "na", "", "ni", "˥", "nya", "˥", "nyu", "˥", "nyo",
    "", "nu", "", "ne", "", "no",

    "", "ha", "", "ba", "", "pa", "", "hi", "ҥ", "hya",
    "ҥ", "hyu", "ҥ", "hyo", "", "bi", "ӥ", "bya", "ӥ", "byu",
    "ӥ", "byo", "", "pi", "ԥ", "pya", "ԥ", "pyu", "ԥ", "pyo",
    "", "fu", "ե", "fa", "ե", "fi", "ե", "fe", "ե", "fo",
    "", "bu", "", "pu", "", "he", "", "be", "", "pe", "", "ho",
    "", "bo", "", "po",

    "", "ma", "", "mi", "ߥ", "mya", "ߥ", "myu", "ߥ", "myo",
    "", "mu", "", "me", "", "mo",

    "", "ya", "", "ya", "", "yu", "", "yu", "", "yo", "", "yo",

    "", "ra", "", "ri", "", "rya", "", "ryu", "", "ryo",
    "", "ru", "", "re", "", "ro",

    "", "wa", "", "wa", "", "i", "", "e", 
    "", "wo", "", "n",
    "", "n'a", "", "n'i", "", "n'u", "", "n'e", "", "n'o",
    "", "vu", "", "va", "", "vi", "", "ve", "", "vo",
    "", "ka", "", "ke",
    "", ""

}, K2rom_k_table[] = { 

    "", "a", "", "a", "", "i", "", "i", "", "u", "", "u",
    "", "e", "", "e", "", "o", "", "o",

    "", "ka", "", "ga", "", "ki", "", "kya", "", "kyu",
    "", "kyo", "", "gi", "", "gya", "", "gyu", "", "gyo",
    "", "ku", "", "gu", "", "ke", "", "ge", "", "ko", "", "go",

    "", "sa", "", "za", "", "si", "", "sya", "", "syu",
    "", "syo", "", "zi", "", "zya", "", "zyu", "", "zyo",
    "", "su", "", "zu", "", "se", "", "ze", "", "so", "", "zo",

    "", "ta", "", "da", "", "ti", "", "tya", "", "tyu",
    "", "tyo", "", "di", "¥", "dya", "¥", "dyu", "¥", "dyo",

    "", "tu", "å", "kka", "å", "gga", "å", "kki", "å", "kkya",
    "å", "kkyu", "å", "kkyo", "å", "ggi", "å", "ggya",
    "å", "ggyu", "å", "ggyo", "å", "kku", "å", "ggu",
    "å", "kke", "å", "gge", "å", "kko", "å", "ggo", "å", "ssa",
    "å", "zza", "å", "ssi", "å", "ssya",
    "å", "ssyu", "å", "ssho",
    "å", "zzi", "å", "zzya", "å", "zzyu", "å", "zzyo",
    "å", "ssu", "å", "zzu", "å", "sse", "å", "zze", "å", "sso",
    "å", "zzo", "å", "tta", "å", "dda", "å", "tti",
    "å", "ttya", "å", "ttyu", "å", "ttyo", "å", "ddi",
    "å¥", "ddya", "å¥", "ddyu", "å¥", "ddyo", "å", "ttu",
    "å", "ddu", "å", "tte", "å", "dde", "å", "tto", "å", "ddo",
    "å", "hha", "å", "bba", "å", "ppa", "å", "hhi",
    "åҥ", "hhya", "åҥ", "hhyu", "åҥ", "hhyo", "å", "bbi",
    "åӥ", "bbya", "åӥ", "bbyu", "åӥ", "bbyo", "å", "ppi",
    "åԥ", "ppya", "åԥ", "ppyu", "åԥ", "ppyo", "å", "hhu",
    "åե", "ffa", "åե", "ffi", "åե", "ffe", "åե", "ffo",
    "å", "bbu", "å", "ppu", "å", "hhe", "å", "bbe", "å", "ppe",
    "å", "hho", "å", "bbo", "å", "ppo", "å", "yya", "å", "yyu",
    "å", "yyo", "å", "rra", "å", "rri", "å", "rrya",
    "å", "rryu", "å", "rryo", "å", "rru", "å", "rre",
    "å", "rro", "å", "vvu", "å", "vva", "å", "vvi",
    "å", "vve", "å", "vvo",

    "", "tu", "", "du", "", "te", "", "de", "", "to", "", "do",

    "", "na", "", "ni", "˥", "nya", "˥", "nyu", "˥", "nyo",
    "", "nu", "", "ne", "", "no",

    "", "ha", "", "ba", "", "pa", "", "hi", "ҥ", "hya",
    "ҥ", "hyu", "ҥ", "hyo", "", "bi", "ӥ", "bya", "ӥ", "byu",
    "ӥ", "byo", "", "pi", "ԥ", "pya", "ԥ", "pyu", "ԥ", "pyo",
    "", "hu", "ե", "fa", "ե", "fi", "ե", "fe", "ե", "fo",
    "", "bu", "", "pu", "", "he", "", "be", "", "pe", "", "ho",
    "", "bo", "", "po",

    "", "ma", "", "mi", "ߥ", "mya", "ߥ", "myu", "ߥ", "myo",
    "", "mu", "", "me", "", "mo",

    "", "ya", "", "ya", "", "yu", "", "yu", "", "yo", "", "yo",

    "", "ra", "", "ri", "", "rya", "", "ryu", "", "ryo",
    "", "ru", "", "re", "", "ro",

    "", "wa", "", "wa", "", "i", "", "e", 
    "", "wo", "", "n",
    "", "n'a", "", "n'i", "", "n'u", "", "n'e", "", "n'o",
    "", "vu", "", "va", "", "vi", "", "ve", "", "vo",
    "", "ka", "", "ke",
    "", ""
};

#define K2rom_buflen 11

int K2rom(c, n, type)
     Character *c;
     Character *n;
     int type;
{
    static int index_table[0x81];
    static int index_made=0;
    static struct K2rom_tbl *K2rom_ptr;
    struct K2rom_tbl *p;
    int i, clen, ylen;
    unsigned char buffer[K2rom_buflen];
    int max_match, match_more;
    char *max_romaji;

    if (index_made == 0) {
	int last;

	for (i = 0; i < 0x81; ++ i) {
	    index_table[i] = -1;
	}
	index_table[0x21] = 0;
	K2rom_ptr = (romaji_type == HEPBURN) ? K2rom_h_table : K2rom_k_table;
	for (p = K2rom_ptr, i = 0; *(p->kana) != '\0'; ++ p, ++ i) {
	    index_table[(((p->kana)[1])&0x7f)+1] = i+1;
	}
	last = i;
	for (i = 0x80; i >= 0; -- i) {
	    if (index_table[i] == -1)
		index_table[i] = last;
	    else
		last = index_table[i];
	}
	index_made = 1;
    }

    if ((c[0].c1 == 0xa1) && (c[0].c2 == 0xbc)) {
	n[0].type = type;
	n[0].c1 = '^';
	n[1].type = OTHER;
	n[1].c1 = 0;
	n[1].c2 = 0;
	return 1;
    }

    buffer[K2rom_buflen-1] = '\0'; clen = K2rom_buflen-1;
    for (i = 0; i < (K2rom_buflen-1)/2; i ++) {
	buffer[i*2  ] = c[i].c1;
	buffer[i*2+1] = c[i].c2;

	if (c[i].c1 == '\0') {
	    clen = i*2;
	    break;
	}
    }

    if (clen == 0) {
	n[0].type=OTHER;
	n[0].c1 = '\0';
	return 0;
    }

    max_match = 0;
    max_romaji = NULL;
    match_more = 0;
    for (i = index_table[buffer[1]&0x7f];
	 i < index_table[(buffer[1]&0x7f)+1];
	 ++ i) {
	ylen = strlen(K2rom_ptr[i].kana);
	if (clen >= ylen) {
	    if (max_match < ylen) {
		if (strncmp(buffer, K2rom_ptr[i].kana, ylen) == 0) {
		    max_match = ylen/2;
		    max_romaji = K2rom_ptr[i].romaji;
		}
	    }
	} else {
	    if (match_more == 0)
		if (strncmp(buffer, K2rom_ptr[i].kana, clen) == 0)
		    match_more = 1;
	}
    }

    if (max_romaji == NULL) {
	i = 0;
	max_match = 1;
    } else {
	for (i = 0; max_romaji[i] != '\0'; ++ i) {
	    n[i].type=type;
	    n[i].c1 = max_romaji[i];
	}
    }
    n[i].type=OTHER;
    n[i].c1 = '\0';

    return (match_more == 0) ? max_match : -max_match;
}

int K2a(c, n)
     Character *c;
     Character *n;
{
    return K2rom(c, n, ASCII);
}

int K2j(c, n)
     Character *c;
     Character *n;
{
    return K2rom(c, n, JISROMAN);
}

int K2H(c, n)
     Character *c;
     Character *n;
{
    if (c[0].c1 == 0xa5) {
	if (c[0].c2 < 0xf4) { /* !=  */
	    n[0].type = JIS83;
	    n[0].c1 = 0xa4;
	    n[0].c2 = c[0].c2;
	    n[1].type = OTHER;
	    n[1].c1 = 0;
	    n[1].c2 = 0;
	    return 1;
	} else if (c[0].c2 == 0xf4) { /* ==  */
	    n[0].type = JIS83;
	    n[0].c1 = 0xa4;
	    n[0].c2 = 0xa6;
	    n[1].type = JIS83;
	    n[1].c1 = 0xa1;
	    n[1].c2 = 0xab;
	    n[2].type = OTHER;
	    n[2].c1 = 0;
	    n[2].c2 = 0;
	    return 1;
	} else if (c[0].c2 == 0xf5) { /* ==  */
	    n[0].type = JIS83;
	    n[0].c1 = 0xa4;
	    n[0].c2 = 0xa;
	    n[1].type = OTHER;
	    n[1].c1 = 0;
	    n[1].c2 = 0;
	    return 1;
	} else if (c[0].c2 == 0xf5) { /* ==  */
	    n[0].type = JIS83;
	    n[0].c1 = 0xa4;
	    n[0].c2 = 0xb1;
	    n[1].type = OTHER;
	    n[1].c1 = 0;
	    n[1].c2 = 0;
	    return 1;
	}
    } else if ((c[0].c1 == 0xa1) &&
	       ((c[0].c2 == 0xbc) || (c[0].c2 == 0xab) || (c[0].c2 == 0xac))) {
	n[0].type = JIS83;
	n[0].c1 = c[0].c1;
	n[0].c2 = c[0].c2;
	n[1].type = OTHER;
	n[1].c1 = 0;
	n[1].c2 = 0;
	return 1;
    }
    n[0].type = OTHER;
    n[0].c1 = 0;
    n[0].c2 = 0;
    return 1;
}

int K2k(c, n)
     Character *c;
     Character *n;
{
    unsigned char *b;
    int i;

    static unsigned char K2k_table[0x60][3] = {
	"",   "'",  "1",  "(",  "2",  ")",  "3",  "*",
	"4",  "+",  "5",  "6",  "6^", "7",  "7^", "8",
	"8^", "9",  "9^", ":",  ":^", ";",  ";^", "<",
	"<^", "=",  "=^", ">",  ">^", "?",  "?^", "@",
	"@^", "A",  "A^", "/",  "B",  "B^", "C",  "C^",
	"D",  "D^", "E",  "F",  "G",  "H",  "I",  "J",
	"J^", "J_", "K",  "K^", "K_", "L",  "L^", "L_",
	"M",  "M^", "M_", "N",  "N^", "N_", "O",  "P",
	"Q",  "R",  "S",  ",",  "T",  "-",  "U",  ".",
	"V",  "W",  "X",  "Y",  "Z",  "[",  "\\",  "\\",
	"2",  "4",  "&",  "]",  "3^", "6",  "9",   "",
	"",   "",   "",   "",   "",   "",   "",   ""};

    if (c[0].c1 == 0xa5) {
	for (b = K2k_table[(c[0].c2 & 0x7f) - 0x20], i = 0;
	     *b != '\0'; ++ b, ++ i) {
	    n[i].type = KATAKANA;
	    n[i].c1 = *b;
	}
	n[i].type = OTHER;
	n[i].c1 = 0;
    } else if ((c[0].c1 == 0xa1) &&
	       ((c[0].c2 == 0xbc) || (c[0].c2 == 0xab) || (c[0].c2 == 0xac))) {
	n[0].type = KATAKANA;
	switch(c[0].c2) {
	  case 0xbc:
	    n[0].c1 = '0'; break;
	  case 0xab:
	    n[0].c1 = '^'; break;
	  case 0xac:
	    n[0].c1 = '_'; break;
	}
	n[1].type = OTHER;
	n[1].c1 = 0;
    } else {
	n[0].type = OTHER;
	n[0].c1 = 0;
    }
    return 1;
}
