Example of illegal code:

```ada
function F (X : out Integer) return Integer
  with Exceptional_Cases => (Constraint_Error => X <= 0);
```

This error is issued on functions with an `Exceptional_Cases` aspect or pragma.
Functions should be free of side-effects in SPARK, which includes that they
should always terminate normally on any input that satisfies their
precondition.

The fix is to declare that the function has side-effects with the aspect
`Side_Effects`:

```ada
function F (X : out Integer) return Integer
  with Side_Effects,
       Exceptional_Cases => (Constraint_Error => X <= 0);
```

As a result, calls to `F` can only appear as the right-hand side of
assignments, which may require adapting `F`'s callers:

```ada
declare
   X : Integer;
   Y : Integer := F (X); -- error
begin
   Y := F (X); -- ok
   Y := F (X) + 1; -- error
end;
```
