# Mongolian

## Introduction

Mongolian constellations and cosmogony were inherited from the occidental civilisation notably by the contact with Alexander the Great and was largely influenced by Chinese civilisation and Buddhist religion, resulting in numerous myths and beliefs linked with what surrounds them. The local wild and fauna are the main themes of this skyculture. The wealth of their cosmogony is probably to link with the observation conditions for whom they benefit even now. In the past, the necessity for them to move and to get one's bearing even during the night and at different seasons, by searching the weather's mildness, is probably one of the element which developed their imaginary facing the sky.

## Description

### Constellations

 Generally, stars represent animals turning around the North Star which is symbolized by the golden stick (*Altan Hadaas*). Almost all Mongolian asterisms are similar to those that we know. However some have other names like *Num Sum* (The Bow and the Arrow) for the constellation Swan, or *Doloon Burkhan* for the seven stars of the Big Dipper. The summer triangle made up of Vega, Deneb and Altair stars refers to three stags (*Gurvan Maral Od* in Mongolian). And Cassiopeia represents, in the Mongolian imagination, the Five Stars Woman (*Hun Tavan Od*).

### Planets and Stars

 Originally, Tibeto-Mongolian astrology calculates the positions of each of the planets visible with the naked eye. Because planets beyond Saturn are not visible without telescope (the instrument which appeared long time after the creation of their astrology), the Mongolians have attributed one of the five planets for each day of the week, completing with the Sun (*Nar*) for Sunday and the Moon (*Sar*) for Monday. The names of the Solar System's planets and Pluto have some peculiarities in Mongolian. Mercury is named *Bud* (associated with Wednesday), Venus, *Sugar* (associated with Friday), the Earth, *Delkhii*, Mars, *Angarag* (associated with Tuesday), Jupiter, *Barhasbadi* (associated with Thursday), Saturn, *Sanchir* (associated with Saturday), Uranus, *Tengeriin-van*, Neptune, *Dalai-van* and at last Pluto, *Dalkhii-van*. We can see that the three last, invisible to the naked eye and discovered long time after the others, have the characteristic to have the particle *-van* at the end of the name, indicating the princely status in Mongolian. Earth and Pluto are named similarly, except that this last one has this particle. It is possible to translate from Mongolian Pluto like "The princely ground" (ground and not Earth because it means here the surface on which we walk, not the Earth. Uranus, *Tengeriin-van*, could be translated as "princely sky", and Neptune, *Dalai-van*, as the "princely ocean". Nevertheless, this particle has no real equivalent in English, and translations above are presented to give an idea of the planets name's meaning. However, the names of the celestial bodies specified here come from Sanskrit (language spoken in India) and are largely used in the current language in Mongolia but in an unofficial way.

 It is also very interesting to see the tight link between terms designating other celestial bodies and their beliefs: indeed, *Tengeriin Zadas* appoints the Milky Way. We could literally translate this as the "Sky Line" (*Tengeriin* for the sky, which also means the god of the sky, and *Zadas* for the line). Well known in Mongolian star lore concerns Alcor, the star located above Mizar in the Big Bear. It symbolises the recover and protection star. It was placed here by *Tengeriin* (god of heaven) to protect Mizar. To become an archer for Genghis Khan (13th century), it seemed that one had to be able to discern these two stars with the naked eye.

 From a historic point of view, this excellent knowledge of the sky goes back to *Ulug Beg* (AD1394-1449; *Taraghay* by his real name), astronomer, mathematician and viceroy in Samarkand whose empire spread as far as Central Asia. Turning away from his royal obligations, he examined celestial bodies and astronomical questions of his time. He is the first to extremely precisely measure Saturn's revolution period (*Sanchir*) with a sextant of 40 meters radius.

### Myths and Legends

### The Great Bear

 Mongolians are particularly attached to the Great Bear. This constellation is limited for them to the seven Dipper stars making the bear's tail and body, but the legend concerning it is probably the most famous in Mongolia.

> Once upon a time, there were eight orphan brothers gifted with outstanding capabilities living within a kingdom. The king and the queen lived within it peacefully. One day, a monster came and kidnapped the queen. The king asked the eight brothers to bring her back and said: "If one of you succeeds to rescue my beloved, I will give to him a golden arrow". The orphans went together to assist their queen. They searched the monster during two days and three nights, when in the middle of the third night, they found and killed the monster. They brought back the queen in the castle.
>
> The king did not cut out the arrow in eight parts, he decided to threw it in the sky. The first to catch it could keep it. The younger brother succeeded the test and changed immediately into the North Star (Polar Star). The seven others changed into the seven gods, the seven Buddhas visiting their younger brother every night. The name *Doloon burkhan* (the Seven Buddhas) come from this legend to appoint the Great Bear and the Golden Stick, *Altan Hadaas*, the Polar Star.

 A tradition, particularly delightful, concerns the link between Mongolian people and the Great Bear as one star of this constellation is attributed to each of them. It depends on their birth year in the Chinese calendar. Chinese and Mongolian calendars have some similarities (the Mongolian calendar is a lunar calendar). Each year is symbolized by an animal, itself associated to a star of the constellation Great Bear. The first, Dubhe, corresponds to the rat's year, the second, Merak, corresponds to the ox and so on until the end of the Great Bear's tail where Alkaid symbolizes the year of the horse. Then we come back to the first, the sheep year and we repeat the same way until the twelfth and latest year of the Chinese calendar, the one of the pig. Therefore, the two stars at the end of the tail are assigned one time only.

[Note by G. Zotti: This is a variant of the old Seven Buddha Sutra described by *Elverskog*. There however, the association of the stars goes in an up-and-down movement, i.e., Dubhe/Rat, Merak/Ox, ... Mizar/Snake, Alkaid/Horse, Mizar/Goat, ... Merak/Pig.]
 <img src="illustrations/doloon_burkhan.png" width="550">

### Shooting stars

 Shooting stars have also a specific meaning: they are personified through their beliefs. When they see these shooting stars they imagine that it is a star which falls from the sky and which symbolizes somebody who just died. Whereas occidental people make a wish, Mongolians say: "Phew, it is not me!"

### Neglected Legends

 Three legends just as rich in meaning concern the Sun, eclipses and *Hun Tavan Od* (Cassiopeia). However, they are nowadays neglected and almost forgotten by most Mongolians:

#### Sun

> At the origin of the world, there was only one man and vast particularly dry meadows, burned by the seven suns which lit the world. This man, a very good archer, made the promise to the gods that he pierced all these suns without missing a target even once. If he should fail, he would cut himself all the fingers one by one and leave to live in a hole like a marmot (groundhog) to ward off the curse that would weigh on him. He took his bow, pulled a first arrow and hit his target. A second, a third until the sixth which destroyed the suns. He finished by pulling his seventh arrow towards the last sun, when a swallow flew off and passed through its direction. The bird was hit. The man had not reach his goal, so he left towards exile in a hole, cut his fingers and turned into a marmot. The swallow had just saved our Sun, otherwise all life would have disappeared from the world's surface.

 We have to see here a parallel with the number seven, important in the Mongolian culture like all odd numbers. They bring luck in the buddhist religion.

#### Eclipses

> At that time lived a scary monster named *Raah* which frightened the entire world. He devoured all who were in its way. The god *Orchiwaani* owned a magic spring: whoever drank from it became immortal. One day, *Raah* stole the spring and drunk. The Moon and the Sun caught the monster in the act and reported to *Orchiwaani*. Seething with rage to hear about this piece of news he went to fight the monster. He cut its head many times but it grew again immediately because *Raah* had become immortal. He thought then to cut its tail in order to allow all that it ate to leave again directly. Just as *Orchiwaani* would seize the monster to finish it off, it escaped and disappeared between the Moon and the Sun. Then *Orchiwaani* asked the Moon, who recaptured *Raah* and cut its rump and its tail. In revenge, the monster comes back sometimes to eat the Moon or the Sun which exit immediately, giving rise to moon and solar eclipses.

When there is an eclipse, Mongolians know that it means that *Raah* devours the Moon or the Sun and they make a lot of noise so that the monster liberates the eclipsed star. In the 13th century, Guillaume de Rubruck wrote:

> "Some [Mongolian people] have knowledge in astronomy and predict them [to other Mongolian people] the Lunar and Solar eclipses and, when it is about to produce one, everybody stocks up on food because they do not pass the door of their habitation. And while the eclipse happened, they play the drum and instruments and do big noise and clamors. When the eclipse is finished, they devote themselves to beverage and festivity and do big party."

(Source: [#1])

Eclipse travelers in 2008 still witnessed drivers and cooks hiding in their tents and making noise with the pots. It seemed authentic, not a show for the tourists. Also note the similarity of *Raah* with Indian *Rahu*.

#### Cassiopeia (*Hun Tavan Od*)

Cassiopeia (*Hun Tavan Od*) symbolises unity, brotherhood, solidarity for the Mongolians. The constellation's five stars represent unity of the five children of Genghis Khan's wife, Oulin.

> Them did not get well along with each other and squabbled all the time. Their mother decided to strongly tie five ropes, and each one should try to untie a knot. If they succeeded, it meant that they didn't remain united with other, and that the brotherhood didn't gather in hard times. Conversely, if the knots withstood the test, the five brothers would remain united and close for the rest of their lives and would be victorious at the time of wars.

### Other Beliefs Linked to the Sky

According to a Mongolian legend, a woman devoting herself to count one hundred stars in the sky will dream about her future husband.

 Sometimes, Mongolians honor the Great Bear (*Doloon Burkhan*) by throwing milk in its direction. Milk, of white color, symbolizes purity in Mongolia. They pray so that something may be fulfilled, but for several persons, not for just one person, because this would bring bad luck. Milk can be replaced by vodka which, even if it is colorless, symbolizes the dark color and the strength for Mongolians. By doing this, it avoids bad luck, quarrels, fear and fends off evil spirits.

### Conclusion

 The constellations are inspired by occidental ones, but the Mongolian cosmogony, briefly exposed here, highlights a notable identity of beliefs which are associated with it. Mongolian culture and knowledge transmission is essentially verbal, and so few written traces exist about these subjects. It is therefore particularly hard to relate their cosmogony with high fidelity and precision. In order to preserve knowledge about this cosmogony, every observation, suggestions or collaboration are welcome!

### Acknowledgements and Further Reading

 - Bayrlalaa (thank you) to Mongolians, for their kindness and their help in the gathering of these informations about their culture and their cosmogony
 - [L'Uranoscope de France](http://uranoscope.free.fr)
 - [ L'Association Française d'Astronomie / The French Astronomy Association](http://www.afanet.fr)
 - [OutOfNowhere](http://www.outofnowhere.asia)

## References

 - [#1]: *Les astres chez les Turcs et les Mongols* by Jean-Paul Roux (French). *Revue de l'histoire des religions*, tome 195 n°2, 1979. pp; 153-192.
 - [#2]: [Johan Elverskog: The Mongolian Big Dipper Sutra. ](https://journals.ub.uni-heidelberg.de/index.php/jiabs/article/download/8974/2867) Journal of the International Association of Buddhist Studies 29 Nr1 2006(2008), pp87-123.

## Authors

 This skyculture is a contribution from two users of Stellarium, **Anthony Lagain** (anthony.lagain(at)gmail.com) and **Batiste Rousseau** (batiste.rousseau(at)gmail.com) mainly based on oral tales of numerous Mongolians met during a two months stay in Mongolia. To learn more about them: [www.souslecieldemongolie.wordpress.com](http://souslecieldemongolie.wordpress.com/) (in French).

## License

CC BY-SA 4.0
