# Modern (H.A. Rey)

## Introduction

During the 19th century the use and further editions of richly illustrated atlases with sumptuously engraved mythological figures fell out of fashion. The stars of the constellations in atlases of that time started to be shown connected with line patterns ("stick figures"), which however appear sometimes only to have been used to indicate which stars belong to which constellation. Over several decades the figures had ceased to resemble the figures they were named after and appeared incomprehensible to beginning stargazers in the middle of the 20th century.

## Description

<img src="illustrations/Rey_cover.png" width="150" align="right"/> H. A. Rey (Hans Augusto Reyersbach) (1898-1977), an artist and author of children's books of German descent but emigrated to the USA, published his answer to this problem in 1952 with the book *The Stars - A New Way To See Them*[#1][#2].

### The Constellations

In this book, which has become very popular especially in the US, Rey connected the stars of every constellation "in such a way that the resulting shape makes sense." What surprised him was "that nobody has done it before. The basic idea is so simple."

Rey's new stick figures make it indeed very simple to recognize the depicted constellation figures. Rey's work does not include figurative artwork, therefore this sky culture deliberately only comes with Rey's original stick figures. The constellation names were also always given in English by Rey. If you switch to "Native" name display mode, you may see exactly the spelling used in his book. Also the stars named here are limited to those included in the book.

### Rey's Figures and the Classic Constellations

Rey's constellations adhere to the tradition of the Western sky culture and describes the 88 officially acknowledged constellations, with addition of asterisms of the two Dippers and the "Great Square" (of Pegasus). However, at several points Rey's figures deviate from the canonical figures described since Ptolemy's Almagest (2nd century AD), where also positions of the stars in their constellations had been described in their names. For example,

 - Rey inverted the figure of the Great Bear (*Ursa Major*) to look like a polar bear scenting prey. This on one hand does not have the usual problem to explain its long tail. On the other hand, the bear is not shown to walk around the pole in this orientation.
 - The Bull (*Taurus*), only the front of which is shown with long upright horns in usual depictions, is shown with a complete body including its tail, with horns stretched wide like those of a buffalo. Its bright eye *Aldebaran* now lies in its neck.
 - The head of *Hercules* is usually next to the head of *Ophiuchus*, the serpent holder, and the four stars known as "keystone" form his body. Rey makes his head out of the keystone, and the star that usually marks the hero's head is now one of his feet.
 - The Whale (*Cetus*) has been turned around, its former mouth now forming a tail fin.
 - *Pegasus* exchanged feet and head.
 - *Bootes*, the herdsman, is shown sitting and smoking a pipe (no trace of political correctness in a children's book of the 1950s... :-)

### External links

 - [H.A.Rey (Wikipedia)](http://en.wikipedia.org/wiki/H._A._Rey)

## References

 - [#1]: H.A.Rey (1952). "The Stars. A New Way to See Them" (41th printing ca. 1997). Houghton Mifflin Company, Boston. ISBN 0-395-08121-1 (reinforced).
 - [#2]: H.A.Rey (1952). "The Stars. A New Way to See Them" (44th printing ca. 1997). Houghton Mifflin Company, Boston. ISBN 0-395-24830-2 (paperbound).
 - [#3]: H.A.Rey (1954). "Find the Constellations" (rev. ed. 1977, 38th printing ca. 1997). Houghton Mifflin Company, Boston. ISBN 0-395-24418-8.

## Authors

This sky culture used to be for a long time an easy user-installable addon example contributed by Mike Richards. It has been reworked following the 41st reprint and completed with this description by Georg Zotti.

## License

CC BY-SA 4.0
