/*      gausslegendre.h
//      
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//      
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//      
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//      
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//      
*/      


#if !defined (GAUSSLEGENDRE_H)
#define GAUSSLEGENDRE_H     1

#include "compthreads.h"
#include "pi.h"

typedef struct gausslegendre_data
{

  mpf_t a, a2, b, b2, t, p, p2, aplus1, bplus1, tplus1, pplus1, temp1, temp2,
    pi;

} gldata;

extern gldata gd[MAX_THREADS];

st_threadfunc_t gl_initialize (st_threadfuncarg_t idx);
st_threadfunc_t gl_calculate (st_threadfuncarg_t idx);
st_threadfunc_t gl_finalize (st_threadfuncarg_t idx);

#endif
