/*      hppa-cpuid.cpp
//      
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//      
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//      
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//      
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//      
*/      

/* Determine the Hewlett-Packard PA RISC CPU implementation 
 */

#include <unistd.h>

int
CPUID (char *ChipID, char *VendorID)
{
  long chip_id;
  strcpy (VendorID, "HP");
  chip_id = sysconf (_SC_CPU_VERSION);

  switch (chip_id)
    {
    case CPU_PA_RISC1_0:
      strcpy (ChipID, "Hewlett-Packard PA RISC 1.0");
      break;
    case CPU_PA_RISC1_1:
      strcpy (ChipID, "Hewlett-Packard PA RISC 1.1");
      break;
    case CPU_PA_RISC1_2:
      strcpy (ChipID, "Hewlett-Packard PA RISC 1.2");
      break;
    case CPU_PA_RISC2_0:
      strcpy (ChipID, "Hewlett-Packard PA RISC 2.0");
      break;
    default:
      strcpy (ChipID, "Unknown PA RISC CPU implementation");
      break;
    }

  return 4;			/* PA RISC cpuid = 4 */
}
