/*      outtime.cpp
//      
//      Copyright 2005-2011 Lucas Tsatiris <systester.project@gmail.com>
//      
//      This program is free software; you can redistribute it and/or modify
//      it under the terms of the GNU General Public License as published by
//      the Free Software Foundation; either version 2 of the License, or
//      (at your option) any later version.
//      
//      This program is distributed in the hope that it will be useful,
//      but WITHOUT ANY WARRANTY; without even the implied warranty of
//      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//      GNU General Public License for more details.
//      
//      You should have received a copy of the GNU General Public License
//      along with this program; if not, write to the Free Software
//      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
//      MA 02110-1301, USA.
//      
*/      


#include "systester.h"

/*
 * Prepare the elapsed time for the screen output 
 */
void
outtime (unsigned long long start, unsigned long long stop, char *str)
{

  unsigned long long hours = 0, minutes = 0, remainder = 0, total_seconds = 0;
  float seconds;

  total_seconds = (unsigned long long) ((stop - start) / 1000);
  hours = (unsigned long long) (total_seconds / 3600);
  remainder = total_seconds % 3600;
  minutes = (unsigned long long) (remainder / 60);
  seconds =
    (float) ((stop - start) -
	     (((hours * 3600) + (minutes * 60)) * 1000)) / 1000;

  sprintf (str, "%2dh %2dm %6.3fs", (int) hours, (int) minutes, seconds);
}
