// Copyright 2021 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.13.0
// source: proto/v1/intoto_statement.proto

package grafeas_go_proto

import (
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement
// The serialized InTotoStatement will be stored as Envelope.payload.
// Envelope.payloadType is always "application/vnd.in-toto+json".
type InTotoStatement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Always `https://in-toto.io/Statement/v0.1`.
	Type    string     `protobuf:"bytes,1,opt,name=type,json=_type,proto3" json:"type,omitempty"`
	Subject []*Subject `protobuf:"bytes,2,rep,name=subject,proto3" json:"subject,omitempty"`
	// `https://slsa.dev/provenance/v0.1` for SlsaProvenance.
	PredicateType string `protobuf:"bytes,3,opt,name=predicate_type,json=predicateType,proto3" json:"predicate_type,omitempty"`
	// Types that are assignable to Predicate:
	//
	//	*InTotoStatement_Provenance
	//	*InTotoStatement_SlsaProvenance
	//	*InTotoStatement_SlsaProvenanceZeroTwo
	Predicate isInTotoStatement_Predicate `protobuf_oneof:"predicate"`
}

func (x *InTotoStatement) Reset() {
	*x = InTotoStatement{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoStatement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoStatement) ProtoMessage() {}

func (x *InTotoStatement) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoStatement.ProtoReflect.Descriptor instead.
func (*InTotoStatement) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{0}
}

func (x *InTotoStatement) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *InTotoStatement) GetSubject() []*Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *InTotoStatement) GetPredicateType() string {
	if x != nil {
		return x.PredicateType
	}
	return ""
}

func (m *InTotoStatement) GetPredicate() isInTotoStatement_Predicate {
	if m != nil {
		return m.Predicate
	}
	return nil
}

func (x *InTotoStatement) GetProvenance() *InTotoProvenance {
	if x, ok := x.GetPredicate().(*InTotoStatement_Provenance); ok {
		return x.Provenance
	}
	return nil
}

func (x *InTotoStatement) GetSlsaProvenance() *SlsaProvenance {
	if x, ok := x.GetPredicate().(*InTotoStatement_SlsaProvenance); ok {
		return x.SlsaProvenance
	}
	return nil
}

func (x *InTotoStatement) GetSlsaProvenanceZeroTwo() *SlsaProvenanceZeroTwo {
	if x, ok := x.GetPredicate().(*InTotoStatement_SlsaProvenanceZeroTwo); ok {
		return x.SlsaProvenanceZeroTwo
	}
	return nil
}

type isInTotoStatement_Predicate interface {
	isInTotoStatement_Predicate()
}

type InTotoStatement_Provenance struct {
	Provenance *InTotoProvenance `protobuf:"bytes,4,opt,name=provenance,proto3,oneof"`
}

type InTotoStatement_SlsaProvenance struct {
	SlsaProvenance *SlsaProvenance `protobuf:"bytes,5,opt,name=slsa_provenance,json=slsaProvenance,proto3,oneof"`
}

type InTotoStatement_SlsaProvenanceZeroTwo struct {
	SlsaProvenanceZeroTwo *SlsaProvenanceZeroTwo `protobuf:"bytes,6,opt,name=slsa_provenance_zero_two,json=slsaProvenanceZeroTwo,proto3,oneof"`
}

func (*InTotoStatement_Provenance) isInTotoStatement_Predicate() {}

func (*InTotoStatement_SlsaProvenance) isInTotoStatement_Predicate() {}

func (*InTotoStatement_SlsaProvenanceZeroTwo) isInTotoStatement_Predicate() {}

type Subject struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// `"<ALGORITHM>": "<HEX_VALUE>"`
	// Algorithms can be e.g. sha256, sha512
	// See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
	Digest map[string]string `protobuf:"bytes,2,rep,name=digest,proto3" json:"digest,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Subject) Reset() {
	*x = Subject{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Subject) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Subject) ProtoMessage() {}

func (x *Subject) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Subject.ProtoReflect.Descriptor instead.
func (*Subject) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{1}
}

func (x *Subject) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Subject) GetDigest() map[string]string {
	if x != nil {
		return x.Digest
	}
	return nil
}

type InTotoSlsaProvenanceV1 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// InToto spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement
	Type          string                                   `protobuf:"bytes,1,opt,name=type,json=_type,proto3" json:"type,omitempty"`
	Subject       []*Subject                               `protobuf:"bytes,2,rep,name=subject,proto3" json:"subject,omitempty"`
	PredicateType string                                   `protobuf:"bytes,3,opt,name=predicate_type,json=predicateType,proto3" json:"predicate_type,omitempty"`
	Predicate     *InTotoSlsaProvenanceV1_SlsaProvenanceV1 `protobuf:"bytes,4,opt,name=predicate,proto3" json:"predicate,omitempty"`
}

func (x *InTotoSlsaProvenanceV1) Reset() {
	*x = InTotoSlsaProvenanceV1{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoSlsaProvenanceV1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoSlsaProvenanceV1) ProtoMessage() {}

func (x *InTotoSlsaProvenanceV1) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoSlsaProvenanceV1.ProtoReflect.Descriptor instead.
func (*InTotoSlsaProvenanceV1) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{2}
}

func (x *InTotoSlsaProvenanceV1) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1) GetSubject() []*Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1) GetPredicateType() string {
	if x != nil {
		return x.PredicateType
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1) GetPredicate() *InTotoSlsaProvenanceV1_SlsaProvenanceV1 {
	if x != nil {
		return x.Predicate
	}
	return nil
}

// Keep in sync with schema at
// https://github.com/slsa-framework/slsa/blob/main/docs/provenance/schema/v1/provenance.proto
// Builder renamed to ProvenanceBuilder because of Java conflicts.
type InTotoSlsaProvenanceV1_SlsaProvenanceV1 struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BuildDefinition *InTotoSlsaProvenanceV1_BuildDefinition `protobuf:"bytes,1,opt,name=build_definition,json=buildDefinition,proto3" json:"build_definition,omitempty"`
	RunDetails      *InTotoSlsaProvenanceV1_RunDetails      `protobuf:"bytes,2,opt,name=run_details,json=runDetails,proto3" json:"run_details,omitempty"`
}

func (x *InTotoSlsaProvenanceV1_SlsaProvenanceV1) Reset() {
	*x = InTotoSlsaProvenanceV1_SlsaProvenanceV1{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoSlsaProvenanceV1_SlsaProvenanceV1) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoSlsaProvenanceV1_SlsaProvenanceV1) ProtoMessage() {}

func (x *InTotoSlsaProvenanceV1_SlsaProvenanceV1) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoSlsaProvenanceV1_SlsaProvenanceV1.ProtoReflect.Descriptor instead.
func (*InTotoSlsaProvenanceV1_SlsaProvenanceV1) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{2, 0}
}

func (x *InTotoSlsaProvenanceV1_SlsaProvenanceV1) GetBuildDefinition() *InTotoSlsaProvenanceV1_BuildDefinition {
	if x != nil {
		return x.BuildDefinition
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_SlsaProvenanceV1) GetRunDetails() *InTotoSlsaProvenanceV1_RunDetails {
	if x != nil {
		return x.RunDetails
	}
	return nil
}

type InTotoSlsaProvenanceV1_BuildDefinition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	BuildType            string                                       `protobuf:"bytes,1,opt,name=build_type,json=buildType,proto3" json:"build_type,omitempty"`
	ExternalParameters   *_struct.Struct                              `protobuf:"bytes,2,opt,name=external_parameters,json=externalParameters,proto3" json:"external_parameters,omitempty"`
	InternalParameters   *_struct.Struct                              `protobuf:"bytes,3,opt,name=internal_parameters,json=internalParameters,proto3" json:"internal_parameters,omitempty"`
	ResolvedDependencies []*InTotoSlsaProvenanceV1_ResourceDescriptor `protobuf:"bytes,4,rep,name=resolved_dependencies,json=resolvedDependencies,proto3" json:"resolved_dependencies,omitempty"`
}

func (x *InTotoSlsaProvenanceV1_BuildDefinition) Reset() {
	*x = InTotoSlsaProvenanceV1_BuildDefinition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoSlsaProvenanceV1_BuildDefinition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoSlsaProvenanceV1_BuildDefinition) ProtoMessage() {}

func (x *InTotoSlsaProvenanceV1_BuildDefinition) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoSlsaProvenanceV1_BuildDefinition.ProtoReflect.Descriptor instead.
func (*InTotoSlsaProvenanceV1_BuildDefinition) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{2, 1}
}

func (x *InTotoSlsaProvenanceV1_BuildDefinition) GetBuildType() string {
	if x != nil {
		return x.BuildType
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1_BuildDefinition) GetExternalParameters() *_struct.Struct {
	if x != nil {
		return x.ExternalParameters
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_BuildDefinition) GetInternalParameters() *_struct.Struct {
	if x != nil {
		return x.InternalParameters
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_BuildDefinition) GetResolvedDependencies() []*InTotoSlsaProvenanceV1_ResourceDescriptor {
	if x != nil {
		return x.ResolvedDependencies
	}
	return nil
}

type InTotoSlsaProvenanceV1_ResourceDescriptor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name             string                    `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Uri              string                    `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	Digest           map[string]string         `protobuf:"bytes,3,rep,name=digest,proto3" json:"digest,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Content          []byte                    `protobuf:"bytes,4,opt,name=content,proto3" json:"content,omitempty"`
	DownloadLocation string                    `protobuf:"bytes,5,opt,name=download_location,json=downloadLocation,proto3" json:"download_location,omitempty"`
	MediaType        string                    `protobuf:"bytes,6,opt,name=media_type,json=mediaType,proto3" json:"media_type,omitempty"`
	Annotations      map[string]*_struct.Value `protobuf:"bytes,7,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) Reset() {
	*x = InTotoSlsaProvenanceV1_ResourceDescriptor{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoSlsaProvenanceV1_ResourceDescriptor) ProtoMessage() {}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoSlsaProvenanceV1_ResourceDescriptor.ProtoReflect.Descriptor instead.
func (*InTotoSlsaProvenanceV1_ResourceDescriptor) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{2, 2}
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) GetDigest() map[string]string {
	if x != nil {
		return x.Digest
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) GetContent() []byte {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) GetDownloadLocation() string {
	if x != nil {
		return x.DownloadLocation
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) GetMediaType() string {
	if x != nil {
		return x.MediaType
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1_ResourceDescriptor) GetAnnotations() map[string]*_struct.Value {
	if x != nil {
		return x.Annotations
	}
	return nil
}

type InTotoSlsaProvenanceV1_RunDetails struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Builder    *InTotoSlsaProvenanceV1_ProvenanceBuilder    `protobuf:"bytes,1,opt,name=builder,proto3" json:"builder,omitempty"`
	Metadata   *InTotoSlsaProvenanceV1_BuildMetadata        `protobuf:"bytes,2,opt,name=metadata,proto3" json:"metadata,omitempty"`
	Byproducts []*InTotoSlsaProvenanceV1_ResourceDescriptor `protobuf:"bytes,3,rep,name=byproducts,proto3" json:"byproducts,omitempty"`
}

func (x *InTotoSlsaProvenanceV1_RunDetails) Reset() {
	*x = InTotoSlsaProvenanceV1_RunDetails{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoSlsaProvenanceV1_RunDetails) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoSlsaProvenanceV1_RunDetails) ProtoMessage() {}

func (x *InTotoSlsaProvenanceV1_RunDetails) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoSlsaProvenanceV1_RunDetails.ProtoReflect.Descriptor instead.
func (*InTotoSlsaProvenanceV1_RunDetails) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{2, 3}
}

func (x *InTotoSlsaProvenanceV1_RunDetails) GetBuilder() *InTotoSlsaProvenanceV1_ProvenanceBuilder {
	if x != nil {
		return x.Builder
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_RunDetails) GetMetadata() *InTotoSlsaProvenanceV1_BuildMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_RunDetails) GetByproducts() []*InTotoSlsaProvenanceV1_ResourceDescriptor {
	if x != nil {
		return x.Byproducts
	}
	return nil
}

type InTotoSlsaProvenanceV1_ProvenanceBuilder struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id                  string                                       `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Version             map[string]string                            `protobuf:"bytes,2,rep,name=version,proto3" json:"version,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	BuilderDependencies []*InTotoSlsaProvenanceV1_ResourceDescriptor `protobuf:"bytes,3,rep,name=builder_dependencies,json=builderDependencies,proto3" json:"builder_dependencies,omitempty"`
}

func (x *InTotoSlsaProvenanceV1_ProvenanceBuilder) Reset() {
	*x = InTotoSlsaProvenanceV1_ProvenanceBuilder{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoSlsaProvenanceV1_ProvenanceBuilder) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoSlsaProvenanceV1_ProvenanceBuilder) ProtoMessage() {}

func (x *InTotoSlsaProvenanceV1_ProvenanceBuilder) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoSlsaProvenanceV1_ProvenanceBuilder.ProtoReflect.Descriptor instead.
func (*InTotoSlsaProvenanceV1_ProvenanceBuilder) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{2, 4}
}

func (x *InTotoSlsaProvenanceV1_ProvenanceBuilder) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1_ProvenanceBuilder) GetVersion() map[string]string {
	if x != nil {
		return x.Version
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_ProvenanceBuilder) GetBuilderDependencies() []*InTotoSlsaProvenanceV1_ResourceDescriptor {
	if x != nil {
		return x.BuilderDependencies
	}
	return nil
}

type InTotoSlsaProvenanceV1_BuildMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	InvocationId string               `protobuf:"bytes,1,opt,name=invocation_id,json=invocationId,proto3" json:"invocation_id,omitempty"`
	StartedOn    *timestamp.Timestamp `protobuf:"bytes,2,opt,name=started_on,json=startedOn,proto3" json:"started_on,omitempty"`
	FinishedOn   *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finished_on,json=finishedOn,proto3" json:"finished_on,omitempty"`
}

func (x *InTotoSlsaProvenanceV1_BuildMetadata) Reset() {
	*x = InTotoSlsaProvenanceV1_BuildMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_intoto_statement_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *InTotoSlsaProvenanceV1_BuildMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*InTotoSlsaProvenanceV1_BuildMetadata) ProtoMessage() {}

func (x *InTotoSlsaProvenanceV1_BuildMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_intoto_statement_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use InTotoSlsaProvenanceV1_BuildMetadata.ProtoReflect.Descriptor instead.
func (*InTotoSlsaProvenanceV1_BuildMetadata) Descriptor() ([]byte, []int) {
	return file_proto_v1_intoto_statement_proto_rawDescGZIP(), []int{2, 5}
}

func (x *InTotoSlsaProvenanceV1_BuildMetadata) GetInvocationId() string {
	if x != nil {
		return x.InvocationId
	}
	return ""
}

func (x *InTotoSlsaProvenanceV1_BuildMetadata) GetStartedOn() *timestamp.Timestamp {
	if x != nil {
		return x.StartedOn
	}
	return nil
}

func (x *InTotoSlsaProvenanceV1_BuildMetadata) GetFinishedOn() *timestamp.Timestamp {
	if x != nil {
		return x.FinishedOn
	}
	return nil
}

var File_proto_v1_intoto_statement_proto protoreflect.FileDescriptor

var file_proto_v1_intoto_statement_proto_rawDesc = []byte{
	0x0a, 0x1f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x6f, 0x74,
	0x6f, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x0a, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x5f, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6c, 0x73, 0x61, 0x5f, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x27,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x6c, 0x73, 0x61, 0x5f, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x74, 0x77,
	0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xee, 0x02, 0x0a, 0x0f, 0x49, 0x6e, 0x54, 0x6f,
	0x74, 0x6f, 0x53, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x13, 0x0a, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x5f, 0x74, 0x79, 0x70, 0x65,
	0x12, 0x2d, 0x0a, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x13, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12,
	0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3e, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x50, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x72, 0x6f, 0x76,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x73, 0x6c, 0x73, 0x61, 0x5f, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x73,
	0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x48, 0x00, 0x52, 0x0e, 0x73,
	0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x5c, 0x0a,
	0x18, 0x73, 0x6c, 0x73, 0x61, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x74, 0x77, 0x6f, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x21, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x6c, 0x73,
	0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x5a, 0x65, 0x72, 0x6f, 0x54,
	0x77, 0x6f, 0x48, 0x00, 0x52, 0x15, 0x73, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x5a, 0x65, 0x72, 0x6f, 0x54, 0x77, 0x6f, 0x42, 0x0b, 0x0a, 0x09, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x22, 0x91, 0x01, 0x0a, 0x07, 0x53, 0x75, 0x62,
	0x6a, 0x65, 0x63, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x37, 0x0a, 0x06, 0x64, 0x69, 0x67, 0x65,
	0x73, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e, 0x44, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73,
	0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b,
	0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0xa4, 0x0f, 0x0a,
	0x16, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65,
	0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x12, 0x13, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x07,
	0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65,
	0x63, 0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x70,
	0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x51, 0x0a, 0x09, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f,
	0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x2e, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x52, 0x09, 0x70, 0x72, 0x65, 0x64,
	0x69, 0x63, 0x61, 0x74, 0x65, 0x1a, 0xc1, 0x01, 0x0a, 0x10, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72,
	0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x12, 0x5d, 0x0a, 0x10, 0x62, 0x75,
	0x69, 0x6c, 0x64, 0x5f, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x32, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x2e, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x44, 0x65,
	0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x44,
	0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x0b, 0x72, 0x75, 0x6e,
	0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d,
	0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f,
	0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65,
	0x56, 0x31, 0x2e, 0x52, 0x75, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x52, 0x0a, 0x72,
	0x75, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0xb0, 0x02, 0x0a, 0x0f, 0x42, 0x75,
	0x69, 0x6c, 0x64, 0x44, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a,
	0x0a, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x48, 0x0a, 0x13,
	0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75,
	0x63, 0x74, 0x52, 0x12, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x48, 0x0a, 0x13, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
	0x61, 0x6c, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x17, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x52, 0x12, 0x69, 0x6e,
	0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x6a, 0x0a, 0x15, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x5f, 0x64, 0x65, 0x70,
	0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x35, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54,
	0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x56, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52, 0x14, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64,
	0x44, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a, 0xf8, 0x03, 0x0a,
	0x12, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12, 0x59, 0x0a, 0x06, 0x64, 0x69, 0x67,
	0x65, 0x73, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x72, 0x61, 0x66,
	0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73,
	0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72,
	0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x64, 0x69,
	0x67, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x2b,
	0x0a, 0x11, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x64, 0x6f, 0x77, 0x6e, 0x6c,
	0x6f, 0x61, 0x64, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x6d,
	0x65, 0x64, 0x69, 0x61, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x54, 0x79, 0x70, 0x65, 0x12, 0x68, 0x0a, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x46, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54,
	0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x56, 0x31, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x2e, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a,
	0x56, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x2c, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x81, 0x02, 0x0a, 0x0a, 0x52, 0x75, 0x6e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x07, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65,
	0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61, 0x50,
	0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76,
	0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x52, 0x07, 0x62,
	0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x12, 0x4c, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61,
	0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x2e, 0x42, 0x75, 0x69,
	0x6c, 0x64, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x55, 0x0a, 0x0a, 0x62, 0x79, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65,
	0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61,
	0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x2e, 0x52, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x52,
	0x0a, 0x62, 0x79, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x1a, 0xa6, 0x02, 0x0a, 0x11,
	0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65,
	0x72, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x5b, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e,
	0x61, 0x6e, 0x63, 0x65, 0x56, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63,
	0x65, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x2e, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x68,
	0x0a, 0x14, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x5f, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
	0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f,
	0x53, 0x6c, 0x73, 0x61, 0x50, 0x72, 0x6f, 0x76, 0x65, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x56, 0x31,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x6f, 0x72, 0x52, 0x13, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x65, 0x72, 0x44, 0x65, 0x70, 0x65,
	0x6e, 0x64, 0x65, 0x6e, 0x63, 0x69, 0x65, 0x73, 0x1a, 0x3a, 0x0a, 0x0c, 0x56, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x1a, 0xac, 0x01, 0x0a, 0x0d, 0x42, 0x75, 0x69, 0x6c, 0x64, 0x4d, 0x65,
	0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x76, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x69,
	0x6e, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x64, 0x12, 0x39, 0x0a, 0x0a, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x65, 0x64, 0x4f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68,
	0x65, 0x64, 0x5f, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x65,
	0x64, 0x4f, 0x6e, 0x42, 0x63, 0x0a, 0x0d, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61,
	0x73, 0x2e, 0x76, 0x31, 0x42, 0x14, 0x49, 0x6e, 0x54, 0x6f, 0x74, 0x6f, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x34, 0x67, 0x69,
	0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73,
	0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76,
	0x31, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0xa2, 0x02, 0x03, 0x47, 0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_proto_v1_intoto_statement_proto_rawDescOnce sync.Once
	file_proto_v1_intoto_statement_proto_rawDescData = file_proto_v1_intoto_statement_proto_rawDesc
)

func file_proto_v1_intoto_statement_proto_rawDescGZIP() []byte {
	file_proto_v1_intoto_statement_proto_rawDescOnce.Do(func() {
		file_proto_v1_intoto_statement_proto_rawDescData = protoimpl.X.CompressGZIP(file_proto_v1_intoto_statement_proto_rawDescData)
	})
	return file_proto_v1_intoto_statement_proto_rawDescData
}

var file_proto_v1_intoto_statement_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_proto_v1_intoto_statement_proto_goTypes = []interface{}{
	(*InTotoStatement)(nil),        // 0: grafeas.v1.InTotoStatement
	(*Subject)(nil),                // 1: grafeas.v1.Subject
	(*InTotoSlsaProvenanceV1)(nil), // 2: grafeas.v1.InTotoSlsaProvenanceV1
	nil,                            // 3: grafeas.v1.Subject.DigestEntry
	(*InTotoSlsaProvenanceV1_SlsaProvenanceV1)(nil),   // 4: grafeas.v1.InTotoSlsaProvenanceV1.SlsaProvenanceV1
	(*InTotoSlsaProvenanceV1_BuildDefinition)(nil),    // 5: grafeas.v1.InTotoSlsaProvenanceV1.BuildDefinition
	(*InTotoSlsaProvenanceV1_ResourceDescriptor)(nil), // 6: grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor
	(*InTotoSlsaProvenanceV1_RunDetails)(nil),         // 7: grafeas.v1.InTotoSlsaProvenanceV1.RunDetails
	(*InTotoSlsaProvenanceV1_ProvenanceBuilder)(nil),  // 8: grafeas.v1.InTotoSlsaProvenanceV1.ProvenanceBuilder
	(*InTotoSlsaProvenanceV1_BuildMetadata)(nil),      // 9: grafeas.v1.InTotoSlsaProvenanceV1.BuildMetadata
	nil,                           // 10: grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor.DigestEntry
	nil,                           // 11: grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor.AnnotationsEntry
	nil,                           // 12: grafeas.v1.InTotoSlsaProvenanceV1.ProvenanceBuilder.VersionEntry
	(*InTotoProvenance)(nil),      // 13: grafeas.v1.InTotoProvenance
	(*SlsaProvenance)(nil),        // 14: grafeas.v1.SlsaProvenance
	(*SlsaProvenanceZeroTwo)(nil), // 15: grafeas.v1.SlsaProvenanceZeroTwo
	(*_struct.Struct)(nil),        // 16: google.protobuf.Struct
	(*timestamp.Timestamp)(nil),   // 17: google.protobuf.Timestamp
	(*_struct.Value)(nil),         // 18: google.protobuf.Value
}
var file_proto_v1_intoto_statement_proto_depIdxs = []int32{
	1,  // 0: grafeas.v1.InTotoStatement.subject:type_name -> grafeas.v1.Subject
	13, // 1: grafeas.v1.InTotoStatement.provenance:type_name -> grafeas.v1.InTotoProvenance
	14, // 2: grafeas.v1.InTotoStatement.slsa_provenance:type_name -> grafeas.v1.SlsaProvenance
	15, // 3: grafeas.v1.InTotoStatement.slsa_provenance_zero_two:type_name -> grafeas.v1.SlsaProvenanceZeroTwo
	3,  // 4: grafeas.v1.Subject.digest:type_name -> grafeas.v1.Subject.DigestEntry
	1,  // 5: grafeas.v1.InTotoSlsaProvenanceV1.subject:type_name -> grafeas.v1.Subject
	4,  // 6: grafeas.v1.InTotoSlsaProvenanceV1.predicate:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.SlsaProvenanceV1
	5,  // 7: grafeas.v1.InTotoSlsaProvenanceV1.SlsaProvenanceV1.build_definition:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.BuildDefinition
	7,  // 8: grafeas.v1.InTotoSlsaProvenanceV1.SlsaProvenanceV1.run_details:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.RunDetails
	16, // 9: grafeas.v1.InTotoSlsaProvenanceV1.BuildDefinition.external_parameters:type_name -> google.protobuf.Struct
	16, // 10: grafeas.v1.InTotoSlsaProvenanceV1.BuildDefinition.internal_parameters:type_name -> google.protobuf.Struct
	6,  // 11: grafeas.v1.InTotoSlsaProvenanceV1.BuildDefinition.resolved_dependencies:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor
	10, // 12: grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor.digest:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor.DigestEntry
	11, // 13: grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor.annotations:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor.AnnotationsEntry
	8,  // 14: grafeas.v1.InTotoSlsaProvenanceV1.RunDetails.builder:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.ProvenanceBuilder
	9,  // 15: grafeas.v1.InTotoSlsaProvenanceV1.RunDetails.metadata:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.BuildMetadata
	6,  // 16: grafeas.v1.InTotoSlsaProvenanceV1.RunDetails.byproducts:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor
	12, // 17: grafeas.v1.InTotoSlsaProvenanceV1.ProvenanceBuilder.version:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.ProvenanceBuilder.VersionEntry
	6,  // 18: grafeas.v1.InTotoSlsaProvenanceV1.ProvenanceBuilder.builder_dependencies:type_name -> grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor
	17, // 19: grafeas.v1.InTotoSlsaProvenanceV1.BuildMetadata.started_on:type_name -> google.protobuf.Timestamp
	17, // 20: grafeas.v1.InTotoSlsaProvenanceV1.BuildMetadata.finished_on:type_name -> google.protobuf.Timestamp
	18, // 21: grafeas.v1.InTotoSlsaProvenanceV1.ResourceDescriptor.AnnotationsEntry.value:type_name -> google.protobuf.Value
	22, // [22:22] is the sub-list for method output_type
	22, // [22:22] is the sub-list for method input_type
	22, // [22:22] is the sub-list for extension type_name
	22, // [22:22] is the sub-list for extension extendee
	0,  // [0:22] is the sub-list for field type_name
}

func init() { file_proto_v1_intoto_statement_proto_init() }
func file_proto_v1_intoto_statement_proto_init() {
	if File_proto_v1_intoto_statement_proto != nil {
		return
	}
	file_proto_v1_intoto_provenance_proto_init()
	file_proto_v1_slsa_provenance_proto_init()
	file_proto_v1_slsa_provenance_zero_two_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_proto_v1_intoto_statement_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoStatement); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Subject); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoSlsaProvenanceV1); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoSlsaProvenanceV1_SlsaProvenanceV1); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoSlsaProvenanceV1_BuildDefinition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoSlsaProvenanceV1_ResourceDescriptor); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoSlsaProvenanceV1_RunDetails); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoSlsaProvenanceV1_ProvenanceBuilder); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_intoto_statement_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*InTotoSlsaProvenanceV1_BuildMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_proto_v1_intoto_statement_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*InTotoStatement_Provenance)(nil),
		(*InTotoStatement_SlsaProvenance)(nil),
		(*InTotoStatement_SlsaProvenanceZeroTwo)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_proto_v1_intoto_statement_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_proto_v1_intoto_statement_proto_goTypes,
		DependencyIndexes: file_proto_v1_intoto_statement_proto_depIdxs,
		MessageInfos:      file_proto_v1_intoto_statement_proto_msgTypes,
	}.Build()
	File_proto_v1_intoto_statement_proto = out.File
	file_proto_v1_intoto_statement_proto_rawDesc = nil
	file_proto_v1_intoto_statement_proto_goTypes = nil
	file_proto_v1_intoto_statement_proto_depIdxs = nil
}
