// Copyright 2023 The Grafeas Authors. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.27.1
// 	protoc        v3.13.0
// source: proto/v1/sbom.proto

package grafeas_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The note representing an SBOM reference.
type SBOMReferenceNote struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The format that SBOM takes. E.g. may be spdx, cyclonedx, etc...
	Format string `protobuf:"bytes,1,opt,name=format,proto3" json:"format,omitempty"`
	// The version of the format that the SBOM takes. E.g. if the format
	// is spdx, the version may be 2.3.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SBOMReferenceNote) Reset() {
	*x = SBOMReferenceNote{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_sbom_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SBOMReferenceNote) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SBOMReferenceNote) ProtoMessage() {}

func (x *SBOMReferenceNote) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_sbom_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SBOMReferenceNote.ProtoReflect.Descriptor instead.
func (*SBOMReferenceNote) Descriptor() ([]byte, []int) {
	return file_proto_v1_sbom_proto_rawDescGZIP(), []int{0}
}

func (x *SBOMReferenceNote) GetFormat() string {
	if x != nil {
		return x.Format
	}
	return ""
}

func (x *SBOMReferenceNote) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// The occurrence representing an SBOM reference as applied to a specific
// resource. The occurrence follows the DSSE specification. See
// https://github.com/secure-systems-lab/dsse/blob/master/envelope.md for more
// details.
type SBOMReferenceOccurrence struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The actual payload that contains the SBOM reference data.
	Payload *SbomReferenceIntotoPayload `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// The kind of payload that SbomReferenceIntotoPayload takes. Since it's in
	// the intoto format, this value is expected to be
	// 'application/vnd.in-toto+json'.
	PayloadType string `protobuf:"bytes,2,opt,name=payload_type,json=payloadType,proto3" json:"payload_type,omitempty"`
	// The signatures over the payload.
	Signatures []*EnvelopeSignature `protobuf:"bytes,3,rep,name=signatures,proto3" json:"signatures,omitempty"`
}

func (x *SBOMReferenceOccurrence) Reset() {
	*x = SBOMReferenceOccurrence{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_sbom_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SBOMReferenceOccurrence) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SBOMReferenceOccurrence) ProtoMessage() {}

func (x *SBOMReferenceOccurrence) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_sbom_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SBOMReferenceOccurrence.ProtoReflect.Descriptor instead.
func (*SBOMReferenceOccurrence) Descriptor() ([]byte, []int) {
	return file_proto_v1_sbom_proto_rawDescGZIP(), []int{1}
}

func (x *SBOMReferenceOccurrence) GetPayload() *SbomReferenceIntotoPayload {
	if x != nil {
		return x.Payload
	}
	return nil
}

func (x *SBOMReferenceOccurrence) GetPayloadType() string {
	if x != nil {
		return x.PayloadType
	}
	return ""
}

func (x *SBOMReferenceOccurrence) GetSignatures() []*EnvelopeSignature {
	if x != nil {
		return x.Signatures
	}
	return nil
}

// The actual payload that contains the SBOM Reference data.
// The payload follows the intoto statement specification. See
// https://github.com/in-toto/attestation/blob/main/spec/v1.0/statement.md
// for more details.
type SbomReferenceIntotoPayload struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier for the schema of the Statement.
	Type string `protobuf:"bytes,1,opt,name=type,json=_type,proto3" json:"type,omitempty"`
	// URI identifying the type of the Predicate.
	PredicateType string `protobuf:"bytes,2,opt,name=predicate_type,json=predicateType,proto3" json:"predicate_type,omitempty"`
	// Set of software artifacts that the attestation applies to. Each element
	// represents a single software artifact.
	Subject []*Subject `protobuf:"bytes,3,rep,name=subject,proto3" json:"subject,omitempty"`
	// Additional parameters of the Predicate. Includes the actual data about the
	// SBOM.
	Predicate *SbomReferenceIntotoPredicate `protobuf:"bytes,4,opt,name=predicate,proto3" json:"predicate,omitempty"`
}

func (x *SbomReferenceIntotoPayload) Reset() {
	*x = SbomReferenceIntotoPayload{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_sbom_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SbomReferenceIntotoPayload) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SbomReferenceIntotoPayload) ProtoMessage() {}

func (x *SbomReferenceIntotoPayload) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_sbom_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SbomReferenceIntotoPayload.ProtoReflect.Descriptor instead.
func (*SbomReferenceIntotoPayload) Descriptor() ([]byte, []int) {
	return file_proto_v1_sbom_proto_rawDescGZIP(), []int{2}
}

func (x *SbomReferenceIntotoPayload) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

func (x *SbomReferenceIntotoPayload) GetPredicateType() string {
	if x != nil {
		return x.PredicateType
	}
	return ""
}

func (x *SbomReferenceIntotoPayload) GetSubject() []*Subject {
	if x != nil {
		return x.Subject
	}
	return nil
}

func (x *SbomReferenceIntotoPayload) GetPredicate() *SbomReferenceIntotoPredicate {
	if x != nil {
		return x.Predicate
	}
	return nil
}

// A predicate which describes the SBOM being referenced.
type SbomReferenceIntotoPredicate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The person or system referring this predicate to the consumer.
	ReferrerId string `protobuf:"bytes,1,opt,name=referrer_id,json=referrerId,proto3" json:"referrer_id,omitempty"`
	// The location of the SBOM.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// The mime type of the SBOM.
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// A map of algorithm to digest of the contents of the SBOM.
	Digest map[string]string `protobuf:"bytes,4,rep,name=digest,proto3" json:"digest,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *SbomReferenceIntotoPredicate) Reset() {
	*x = SbomReferenceIntotoPredicate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_proto_v1_sbom_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SbomReferenceIntotoPredicate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SbomReferenceIntotoPredicate) ProtoMessage() {}

func (x *SbomReferenceIntotoPredicate) ProtoReflect() protoreflect.Message {
	mi := &file_proto_v1_sbom_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SbomReferenceIntotoPredicate.ProtoReflect.Descriptor instead.
func (*SbomReferenceIntotoPredicate) Descriptor() ([]byte, []int) {
	return file_proto_v1_sbom_proto_rawDescGZIP(), []int{3}
}

func (x *SbomReferenceIntotoPredicate) GetReferrerId() string {
	if x != nil {
		return x.ReferrerId
	}
	return ""
}

func (x *SbomReferenceIntotoPredicate) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *SbomReferenceIntotoPredicate) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *SbomReferenceIntotoPredicate) GetDigest() map[string]string {
	if x != nil {
		return x.Digest
	}
	return nil
}

var File_proto_v1_sbom_proto protoreflect.FileDescriptor

var file_proto_v1_sbom_proto_rawDesc = []byte{
	0x0a, 0x13, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x62, 0x6f, 0x6d, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76,
	0x31, 0x1a, 0x15, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f,
	0x76, 0x31, 0x2f, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x45, 0x0a, 0x11, 0x53, 0x42, 0x4f,
	0x4d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x6f, 0x74, 0x65, 0x12, 0x16,
	0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x22, 0xbd, 0x01, 0x0a, 0x17, 0x53, 0x42, 0x4f, 0x4d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x4f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x40, 0x0a, 0x07,
	0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x26, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x62, 0x6f, 0x6d, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x50, 0x61,
	0x79, 0x6c, 0x6f, 0x61, 0x64, 0x52, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12, 0x21,
	0x0a, 0x0c, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x3d, 0x0a, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x45, 0x6e, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x52, 0x0a, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73,
	0x22, 0xcf, 0x01, 0x0a, 0x1a, 0x53, 0x62, 0x6f, 0x6d, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x49, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x12,
	0x13, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x2d, 0x0a, 0x07, 0x73,
	0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x75, 0x62, 0x6a, 0x65, 0x63,
	0x74, 0x52, 0x07, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x12, 0x46, 0x0a, 0x09, 0x70, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x62, 0x6f, 0x6d, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x52, 0x09, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x61,
	0x74, 0x65, 0x22, 0x81, 0x02, 0x0a, 0x1c, 0x53, 0x62, 0x6f, 0x6d, 0x52, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x50, 0x72, 0x65, 0x64, 0x69, 0x63,
	0x61, 0x74, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x72, 0x5f,
	0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72,
	0x65, 0x72, 0x49, 0x64, 0x12, 0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x4c, 0x0a,
	0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e,
	0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x62, 0x6f, 0x6d, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x49, 0x6e, 0x74, 0x6f, 0x74, 0x6f, 0x50, 0x72,
	0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x2e, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x06, 0x64, 0x69, 0x67, 0x65, 0x73, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x44,
	0x69, 0x67, 0x65, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x4d, 0x0a, 0x0d, 0x69, 0x6f, 0x2e, 0x67, 0x72, 0x61,
	0x66, 0x65, 0x61, 0x73, 0x2e, 0x76, 0x31, 0x50, 0x01, 0x5a, 0x34, 0x67, 0x69, 0x74, 0x68, 0x75,
	0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x67, 0x72,
	0x61, 0x66, 0x65, 0x61, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x76, 0x31, 0x2f, 0x67,
	0x72, 0x61, 0x66, 0x65, 0x61, 0x73, 0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0xa2,
	0x02, 0x03, 0x47, 0x52, 0x41, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_proto_v1_sbom_proto_rawDescOnce sync.Once
	file_proto_v1_sbom_proto_rawDescData = file_proto_v1_sbom_proto_rawDesc
)

func file_proto_v1_sbom_proto_rawDescGZIP() []byte {
	file_proto_v1_sbom_proto_rawDescOnce.Do(func() {
		file_proto_v1_sbom_proto_rawDescData = protoimpl.X.CompressGZIP(file_proto_v1_sbom_proto_rawDescData)
	})
	return file_proto_v1_sbom_proto_rawDescData
}

var file_proto_v1_sbom_proto_msgTypes = make([]protoimpl.MessageInfo, 5)
var file_proto_v1_sbom_proto_goTypes = []interface{}{
	(*SBOMReferenceNote)(nil),            // 0: grafeas.v1.SBOMReferenceNote
	(*SBOMReferenceOccurrence)(nil),      // 1: grafeas.v1.SBOMReferenceOccurrence
	(*SbomReferenceIntotoPayload)(nil),   // 2: grafeas.v1.SbomReferenceIntotoPayload
	(*SbomReferenceIntotoPredicate)(nil), // 3: grafeas.v1.SbomReferenceIntotoPredicate
	nil,                                  // 4: grafeas.v1.SbomReferenceIntotoPredicate.DigestEntry
	(*EnvelopeSignature)(nil),            // 5: grafeas.v1.EnvelopeSignature
	(*Subject)(nil),                      // 6: grafeas.v1.Subject
}
var file_proto_v1_sbom_proto_depIdxs = []int32{
	2, // 0: grafeas.v1.SBOMReferenceOccurrence.payload:type_name -> grafeas.v1.SbomReferenceIntotoPayload
	5, // 1: grafeas.v1.SBOMReferenceOccurrence.signatures:type_name -> grafeas.v1.EnvelopeSignature
	6, // 2: grafeas.v1.SbomReferenceIntotoPayload.subject:type_name -> grafeas.v1.Subject
	3, // 3: grafeas.v1.SbomReferenceIntotoPayload.predicate:type_name -> grafeas.v1.SbomReferenceIntotoPredicate
	4, // 4: grafeas.v1.SbomReferenceIntotoPredicate.digest:type_name -> grafeas.v1.SbomReferenceIntotoPredicate.DigestEntry
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_proto_v1_sbom_proto_init() }
func file_proto_v1_sbom_proto_init() {
	if File_proto_v1_sbom_proto != nil {
		return
	}
	file_proto_v1_common_proto_init()
	file_proto_v1_intoto_statement_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_proto_v1_sbom_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SBOMReferenceNote); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_sbom_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SBOMReferenceOccurrence); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_sbom_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SbomReferenceIntotoPayload); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_proto_v1_sbom_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SbomReferenceIntotoPredicate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_proto_v1_sbom_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   5,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_proto_v1_sbom_proto_goTypes,
		DependencyIndexes: file_proto_v1_sbom_proto_depIdxs,
		MessageInfos:      file_proto_v1_sbom_proto_msgTypes,
	}.Build()
	File_proto_v1_sbom_proto = out.File
	file_proto_v1_sbom_proto_rawDesc = nil
	file_proto_v1_sbom_proto_goTypes = nil
	file_proto_v1_sbom_proto_depIdxs = nil
}
