// Copyright 2024 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package apigee provides access to the Apigee API.
//
// For product documentation, see: https://cloud.google.com/apigee-api-management/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/apigee/v1"
//	...
//	ctx := context.Background()
//	apigeeService, err := apigee.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	apigeeService, err := apigee.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	apigeeService, err := apigee.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package apigee // import "google.golang.org/api/apigee/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version

const apiId = "apigee:v1"
const apiName = "apigee"
const apiVersion = "v1"
const basePath = "https://apigee.googleapis.com/"
const basePathTemplate = "https://apigee.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://apigee.mtls.googleapis.com/"
const defaultUniverseDomain = "googleapis.com"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.WithDefaultUniverseDomain(defaultUniverseDomain))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Hybrid = NewHybridService(s)
	s.Organizations = NewOrganizationsService(s)
	s.Projects = NewProjectsService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Hybrid *HybridService

	Organizations *OrganizationsService

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewHybridService(s *Service) *HybridService {
	rs := &HybridService{s: s}
	rs.Issuers = NewHybridIssuersService(s)
	return rs
}

type HybridService struct {
	s *Service

	Issuers *HybridIssuersService
}

func NewHybridIssuersService(s *Service) *HybridIssuersService {
	rs := &HybridIssuersService{s: s}
	return rs
}

type HybridIssuersService struct {
	s *Service
}

func NewOrganizationsService(s *Service) *OrganizationsService {
	rs := &OrganizationsService{s: s}
	rs.Analytics = NewOrganizationsAnalyticsService(s)
	rs.Apiproducts = NewOrganizationsApiproductsService(s)
	rs.Apis = NewOrganizationsApisService(s)
	rs.Appgroups = NewOrganizationsAppgroupsService(s)
	rs.Apps = NewOrganizationsAppsService(s)
	rs.Datacollectors = NewOrganizationsDatacollectorsService(s)
	rs.Deployments = NewOrganizationsDeploymentsService(s)
	rs.Developers = NewOrganizationsDevelopersService(s)
	rs.EndpointAttachments = NewOrganizationsEndpointAttachmentsService(s)
	rs.Envgroups = NewOrganizationsEnvgroupsService(s)
	rs.Environments = NewOrganizationsEnvironmentsService(s)
	rs.HostQueries = NewOrganizationsHostQueriesService(s)
	rs.HostSecurityReports = NewOrganizationsHostSecurityReportsService(s)
	rs.HostStats = NewOrganizationsHostStatsService(s)
	rs.Instances = NewOrganizationsInstancesService(s)
	rs.Keyvaluemaps = NewOrganizationsKeyvaluemapsService(s)
	rs.Operations = NewOrganizationsOperationsService(s)
	rs.OptimizedHostStats = NewOrganizationsOptimizedHostStatsService(s)
	rs.Reports = NewOrganizationsReportsService(s)
	rs.SecurityProfiles = NewOrganizationsSecurityProfilesService(s)
	rs.Sharedflows = NewOrganizationsSharedflowsService(s)
	rs.Sites = NewOrganizationsSitesService(s)
	return rs
}

type OrganizationsService struct {
	s *Service

	Analytics *OrganizationsAnalyticsService

	Apiproducts *OrganizationsApiproductsService

	Apis *OrganizationsApisService

	Appgroups *OrganizationsAppgroupsService

	Apps *OrganizationsAppsService

	Datacollectors *OrganizationsDatacollectorsService

	Deployments *OrganizationsDeploymentsService

	Developers *OrganizationsDevelopersService

	EndpointAttachments *OrganizationsEndpointAttachmentsService

	Envgroups *OrganizationsEnvgroupsService

	Environments *OrganizationsEnvironmentsService

	HostQueries *OrganizationsHostQueriesService

	HostSecurityReports *OrganizationsHostSecurityReportsService

	HostStats *OrganizationsHostStatsService

	Instances *OrganizationsInstancesService

	Keyvaluemaps *OrganizationsKeyvaluemapsService

	Operations *OrganizationsOperationsService

	OptimizedHostStats *OrganizationsOptimizedHostStatsService

	Reports *OrganizationsReportsService

	SecurityProfiles *OrganizationsSecurityProfilesService

	Sharedflows *OrganizationsSharedflowsService

	Sites *OrganizationsSitesService
}

func NewOrganizationsAnalyticsService(s *Service) *OrganizationsAnalyticsService {
	rs := &OrganizationsAnalyticsService{s: s}
	rs.Datastores = NewOrganizationsAnalyticsDatastoresService(s)
	return rs
}

type OrganizationsAnalyticsService struct {
	s *Service

	Datastores *OrganizationsAnalyticsDatastoresService
}

func NewOrganizationsAnalyticsDatastoresService(s *Service) *OrganizationsAnalyticsDatastoresService {
	rs := &OrganizationsAnalyticsDatastoresService{s: s}
	return rs
}

type OrganizationsAnalyticsDatastoresService struct {
	s *Service
}

func NewOrganizationsApiproductsService(s *Service) *OrganizationsApiproductsService {
	rs := &OrganizationsApiproductsService{s: s}
	rs.Attributes_ = NewOrganizationsApiproductsAttributesService(s)
	rs.Rateplans = NewOrganizationsApiproductsRateplansService(s)
	return rs
}

type OrganizationsApiproductsService struct {
	s *Service

	Attributes_ *OrganizationsApiproductsAttributesService

	Rateplans *OrganizationsApiproductsRateplansService
}

func NewOrganizationsApiproductsAttributesService(s *Service) *OrganizationsApiproductsAttributesService {
	rs := &OrganizationsApiproductsAttributesService{s: s}
	return rs
}

type OrganizationsApiproductsAttributesService struct {
	s *Service
}

func NewOrganizationsApiproductsRateplansService(s *Service) *OrganizationsApiproductsRateplansService {
	rs := &OrganizationsApiproductsRateplansService{s: s}
	return rs
}

type OrganizationsApiproductsRateplansService struct {
	s *Service
}

func NewOrganizationsApisService(s *Service) *OrganizationsApisService {
	rs := &OrganizationsApisService{s: s}
	rs.Deployments = NewOrganizationsApisDeploymentsService(s)
	rs.Keyvaluemaps = NewOrganizationsApisKeyvaluemapsService(s)
	rs.Revisions = NewOrganizationsApisRevisionsService(s)
	return rs
}

type OrganizationsApisService struct {
	s *Service

	Deployments *OrganizationsApisDeploymentsService

	Keyvaluemaps *OrganizationsApisKeyvaluemapsService

	Revisions *OrganizationsApisRevisionsService
}

func NewOrganizationsApisDeploymentsService(s *Service) *OrganizationsApisDeploymentsService {
	rs := &OrganizationsApisDeploymentsService{s: s}
	return rs
}

type OrganizationsApisDeploymentsService struct {
	s *Service
}

func NewOrganizationsApisKeyvaluemapsService(s *Service) *OrganizationsApisKeyvaluemapsService {
	rs := &OrganizationsApisKeyvaluemapsService{s: s}
	rs.Entries = NewOrganizationsApisKeyvaluemapsEntriesService(s)
	return rs
}

type OrganizationsApisKeyvaluemapsService struct {
	s *Service

	Entries *OrganizationsApisKeyvaluemapsEntriesService
}

func NewOrganizationsApisKeyvaluemapsEntriesService(s *Service) *OrganizationsApisKeyvaluemapsEntriesService {
	rs := &OrganizationsApisKeyvaluemapsEntriesService{s: s}
	return rs
}

type OrganizationsApisKeyvaluemapsEntriesService struct {
	s *Service
}

func NewOrganizationsApisRevisionsService(s *Service) *OrganizationsApisRevisionsService {
	rs := &OrganizationsApisRevisionsService{s: s}
	rs.Deployments = NewOrganizationsApisRevisionsDeploymentsService(s)
	return rs
}

type OrganizationsApisRevisionsService struct {
	s *Service

	Deployments *OrganizationsApisRevisionsDeploymentsService
}

func NewOrganizationsApisRevisionsDeploymentsService(s *Service) *OrganizationsApisRevisionsDeploymentsService {
	rs := &OrganizationsApisRevisionsDeploymentsService{s: s}
	return rs
}

type OrganizationsApisRevisionsDeploymentsService struct {
	s *Service
}

func NewOrganizationsAppgroupsService(s *Service) *OrganizationsAppgroupsService {
	rs := &OrganizationsAppgroupsService{s: s}
	rs.Apps = NewOrganizationsAppgroupsAppsService(s)
	return rs
}

type OrganizationsAppgroupsService struct {
	s *Service

	Apps *OrganizationsAppgroupsAppsService
}

func NewOrganizationsAppgroupsAppsService(s *Service) *OrganizationsAppgroupsAppsService {
	rs := &OrganizationsAppgroupsAppsService{s: s}
	rs.Keys = NewOrganizationsAppgroupsAppsKeysService(s)
	return rs
}

type OrganizationsAppgroupsAppsService struct {
	s *Service

	Keys *OrganizationsAppgroupsAppsKeysService
}

func NewOrganizationsAppgroupsAppsKeysService(s *Service) *OrganizationsAppgroupsAppsKeysService {
	rs := &OrganizationsAppgroupsAppsKeysService{s: s}
	rs.Apiproducts = NewOrganizationsAppgroupsAppsKeysApiproductsService(s)
	return rs
}

type OrganizationsAppgroupsAppsKeysService struct {
	s *Service

	Apiproducts *OrganizationsAppgroupsAppsKeysApiproductsService
}

func NewOrganizationsAppgroupsAppsKeysApiproductsService(s *Service) *OrganizationsAppgroupsAppsKeysApiproductsService {
	rs := &OrganizationsAppgroupsAppsKeysApiproductsService{s: s}
	return rs
}

type OrganizationsAppgroupsAppsKeysApiproductsService struct {
	s *Service
}

func NewOrganizationsAppsService(s *Service) *OrganizationsAppsService {
	rs := &OrganizationsAppsService{s: s}
	return rs
}

type OrganizationsAppsService struct {
	s *Service
}

func NewOrganizationsDatacollectorsService(s *Service) *OrganizationsDatacollectorsService {
	rs := &OrganizationsDatacollectorsService{s: s}
	return rs
}

type OrganizationsDatacollectorsService struct {
	s *Service
}

func NewOrganizationsDeploymentsService(s *Service) *OrganizationsDeploymentsService {
	rs := &OrganizationsDeploymentsService{s: s}
	return rs
}

type OrganizationsDeploymentsService struct {
	s *Service
}

func NewOrganizationsDevelopersService(s *Service) *OrganizationsDevelopersService {
	rs := &OrganizationsDevelopersService{s: s}
	rs.Apps = NewOrganizationsDevelopersAppsService(s)
	rs.Attributes_ = NewOrganizationsDevelopersAttributesService(s)
	rs.Balance = NewOrganizationsDevelopersBalanceService(s)
	rs.Subscriptions = NewOrganizationsDevelopersSubscriptionsService(s)
	return rs
}

type OrganizationsDevelopersService struct {
	s *Service

	Apps *OrganizationsDevelopersAppsService

	Attributes_ *OrganizationsDevelopersAttributesService

	Balance *OrganizationsDevelopersBalanceService

	Subscriptions *OrganizationsDevelopersSubscriptionsService
}

func NewOrganizationsDevelopersAppsService(s *Service) *OrganizationsDevelopersAppsService {
	rs := &OrganizationsDevelopersAppsService{s: s}
	rs.Attributes_ = NewOrganizationsDevelopersAppsAttributesService(s)
	rs.Keys = NewOrganizationsDevelopersAppsKeysService(s)
	return rs
}

type OrganizationsDevelopersAppsService struct {
	s *Service

	Attributes_ *OrganizationsDevelopersAppsAttributesService

	Keys *OrganizationsDevelopersAppsKeysService
}

func NewOrganizationsDevelopersAppsAttributesService(s *Service) *OrganizationsDevelopersAppsAttributesService {
	rs := &OrganizationsDevelopersAppsAttributesService{s: s}
	return rs
}

type OrganizationsDevelopersAppsAttributesService struct {
	s *Service
}

func NewOrganizationsDevelopersAppsKeysService(s *Service) *OrganizationsDevelopersAppsKeysService {
	rs := &OrganizationsDevelopersAppsKeysService{s: s}
	rs.Apiproducts = NewOrganizationsDevelopersAppsKeysApiproductsService(s)
	rs.Create_ = NewOrganizationsDevelopersAppsKeysCreateService(s)
	return rs
}

type OrganizationsDevelopersAppsKeysService struct {
	s *Service

	Apiproducts *OrganizationsDevelopersAppsKeysApiproductsService

	Create_ *OrganizationsDevelopersAppsKeysCreateService
}

func NewOrganizationsDevelopersAppsKeysApiproductsService(s *Service) *OrganizationsDevelopersAppsKeysApiproductsService {
	rs := &OrganizationsDevelopersAppsKeysApiproductsService{s: s}
	return rs
}

type OrganizationsDevelopersAppsKeysApiproductsService struct {
	s *Service
}

func NewOrganizationsDevelopersAppsKeysCreateService(s *Service) *OrganizationsDevelopersAppsKeysCreateService {
	rs := &OrganizationsDevelopersAppsKeysCreateService{s: s}
	return rs
}

type OrganizationsDevelopersAppsKeysCreateService struct {
	s *Service
}

func NewOrganizationsDevelopersAttributesService(s *Service) *OrganizationsDevelopersAttributesService {
	rs := &OrganizationsDevelopersAttributesService{s: s}
	return rs
}

type OrganizationsDevelopersAttributesService struct {
	s *Service
}

func NewOrganizationsDevelopersBalanceService(s *Service) *OrganizationsDevelopersBalanceService {
	rs := &OrganizationsDevelopersBalanceService{s: s}
	return rs
}

type OrganizationsDevelopersBalanceService struct {
	s *Service
}

func NewOrganizationsDevelopersSubscriptionsService(s *Service) *OrganizationsDevelopersSubscriptionsService {
	rs := &OrganizationsDevelopersSubscriptionsService{s: s}
	return rs
}

type OrganizationsDevelopersSubscriptionsService struct {
	s *Service
}

func NewOrganizationsEndpointAttachmentsService(s *Service) *OrganizationsEndpointAttachmentsService {
	rs := &OrganizationsEndpointAttachmentsService{s: s}
	return rs
}

type OrganizationsEndpointAttachmentsService struct {
	s *Service
}

func NewOrganizationsEnvgroupsService(s *Service) *OrganizationsEnvgroupsService {
	rs := &OrganizationsEnvgroupsService{s: s}
	rs.Attachments = NewOrganizationsEnvgroupsAttachmentsService(s)
	return rs
}

type OrganizationsEnvgroupsService struct {
	s *Service

	Attachments *OrganizationsEnvgroupsAttachmentsService
}

func NewOrganizationsEnvgroupsAttachmentsService(s *Service) *OrganizationsEnvgroupsAttachmentsService {
	rs := &OrganizationsEnvgroupsAttachmentsService{s: s}
	return rs
}

type OrganizationsEnvgroupsAttachmentsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsService(s *Service) *OrganizationsEnvironmentsService {
	rs := &OrganizationsEnvironmentsService{s: s}
	rs.AddonsConfig = NewOrganizationsEnvironmentsAddonsConfigService(s)
	rs.Analytics = NewOrganizationsEnvironmentsAnalyticsService(s)
	rs.Apis = NewOrganizationsEnvironmentsApisService(s)
	rs.ArchiveDeployments = NewOrganizationsEnvironmentsArchiveDeploymentsService(s)
	rs.Caches = NewOrganizationsEnvironmentsCachesService(s)
	rs.Deployments = NewOrganizationsEnvironmentsDeploymentsService(s)
	rs.Flowhooks = NewOrganizationsEnvironmentsFlowhooksService(s)
	rs.Keystores = NewOrganizationsEnvironmentsKeystoresService(s)
	rs.Keyvaluemaps = NewOrganizationsEnvironmentsKeyvaluemapsService(s)
	rs.OptimizedStats = NewOrganizationsEnvironmentsOptimizedStatsService(s)
	rs.Queries = NewOrganizationsEnvironmentsQueriesService(s)
	rs.References = NewOrganizationsEnvironmentsReferencesService(s)
	rs.Resourcefiles = NewOrganizationsEnvironmentsResourcefilesService(s)
	rs.SecurityActions = NewOrganizationsEnvironmentsSecurityActionsService(s)
	rs.SecurityIncidents = NewOrganizationsEnvironmentsSecurityIncidentsService(s)
	rs.SecurityReports = NewOrganizationsEnvironmentsSecurityReportsService(s)
	rs.SecurityStats = NewOrganizationsEnvironmentsSecurityStatsService(s)
	rs.Sharedflows = NewOrganizationsEnvironmentsSharedflowsService(s)
	rs.Stats = NewOrganizationsEnvironmentsStatsService(s)
	rs.Targetservers = NewOrganizationsEnvironmentsTargetserversService(s)
	rs.TraceConfig = NewOrganizationsEnvironmentsTraceConfigService(s)
	return rs
}

type OrganizationsEnvironmentsService struct {
	s *Service

	AddonsConfig *OrganizationsEnvironmentsAddonsConfigService

	Analytics *OrganizationsEnvironmentsAnalyticsService

	Apis *OrganizationsEnvironmentsApisService

	ArchiveDeployments *OrganizationsEnvironmentsArchiveDeploymentsService

	Caches *OrganizationsEnvironmentsCachesService

	Deployments *OrganizationsEnvironmentsDeploymentsService

	Flowhooks *OrganizationsEnvironmentsFlowhooksService

	Keystores *OrganizationsEnvironmentsKeystoresService

	Keyvaluemaps *OrganizationsEnvironmentsKeyvaluemapsService

	OptimizedStats *OrganizationsEnvironmentsOptimizedStatsService

	Queries *OrganizationsEnvironmentsQueriesService

	References *OrganizationsEnvironmentsReferencesService

	Resourcefiles *OrganizationsEnvironmentsResourcefilesService

	SecurityActions *OrganizationsEnvironmentsSecurityActionsService

	SecurityIncidents *OrganizationsEnvironmentsSecurityIncidentsService

	SecurityReports *OrganizationsEnvironmentsSecurityReportsService

	SecurityStats *OrganizationsEnvironmentsSecurityStatsService

	Sharedflows *OrganizationsEnvironmentsSharedflowsService

	Stats *OrganizationsEnvironmentsStatsService

	Targetservers *OrganizationsEnvironmentsTargetserversService

	TraceConfig *OrganizationsEnvironmentsTraceConfigService
}

func NewOrganizationsEnvironmentsAddonsConfigService(s *Service) *OrganizationsEnvironmentsAddonsConfigService {
	rs := &OrganizationsEnvironmentsAddonsConfigService{s: s}
	return rs
}

type OrganizationsEnvironmentsAddonsConfigService struct {
	s *Service
}

func NewOrganizationsEnvironmentsAnalyticsService(s *Service) *OrganizationsEnvironmentsAnalyticsService {
	rs := &OrganizationsEnvironmentsAnalyticsService{s: s}
	rs.Admin = NewOrganizationsEnvironmentsAnalyticsAdminService(s)
	rs.Exports = NewOrganizationsEnvironmentsAnalyticsExportsService(s)
	return rs
}

type OrganizationsEnvironmentsAnalyticsService struct {
	s *Service

	Admin *OrganizationsEnvironmentsAnalyticsAdminService

	Exports *OrganizationsEnvironmentsAnalyticsExportsService
}

func NewOrganizationsEnvironmentsAnalyticsAdminService(s *Service) *OrganizationsEnvironmentsAnalyticsAdminService {
	rs := &OrganizationsEnvironmentsAnalyticsAdminService{s: s}
	return rs
}

type OrganizationsEnvironmentsAnalyticsAdminService struct {
	s *Service
}

func NewOrganizationsEnvironmentsAnalyticsExportsService(s *Service) *OrganizationsEnvironmentsAnalyticsExportsService {
	rs := &OrganizationsEnvironmentsAnalyticsExportsService{s: s}
	return rs
}

type OrganizationsEnvironmentsAnalyticsExportsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsApisService(s *Service) *OrganizationsEnvironmentsApisService {
	rs := &OrganizationsEnvironmentsApisService{s: s}
	rs.Deployments = NewOrganizationsEnvironmentsApisDeploymentsService(s)
	rs.Revisions = NewOrganizationsEnvironmentsApisRevisionsService(s)
	return rs
}

type OrganizationsEnvironmentsApisService struct {
	s *Service

	Deployments *OrganizationsEnvironmentsApisDeploymentsService

	Revisions *OrganizationsEnvironmentsApisRevisionsService
}

func NewOrganizationsEnvironmentsApisDeploymentsService(s *Service) *OrganizationsEnvironmentsApisDeploymentsService {
	rs := &OrganizationsEnvironmentsApisDeploymentsService{s: s}
	return rs
}

type OrganizationsEnvironmentsApisDeploymentsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsApisRevisionsService(s *Service) *OrganizationsEnvironmentsApisRevisionsService {
	rs := &OrganizationsEnvironmentsApisRevisionsService{s: s}
	rs.Debugsessions = NewOrganizationsEnvironmentsApisRevisionsDebugsessionsService(s)
	rs.Deployments = NewOrganizationsEnvironmentsApisRevisionsDeploymentsService(s)
	return rs
}

type OrganizationsEnvironmentsApisRevisionsService struct {
	s *Service

	Debugsessions *OrganizationsEnvironmentsApisRevisionsDebugsessionsService

	Deployments *OrganizationsEnvironmentsApisRevisionsDeploymentsService
}

func NewOrganizationsEnvironmentsApisRevisionsDebugsessionsService(s *Service) *OrganizationsEnvironmentsApisRevisionsDebugsessionsService {
	rs := &OrganizationsEnvironmentsApisRevisionsDebugsessionsService{s: s}
	rs.Data = NewOrganizationsEnvironmentsApisRevisionsDebugsessionsDataService(s)
	return rs
}

type OrganizationsEnvironmentsApisRevisionsDebugsessionsService struct {
	s *Service

	Data *OrganizationsEnvironmentsApisRevisionsDebugsessionsDataService
}

func NewOrganizationsEnvironmentsApisRevisionsDebugsessionsDataService(s *Service) *OrganizationsEnvironmentsApisRevisionsDebugsessionsDataService {
	rs := &OrganizationsEnvironmentsApisRevisionsDebugsessionsDataService{s: s}
	return rs
}

type OrganizationsEnvironmentsApisRevisionsDebugsessionsDataService struct {
	s *Service
}

func NewOrganizationsEnvironmentsApisRevisionsDeploymentsService(s *Service) *OrganizationsEnvironmentsApisRevisionsDeploymentsService {
	rs := &OrganizationsEnvironmentsApisRevisionsDeploymentsService{s: s}
	return rs
}

type OrganizationsEnvironmentsApisRevisionsDeploymentsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsArchiveDeploymentsService(s *Service) *OrganizationsEnvironmentsArchiveDeploymentsService {
	rs := &OrganizationsEnvironmentsArchiveDeploymentsService{s: s}
	return rs
}

type OrganizationsEnvironmentsArchiveDeploymentsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsCachesService(s *Service) *OrganizationsEnvironmentsCachesService {
	rs := &OrganizationsEnvironmentsCachesService{s: s}
	return rs
}

type OrganizationsEnvironmentsCachesService struct {
	s *Service
}

func NewOrganizationsEnvironmentsDeploymentsService(s *Service) *OrganizationsEnvironmentsDeploymentsService {
	rs := &OrganizationsEnvironmentsDeploymentsService{s: s}
	return rs
}

type OrganizationsEnvironmentsDeploymentsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsFlowhooksService(s *Service) *OrganizationsEnvironmentsFlowhooksService {
	rs := &OrganizationsEnvironmentsFlowhooksService{s: s}
	return rs
}

type OrganizationsEnvironmentsFlowhooksService struct {
	s *Service
}

func NewOrganizationsEnvironmentsKeystoresService(s *Service) *OrganizationsEnvironmentsKeystoresService {
	rs := &OrganizationsEnvironmentsKeystoresService{s: s}
	rs.Aliases = NewOrganizationsEnvironmentsKeystoresAliasesService(s)
	return rs
}

type OrganizationsEnvironmentsKeystoresService struct {
	s *Service

	Aliases *OrganizationsEnvironmentsKeystoresAliasesService
}

func NewOrganizationsEnvironmentsKeystoresAliasesService(s *Service) *OrganizationsEnvironmentsKeystoresAliasesService {
	rs := &OrganizationsEnvironmentsKeystoresAliasesService{s: s}
	return rs
}

type OrganizationsEnvironmentsKeystoresAliasesService struct {
	s *Service
}

func NewOrganizationsEnvironmentsKeyvaluemapsService(s *Service) *OrganizationsEnvironmentsKeyvaluemapsService {
	rs := &OrganizationsEnvironmentsKeyvaluemapsService{s: s}
	rs.Entries = NewOrganizationsEnvironmentsKeyvaluemapsEntriesService(s)
	return rs
}

type OrganizationsEnvironmentsKeyvaluemapsService struct {
	s *Service

	Entries *OrganizationsEnvironmentsKeyvaluemapsEntriesService
}

func NewOrganizationsEnvironmentsKeyvaluemapsEntriesService(s *Service) *OrganizationsEnvironmentsKeyvaluemapsEntriesService {
	rs := &OrganizationsEnvironmentsKeyvaluemapsEntriesService{s: s}
	return rs
}

type OrganizationsEnvironmentsKeyvaluemapsEntriesService struct {
	s *Service
}

func NewOrganizationsEnvironmentsOptimizedStatsService(s *Service) *OrganizationsEnvironmentsOptimizedStatsService {
	rs := &OrganizationsEnvironmentsOptimizedStatsService{s: s}
	return rs
}

type OrganizationsEnvironmentsOptimizedStatsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsQueriesService(s *Service) *OrganizationsEnvironmentsQueriesService {
	rs := &OrganizationsEnvironmentsQueriesService{s: s}
	return rs
}

type OrganizationsEnvironmentsQueriesService struct {
	s *Service
}

func NewOrganizationsEnvironmentsReferencesService(s *Service) *OrganizationsEnvironmentsReferencesService {
	rs := &OrganizationsEnvironmentsReferencesService{s: s}
	return rs
}

type OrganizationsEnvironmentsReferencesService struct {
	s *Service
}

func NewOrganizationsEnvironmentsResourcefilesService(s *Service) *OrganizationsEnvironmentsResourcefilesService {
	rs := &OrganizationsEnvironmentsResourcefilesService{s: s}
	return rs
}

type OrganizationsEnvironmentsResourcefilesService struct {
	s *Service
}

func NewOrganizationsEnvironmentsSecurityActionsService(s *Service) *OrganizationsEnvironmentsSecurityActionsService {
	rs := &OrganizationsEnvironmentsSecurityActionsService{s: s}
	return rs
}

type OrganizationsEnvironmentsSecurityActionsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsSecurityIncidentsService(s *Service) *OrganizationsEnvironmentsSecurityIncidentsService {
	rs := &OrganizationsEnvironmentsSecurityIncidentsService{s: s}
	return rs
}

type OrganizationsEnvironmentsSecurityIncidentsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsSecurityReportsService(s *Service) *OrganizationsEnvironmentsSecurityReportsService {
	rs := &OrganizationsEnvironmentsSecurityReportsService{s: s}
	return rs
}

type OrganizationsEnvironmentsSecurityReportsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsSecurityStatsService(s *Service) *OrganizationsEnvironmentsSecurityStatsService {
	rs := &OrganizationsEnvironmentsSecurityStatsService{s: s}
	return rs
}

type OrganizationsEnvironmentsSecurityStatsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsSharedflowsService(s *Service) *OrganizationsEnvironmentsSharedflowsService {
	rs := &OrganizationsEnvironmentsSharedflowsService{s: s}
	rs.Deployments = NewOrganizationsEnvironmentsSharedflowsDeploymentsService(s)
	rs.Revisions = NewOrganizationsEnvironmentsSharedflowsRevisionsService(s)
	return rs
}

type OrganizationsEnvironmentsSharedflowsService struct {
	s *Service

	Deployments *OrganizationsEnvironmentsSharedflowsDeploymentsService

	Revisions *OrganizationsEnvironmentsSharedflowsRevisionsService
}

func NewOrganizationsEnvironmentsSharedflowsDeploymentsService(s *Service) *OrganizationsEnvironmentsSharedflowsDeploymentsService {
	rs := &OrganizationsEnvironmentsSharedflowsDeploymentsService{s: s}
	return rs
}

type OrganizationsEnvironmentsSharedflowsDeploymentsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsSharedflowsRevisionsService(s *Service) *OrganizationsEnvironmentsSharedflowsRevisionsService {
	rs := &OrganizationsEnvironmentsSharedflowsRevisionsService{s: s}
	return rs
}

type OrganizationsEnvironmentsSharedflowsRevisionsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsStatsService(s *Service) *OrganizationsEnvironmentsStatsService {
	rs := &OrganizationsEnvironmentsStatsService{s: s}
	return rs
}

type OrganizationsEnvironmentsStatsService struct {
	s *Service
}

func NewOrganizationsEnvironmentsTargetserversService(s *Service) *OrganizationsEnvironmentsTargetserversService {
	rs := &OrganizationsEnvironmentsTargetserversService{s: s}
	return rs
}

type OrganizationsEnvironmentsTargetserversService struct {
	s *Service
}

func NewOrganizationsEnvironmentsTraceConfigService(s *Service) *OrganizationsEnvironmentsTraceConfigService {
	rs := &OrganizationsEnvironmentsTraceConfigService{s: s}
	rs.Overrides = NewOrganizationsEnvironmentsTraceConfigOverridesService(s)
	return rs
}

type OrganizationsEnvironmentsTraceConfigService struct {
	s *Service

	Overrides *OrganizationsEnvironmentsTraceConfigOverridesService
}

func NewOrganizationsEnvironmentsTraceConfigOverridesService(s *Service) *OrganizationsEnvironmentsTraceConfigOverridesService {
	rs := &OrganizationsEnvironmentsTraceConfigOverridesService{s: s}
	return rs
}

type OrganizationsEnvironmentsTraceConfigOverridesService struct {
	s *Service
}

func NewOrganizationsHostQueriesService(s *Service) *OrganizationsHostQueriesService {
	rs := &OrganizationsHostQueriesService{s: s}
	return rs
}

type OrganizationsHostQueriesService struct {
	s *Service
}

func NewOrganizationsHostSecurityReportsService(s *Service) *OrganizationsHostSecurityReportsService {
	rs := &OrganizationsHostSecurityReportsService{s: s}
	return rs
}

type OrganizationsHostSecurityReportsService struct {
	s *Service
}

func NewOrganizationsHostStatsService(s *Service) *OrganizationsHostStatsService {
	rs := &OrganizationsHostStatsService{s: s}
	return rs
}

type OrganizationsHostStatsService struct {
	s *Service
}

func NewOrganizationsInstancesService(s *Service) *OrganizationsInstancesService {
	rs := &OrganizationsInstancesService{s: s}
	rs.Attachments = NewOrganizationsInstancesAttachmentsService(s)
	rs.Canaryevaluations = NewOrganizationsInstancesCanaryevaluationsService(s)
	rs.NatAddresses = NewOrganizationsInstancesNatAddressesService(s)
	return rs
}

type OrganizationsInstancesService struct {
	s *Service

	Attachments *OrganizationsInstancesAttachmentsService

	Canaryevaluations *OrganizationsInstancesCanaryevaluationsService

	NatAddresses *OrganizationsInstancesNatAddressesService
}

func NewOrganizationsInstancesAttachmentsService(s *Service) *OrganizationsInstancesAttachmentsService {
	rs := &OrganizationsInstancesAttachmentsService{s: s}
	return rs
}

type OrganizationsInstancesAttachmentsService struct {
	s *Service
}

func NewOrganizationsInstancesCanaryevaluationsService(s *Service) *OrganizationsInstancesCanaryevaluationsService {
	rs := &OrganizationsInstancesCanaryevaluationsService{s: s}
	return rs
}

type OrganizationsInstancesCanaryevaluationsService struct {
	s *Service
}

func NewOrganizationsInstancesNatAddressesService(s *Service) *OrganizationsInstancesNatAddressesService {
	rs := &OrganizationsInstancesNatAddressesService{s: s}
	return rs
}

type OrganizationsInstancesNatAddressesService struct {
	s *Service
}

func NewOrganizationsKeyvaluemapsService(s *Service) *OrganizationsKeyvaluemapsService {
	rs := &OrganizationsKeyvaluemapsService{s: s}
	rs.Entries = NewOrganizationsKeyvaluemapsEntriesService(s)
	return rs
}

type OrganizationsKeyvaluemapsService struct {
	s *Service

	Entries *OrganizationsKeyvaluemapsEntriesService
}

func NewOrganizationsKeyvaluemapsEntriesService(s *Service) *OrganizationsKeyvaluemapsEntriesService {
	rs := &OrganizationsKeyvaluemapsEntriesService{s: s}
	return rs
}

type OrganizationsKeyvaluemapsEntriesService struct {
	s *Service
}

func NewOrganizationsOperationsService(s *Service) *OrganizationsOperationsService {
	rs := &OrganizationsOperationsService{s: s}
	return rs
}

type OrganizationsOperationsService struct {
	s *Service
}

func NewOrganizationsOptimizedHostStatsService(s *Service) *OrganizationsOptimizedHostStatsService {
	rs := &OrganizationsOptimizedHostStatsService{s: s}
	return rs
}

type OrganizationsOptimizedHostStatsService struct {
	s *Service
}

func NewOrganizationsReportsService(s *Service) *OrganizationsReportsService {
	rs := &OrganizationsReportsService{s: s}
	return rs
}

type OrganizationsReportsService struct {
	s *Service
}

func NewOrganizationsSecurityProfilesService(s *Service) *OrganizationsSecurityProfilesService {
	rs := &OrganizationsSecurityProfilesService{s: s}
	rs.Environments = NewOrganizationsSecurityProfilesEnvironmentsService(s)
	return rs
}

type OrganizationsSecurityProfilesService struct {
	s *Service

	Environments *OrganizationsSecurityProfilesEnvironmentsService
}

func NewOrganizationsSecurityProfilesEnvironmentsService(s *Service) *OrganizationsSecurityProfilesEnvironmentsService {
	rs := &OrganizationsSecurityProfilesEnvironmentsService{s: s}
	return rs
}

type OrganizationsSecurityProfilesEnvironmentsService struct {
	s *Service
}

func NewOrganizationsSharedflowsService(s *Service) *OrganizationsSharedflowsService {
	rs := &OrganizationsSharedflowsService{s: s}
	rs.Deployments = NewOrganizationsSharedflowsDeploymentsService(s)
	rs.Revisions = NewOrganizationsSharedflowsRevisionsService(s)
	return rs
}

type OrganizationsSharedflowsService struct {
	s *Service

	Deployments *OrganizationsSharedflowsDeploymentsService

	Revisions *OrganizationsSharedflowsRevisionsService
}

func NewOrganizationsSharedflowsDeploymentsService(s *Service) *OrganizationsSharedflowsDeploymentsService {
	rs := &OrganizationsSharedflowsDeploymentsService{s: s}
	return rs
}

type OrganizationsSharedflowsDeploymentsService struct {
	s *Service
}

func NewOrganizationsSharedflowsRevisionsService(s *Service) *OrganizationsSharedflowsRevisionsService {
	rs := &OrganizationsSharedflowsRevisionsService{s: s}
	rs.Deployments = NewOrganizationsSharedflowsRevisionsDeploymentsService(s)
	return rs
}

type OrganizationsSharedflowsRevisionsService struct {
	s *Service

	Deployments *OrganizationsSharedflowsRevisionsDeploymentsService
}

func NewOrganizationsSharedflowsRevisionsDeploymentsService(s *Service) *OrganizationsSharedflowsRevisionsDeploymentsService {
	rs := &OrganizationsSharedflowsRevisionsDeploymentsService{s: s}
	return rs
}

type OrganizationsSharedflowsRevisionsDeploymentsService struct {
	s *Service
}

func NewOrganizationsSitesService(s *Service) *OrganizationsSitesService {
	rs := &OrganizationsSitesService{s: s}
	rs.Apicategories = NewOrganizationsSitesApicategoriesService(s)
	rs.Apidocs = NewOrganizationsSitesApidocsService(s)
	return rs
}

type OrganizationsSitesService struct {
	s *Service

	Apicategories *OrganizationsSitesApicategoriesService

	Apidocs *OrganizationsSitesApidocsService
}

func NewOrganizationsSitesApicategoriesService(s *Service) *OrganizationsSitesApicategoriesService {
	rs := &OrganizationsSitesApicategoriesService{s: s}
	return rs
}

type OrganizationsSitesApicategoriesService struct {
	s *Service
}

func NewOrganizationsSitesApidocsService(s *Service) *OrganizationsSitesApidocsService {
	rs := &OrganizationsSitesApidocsService{s: s}
	return rs
}

type OrganizationsSitesApidocsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	return rs
}

type ProjectsService struct {
	s *Service
}

// EdgeConfigstoreBundleBadBundle: Describes why a bundle is invalid.
// Intended for use in error details.
type EdgeConfigstoreBundleBadBundle struct {
	// Violations: Describes all precondition violations.
	Violations []*EdgeConfigstoreBundleBadBundleViolation `json:"violations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Violations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Violations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EdgeConfigstoreBundleBadBundle) MarshalJSON() ([]byte, error) {
	type NoMethod EdgeConfigstoreBundleBadBundle
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EdgeConfigstoreBundleBadBundleViolation: A message type used to
// describe a single bundle validation error.
type EdgeConfigstoreBundleBadBundleViolation struct {
	// Description: A description of why the bundle is invalid and how to
	// fix it.
	Description string `json:"description,omitempty"`

	// Filename: The filename (including relative path from the bundle root)
	// in which the error occurred.
	Filename string `json:"filename,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EdgeConfigstoreBundleBadBundleViolation) MarshalJSON() ([]byte, error) {
	type NoMethod EdgeConfigstoreBundleBadBundleViolation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleApiHttpBody: Message that represents an arbitrary HTTP body. It
// should only be used for payload formats that can't be represented as
// JSON, such as raw binary or an HTML page. This message can be used
// both in streaming and non-streaming API methods in the request as
// well as the response. It can be used as a top-level request field,
// which is convenient if one wants to extract parameters from either
// the URL or HTTP template into the request fields and also want access
// to the raw HTTP body. Example: message GetResourceRequest { // A
// unique request id. string request_id = 1; // The raw HTTP body is
// bound to this field. google.api.HttpBody http_body = 2; } service
// ResourceService { rpc GetResource(GetResourceRequest) returns
// (google.api.HttpBody); rpc UpdateResource(google.api.HttpBody)
// returns (google.protobuf.Empty); } Example with streaming methods:
// service CaldavService { rpc GetCalendar(stream google.api.HttpBody)
// returns (stream google.api.HttpBody); rpc UpdateCalendar(stream
// google.api.HttpBody) returns (stream google.api.HttpBody); } Use of
// this type only changes how the request and response bodies are
// handled, all other features will continue to work unchanged.
type GoogleApiHttpBody struct {
	// ContentType: The HTTP Content-Type header value specifying the
	// content type of the body.
	ContentType string `json:"contentType,omitempty"`

	// Data: The HTTP request/response body as raw binary.
	Data string `json:"data,omitempty"`

	// Extensions: Application specific response metadata. Must be set in
	// the first response for streaming APIs.
	Extensions []googleapi.RawMessage `json:"extensions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContentType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContentType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleApiHttpBody) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleApiHttpBody
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1APIProductAssociation: APIProductAssociation has
// the API product and its administrative state association.
type GoogleCloudApigeeV1APIProductAssociation struct {
	// Apiproduct: API product to be associated with the credential.
	Apiproduct string `json:"apiproduct,omitempty"`

	// Status: The API product credential associated status. Valid values
	// are `approved` or `revoked`.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Apiproduct") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apiproduct") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1APIProductAssociation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1APIProductAssociation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Access struct {
	Get *GoogleCloudApigeeV1AccessGet `json:"Get,omitempty"`

	Remove *GoogleCloudApigeeV1AccessRemove `json:"Remove,omitempty"`

	Set *GoogleCloudApigeeV1AccessSet `json:"Set,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Get") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Get") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Access) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Access
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AccessGet: Get action. For example, "Get" : {
// "name" : "target.name", "value" : "default" }
type GoogleCloudApigeeV1AccessGet struct {
	Name string `json:"name,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AccessGet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AccessGet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AccessLoggingConfig: Access logging configuration
// enables customers to ship the access logs from the tenant projects to
// their own project's cloud logging. The feature is at the instance
// level ad disabled by default. It can be enabled during CreateInstance
// or UpdateInstance.
type GoogleCloudApigeeV1AccessLoggingConfig struct {
	// Enabled: Optional. Boolean flag that specifies whether the customer
	// access log feature is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// Filter: Optional. Ship the access log entries that match the
	// status_code defined in the filter. The status_code is the only
	// expected/supported filter field. (Ex: status_code) The filter will
	// parse it to the Common Expression Language semantics for expression
	// evaluation to build the filter condition. (Ex: "filter": status_code
	// >= 200 && status_code < 300 )
	Filter string `json:"filter,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AccessLoggingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AccessLoggingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AccessRemove: Remove action. For example, "Remove"
// : { "name" : "target.name", "success" : true }
type GoogleCloudApigeeV1AccessRemove struct {
	Name string `json:"name,omitempty"`

	Success bool `json:"success,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AccessRemove) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AccessRemove
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AccessSet: Set action. For example, "Set" : {
// "name" : "target.name", "success" : true, "value" : "default" }
type GoogleCloudApigeeV1AccessSet struct {
	Name string `json:"name,omitempty"`

	Success bool `json:"success,omitempty"`

	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AccessSet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AccessSet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ActivateNatAddressRequest: Request for
// ActivateNatAddressRequest. Activate the nat address request.
type GoogleCloudApigeeV1ActivateNatAddressRequest struct {
}

// GoogleCloudApigeeV1AddonsConfig: Add-on configurations for the Apigee
// organization.
type GoogleCloudApigeeV1AddonsConfig struct {
	// AdvancedApiOpsConfig: Configuration for the Advanced API Ops add-on.
	AdvancedApiOpsConfig *GoogleCloudApigeeV1AdvancedApiOpsConfig `json:"advancedApiOpsConfig,omitempty"`

	// AnalyticsConfig: Configuration for the Analytics add-on.
	AnalyticsConfig *GoogleCloudApigeeV1AnalyticsConfig `json:"analyticsConfig,omitempty"`

	// ApiSecurityConfig: Configuration for the API Security add-on.
	ApiSecurityConfig *GoogleCloudApigeeV1ApiSecurityConfig `json:"apiSecurityConfig,omitempty"`

	// ConnectorsPlatformConfig: Configuration for the Connectors Platform
	// add-on.
	ConnectorsPlatformConfig *GoogleCloudApigeeV1ConnectorsPlatformConfig `json:"connectorsPlatformConfig,omitempty"`

	// IntegrationConfig: Configuration for the Integration add-on.
	IntegrationConfig *GoogleCloudApigeeV1IntegrationConfig `json:"integrationConfig,omitempty"`

	// MonetizationConfig: Configuration for the Monetization add-on.
	MonetizationConfig *GoogleCloudApigeeV1MonetizationConfig `json:"monetizationConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "AdvancedApiOpsConfig") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AdvancedApiOpsConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AddonsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AddonsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AdjustDeveloperBalanceRequest: Request for
// AdjustDeveloperBalance.
type GoogleCloudApigeeV1AdjustDeveloperBalanceRequest struct {
	// Adjustment: * A positive value of `adjustment` means that that the
	// API provider wants to adjust the balance for an under-charged
	// developer i.e. the balance of the developer will decrease. * A
	// negative value of `adjustment` means that that the API provider wants
	// to adjust the balance for an over-charged developer i.e. the balance
	// of the developer will increase.
	Adjustment *GoogleTypeMoney `json:"adjustment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Adjustment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Adjustment") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AdjustDeveloperBalanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AdjustDeveloperBalanceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AdvancedApiOpsConfig: Configuration for the
// Advanced API Ops add-on.
type GoogleCloudApigeeV1AdvancedApiOpsConfig struct {
	// Enabled: Flag that specifies whether the Advanced API Ops add-on is
	// enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AdvancedApiOpsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AdvancedApiOpsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Alias: Reference to a certificate or
// key/certificate pair.
type GoogleCloudApigeeV1Alias struct {
	// Alias: Resource ID for this alias. Values must match the regular
	// expression `[^/]{1,255}`.
	Alias string `json:"alias,omitempty"`

	// CertsInfo: Chain of certificates under this alias.
	CertsInfo *GoogleCloudApigeeV1Certificate `json:"certsInfo,omitempty"`

	// Type: Type of alias.
	//
	// Possible values:
	//   "ALIAS_TYPE_UNSPECIFIED" - Alias type is not specified.
	//   "CERT" - Certificate.
	//   "KEY_CERT" - Key/certificate pair.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Alias") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Alias) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Alias
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1AliasRevisionConfig struct {
	// Location: Location of the alias file. For example, a Google Cloud
	// Storage URI.
	Location string `json:"location,omitempty"`

	// Name: Name of the alias revision included in the keystore in the
	// following format:
	// `organizations/{org}/environments/{env}/keystores/{keystore}/aliases/{
	// alias}/revisions/{rev}`
	Name string `json:"name,omitempty"`

	// Possible values:
	//   "ALIAS_TYPE_UNSPECIFIED" - Alias type is not specified.
	//   "CERT" - Certificate.
	//   "KEY_CERT" - Key/certificate pair.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Location") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AliasRevisionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AliasRevisionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AnalyticsConfig: Configuration for the Analytics
// add-on.
type GoogleCloudApigeeV1AnalyticsConfig struct {
	// Enabled: Whether the Analytics add-on is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ExpireTimeMillis: Output only. Time at which the Analytics add-on
	// expires in milliseconds since epoch. If unspecified, the add-on will
	// never expire.
	ExpireTimeMillis int64 `json:"expireTimeMillis,omitempty,string"`

	// State: Output only. The state of the Analytics add-on.
	//
	// Possible values:
	//   "ADDON_STATE_UNSPECIFIED" - Default value.
	//   "ENABLING" - Add-on is in progress of enabling.
	//   "ENABLED" - Add-on is fully enabled and ready to use.
	//   "DISABLING" - Add-on is in progress of disabling.
	//   "DISABLED" - Add-on is fully disabled.
	State string `json:"state,omitempty"`

	// UpdateTime: Output only. The latest update time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AnalyticsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AnalyticsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiCategory: `ApiCategory` represents an API
// category. Catalog items
// (/apigee/docs/reference/apis/apigee/rest/v1/organizations.sites.apidoc
// s) can be tagged with API categories; users viewing the API catalog
// in the portal will have the option to browse the catalog by category.
type GoogleCloudApigeeV1ApiCategory struct {
	// Id: ID of the category (a UUID).
	Id string `json:"id,omitempty"`

	// Name: Name of the category.
	Name string `json:"name,omitempty"`

	// SiteId: Name of the portal.
	SiteId string `json:"siteId,omitempty"`

	// UpdateTime: Time the category was last modified in milliseconds since
	// epoch.
	UpdateTime int64 `json:"updateTime,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiCategory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiCategory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiCategoryResponse: The API category resource
// wrapped with response status, error_code, etc.
type GoogleCloudApigeeV1ApiCategoryResponse struct {
	// Data: The API category resource.
	Data *GoogleCloudApigeeV1ApiCategory `json:"data,omitempty"`

	// ErrorCode: Unique error code for the request, if any.
	ErrorCode string `json:"errorCode,omitempty"`

	// Message: Description of the operation.
	Message string `json:"message,omitempty"`

	// RequestId: Unique ID of the request.
	RequestId string `json:"requestId,omitempty"`

	// Status: Status of the operation.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiCategoryResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiCategoryResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiDoc: `ApiDoc` represents an API catalog item.
// Catalog items are used in two ways in a portal: - Users can browse
// and interact with a visual representation of the API documentation -
// The `api_product_name` field provides a link to a backing [API
// product]
// (/apigee/docs/reference/apis/apigee/rest/v1/organizations.apiproducts)
// . Through this link, portal users can create and manage developer
// apps linked to one or more API products.
type GoogleCloudApigeeV1ApiDoc struct {
	// AnonAllowed: Optional. Boolean flag that manages user access to the
	// catalog item. When true, the catalog item has public visibility and
	// can be viewed anonymously; otherwise, only registered users may view
	// it. Note: when the parent portal is enrolled in the audience
	// management feature
	// (https://cloud.google.com/apigee/docs/api-platform/publish/portal/portal-audience#enrolling_in_the_beta_release_of_the_audience_management_feature),
	// and this flag is set to false, visibility is set to an indeterminate
	// state and must be explicitly specified in the management UI (see
	// Manage the visibility of an API in your portal
	// (https://cloud.google.com/apigee/docs/api-platform/publish/portal/publish-apis#visibility)).
	// Additionally, when enrolled in the audience management feature,
	// updates to this flag will be ignored as visibility permissions must
	// be updated in the management UI.
	AnonAllowed bool `json:"anonAllowed,omitempty"`

	// ApiProductName: Required. Immutable. The `name` field of the
	// associated API product
	// (/apigee/docs/reference/apis/apigee/rest/v1/organizations.apiproducts)
	// . A portal may have only one catalog item associated with a given API
	// product.
	ApiProductName string `json:"apiProductName,omitempty"`

	// CategoryIds: Optional. The IDs of the API categories to which this
	// catalog item belongs.
	CategoryIds []string `json:"categoryIds,omitempty"`

	// Description: Optional. Description of the catalog item. Max length is
	// 10,000 characters.
	Description string `json:"description,omitempty"`

	// EdgeAPIProductName: Optional. Immutable. DEPRECATED: use the
	// `apiProductName` field instead
	EdgeAPIProductName string `json:"edgeAPIProductName,omitempty"`

	// GraphqlEndpointUrl: Optional. DEPRECATED: manage documentation
	// through the `getDocumentation` and `updateDocumentation` methods
	GraphqlEndpointUrl string `json:"graphqlEndpointUrl,omitempty"`

	// GraphqlSchema: Optional. DEPRECATED: manage documentation through the
	// `getDocumentation` and `updateDocumentation` methods
	GraphqlSchema string `json:"graphqlSchema,omitempty"`

	// GraphqlSchemaDisplayName: Optional. DEPRECATED: manage documentation
	// through the `getDocumentation` and `updateDocumentation` methods
	GraphqlSchemaDisplayName string `json:"graphqlSchemaDisplayName,omitempty"`

	// Id: Output only. The ID of the catalog item.
	Id int64 `json:"id,omitempty,string"`

	// ImageUrl: Optional. Location of the image used for the catalog item
	// in the catalog. For portal files, this can have the format
	// `/files/{filename}`. Max length is 2,083 characters.
	ImageUrl string `json:"imageUrl,omitempty"`

	// Modified: Output only. Time the catalog item was last modified in
	// milliseconds since epoch.
	Modified int64 `json:"modified,omitempty,string"`

	// Published: Optional. Denotes whether the catalog item is published to
	// the portal or is in a draft state. When the parent portal is enrolled
	// in the audience management feature
	// (https://cloud.google.com/apigee/docs/api-platform/publish/portal/portal-audience#enrolling_in_the_beta_release_of_the_audience_management_feature),
	// the visibility can be set to public on creation by setting the
	// anonAllowed flag to true or further managed in the management UI (see
	// Manage the visibility of an API in your portal
	// (https://cloud.google.com/apigee/docs/api-platform/publish/portal/publish-apis#visibility))
	// before it can be visible to any users. If not enrolled in the
	// audience management feature, the visibility is managed by the
	// `anonAllowed` flag.
	Published bool `json:"published,omitempty"`

	// RequireCallbackUrl: Optional. Whether a callback URL is required when
	// this catalog item's API product is enabled in a developer app. When
	// true, a portal user will be required to input a URL when managing the
	// app (this is typically used for the app's OAuth flow).
	RequireCallbackUrl bool `json:"requireCallbackUrl,omitempty"`

	// SiteId: Output only. The ID of the parent portal.
	SiteId string `json:"siteId,omitempty"`

	// SpecId: Optional. DEPRECATED: DO NOT USE
	SpecId string `json:"specId,omitempty"`

	// Title: Required. The user-facing name of the catalog item. `title`
	// must be a non-empty string with a max length of 255 characters.
	Title string `json:"title,omitempty"`

	// Visibility: Optional. DEPRECATED: use the `published` field instead
	Visibility bool `json:"visibility,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnonAllowed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnonAllowed") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiDoc) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiDoc
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiDocDocumentation: The documentation for a
// catalog item.
type GoogleCloudApigeeV1ApiDocDocumentation struct {
	// GraphqlDocumentation: Optional. GraphQL documentation.
	GraphqlDocumentation *GoogleCloudApigeeV1GraphqlDocumentation `json:"graphqlDocumentation,omitempty"`

	// OasDocumentation: Optional. OpenAPI Specification documentation.
	OasDocumentation *GoogleCloudApigeeV1OASDocumentation `json:"oasDocumentation,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "GraphqlDocumentation") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "GraphqlDocumentation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiDocDocumentation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiDocDocumentation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiDocDocumentationResponse: The catalog item
// documentation wrapped with response status, error_code, etc.
type GoogleCloudApigeeV1ApiDocDocumentationResponse struct {
	// Data: Output only. The documentation resource.
	Data *GoogleCloudApigeeV1ApiDocDocumentation `json:"data,omitempty"`

	// ErrorCode: Output only. Unique error code for the request, if any.
	ErrorCode string `json:"errorCode,omitempty"`

	// Message: Output only. Description of the operation.
	Message string `json:"message,omitempty"`

	// RequestId: Output only. Unique ID of the request.
	RequestId string `json:"requestId,omitempty"`

	// Status: Output only. Status of the operation.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiDocDocumentationResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiDocDocumentationResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiDocResponse: The catalog item resource wrapped
// with response status, error_code, etc.
type GoogleCloudApigeeV1ApiDocResponse struct {
	// Data: The catalog item resource.
	Data *GoogleCloudApigeeV1ApiDoc `json:"data,omitempty"`

	// ErrorCode: Unique error code for the request, if any.
	ErrorCode string `json:"errorCode,omitempty"`

	// Message: Description of the operation.
	Message string `json:"message,omitempty"`

	// RequestId: Unique ID of the request.
	RequestId string `json:"requestId,omitempty"`

	// Status: Status of the operation.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiDocResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiDocResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ApiProduct struct {
	// ApiResources: Comma-separated list of API resources to be bundled in
	// the API product. By default, the resource paths are mapped from the
	// `proxy.pathsuffix` variable. The proxy path suffix is defined as the
	// URI fragment following the ProxyEndpoint base path. For example, if
	// the `apiResources` element is defined to be `/forecastrss` and the
	// base path defined for the API proxy is `/weather`, then only requests
	// to `/weather/forecastrss` are permitted by the API product. You can
	// select a specific path, or you can select all subpaths with the
	// following wildcard: - `/**`: Indicates that all sub-URIs are
	// included. - `/*` : Indicates that only URIs one level down are
	// included. By default, / supports the same resources as /** as well as
	// the base path defined by the API proxy. For example, if the base path
	// of the API proxy is `/v1/weatherapikey`, then the API product
	// supports requests to `/v1/weatherapikey` and to any sub-URIs, such as
	// `/v1/weatherapikey/forecastrss`, `/v1/weatherapikey/region/CA`, and
	// so on. For more information, see Managing API products.
	ApiResources []string `json:"apiResources,omitempty"`

	// ApprovalType: Flag that specifies how API keys are approved to access
	// the APIs defined by the API product. If set to `manual`, the consumer
	// key is generated and returned in "pending" state. In this case, the
	// API keys won't work until they have been explicitly approved. If set
	// to `auto`, the consumer key is generated and returned in "approved"
	// state and can be used immediately. **Note:** Typically, `auto` is
	// used to provide access to free or trial API products that provide
	// limited quota or capabilities.
	ApprovalType string `json:"approvalType,omitempty"`

	// Attributes: Array of attributes that may be used to extend the
	// default API product profile with customer-specific metadata. You can
	// specify a maximum of 18 attributes. Use this property to specify the
	// access level of the API product as either `public`, `private`, or
	// `internal`. Only products marked `public` are available to developers
	// in the Apigee developer portal. For example, you can set a product to
	// `internal` while it is in development and then change access to
	// `public` when it is ready to release on the portal. API products
	// marked as `private` do not appear on the portal, but can be accessed
	// by external developers.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// CreatedAt: Response only. Creation time of this environment as
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Description: Description of the API product. Include key information
	// about the API product that is not captured by other fields.
	Description string `json:"description,omitempty"`

	// DisplayName: Name displayed in the UI or developer portal to
	// developers registering for API access.
	DisplayName string `json:"displayName,omitempty"`

	// Environments: Comma-separated list of environment names to which the
	// API product is bound. Requests to environments that are not listed
	// are rejected. By specifying one or more environments, you can bind
	// the resources listed in the API product to a specific environment,
	// preventing developers from accessing those resources through API
	// proxies deployed in another environment. This setting is used, for
	// example, to prevent resources associated with API proxies in `prod`
	// from being accessed by API proxies deployed in `test`.
	Environments []string `json:"environments,omitempty"`

	// GraphqlOperationGroup: Configuration used to group Apigee proxies or
	// remote services with graphQL operation name, graphQL operation type
	// and quotas. This grouping allows us to precisely set quota for a
	// particular combination of graphQL name and operation type for a
	// particular proxy request. If graphQL name is not set, this would
	// imply quota will be applied on all graphQL requests matching the
	// operation type.
	GraphqlOperationGroup *GoogleCloudApigeeV1GraphQLOperationGroup `json:"graphqlOperationGroup,omitempty"`

	// GrpcOperationGroup: Optional. Configuration used to group Apigee
	// proxies with gRPC services and method names. This grouping allows us
	// to set quota for a particular proxy with the gRPC service name and
	// method. If a method name is not set, this implies quota and
	// authorization are applied to all gRPC methods implemented by that
	// proxy for that particular gRPC service.
	GrpcOperationGroup *GoogleCloudApigeeV1GrpcOperationGroup `json:"grpcOperationGroup,omitempty"`

	// LastModifiedAt: Response only. Modified time of this environment as
	// milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Internal name of the API product. Characters you can use in the
	// name are restricted to: `A-Z0-9._\-$ %`. **Note:** The internal name
	// cannot be edited when updating the API product.
	Name string `json:"name,omitempty"`

	// OperationGroup: Configuration used to group Apigee proxies or remote
	// services with resources, method types, and quotas. The resource
	// refers to the resource URI (excluding the base path). With this
	// grouping, the API product creator is able to fine-tune and give
	// precise control over which REST methods have access to specific
	// resources and how many calls can be made (using the `quota` setting).
	// **Note:** The `api_resources` setting cannot be specified for both
	// the API product and operation group; otherwise the call will fail.
	OperationGroup *GoogleCloudApigeeV1OperationGroup `json:"operationGroup,omitempty"`

	// Proxies: Comma-separated list of API proxy names to which this API
	// product is bound. By specifying API proxies, you can associate
	// resources in the API product with specific API proxies, preventing
	// developers from accessing those resources through other API proxies.
	// Apigee rejects requests to API proxies that are not listed. **Note:**
	// The API proxy names must already exist in the specified environment
	// as they will be validated upon creation.
	Proxies []string `json:"proxies,omitempty"`

	// Quota: Number of request messages permitted per app by this API
	// product for the specified `quotaInterval` and `quotaTimeUnit`. For
	// example, a `quota` of 50, for a `quotaInterval` of 12 and a
	// `quotaTimeUnit` of hours means 50 requests are allowed every 12
	// hours.
	Quota string `json:"quota,omitempty"`

	// QuotaCounterScope: Scope of the quota decides how the quota counter
	// gets applied and evaluate for quota violation. If the Scope is set as
	// PROXY, then all the operations defined for the APIproduct that are
	// associated with the same proxy will share the same quota counter set
	// at the APIproduct level, making it a global counter at a proxy level.
	// If the Scope is set as OPERATION, then each operations get the
	// counter set at the API product dedicated, making it a local counter.
	// Note that, the QuotaCounterScope applies only when an operation does
	// not have dedicated quota set for itself.
	//
	// Possible values:
	//   "QUOTA_COUNTER_SCOPE_UNSPECIFIED" - When quota is not explicitly
	// defined for each operation(REST/GraphQL), the limits set at product
	// level will be used as a local counter for quota evaluation by all the
	// operations, independent of proxy association.
	//   "PROXY" - When quota is not explicitly defined for each
	// operation(REST/GraphQL), set at product level will be used as a
	// global counter for quota evaluation by all the operations associated
	// with a particular proxy.
	//   "OPERATION" - When quota is not explicitly defined for each
	// operation(REST/GraphQL), the limits set at product level will be used
	// as a local counter for quota evaluation by all the operations,
	// independent of proxy association. This behavior mimics the same as
	// QUOTA_COUNTER_SCOPE_UNSPECIFIED.
	QuotaCounterScope string `json:"quotaCounterScope,omitempty"`

	// QuotaInterval: Time interval over which the number of request
	// messages is calculated.
	QuotaInterval string `json:"quotaInterval,omitempty"`

	// QuotaTimeUnit: Time unit defined for the `quotaInterval`. Valid
	// values include `minute`, `hour`, `day`, or `month`.
	QuotaTimeUnit string `json:"quotaTimeUnit,omitempty"`

	// Scopes: Comma-separated list of OAuth scopes that are validated at
	// runtime. Apigee validates that the scopes in any access token
	// presented match the scopes defined in the OAuth policy associated
	// with the API product.
	Scopes []string `json:"scopes,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiResources") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiResources") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiProduct) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiProduct
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ApiProductRef struct {
	// Apiproduct: Name of the API product.
	Apiproduct string `json:"apiproduct,omitempty"`

	// Status: Status of the API product. Valid values are `approved` or
	// `revoked`.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Apiproduct") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apiproduct") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiProductRef) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiProductRef
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiProxy: Metadata describing the API proxy
type GoogleCloudApigeeV1ApiProxy struct {
	// ApiProxyType: Output only. The type of the API proxy.
	//
	// Possible values:
	//   "API_PROXY_TYPE_UNSPECIFIED" - API proxy type not specified.
	//   "PROGRAMMABLE" - Programmable API Proxies enable you to develop
	// APIs with highly flexible behavior using bundled policy configuration
	// and one or more programming languages to describe complex sequential
	// and/or conditional flows of logic.
	//   "CONFIGURABLE" - Configurable API Proxies enable you to develop
	// efficient APIs using simple configuration while complex execution
	// control flow logic is handled by Apigee. This type only works with
	// the ARCHIVE deployment type and cannot be combined with the PROXY
	// deployment type.
	ApiProxyType string `json:"apiProxyType,omitempty"`

	// Labels: User labels applied to this API Proxy.
	Labels map[string]string `json:"labels,omitempty"`

	// LatestRevisionId: Output only. The id of the most recently created
	// revision for this api proxy.
	LatestRevisionId string `json:"latestRevisionId,omitempty"`

	// MetaData: Output only. Metadata describing the API proxy.
	MetaData *GoogleCloudApigeeV1EntityMetadata `json:"metaData,omitempty"`

	// Name: Output only. Name of the API proxy.
	Name string `json:"name,omitempty"`

	// ReadOnly: Output only. Whether this proxy is read-only. A read-only
	// proxy cannot have new revisions created through calls to
	// CreateApiProxyRevision. A proxy is read-only if it was generated by
	// an archive.
	ReadOnly bool `json:"readOnly,omitempty"`

	// Revision: Output only. List of revisions defined for the API proxy.
	Revision []string `json:"revision,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProxyType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProxyType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiProxy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiProxy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiProxyRevision: API proxy revision.
type GoogleCloudApigeeV1ApiProxyRevision struct {
	// Archive: Output only. The archive that generated this proxy revision.
	// This field is only present on proxy revisions that were generated by
	// an archive. Proxies generated by archives cannot be updated, deleted,
	// or deployed to other environments. Format:
	// `organizations/*/environments/*/archiveDeployments/*`
	Archive string `json:"archive,omitempty"`

	// Basepaths: Base URL of the API proxy.
	Basepaths []string `json:"basepaths,omitempty"`

	// ConfigurationVersion: Version of the API proxy configuration schema
	// to which the API proxy conforms. Currently, the only supported value
	// is 4.0 (`majorVersion.minorVersion`). This setting may be used in the
	// future to track the evolution of the API proxy format.
	ConfigurationVersion *GoogleCloudApigeeV1ConfigVersion `json:"configurationVersion,omitempty"`

	// ContextInfo: Revision number, app name, and organization for the API
	// proxy.
	ContextInfo string `json:"contextInfo,omitempty"`

	// CreatedAt: Time that the API proxy revision was created in
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Description: Description of the API proxy revision.
	Description string `json:"description,omitempty"`

	// DisplayName: Human-readable name of the API proxy.
	DisplayName string `json:"displayName,omitempty"`

	// EntityMetaDataAsProperties: Metadata describing the API proxy
	// revision as a key-value map.
	EntityMetaDataAsProperties map[string]string `json:"entityMetaDataAsProperties,omitempty"`

	// HasExtensiblePolicy: Output only. This field will be marked as true
	// if revision contains any policies marked as extensible.
	HasExtensiblePolicy bool `json:"hasExtensiblePolicy,omitempty"`

	// IntegrationEndpoints: List of IntegrationEndpoints in the
	// '/integration-endpoints' directory of the API proxy. This is a
	// 'manifest' setting designed to provide visibility into the contents
	// of the API proxy.
	IntegrationEndpoints []string `json:"integrationEndpoints,omitempty"`

	// LastModifiedAt: Time that the API proxy revision was last modified in
	// milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Name of the API proxy.
	Name string `json:"name,omitempty"`

	// Policies: List of policy names included in the API proxy revision..
	Policies []string `json:"policies,omitempty"`

	// Proxies: List of proxy names included in the API proxy revision.
	Proxies []string `json:"proxies,omitempty"`

	// ProxyEndpoints: List of ProxyEndpoints in the `/proxies` directory of
	// the API proxy. Typically, this element is included only when the API
	// proxy was created using the Edge UI. This is a 'manifest' setting
	// designed to provide visibility into the contents of the API proxy.
	ProxyEndpoints []string `json:"proxyEndpoints,omitempty"`

	// ResourceFiles: List of resource files included in the API proxy
	// revision.
	ResourceFiles *GoogleCloudApigeeV1ResourceFiles `json:"resourceFiles,omitempty"`

	// Resources: List of the resources included in the API proxy revision
	// formatted as "{type}://{name}".
	Resources []string `json:"resources,omitempty"`

	// Revision: API proxy revision.
	Revision string `json:"revision,omitempty"`

	// SharedFlows: List of the shared flows included in the API proxy
	// revision.
	SharedFlows []string `json:"sharedFlows,omitempty"`

	// Spec: OpenAPI Specification that is associated with the API proxy.
	// The value is set to a URL or to a path in the specification store.
	Spec string `json:"spec,omitempty"`

	// TargetEndpoints: List of TargetEndpoints in the `/targets` directory
	// of the API proxy. Typically, this element is included only when the
	// API proxy was created using the Edge UI. This is a 'manifest' setting
	// designed to provide visibility into the contents of the API proxy.
	TargetEndpoints []string `json:"targetEndpoints,omitempty"`

	// TargetServers: List of TargetServers referenced in any TargetEndpoint
	// in the API proxy. Typically, you will see this element only when the
	// API proxy was created using the Edge UI. This is a 'manifest' setting
	// designed to provide visibility into the contents of the API proxy.
	TargetServers []string `json:"targetServers,omitempty"`

	// Targets: List of the targets included in the API proxy revision.
	Targets []string `json:"targets,omitempty"`

	// Teams: List of the teams included in the API proxy revision.
	Teams []string `json:"teams,omitempty"`

	// Type: Type. Set to `Application`. Maintained for compatibility with
	// the Apigee Edge API.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Archive") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Archive") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiProxyRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiProxyRevision
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiSecurityConfig: Configurations of the API
// Security add-on.
type GoogleCloudApigeeV1ApiSecurityConfig struct {
	// Enabled: Flag that specifies whether the API security add-on is
	// enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ExpiresAt: Output only. Time at which the API Security add-on expires
	// in in milliseconds since epoch. If unspecified, the add-on will never
	// expire.
	ExpiresAt int64 `json:"expiresAt,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiSecurityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiSecurityConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ApiSecurityRuntimeConfig: Response for
// GetApiSecurityRuntimeConfig[EnvironmentService.GetApiSecurityRuntimeCo
// nfig].
type GoogleCloudApigeeV1ApiSecurityRuntimeConfig struct {
	// Location: A list of up to 5 Cloud Storage Blobs that contain
	// SecurityActions.
	Location []string `json:"location,omitempty"`

	// Name: Name of the environment API Security Runtime configuration
	// resource. Format:
	// `organizations/{org}/environments/{env}/apiSecurityRuntimeConfig`
	Name string `json:"name,omitempty"`

	// RevisionId: Revision ID of the API Security Runtime configuration.
	// The higher the value, the more recently the configuration was
	// deployed.
	RevisionId int64 `json:"revisionId,omitempty,string"`

	// Uid: Unique ID for the API Security Runtime configuration. The ID
	// will only change if the environment is deleted and recreated.
	Uid string `json:"uid,omitempty"`

	// UpdateTime: Time that the API Security Runtime configuration was
	// updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Location") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ApiSecurityRuntimeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ApiSecurityRuntimeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1App struct {
	// ApiProducts: List of API products associated with the app.
	ApiProducts []*GoogleCloudApigeeV1ApiProductRef `json:"apiProducts,omitempty"`

	// AppGroup: Name of the AppGroup
	AppGroup string `json:"appGroup,omitempty"`

	// AppId: ID of the app.
	AppId string `json:"appId,omitempty"`

	// Attributes: List of attributes.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// CallbackUrl: Callback URL used by OAuth 2.0 authorization servers to
	// communicate authorization codes back to apps.
	CallbackUrl string `json:"callbackUrl,omitempty"`

	// CompanyName: Name of the company that owns the app.
	CompanyName string `json:"companyName,omitempty"`

	// CreatedAt: Output only. Unix time when the app was created.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Credentials: Output only. Set of credentials for the app. Credentials
	// are API key/secret pairs associated with API products.
	Credentials []*GoogleCloudApigeeV1Credential `json:"credentials,omitempty"`

	// DeveloperEmail: Email of the developer.
	DeveloperEmail string `json:"developerEmail,omitempty"`

	// DeveloperId: ID of the developer.
	DeveloperId string `json:"developerId,omitempty"`

	// KeyExpiresIn: Duration, in milliseconds, of the consumer key that
	// will be generated for the app. The default value, -1, indicates an
	// infinite validity period. Once set, the expiration can't be updated.
	// json key: keyExpiresIn
	KeyExpiresIn int64 `json:"keyExpiresIn,omitempty,string"`

	// LastModifiedAt: Output only. Last modified time as milliseconds since
	// epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Name of the app.
	Name string `json:"name,omitempty"`

	// Scopes: Scopes to apply to the app. The specified scope names must
	// already exist on the API product that you associate with the app.
	Scopes []string `json:"scopes,omitempty"`

	// Status: Status of the credential.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProducts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProducts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1App) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1App
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AppGroup: AppGroup contains the request/response
// fields representing the logical grouping of apps. Note that
// appgroup_id, create_time and update_time cannot be changed by the
// user, and gets updated by the system. The name and the organization
// once provided cannot be edited subsequently.
type GoogleCloudApigeeV1AppGroup struct {
	// AppGroupId: Output only. Internal identifier that cannot be edited
	AppGroupId string `json:"appGroupId,omitempty"`

	// Attributes: A list of attributes
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// ChannelId: channel identifier identifies the owner maintaing this
	// grouping.
	ChannelId string `json:"channelId,omitempty"`

	// ChannelUri: A reference to the associated storefront/marketplace.
	ChannelUri string `json:"channelUri,omitempty"`

	// CreatedAt: Output only. Created time as milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// DisplayName: app group name displayed in the UI
	DisplayName string `json:"displayName,omitempty"`

	// LastModifiedAt: Output only. Modified time as milliseconds since
	// epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Immutable. Name of the AppGroup. Characters you can use in the
	// name are restricted to: A-Z0-9._\-$ %.
	Name string `json:"name,omitempty"`

	// Organization: Immutable. the org the app group is created
	Organization string `json:"organization,omitempty"`

	// Status: Valid values are `active` or `inactive`. Note that the status
	// of the AppGroup should be updated via UpdateAppGroupRequest by
	// setting the action as `active` or `inactive`.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppGroupId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppGroupId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AppGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AppGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AppGroupApp: Response for
// [GetAppGroupApp].[AppGroupApps.GetAppGroupApp],
// [CreateAppGroupAppRequest].[AppGroupApp.CreateAppGroupAppRequest] and
// [DeleteAppGroupApp].[AppGroupApp.DeleteAppGroupApp]
type GoogleCloudApigeeV1AppGroupApp struct {
	// ApiProducts: List of API products associated with the AppGroup app.
	ApiProducts []string `json:"apiProducts,omitempty"`

	// AppGroup: Immutable. Name of the parent AppGroup whose resource name
	// format is of syntax (organizations/*/appgroups/*).
	AppGroup string `json:"appGroup,omitempty"`

	// AppId: Immutable. ID of the AppGroup app.
	AppId string `json:"appId,omitempty"`

	// Attributes: List of attributes for the AppGroup app.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// CallbackUrl: Callback URL used by OAuth 2.0 authorization servers to
	// communicate authorization codes back to AppGroup apps.
	CallbackUrl string `json:"callbackUrl,omitempty"`

	// CreatedAt: Output only. Time the AppGroup app was created in
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Credentials: Output only. Set of credentials for the AppGroup app
	// consisting of the consumer key/secret pairs associated with the API
	// products.
	Credentials []*GoogleCloudApigeeV1Credential `json:"credentials,omitempty"`

	// KeyExpiresIn: Immutable. Expiration time, in seconds, for the
	// consumer key that is generated for the AppGroup app. If not set or
	// left to the default value of `-1`, the API key never expires. The
	// expiration time can't be updated after it is set.
	KeyExpiresIn int64 `json:"keyExpiresIn,omitempty,string"`

	// LastModifiedAt: Output only. Time the AppGroup app was modified in
	// milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Immutable. Name of the AppGroup app whose resource name format
	// is of syntax (organizations/*/appgroups/*/apps/*).
	Name string `json:"name,omitempty"`

	// Scopes: Scopes to apply to the AppGroup app. The specified scopes
	// must already exist for the API product that you associate with the
	// AppGroup app.
	Scopes []string `json:"scopes,omitempty"`

	// Status: Status of the App. Valid values include `approved` or
	// `revoked`.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProducts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProducts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AppGroupApp) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AppGroupApp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1AppGroupAppKey: AppGroupAppKey contains all the
// information associated with the credentials.
type GoogleCloudApigeeV1AppGroupAppKey struct {
	// ApiProducts: Output only. List of API products and its status for
	// which the credential can be used. **Note**: Use
	// UpdateAppGroupAppKeyApiProductRequest API to make the association
	// after the consumer key and secret are created.
	ApiProducts []*GoogleCloudApigeeV1APIProductAssociation `json:"apiProducts,omitempty"`

	// Attributes: List of attributes associated with the credential.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// ConsumerKey: Immutable. Consumer key.
	ConsumerKey string `json:"consumerKey,omitempty"`

	// ConsumerSecret: Secret key.
	ConsumerSecret string `json:"consumerSecret,omitempty"`

	// ExpiresAt: Output only. Time the AppGroup app expires in milliseconds
	// since epoch.
	ExpiresAt int64 `json:"expiresAt,omitempty,string"`

	// ExpiresInSeconds: Immutable. Expiration time, in seconds, for the
	// consumer key. If not set or left to the default value of `-1`, the
	// API key never expires. The expiration time can't be updated after it
	// is set.
	ExpiresInSeconds int64 `json:"expiresInSeconds,omitempty,string"`

	// IssuedAt: Output only. Time the AppGroup app was created in
	// milliseconds since epoch.
	IssuedAt int64 `json:"issuedAt,omitempty,string"`

	// Scopes: Scopes to apply to the app. The specified scope names must
	// already be defined for the API product that you associate with the
	// app.
	Scopes []string `json:"scopes,omitempty"`

	// Status: Status of the credential. Valid values include `approved` or
	// `revoked`.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProducts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProducts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AppGroupAppKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AppGroupAppKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ArchiveDeployment: Archive Deployment information.
type GoogleCloudApigeeV1ArchiveDeployment struct {
	// CreatedAt: Output only. The time at which the Archive Deployment was
	// created in milliseconds since the epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// GcsUri: Input only. The Google Cloud Storage signed URL returned from
	// GenerateUploadUrl and used to upload the Archive zip file.
	GcsUri string `json:"gcsUri,omitempty"`

	// Labels: User-supplied key-value pairs used to organize
	// ArchiveDeployments. Label keys must be between 1 and 63 characters
	// long, have a UTF-8 encoding of maximum 128 bytes, and must conform to
	// the following PCRE regular expression: \p{Ll}\p{Lo}{0,62} Label
	// values must be between 1 and 63 characters long, have a UTF-8
	// encoding of maximum 128 bytes, and must conform to the following PCRE
	// regular expression: [\p{Ll}\p{Lo}\p{N}_-]{0,63} No more than 64
	// labels can be associated with a given store.
	Labels map[string]string `json:"labels,omitempty"`

	// Name: Name of the Archive Deployment in the following format:
	// `organizations/{org}/environments/{env}/archiveDeployments/{id}`.
	Name string `json:"name,omitempty"`

	// Operation: Output only. A reference to the LRO that created this
	// Archive Deployment in the following format:
	// `organizations/{org}/operations/{id}`
	Operation string `json:"operation,omitempty"`

	// UpdatedAt: Output only. The time at which the Archive Deployment was
	// updated in milliseconds since the epoch.
	UpdatedAt int64 `json:"updatedAt,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreatedAt") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatedAt") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ArchiveDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ArchiveDeployment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1AsyncQuery struct {
	// Created: Creation time of the query.
	Created string `json:"created,omitempty"`

	// EnvgroupHostname: Hostname is available only when query is executed
	// at host level.
	EnvgroupHostname string `json:"envgroupHostname,omitempty"`

	// Error: Error is set when query fails.
	Error string `json:"error,omitempty"`

	// ExecutionTime: ExecutionTime is available only after the query is
	// completed.
	ExecutionTime string `json:"executionTime,omitempty"`

	// Name: Asynchronous Query Name.
	Name string `json:"name,omitempty"`

	// QueryParams: Contains information like metrics, dimenstions etc of
	// the AsyncQuery.
	QueryParams *GoogleCloudApigeeV1QueryMetadata `json:"queryParams,omitempty"`

	// ReportDefinitionId: Asynchronous Report ID.
	ReportDefinitionId string `json:"reportDefinitionId,omitempty"`

	// Result: Result is available only after the query is completed.
	Result *GoogleCloudApigeeV1AsyncQueryResult `json:"result,omitempty"`

	// ResultFileSize: ResultFileSize is available only after the query is
	// completed.
	ResultFileSize string `json:"resultFileSize,omitempty"`

	// ResultRows: ResultRows is available only after the query is
	// completed.
	ResultRows int64 `json:"resultRows,omitempty,string"`

	// Self: Self link of the query. Example:
	// `/organizations/myorg/environments/myenv/queries/9cfc0d85-0f30-46d6-ae
	// 6f-318d0cb961bd` or following format if query is running at host
	// level:
	// `/organizations/myorg/hostQueries/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd
	// `
	Self string `json:"self,omitempty"`

	// State: Query state could be "enqueued", "running", "completed",
	// "failed".
	State string `json:"state,omitempty"`

	// Updated: Last updated timestamp for the query.
	Updated string `json:"updated,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Created") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Created") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AsyncQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AsyncQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1AsyncQueryResult struct {
	// Expires: Query result will be unaccessable after this time.
	Expires string `json:"expires,omitempty"`

	// Self: Self link of the query results. Example:
	// `/organizations/myorg/environments/myenv/queries/9cfc0d85-0f30-46d6-ae
	// 6f-318d0cb961bd/result` or following format if query is running at
	// host level:
	// `/organizations/myorg/hostQueries/9cfc0d85-0f30-46d6-ae6f-318d0cb961bd
	// /result`
	Self string `json:"self,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Expires") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Expires") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AsyncQueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AsyncQueryResult
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1AsyncQueryResultView struct {
	// Code: Error code when there is a failure.
	Code int64 `json:"code,omitempty"`

	// Error: Error message when there is a failure.
	Error string `json:"error,omitempty"`

	// Metadata: Metadata contains information like metrics, dimenstions etc
	// of the AsyncQuery.
	Metadata *GoogleCloudApigeeV1QueryMetadata `json:"metadata,omitempty"`

	// Rows: Rows of query result. Each row is a JSON object. Example:
	// {sum(message_count): 1, developer_app: "(not set)",…}
	Rows []interface{} `json:"rows,omitempty"`

	// State: State of retrieving ResultView.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1AsyncQueryResultView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1AsyncQueryResultView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Attribute: Key-value pair to store extra metadata.
type GoogleCloudApigeeV1Attribute struct {
	// Name: API key of the attribute.
	Name string `json:"name,omitempty"`

	// Value: Value of the attribute.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Attribute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Attribute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Attributes struct {
	// Attribute: List of attributes.
	Attribute []*GoogleCloudApigeeV1Attribute `json:"attribute,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attribute") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attribute") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Attributes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Attributes
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1BatchUpdateSecurityIncidentsRequest: Request for
// BatchUpdateSecurityIncident.
type GoogleCloudApigeeV1BatchUpdateSecurityIncidentsRequest struct {
	// Requests: Optional. Required. The request message specifying the
	// resources to update. A maximum of 1000 can be modified in a batch.
	Requests []*GoogleCloudApigeeV1UpdateSecurityIncidentRequest `json:"requests,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Requests") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Requests") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1BatchUpdateSecurityIncidentsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1BatchUpdateSecurityIncidentsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1BatchUpdateSecurityIncidentsResponse: Response for
// BatchUpdateSecurityIncident.
type GoogleCloudApigeeV1BatchUpdateSecurityIncidentsResponse struct {
	// SecurityIncidents: Output only. Updated security incidents
	SecurityIncidents []*GoogleCloudApigeeV1SecurityIncident `json:"securityIncidents,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "SecurityIncidents")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SecurityIncidents") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1BatchUpdateSecurityIncidentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1BatchUpdateSecurityIncidentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1CanaryEvaluation: CanaryEvaluation represents the
// canary analysis between two versions of the runtime that is serving
// requests.
type GoogleCloudApigeeV1CanaryEvaluation struct {
	// Control: Required. The stable version that is serving requests.
	Control string `json:"control,omitempty"`

	// CreateTime: Output only. Create time of the canary evaluation.
	CreateTime string `json:"createTime,omitempty"`

	// EndTime: Required. End time for the evaluation's analysis.
	EndTime string `json:"endTime,omitempty"`

	// MetricLabels: Required. Labels used to filter the metrics used for a
	// canary evaluation.
	MetricLabels *GoogleCloudApigeeV1CanaryEvaluationMetricLabels `json:"metricLabels,omitempty"`

	// Name: Output only. Name of the canary evalution.
	Name string `json:"name,omitempty"`

	// StartTime: Required. Start time for the canary evaluation's analysis.
	StartTime string `json:"startTime,omitempty"`

	// State: Output only. The current state of the canary evaluation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - No state has been specified.
	//   "RUNNING" - The canary evaluation is still in progress.
	//   "SUCCEEDED" - The canary evaluation has finished.
	State string `json:"state,omitempty"`

	// Treatment: Required. The newer version that is serving requests.
	Treatment string `json:"treatment,omitempty"`

	// Verdict: Output only. The resulting verdict of the canary
	// evaluations: NONE, PASS, or FAIL.
	//
	// Possible values:
	//   "VERDICT_UNSPECIFIED" - Verdict is not available yet.
	//   "NONE" - No verdict reached.
	//   "FAIL" - Evaluation is not good.
	//   "PASS" - Evaluation is good.
	Verdict string `json:"verdict,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Control") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Control") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1CanaryEvaluation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1CanaryEvaluation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1CanaryEvaluationMetricLabels: Labels that can be
// used to filter Apigee metrics.
type GoogleCloudApigeeV1CanaryEvaluationMetricLabels struct {
	// Env: The environment ID associated with the metrics.
	Env string `json:"env,omitempty"`

	// InstanceId: Required. The instance ID associated with the metrics. In
	// Apigee Hybrid, the value is configured during installation.
	InstanceId string `json:"instance_id,omitempty"`

	// Location: Required. The location associated with the metrics.
	Location string `json:"location,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Env") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Env") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1CanaryEvaluationMetricLabels) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1CanaryEvaluationMetricLabels
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1CertInfo: X.509 certificate as defined in RFC
// 5280.
type GoogleCloudApigeeV1CertInfo struct {
	// BasicConstraints: X.509 basic constraints extension.
	BasicConstraints string `json:"basicConstraints,omitempty"`

	// ExpiryDate: X.509 `notAfter` validity period in milliseconds since
	// epoch.
	ExpiryDate int64 `json:"expiryDate,omitempty,string"`

	// IsValid: Flag that specifies whether the certificate is valid. Flag
	// is set to `Yes` if the certificate is valid, `No` if expired, or `Not
	// yet` if not yet valid.
	IsValid string `json:"isValid,omitempty"`

	// Issuer: X.509 issuer.
	Issuer string `json:"issuer,omitempty"`

	// PublicKey: Public key component of the X.509 subject public key info.
	PublicKey string `json:"publicKey,omitempty"`

	// SerialNumber: X.509 serial number.
	SerialNumber string `json:"serialNumber,omitempty"`

	// SigAlgName: X.509 signatureAlgorithm.
	SigAlgName string `json:"sigAlgName,omitempty"`

	// Subject: X.509 subject.
	Subject string `json:"subject,omitempty"`

	// SubjectAlternativeNames: X.509 subject alternative names (SANs)
	// extension.
	SubjectAlternativeNames []string `json:"subjectAlternativeNames,omitempty"`

	// ValidFrom: X.509 `notBefore` validity period in milliseconds since
	// epoch.
	ValidFrom int64 `json:"validFrom,omitempty,string"`

	// Version: X.509 version.
	Version int64 `json:"version,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BasicConstraints") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BasicConstraints") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1CertInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1CertInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Certificate struct {
	// CertInfo: Chain of certificates under this name.
	CertInfo []*GoogleCloudApigeeV1CertInfo `json:"certInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CertInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CertInfo") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Certificate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Certificate
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1CommonNameConfig struct {
	MatchWildCards bool `json:"matchWildCards,omitempty"`

	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MatchWildCards") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MatchWildCards") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1CommonNameConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1CommonNameConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ComputeEnvironmentScoresRequest: Request for
// ComputeEnvironmentScores.
type GoogleCloudApigeeV1ComputeEnvironmentScoresRequest struct {
	// Filters: Optional. Filters are used to filter scored components.
	// Return all the components if no filter is mentioned. Example: [{
	// "scorePath":
	// "/org@myorg/envgroup@myenvgroup/env@myenv/proxies/proxy@myproxy/source
	// " }, { "scorePath":
	// "/org@myorg/envgroup@myenvgroup/env@myenv/proxies/proxy@myproxy/target
	// ", }] This will return components with path:
	// "/org@myorg/envgroup@myenvgroup/env@myenv/proxies/proxy@myproxy/source
	// " OR
	// "/org@myorg/envgroup@myenvgroup/env@myenv/proxies/proxy@myproxy/target
	// "
	Filters []*GoogleCloudApigeeV1ComputeEnvironmentScoresRequestFilter `json:"filters,omitempty"`

	// PageSize: Optional. The maximum number of subcomponents to be
	// returned in a single page. The service may return fewer than this
	// value. If unspecified, at most 100 subcomponents will be returned in
	// a single page.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: Optional. A token that can be sent as `page_token` to
	// retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	PageToken string `json:"pageToken,omitempty"`

	// TimeRange: Required. Time range for score calculation. At most 14
	// days of scores will be returned.
	TimeRange *GoogleTypeInterval `json:"timeRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Filters") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Filters") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ComputeEnvironmentScoresRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ComputeEnvironmentScoresRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ComputeEnvironmentScoresRequestFilter: Filter
// scores by component path. Used custom filter instead of AIP-160 as
// the use cases are highly constrained and predictable.
type GoogleCloudApigeeV1ComputeEnvironmentScoresRequestFilter struct {
	// ScorePath: Optional. Return scores for this component. Example:
	// "/org@myorg/envgroup@myenvgroup/env@myenv/proxies/proxy@myproxy/source
	// "
	ScorePath string `json:"scorePath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ScorePath") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ScorePath") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ComputeEnvironmentScoresRequestFilter) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ComputeEnvironmentScoresRequestFilter
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ComputeEnvironmentScoresResponse: Response for
// ComputeEnvironmentScores.
type GoogleCloudApigeeV1ComputeEnvironmentScoresResponse struct {
	// NextPageToken: A page token, received from a previous `ComputeScore`
	// call. Provide this to retrieve the subsequent page.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Scores: List of scores. One score per day.
	Scores []*GoogleCloudApigeeV1Score `json:"scores,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ComputeEnvironmentScoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ComputeEnvironmentScoresResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ConfigVersion: Version of the API proxy
// configuration schema. Currently, only 4.0 is supported.
type GoogleCloudApigeeV1ConfigVersion struct {
	// MajorVersion: Major version of the API proxy configuration schema.
	MajorVersion int64 `json:"majorVersion,omitempty"`

	// MinorVersion: Minor version of the API proxy configuration schema.
	MinorVersion int64 `json:"minorVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "MajorVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "MajorVersion") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ConfigVersion) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ConfigVersion
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ConnectorsPlatformConfig: Configuration for the
// Connectors Platform add-on.
type GoogleCloudApigeeV1ConnectorsPlatformConfig struct {
	// Enabled: Flag that specifies whether the Connectors Platform add-on
	// is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ExpiresAt: Output only. Time at which the Connectors Platform add-on
	// expires in milliseconds since epoch. If unspecified, the add-on will
	// never expire.
	ExpiresAt int64 `json:"expiresAt,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ConnectorsPlatformConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ConnectorsPlatformConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Credential struct {
	// ApiProducts: List of API products this credential can be used for.
	ApiProducts []*GoogleCloudApigeeV1ApiProductRef `json:"apiProducts,omitempty"`

	// Attributes: List of attributes associated with this credential.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// ConsumerKey: Consumer key.
	ConsumerKey string `json:"consumerKey,omitempty"`

	// ConsumerSecret: Secret key.
	ConsumerSecret string `json:"consumerSecret,omitempty"`

	// ExpiresAt: Time the credential will expire in milliseconds since
	// epoch.
	ExpiresAt int64 `json:"expiresAt,omitempty,string"`

	// IssuedAt: Time the credential was issued in milliseconds since epoch.
	IssuedAt int64 `json:"issuedAt,omitempty,string"`

	// Scopes: List of scopes to apply to the app. Specified scopes must
	// already exist on the API product that you associate with the app.
	Scopes []string `json:"scopes,omitempty"`

	// Status: Status of the credential. Valid values include `approved` or
	// `revoked`.
	Status string `json:"status,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiProducts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProducts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Credential) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Credential
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1CreditDeveloperBalanceRequest: Request for
// CreditDeveloperBalance.
type GoogleCloudApigeeV1CreditDeveloperBalanceRequest struct {
	// TransactionAmount: The amount of money to be credited. The wallet
	// corresponding to the currency specified within `transaction_amount`
	// will be updated. For example, if you specified `currency_code` within
	// `transaction_amount` as "USD", then the amount would be added to the
	// wallet which has the "USD" currency or if no such wallet exists, a
	// new wallet will be created with the "USD" currency.
	TransactionAmount *GoogleTypeMoney `json:"transactionAmount,omitempty"`

	// TransactionId: Each transaction_id uniquely identifies a credit
	// balance request. If multiple requests are received with the same
	// transaction_id, only one of them will be considered.
	TransactionId string `json:"transactionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TransactionAmount")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TransactionAmount") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1CreditDeveloperBalanceRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1CreditDeveloperBalanceRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1CustomReport struct {
	// ChartType: This field contains the chart type for the report
	ChartType string `json:"chartType,omitempty"`

	// Comments: Legacy field: not used. This field contains a list of
	// comments associated with custom report
	Comments []string `json:"comments,omitempty"`

	// CreatedAt: Output only. Unix time when the app was created json key:
	// createdAt
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Dimensions: This contains the list of dimensions for the report
	Dimensions []string `json:"dimensions,omitempty"`

	// DisplayName: This is the display name for the report
	DisplayName string `json:"displayName,omitempty"`

	// Environment: Output only. Environment name
	Environment string `json:"environment,omitempty"`

	// Filter: This field contains the filter expression
	Filter string `json:"filter,omitempty"`

	// FromTime: Legacy field: not used. Contains the from time for the
	// report
	FromTime string `json:"fromTime,omitempty"`

	// LastModifiedAt: Output only. Modified time of this entity as
	// milliseconds since epoch. json key: lastModifiedAt
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// LastViewedAt: Output only. Last viewed time of this entity as
	// milliseconds since epoch
	LastViewedAt int64 `json:"lastViewedAt,omitempty,string"`

	// Limit: Legacy field: not used This field contains the limit for the
	// result retrieved
	Limit string `json:"limit,omitempty"`

	// Metrics: Required. This contains the list of metrics
	Metrics []*GoogleCloudApigeeV1CustomReportMetric `json:"metrics,omitempty"`

	// Name: Required. Unique identifier for the report T his is a legacy
	// field used to encode custom report unique id
	Name string `json:"name,omitempty"`

	// Offset: Legacy field: not used. This field contains the offset for
	// the data
	Offset string `json:"offset,omitempty"`

	// Organization: Output only. Organization name
	Organization string `json:"organization,omitempty"`

	// Properties: This field contains report properties such as ui metadata
	// etc.
	Properties []*GoogleCloudApigeeV1ReportProperty `json:"properties,omitempty"`

	// SortByCols: Legacy field: not used much. Contains the list of sort by
	// columns
	SortByCols []string `json:"sortByCols,omitempty"`

	// SortOrder: Legacy field: not used much. Contains the sort order for
	// the sort columns
	SortOrder string `json:"sortOrder,omitempty"`

	// Tags: Legacy field: not used. This field contains a list of tags
	// associated with custom report
	Tags []string `json:"tags,omitempty"`

	// TimeUnit: This field contains the time unit of aggregation for the
	// report
	TimeUnit string `json:"timeUnit,omitempty"`

	// ToTime: Legacy field: not used. Contains the end time for the report
	ToTime string `json:"toTime,omitempty"`

	// Topk: Legacy field: not used. This field contains the top k parameter
	// value for restricting the result
	Topk string `json:"topk,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ChartType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChartType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1CustomReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1CustomReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1CustomReportMetric: This encapsulates a metric
// property of the form sum(message_count) where name is message_count
// and function is sum
type GoogleCloudApigeeV1CustomReportMetric struct {
	// Function: aggregate function
	Function string `json:"function,omitempty"`

	// Name: name of the metric
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Function") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Function") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1CustomReportMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1CustomReportMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DataCollector: Data collector configuration.
type GoogleCloudApigeeV1DataCollector struct {
	// CreatedAt: Output only. The time at which the data collector was
	// created in milliseconds since the epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Description: A description of the data collector.
	Description string `json:"description,omitempty"`

	// LastModifiedAt: Output only. The time at which the Data Collector was
	// last updated in milliseconds since the epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: ID of the data collector. Must begin with `dc_`.
	Name string `json:"name,omitempty"`

	// Type: Immutable. The type of data this data collector will collect.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - For future compatibility.
	//   "INTEGER" - For integer values.
	//   "FLOAT" - For float values.
	//   "STRING" - For string values.
	//   "BOOLEAN" - For boolean values.
	//   "DATETIME" - For datetime values.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreatedAt") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatedAt") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DataCollector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DataCollector
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DataCollectorConfig: Data collector and its
// configuration.
type GoogleCloudApigeeV1DataCollectorConfig struct {
	// Name: Name of the data collector in the following format:
	// `organizations/{org}/datacollectors/{datacollector}`
	Name string `json:"name,omitempty"`

	// Type: Data type accepted by the data collector.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - For future compatibility.
	//   "INTEGER" - For integer values.
	//   "FLOAT" - For float values.
	//   "STRING" - For string values.
	//   "BOOLEAN" - For boolean values.
	//   "DATETIME" - For datetime values.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DataCollectorConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DataCollectorConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Datastore: The data store defines the connection
// to export data repository (Cloud Storage, BigQuery), including the
// credentials used to access the data repository.
type GoogleCloudApigeeV1Datastore struct {
	// CreateTime: Output only. Datastore create time, in milliseconds since
	// the epoch of 1970-01-01T00:00:00Z
	CreateTime int64 `json:"createTime,omitempty,string"`

	// DatastoreConfig: Datastore Configurations.
	DatastoreConfig *GoogleCloudApigeeV1DatastoreConfig `json:"datastoreConfig,omitempty"`

	// DisplayName: Required. Display name in UI
	DisplayName string `json:"displayName,omitempty"`

	// LastUpdateTime: Output only. Datastore last update time, in
	// milliseconds since the epoch of 1970-01-01T00:00:00Z
	LastUpdateTime int64 `json:"lastUpdateTime,omitempty,string"`

	// Org: Output only. Organization that the datastore belongs to
	Org string `json:"org,omitempty"`

	// Self: Output only. Resource link of Datastore. Example:
	// `/organizations/{org}/analytics/datastores/{uuid}`
	Self string `json:"self,omitempty"`

	// TargetType: Destination storage type. Supported types `gcs` or
	// `bigquery`.
	TargetType string `json:"targetType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Datastore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Datastore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DatastoreConfig: Configuration detail for
// datastore
type GoogleCloudApigeeV1DatastoreConfig struct {
	// BucketName: Name of the Cloud Storage bucket. Required for `gcs`
	// target_type.
	BucketName string `json:"bucketName,omitempty"`

	// DatasetName: BigQuery dataset name Required for `bigquery`
	// target_type.
	DatasetName string `json:"datasetName,omitempty"`

	// Path: Path of Cloud Storage bucket Required for `gcs` target_type.
	Path string `json:"path,omitempty"`

	// ProjectId: Required. GCP project in which the datastore exists
	ProjectId string `json:"projectId,omitempty"`

	// TablePrefix: Prefix of BigQuery table Required for `bigquery`
	// target_type.
	TablePrefix string `json:"tablePrefix,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BucketName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DatastoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DatastoreConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DateRange: Date range of the data to export.
type GoogleCloudApigeeV1DateRange struct {
	// End: Required. End date (exclusive) of the data to export in the
	// format `yyyy-mm-dd`. The date range ends at 00:00:00 UTC on the end
	// date- which will not be in the output.
	End string `json:"end,omitempty"`

	// Start: Required. Start date of the data to export in the format
	// `yyyy-mm-dd`. The date range begins at 00:00:00 UTC on the start
	// date.
	Start string `json:"start,omitempty"`

	// ForceSendFields is a list of field names (e.g. "End") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "End") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DateRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DateRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1DebugMask struct {
	// FaultJSONPaths: List of JSON paths that specify the JSON elements to
	// be filtered from JSON payloads in error flows.
	FaultJSONPaths []string `json:"faultJSONPaths,omitempty"`

	// FaultXPaths: List of XPaths that specify the XML elements to be
	// filtered from XML payloads in error flows.
	FaultXPaths []string `json:"faultXPaths,omitempty"`

	// Name: Name of the debug mask.
	Name string `json:"name,omitempty"`

	// Namespaces: Map of namespaces to URIs.
	Namespaces map[string]string `json:"namespaces,omitempty"`

	// RequestJSONPaths: List of JSON paths that specify the JSON elements
	// to be filtered from JSON request message payloads.
	RequestJSONPaths []string `json:"requestJSONPaths,omitempty"`

	// RequestXPaths: List of XPaths that specify the XML elements to be
	// filtered from XML request message payloads.
	RequestXPaths []string `json:"requestXPaths,omitempty"`

	// ResponseJSONPaths: List of JSON paths that specify the JSON elements
	// to be filtered from JSON response message payloads.
	ResponseJSONPaths []string `json:"responseJSONPaths,omitempty"`

	// ResponseXPaths: List of XPaths that specify the XML elements to be
	// filtered from XML response message payloads.
	ResponseXPaths []string `json:"responseXPaths,omitempty"`

	// Variables: List of variables that should be masked from the debug
	// output.
	Variables []string `json:"variables,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "FaultJSONPaths") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "FaultJSONPaths") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DebugMask) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DebugMask
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1DebugSession struct {
	// Count: Optional. The number of request to be traced. Min = 1, Max =
	// 15, Default = 10.
	Count int64 `json:"count,omitempty"`

	// CreateTime: Output only. The first transaction creation timestamp,
	// recorded by UAP.
	CreateTime string `json:"createTime,omitempty"`

	// Filter: Optional. A conditional statement which is evaluated against
	// the request message to determine if it should be traced. Syntax
	// matches that of on API Proxy bundle flow Condition.
	Filter string `json:"filter,omitempty"`

	// Name: A unique ID for this DebugSession.
	Name string `json:"name,omitempty"`

	// Timeout: Optional. The time in seconds after which this DebugSession
	// should end. This value will override the value in query param, if
	// both are provided.
	Timeout int64 `json:"timeout,omitempty,string"`

	// Tracesize: Optional. The maximum number of bytes captured from the
	// response payload. Min = 0, Max = 5120, Default = 5120.
	Tracesize int64 `json:"tracesize,omitempty"`

	// Validity: Optional. The length of time, in seconds, that this debug
	// session is valid, starting from when it's received in the control
	// plane. Min = 1, Max = 15, Default = 10.
	Validity int64 `json:"validity,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Count") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Count") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DebugSession) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DebugSession
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DebugSessionTransaction: A transaction contains
// all of the debug information of the entire message flow of an API
// call processed by the runtime plane. The information is collected and
// recorded at critical points of the message flow in the runtime
// apiproxy.
type GoogleCloudApigeeV1DebugSessionTransaction struct {
	// Completed: Flag indicating whether a transaction is completed or not
	Completed bool `json:"completed,omitempty"`

	// Point: List of debug data collected by runtime plane at various
	// defined points in the flow.
	Point []*GoogleCloudApigeeV1Point `json:"point,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Completed") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Completed") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DebugSessionTransaction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DebugSessionTransaction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1DeleteCustomReportResponse struct {
	// Message: The response contains only a message field.
	Message string `json:"message,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Message") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Message") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeleteCustomReportResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeleteCustomReportResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeleteResponse: Response for certain delete
// operations.
type GoogleCloudApigeeV1DeleteResponse struct {
	// ErrorCode: Unique error code for the request, if any.
	ErrorCode string `json:"errorCode,omitempty"`

	// GcpResource: Google Cloud name of deleted resource.
	GcpResource string `json:"gcpResource,omitempty"`

	// Message: Description of the operation.
	Message string `json:"message,omitempty"`

	// RequestId: Unique ID of the request.
	RequestId string `json:"requestId,omitempty"`

	// Status: Status of the operation.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ErrorCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ErrorCode") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeleteResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeleteResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Deployment struct {
	// ApiProxy: API proxy.
	ApiProxy string `json:"apiProxy,omitempty"`

	// DeployStartTime: Time the API proxy was marked `deployed` in the
	// control plane in millisconds since epoch.
	DeployStartTime int64 `json:"deployStartTime,omitempty,string"`

	// Environment: Environment.
	Environment string `json:"environment,omitempty"`

	// Errors: Errors reported for this deployment. Populated only when
	// state == ERROR. **Note**: This field is displayed only when viewing
	// deployment status.
	Errors []*GoogleRpcStatus `json:"errors,omitempty"`

	// Instances: Status reported by each runtime instance. **Note**: This
	// field is displayed only when viewing deployment status.
	Instances []*GoogleCloudApigeeV1InstanceDeploymentStatus `json:"instances,omitempty"`

	// Pods: Status reported by runtime pods. **Note**: **This field is
	// deprecated**. Runtime versions 1.3 and above report instance level
	// status rather than pod status.
	Pods []*GoogleCloudApigeeV1PodStatus `json:"pods,omitempty"`

	// ProxyDeploymentType: Output only. The type of the deployment
	// (standard or extensible) Deployed proxy revision will be marked as
	// extensible in following 2 cases. 1. The deployed proxy revision uses
	// extensible policies. 2. If a environment supports flowhooks and flow
	// hook is configured.
	//
	// Possible values:
	//   "PROXY_DEPLOYMENT_TYPE_UNSPECIFIED" - Default value till public
	// preview. After public preview this value should not be returned.
	//   "STANDARD" - Deployment will be of type Standard if only Standard
	// proxies are used
	//   "EXTENSIBLE" - Proxy will be of type Extensible if deployments uses
	// one or more Extensible proxies
	ProxyDeploymentType string `json:"proxyDeploymentType,omitempty"`

	// Revision: API proxy revision.
	Revision string `json:"revision,omitempty"`

	// RouteConflicts: Conflicts in the desired state routing configuration.
	// The presence of conflicts does not cause the state to be `ERROR`, but
	// it will mean that some of the deployment's base paths are not routed
	// to its environment. If the conflicts change, the state will
	// transition to `PROGRESSING` until the latest configuration is rolled
	// out to all instances. **Note**: This field is displayed only when
	// viewing deployment status.
	RouteConflicts []*GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict `json:"routeConflicts,omitempty"`

	// ServiceAccount: The full resource name of Cloud IAM Service Account
	// that this deployment is using, eg,
	// `projects/-/serviceAccounts/{email}`.
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// State: Current state of the deployment. **Note**: This field is
	// displayed only when viewing deployment status.
	//
	// Possible values:
	//   "RUNTIME_STATE_UNSPECIFIED" - This value should never be returned.
	//   "READY" - Runtime has loaded the deployment.
	//   "PROGRESSING" - Deployment is not fully ready in the runtime.
	//   "ERROR" - Encountered an error with the deployment that requires
	// intervention.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProxy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProxy") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Deployment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Deployment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeploymentChangeReport: Response for
// GenerateDeployChangeReport and GenerateUndeployChangeReport. This
// report contains any validation failures that would cause the
// deployment to be rejected, as well changes and conflicts in routing
// that may occur due to the new deployment. The existence of a routing
// warning does not necessarily imply that the deployment request is
// bad, if the desired state of the deployment request is to effect a
// routing change. The primary purposes of the routing messages are: 1)
// To inform users of routing changes that may have an effect on traffic
// currently being routed to other existing deployments. 2) To warn
// users if some base path in the proxy will not receive traffic due to
// an existing deployment having already claimed that base path. The
// presence of routing conflicts/changes will not cause non-dry-run
// DeployApiProxy/UndeployApiProxy requests to be rejected.
type GoogleCloudApigeeV1DeploymentChangeReport struct {
	// RoutingChanges: All routing changes that may result from a deployment
	// request.
	RoutingChanges []*GoogleCloudApigeeV1DeploymentChangeReportRoutingChange `json:"routingChanges,omitempty"`

	// RoutingConflicts: All base path conflicts detected for a deployment
	// request.
	RoutingConflicts []*GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict `json:"routingConflicts,omitempty"`

	// ValidationErrors: Validation errors that would cause the deployment
	// change request to be rejected.
	ValidationErrors *GoogleRpcPreconditionFailure `json:"validationErrors,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "RoutingChanges") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "RoutingChanges") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeploymentChangeReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeploymentChangeReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeploymentChangeReportRoutingChange: Describes a
// potential routing change that may occur as a result of some
// deployment operation.
type GoogleCloudApigeeV1DeploymentChangeReportRoutingChange struct {
	// Description: Human-readable description of this routing change.
	Description string `json:"description,omitempty"`

	// EnvironmentGroup: Name of the environment group affected by this
	// routing change.
	EnvironmentGroup string `json:"environmentGroup,omitempty"`

	// FromDeployment: Base path/deployment that may stop receiving some
	// traffic.
	FromDeployment *GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment `json:"fromDeployment,omitempty"`

	// ShouldSequenceRollout: Set to `true` if using sequenced rollout would
	// make this routing change safer. **Note**: This does not necessarily
	// imply that automated sequenced rollout mode is supported for the
	// operation.
	ShouldSequenceRollout bool `json:"shouldSequenceRollout,omitempty"`

	// ToDeployment: Base path/deployment that may start receiving that
	// traffic. May be null if no deployment is able to receive the traffic.
	ToDeployment *GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment `json:"toDeployment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeploymentChangeReportRoutingChange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeploymentChangeReportRoutingChange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict: Describes a
// routing conflict that may cause a deployment not to receive traffic
// at some base path.
type GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict struct {
	// ConflictingDeployment: Existing base path/deployment causing the
	// conflict.
	ConflictingDeployment *GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment `json:"conflictingDeployment,omitempty"`

	// Description: Human-readable description of this conflict.
	Description string `json:"description,omitempty"`

	// EnvironmentGroup: Name of the environment group in which this
	// conflict exists.
	EnvironmentGroup string `json:"environmentGroup,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "ConflictingDeployment") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConflictingDeployment") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeploymentChangeReportRoutingConflict
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment: Tuple
// representing a base path and the deployment containing it.
type GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment struct {
	// ApiProxy: Name of the deployed API proxy revision containing the base
	// path.
	ApiProxy string `json:"apiProxy,omitempty"`

	// Basepath: Base path receiving traffic.
	Basepath string `json:"basepath,omitempty"`

	// Environment: Name of the environment in which the proxy is deployed.
	Environment string `json:"environment,omitempty"`

	// Revision: Name of the deployed API proxy revision containing the base
	// path.
	Revision string `json:"revision,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiProxy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProxy") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeploymentChangeReportRoutingDeployment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeploymentConfig: NEXT ID: 11
type GoogleCloudApigeeV1DeploymentConfig struct {
	// Attributes: Additional key-value metadata for the deployment.
	Attributes map[string]string `json:"attributes,omitempty"`

	// BasePath: Base path where the application will be hosted. Defaults to
	// "/".
	BasePath string `json:"basePath,omitempty"`

	// DeploymentGroups: The list of deployment groups in which this proxy
	// should be deployed. Not currently populated for shared flows.
	DeploymentGroups []string `json:"deploymentGroups,omitempty"`

	// Endpoints: A mapping from basepaths to proxy endpoint names in this
	// proxy. Not populated for shared flows.
	Endpoints map[string]string `json:"endpoints,omitempty"`

	// Location: Location of the API proxy bundle as a URI.
	Location string `json:"location,omitempty"`

	// Name: Name of the API or shared flow revision to be deployed in the
	// following format: `organizations/{org}/apis/{api}/revisions/{rev}` or
	// `organizations/{org}/sharedflows/{sharedflow}/revisions/{rev}`
	Name string `json:"name,omitempty"`

	// ProxyUid: Unique ID of the API proxy revision.
	ProxyUid string `json:"proxyUid,omitempty"`

	// ServiceAccount: The service account identity associated with this
	// deployment. If non-empty, will be in the following format:
	// `projects/-/serviceAccounts/{account_email}`
	ServiceAccount string `json:"serviceAccount,omitempty"`

	// Uid: Unique ID. The ID will only change if the deployment is deleted
	// and recreated.
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attributes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attributes") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeploymentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeploymentConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeploymentGroupConfig: DeploymentGroupConfig
// represents a deployment group that should be present in a particular
// environment.
type GoogleCloudApigeeV1DeploymentGroupConfig struct {
	// DeploymentGroupType: Type of the deployment group, which will be
	// either Standard or Extensible.
	//
	// Possible values:
	//   "DEPLOYMENT_GROUP_TYPE_UNSPECIFIED" - Unspecified type
	//   "STANDARD" - Standard type
	//   "EXTENSIBLE" - Extensible Type
	DeploymentGroupType string `json:"deploymentGroupType,omitempty"`

	// Name: Name of the deployment group in the following format:
	// `organizations/{org}/environments/{env}/deploymentGroups/{group}`.
	Name string `json:"name,omitempty"`

	// RevisionId: Revision number which can be used by the runtime to
	// detect if the deployment group has changed between two versions.
	RevisionId int64 `json:"revisionId,omitempty,string"`

	// Uid: Unique ID. The ID will only change if the deployment group is
	// deleted and recreated.
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeploymentGroupType")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeploymentGroupType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeploymentGroupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeploymentGroupConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Developer struct {
	// AccessType: Access type.
	AccessType string `json:"accessType,omitempty"`

	// AppFamily: Developer app family.
	AppFamily string `json:"appFamily,omitempty"`

	// Apps: List of apps associated with the developer.
	Apps []string `json:"apps,omitempty"`

	// Attributes: Optional. Developer attributes (name/value pairs). The
	// custom attribute limit is 18.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// Companies: List of companies associated with the developer.
	Companies []string `json:"companies,omitempty"`

	// CreatedAt: Output only. Time at which the developer was created in
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// DeveloperId: ID of the developer. **Note**: IDs are generated
	// internally by Apigee and are not guaranteed to stay the same over
	// time.
	DeveloperId string `json:"developerId,omitempty"`

	// Email: Required. Email address of the developer. This value is used
	// to uniquely identify the developer in Apigee hybrid. Note that the
	// email address has to be in lowercase only.
	Email string `json:"email,omitempty"`

	// FirstName: Required. First name of the developer.
	FirstName string `json:"firstName,omitempty"`

	// LastModifiedAt: Output only. Time at which the developer was last
	// modified in milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// LastName: Required. Last name of the developer.
	LastName string `json:"lastName,omitempty"`

	// OrganizationName: Output only. Name of the Apigee organization in
	// which the developer resides.
	OrganizationName string `json:"organizationName,omitempty"`

	// Status: Output only. Status of the developer. Valid values are
	// `active` and `inactive`.
	Status string `json:"status,omitempty"`

	// UserName: Required. User name of the developer. Not used by Apigee
	// hybrid.
	UserName string `json:"userName,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessType") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Developer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Developer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1DeveloperApp struct {
	// ApiProducts: List of API products associated with the developer app.
	ApiProducts []string `json:"apiProducts,omitempty"`

	// AppFamily: Developer app family.
	AppFamily string `json:"appFamily,omitempty"`

	// AppId: ID of the developer app.
	AppId string `json:"appId,omitempty"`

	// Attributes: List of attributes for the developer app.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// CallbackUrl: Callback URL used by OAuth 2.0 authorization servers to
	// communicate authorization codes back to developer apps.
	CallbackUrl string `json:"callbackUrl,omitempty"`

	// CreatedAt: Output only. Time the developer app was created in
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Credentials: Output only. Set of credentials for the developer app
	// consisting of the consumer key/secret pairs associated with the API
	// products.
	Credentials []*GoogleCloudApigeeV1Credential `json:"credentials,omitempty"`

	// DeveloperId: ID of the developer.
	DeveloperId string `json:"developerId,omitempty"`

	// KeyExpiresIn: Expiration time, in milliseconds, for the consumer key
	// that is generated for the developer app. If not set or left to the
	// default value of `-1`, the API key never expires. The expiration time
	// can't be updated after it is set.
	KeyExpiresIn int64 `json:"keyExpiresIn,omitempty,string"`

	// LastModifiedAt: Output only. Time the developer app was modified in
	// milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Name of the developer app.
	Name string `json:"name,omitempty"`

	// Scopes: Scopes to apply to the developer app. The specified scopes
	// must already exist for the API product that you associate with the
	// developer app.
	Scopes []string `json:"scopes,omitempty"`

	// Status: Status of the credential. Valid values include `approved` or
	// `revoked`.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProducts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProducts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeveloperApp) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeveloperApp
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1DeveloperAppKey struct {
	// ApiProducts: List of API products for which the credential can be
	// used. **Note**: Do not specify the list of API products when creating
	// a consumer key and secret for a developer app. Instead, use the
	// UpdateDeveloperAppKey API to make the association after the consumer
	// key and secret are created.
	ApiProducts []interface{} `json:"apiProducts,omitempty"`

	// Attributes: List of attributes associated with the credential.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// ConsumerKey: Consumer key.
	ConsumerKey string `json:"consumerKey,omitempty"`

	// ConsumerSecret: Secret key.
	ConsumerSecret string `json:"consumerSecret,omitempty"`

	// ExpiresAt: Time the developer app expires in milliseconds since
	// epoch.
	ExpiresAt int64 `json:"expiresAt,omitempty,string"`

	// ExpiresInSeconds: Input only. Expiration time, in seconds, for the
	// consumer key. If not set or left to the default value of `-1`, the
	// API key never expires. The expiration time can't be updated after it
	// is set.
	ExpiresInSeconds int64 `json:"expiresInSeconds,omitempty,string"`

	// IssuedAt: Time the developer app was created in milliseconds since
	// epoch.
	IssuedAt int64 `json:"issuedAt,omitempty,string"`

	// Scopes: Scopes to apply to the app. The specified scope names must
	// already be defined for the API product that you associate with the
	// app.
	Scopes []string `json:"scopes,omitempty"`

	// Status: Status of the credential. Valid values include `approved` or
	// `revoked`.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProducts") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProducts") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeveloperAppKey) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeveloperAppKey
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeveloperBalance: Account balance for the
// developer.
type GoogleCloudApigeeV1DeveloperBalance struct {
	// Wallets: Output only. List of all wallets. Each individual wallet
	// stores the account balance for a particular currency.
	Wallets []*GoogleCloudApigeeV1DeveloperBalanceWallet `json:"wallets,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Wallets") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Wallets") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeveloperBalance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeveloperBalance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeveloperBalanceWallet: Wallet used to manage an
// account balance for a particular currency.
type GoogleCloudApigeeV1DeveloperBalanceWallet struct {
	// Balance: Current remaining balance of the developer for a particular
	// currency.
	Balance *GoogleTypeMoney `json:"balance,omitempty"`

	// LastCreditTime: Output only. Time at which the developer last added
	// credit to the account in milliseconds since epoch.
	LastCreditTime int64 `json:"lastCreditTime,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Balance") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Balance") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeveloperBalanceWallet) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeveloperBalanceWallet
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeveloperMonetizationConfig: Monetization
// configuration for the developer.
type GoogleCloudApigeeV1DeveloperMonetizationConfig struct {
	// BillingType: Billing type.
	//
	// Possible values:
	//   "BILLING_TYPE_UNSPECIFIED" - The default/unset value.
	//   "PREPAID" - Developer pays in advance for the use of APIs and the
	// charged amount is deducted from their account balance.
	//   "POSTPAID" - Developer does not maintain an account balance. The
	// API provider bills the developer for API usage.
	BillingType string `json:"billingType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "BillingType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BillingType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeveloperMonetizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeveloperMonetizationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DeveloperSubscription: Structure of a
// DeveloperSubscription.
type GoogleCloudApigeeV1DeveloperSubscription struct {
	// Apiproduct: Name of the API product for which the developer is
	// purchasing a subscription.
	Apiproduct string `json:"apiproduct,omitempty"`

	// CreatedAt: Output only. Time when the API product subscription was
	// created in milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// EndTime: Time when the API product subscription ends in milliseconds
	// since epoch.
	EndTime int64 `json:"endTime,omitempty,string"`

	// LastModifiedAt: Output only. Time when the API product subscription
	// was last modified in milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Output only. Name of the API product subscription.
	Name string `json:"name,omitempty"`

	// StartTime: Time when the API product subscription starts in
	// milliseconds since epoch.
	StartTime int64 `json:"startTime,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Apiproduct") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apiproduct") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DeveloperSubscription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DeveloperSubscription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DimensionMetric: Encapsulates a metric grouped by
// dimension.
type GoogleCloudApigeeV1DimensionMetric struct {
	// IndividualNames: Individual dimension names. E.g. ["dim1_name",
	// "dim2_name"].
	IndividualNames []string `json:"individualNames,omitempty"`

	// Metrics: List of metrics.
	Metrics []*GoogleCloudApigeeV1Metric `json:"metrics,omitempty"`

	// Name: Comma joined dimension names. E.g. "dim1_name,dim2_name".
	// Deprecated. If name already has comma before join, we may get wrong
	// splits. Please use individual_names.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "IndividualNames") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IndividualNames") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DimensionMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DimensionMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1DisableSecurityActionRequest: Message to disable
// an enabled SecurityAction.
type GoogleCloudApigeeV1DisableSecurityActionRequest struct {
}

// GoogleCloudApigeeV1DocumentationFile: Documentation file contents for
// a catalog item.
type GoogleCloudApigeeV1DocumentationFile struct {
	// Contents: Required. The file contents. The max size is 4 MB.
	Contents string `json:"contents,omitempty"`

	// DisplayName: Required. A display name for the file, shown in the
	// management UI. Max length is 255 characters.
	DisplayName string `json:"displayName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Contents") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Contents") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1DocumentationFile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1DocumentationFile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1EnableSecurityActionRequest: Message to enable a
// disabled SecurityAction.
type GoogleCloudApigeeV1EnableSecurityActionRequest struct {
}

// GoogleCloudApigeeV1EndpointAttachment: Apigee endpoint attachment.
// For more information, see [Southbound networking patterns]
// (https://cloud.google.com/apigee/docs/api-platform/architecture/southbound-networking-patterns-endpoints).
type GoogleCloudApigeeV1EndpointAttachment struct {
	// ConnectionState: Output only. State of the endpoint attachment
	// connection to the service attachment.
	//
	// Possible values:
	//   "CONNECTION_STATE_UNSPECIFIED" - The connection state has not been
	// set.
	//   "UNAVAILABLE" - The connection state is unavailable at this time,
	// possibly because the endpoint attachment is currently being
	// provisioned.
	//   "PENDING" - The connection is pending acceptance by the PSC
	// producer.
	//   "ACCEPTED" - The connection has been accepted by the PSC producer.
	//   "REJECTED" - The connection has been rejected by the PSC producer.
	//   "CLOSED" - The connection has been closed by the PSC producer and
	// will not serve traffic going forward.
	//   "FROZEN" - The connection has been frozen by the PSC producer and
	// will not serve traffic.
	//   "NEEDS_ATTENTION" - The connection has been accepted by the PSC
	// producer, but it is not ready to serve the traffic due to producer
	// side issues.
	ConnectionState string `json:"connectionState,omitempty"`

	// Host: Output only. Host that can be used in either the HTTP target
	// endpoint directly or as the host in target server.
	Host string `json:"host,omitempty"`

	// Location: Required. Location of the endpoint attachment.
	Location string `json:"location,omitempty"`

	// Name: Name of the endpoint attachment. Use the following structure in
	// your request:
	// `organizations/{org}/endpointAttachments/{endpoint_attachment}`
	Name string `json:"name,omitempty"`

	// ServiceAttachment: Format: projects/*/regions/*/serviceAttachments/*
	ServiceAttachment string `json:"serviceAttachment,omitempty"`

	// State: Output only. State of the endpoint attachment. Values other
	// than `ACTIVE` mean the resource is not ready to use.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Resource is in an unspecified state.
	//   "CREATING" - Resource is being created.
	//   "ACTIVE" - Resource is provisioned and ready to use.
	//   "DELETING" - The resource is being deleted.
	//   "UPDATING" - The resource is being updated.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ConnectionState") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConnectionState") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1EndpointAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1EndpointAttachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1EndpointChainingRule: EndpointChainingRule
// specifies the proxies contained in a particular deployment group, so
// that other deployment groups can find them in chaining calls.
type GoogleCloudApigeeV1EndpointChainingRule struct {
	// DeploymentGroup: The deployment group to target for cross-shard
	// chaining calls to these proxies.
	DeploymentGroup string `json:"deploymentGroup,omitempty"`

	// ProxyIds: List of proxy ids which may be found in the given
	// deployment group.
	ProxyIds []string `json:"proxyIds,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeploymentGroup") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeploymentGroup") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1EndpointChainingRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1EndpointChainingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1EntityMetadata: Metadata common to many entities
// in this API.
type GoogleCloudApigeeV1EntityMetadata struct {
	// CreatedAt: Time at which the API proxy was created, in milliseconds
	// since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// LastModifiedAt: Time at which the API proxy was most recently
	// modified, in milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// SubType: The type of entity described
	SubType string `json:"subType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreatedAt") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatedAt") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1EntityMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1EntityMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Environment struct {
	// ApiProxyType: Optional. API Proxy type supported by the environment.
	// The type can be set when creating the Environment and cannot be
	// changed.
	//
	// Possible values:
	//   "API_PROXY_TYPE_UNSPECIFIED" - API proxy type not specified.
	//   "PROGRAMMABLE" - Programmable API Proxies enable you to develop
	// APIs with highly flexible behavior using bundled policy configuration
	// and one or more programming languages to describe complex sequential
	// and/or conditional flows of logic.
	//   "CONFIGURABLE" - Configurable API Proxies enable you to develop
	// efficient APIs using simple configuration while complex execution
	// control flow logic is handled by Apigee. This type only works with
	// the ARCHIVE deployment type and cannot be combined with the PROXY
	// deployment type.
	ApiProxyType string `json:"apiProxyType,omitempty"`

	// CreatedAt: Output only. Creation time of this environment as
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// DeploymentType: Optional. Deployment type supported by the
	// environment. The deployment type can be set when creating the
	// environment and cannot be changed. When you enable archive
	// deployment, you will be **prevented from performing** a subset of
	// actions
	// (/apigee/docs/api-platform/local-development/overview#prevented-action
	// s) within the environment, including: * Managing the deployment of
	// API proxy or shared flow revisions * Creating, updating, or deleting
	// resource files * Creating, updating, or deleting target servers
	//
	// Possible values:
	//   "DEPLOYMENT_TYPE_UNSPECIFIED" - Deployment type not specified.
	//   "PROXY" - Proxy deployment enables you to develop and deploy API
	// proxies using Apigee on Google Cloud. This cannot currently be
	// combined with the CONFIGURABLE API proxy type.
	//   "ARCHIVE" - Archive deployment enables you to develop API proxies
	// locally then deploy an archive of your API proxy configuration to an
	// environment in Apigee on Google Cloud. You will be prevented from
	// performing a [subset of
	// actions](/apigee/docs/api-platform/local-development/overview#prevente
	// d-actions) within the environment.
	DeploymentType string `json:"deploymentType,omitempty"`

	// Description: Optional. Description of the environment.
	Description string `json:"description,omitempty"`

	// DisplayName: Optional. Display name for this environment.
	DisplayName string `json:"displayName,omitempty"`

	// ForwardProxyUri: Optional. URI of the forward proxy to be applied to
	// the runtime instances in this environment. Must be in the format of
	// {scheme}://{hostname}:{port}. Note that the scheme must be one of
	// "http" or "https", and the port must be supplied. To remove a forward
	// proxy setting, update the field to an empty value. Note: At this
	// time, PUT operations to add forwardProxyUri to an existing
	// environment fail if the environment has nodeConfig set up. To
	// successfully add the forwardProxyUri setting in this case, include
	// the NodeConfig details with the request.
	ForwardProxyUri string `json:"forwardProxyUri,omitempty"`

	HasAttachedFlowHooks bool `json:"hasAttachedFlowHooks,omitempty"`

	// LastModifiedAt: Output only. Last modification time of this
	// environment as milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Required. Name of the environment. Values must match the
	// regular expression `^[.\\p{Alnum}-_]{1,255}$`
	Name string `json:"name,omitempty"`

	// NodeConfig: Optional. NodeConfig of the environment.
	NodeConfig *GoogleCloudApigeeV1NodeConfig `json:"nodeConfig,omitempty"`

	// Properties: Optional. Key-value pairs that may be used for
	// customizing the environment.
	Properties *GoogleCloudApigeeV1Properties `json:"properties,omitempty"`

	// State: Output only. State of the environment. Values other than
	// ACTIVE means the resource is not ready to use.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Resource is in an unspecified state.
	//   "CREATING" - Resource is being created.
	//   "ACTIVE" - Resource is provisioned and ready to use.
	//   "DELETING" - The resource is being deleted.
	//   "UPDATING" - The resource is being updated.
	State string `json:"state,omitempty"`

	// Type: Optional. EnvironmentType selected for the environment.
	//
	// Possible values:
	//   "ENVIRONMENT_TYPE_UNSPECIFIED" - Environment type not specified.
	//   "BASE" - This is the default type. Base environment has limited
	// capacity and capabilities and are usually used when you are getting
	// started with Apigee or while experimenting. Refer to Apigee's public
	// documentation for more details.
	//   "INTERMEDIATE" - Intermediate environment supports API management
	// features and higher capacity than Base environment. Refer to Apigee's
	// public documentation for more details.
	//   "COMPREHENSIVE" - Comprehensive environment supports advanced
	// capabilites and even higher capacity than Intermediate environment.
	// Refer to Apigee's public documentation for more details.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProxyType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProxyType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Environment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Environment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1EnvironmentConfig struct {
	// AddonsConfig: The latest runtime configurations for add-ons.
	AddonsConfig *GoogleCloudApigeeV1RuntimeAddonsConfig `json:"addonsConfig,omitempty"`

	// ArcConfigLocation: The location for the config blob of API Runtime
	// Control, aka Envoy Adapter, for op-based authentication as a URI,
	// e.g. a Cloud Storage URI. This is only used by Envoy-based gateways.
	ArcConfigLocation string `json:"arcConfigLocation,omitempty"`

	// CreateTime: Time that the environment configuration was created.
	CreateTime string `json:"createTime,omitempty"`

	// DataCollectors: List of data collectors used by the deployments in
	// the environment.
	DataCollectors []*GoogleCloudApigeeV1DataCollectorConfig `json:"dataCollectors,omitempty"`

	// DebugMask: Debug mask that applies to all deployments in the
	// environment.
	DebugMask *GoogleCloudApigeeV1DebugMask `json:"debugMask,omitempty"`

	// DeploymentGroups: List of deployment groups in the environment.
	DeploymentGroups []*GoogleCloudApigeeV1DeploymentGroupConfig `json:"deploymentGroups,omitempty"`

	// Deployments: List of deployments in the environment.
	Deployments []*GoogleCloudApigeeV1DeploymentConfig `json:"deployments,omitempty"`

	// EnvScopedRevisionId: Revision ID for environment-scoped resources
	// (e.g. target servers, keystores) in this config. This ID will
	// increment any time a resource not scoped to a deployment group
	// changes.
	EnvScopedRevisionId int64 `json:"envScopedRevisionId,omitempty,string"`

	// FeatureFlags: Feature flags inherited from the organization and
	// environment.
	FeatureFlags map[string]string `json:"featureFlags,omitempty"`

	// Flowhooks: List of flow hooks in the environment.
	Flowhooks []*GoogleCloudApigeeV1FlowHookConfig `json:"flowhooks,omitempty"`

	// ForwardProxyUri: The forward proxy's url to be used by the runtime.
	// When set, runtime will send requests to the target via the given
	// forward proxy. This is only used by programmable gateways.
	ForwardProxyUri string `json:"forwardProxyUri,omitempty"`

	// GatewayConfigLocation: The location for the gateway config blob as a
	// URI, e.g. a Cloud Storage URI. This is only used by Envoy-based
	// gateways.
	GatewayConfigLocation string `json:"gatewayConfigLocation,omitempty"`

	// Keystores: List of keystores in the environment.
	Keystores []*GoogleCloudApigeeV1KeystoreConfig `json:"keystores,omitempty"`

	// Name: Name of the environment configuration in the following format:
	// `organizations/{org}/environments/{env}/configs/{config}`
	Name string `json:"name,omitempty"`

	// Provider: Used by the Control plane to add context information to
	// help detect the source of the document during diagnostics and
	// debugging.
	Provider string `json:"provider,omitempty"`

	// PubsubTopic: Name of the PubSub topic for the environment.
	PubsubTopic string `json:"pubsubTopic,omitempty"`

	// ResourceReferences: List of resource references in the environment.
	ResourceReferences []*GoogleCloudApigeeV1ReferenceConfig `json:"resourceReferences,omitempty"`

	// Resources: List of resource versions in the environment.
	Resources []*GoogleCloudApigeeV1ResourceConfig `json:"resources,omitempty"`

	// RevisionId: Revision ID of the environment configuration. The higher
	// the value, the more recently the configuration was deployed.
	RevisionId int64 `json:"revisionId,omitempty,string"`

	// SequenceNumber: DEPRECATED: Use revision_id.
	SequenceNumber int64 `json:"sequenceNumber,omitempty,string"`

	// Targets: List of target servers in the environment. Disabled target
	// servers are not displayed.
	Targets []*GoogleCloudApigeeV1TargetServerConfig `json:"targets,omitempty"`

	// TraceConfig: Trace configurations. Contains config for the
	// environment and config overrides for specific API proxies.
	TraceConfig *GoogleCloudApigeeV1RuntimeTraceConfig `json:"traceConfig,omitempty"`

	// Uid: Unique ID for the environment configuration. The ID will only
	// change if the environment is deleted and recreated.
	Uid string `json:"uid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AddonsConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddonsConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1EnvironmentConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1EnvironmentConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1EnvironmentGroup: EnvironmentGroup configuration.
// An environment group is used to group one or more Apigee environments
// under a single host name.
type GoogleCloudApigeeV1EnvironmentGroup struct {
	// CreatedAt: Output only. The time at which the environment group was
	// created as milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Hostnames: Required. Host names for this environment group.
	Hostnames []string `json:"hostnames,omitempty"`

	// LastModifiedAt: Output only. The time at which the environment group
	// was last updated as milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: ID of the environment group.
	Name string `json:"name,omitempty"`

	// State: Output only. State of the environment group. Values other than
	// ACTIVE means the resource is not ready to use.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Resource is in an unspecified state.
	//   "CREATING" - Resource is being created.
	//   "ACTIVE" - Resource is provisioned and ready to use.
	//   "DELETING" - The resource is being deleted.
	//   "UPDATING" - The resource is being updated.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreatedAt") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatedAt") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1EnvironmentGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1EnvironmentGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1EnvironmentGroupAttachment:
// EnvironmentGroupAttachment is a resource which defines an attachment
// of an environment to an environment group.
type GoogleCloudApigeeV1EnvironmentGroupAttachment struct {
	// CreatedAt: Output only. The time at which the environment group
	// attachment was created as milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Environment: Required. ID of the attached environment.
	Environment string `json:"environment,omitempty"`

	// EnvironmentGroupId: Output only. ID of the environment group.
	EnvironmentGroupId string `json:"environmentGroupId,omitempty"`

	// Name: ID of the environment group attachment.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreatedAt") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatedAt") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1EnvironmentGroupAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1EnvironmentGroupAttachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1EnvironmentGroupConfig: EnvironmentGroupConfig is
// a revisioned snapshot of an EnvironmentGroup and its associated
// routing rules.
type GoogleCloudApigeeV1EnvironmentGroupConfig struct {
	// EndpointChainingRules: A list of proxies in each deployment group for
	// proxy chaining calls.
	EndpointChainingRules []*GoogleCloudApigeeV1EndpointChainingRule `json:"endpointChainingRules,omitempty"`

	// Hostnames: Host names for the environment group.
	Hostnames []string `json:"hostnames,omitempty"`

	// Location: When this message appears in the top-level IngressConfig,
	// this field will be populated in lieu of the inlined routing_rules and
	// hostnames fields. Some URL for downloading the full
	// EnvironmentGroupConfig for this group.
	Location string `json:"location,omitempty"`

	// Name: Name of the environment group in the following format:
	// `organizations/{org}/envgroups/{envgroup}`.
	Name string `json:"name,omitempty"`

	// RevisionId: Revision id that defines the ordering of the
	// EnvironmentGroupConfig resource. The higher the revision, the more
	// recently the configuration was deployed.
	RevisionId int64 `json:"revisionId,omitempty,string"`

	// RoutingRules: Ordered list of routing rules defining how traffic to
	// this environment group's hostnames should be routed to different
	// environments.
	RoutingRules []*GoogleCloudApigeeV1RoutingRule `json:"routingRules,omitempty"`

	// Uid: A unique id for the environment group config that will only
	// change if the environment group is deleted and recreated.
	Uid string `json:"uid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "EndpointChainingRules") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndpointChainingRules") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1EnvironmentGroupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1EnvironmentGroupConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ExpireDeveloperSubscriptionRequest: Request for
// ExpireDeveloperSubscription.
type GoogleCloudApigeeV1ExpireDeveloperSubscriptionRequest struct {
}

// GoogleCloudApigeeV1Export: Details of an export job.
type GoogleCloudApigeeV1Export struct {
	// Created: Output only. Time the export job was created.
	Created string `json:"created,omitempty"`

	// DatastoreName: Name of the datastore that is the destination of the
	// export job [datastore]
	DatastoreName string `json:"datastoreName,omitempty"`

	// Description: Description of the export job.
	Description string `json:"description,omitempty"`

	// Error: Output only. Error is set when export fails
	Error string `json:"error,omitempty"`

	// ExecutionTime: Output only. Execution time for this export job. If
	// the job is still in progress, it will be set to the amount of time
	// that has elapsed since`created`, in seconds. Else, it will set to
	// (`updated` - `created`), in seconds.
	ExecutionTime string `json:"executionTime,omitempty"`

	// Name: Display name of the export job.
	Name string `json:"name,omitempty"`

	// Self: Output only. Self link of the export job. A URI that can be
	// used to retrieve the status of an export job. Example:
	// `/organizations/myorg/environments/myenv/analytics/exports/9cfc0d85-0f
	// 30-46d6-ae6f-318d0cb961bd`
	Self string `json:"self,omitempty"`

	// State: Output only. Status of the export job. Valid values include
	// `enqueued`, `running`, `completed`, and `failed`.
	State string `json:"state,omitempty"`

	// Updated: Output only. Time the export job was last updated.
	Updated string `json:"updated,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Created") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Created") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Export) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Export
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ExportRequest: Request body for
// [CreateExportRequest]
type GoogleCloudApigeeV1ExportRequest struct {
	// CsvDelimiter: Optional. Delimiter used in the CSV file, if
	// `outputFormat` is set to `csv`. Defaults to the `,` (comma)
	// character. Supported delimiter characters include comma (`,`), pipe
	// (`|`), and tab (`\t`).
	CsvDelimiter string `json:"csvDelimiter,omitempty"`

	// DatastoreName: Required. Name of the preconfigured datastore.
	DatastoreName string `json:"datastoreName,omitempty"`

	// DateRange: Required. Date range of the data to export.
	DateRange *GoogleCloudApigeeV1DateRange `json:"dateRange,omitempty"`

	// Description: Optional. Description of the export job.
	Description string `json:"description,omitempty"`

	// Name: Required. Display name of the export job.
	Name string `json:"name,omitempty"`

	// OutputFormat: Optional. Output format of the export. Valid values
	// include: `csv` or `json`. Defaults to `json`. Note: Configure the
	// delimiter for CSV output using the `csvDelimiter` property.
	OutputFormat string `json:"outputFormat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CsvDelimiter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CsvDelimiter") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ExportRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ExportRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1FlowHook struct {
	// ContinueOnError: Optional. Flag that specifies whether execution
	// should continue if the flow hook throws an exception. Set to `true`
	// to continue execution. Set to `false` to stop execution if the flow
	// hook throws an exception. Defaults to `true`.
	ContinueOnError bool `json:"continueOnError,omitempty"`

	// Description: Description of the flow hook.
	Description string `json:"description,omitempty"`

	// FlowHookPoint: Output only. Where in the API call flow the flow hook
	// is invoked. Must be one of `PreProxyFlowHook`, `PostProxyFlowHook`,
	// `PreTargetFlowHook`, or `PostTargetFlowHook`.
	FlowHookPoint string `json:"flowHookPoint,omitempty"`

	// SharedFlow: Shared flow attached to this flow hook, or empty if there
	// is none attached.
	SharedFlow string `json:"sharedFlow,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ContinueOnError") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContinueOnError") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1FlowHook) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1FlowHook
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1FlowHookConfig struct {
	// ContinueOnError: Flag that specifies whether the flow should abort
	// after an error in the flow hook. Defaults to `true` (continue on
	// error).
	ContinueOnError bool `json:"continueOnError,omitempty"`

	// Name: Name of the flow hook in the following format:
	// `organizations/{org}/environments/{env}/flowhooks/{point}`. Valid
	// `point` values include: `PreProxyFlowHook`, `PostProxyFlowHook`,
	// `PreTargetFlowHook`, and `PostTargetFlowHook`
	Name string `json:"name,omitempty"`

	// SharedFlowName: Name of the shared flow to invoke in the following
	// format: `organizations/{org}/sharedflows/{sharedflow}`
	SharedFlowName string `json:"sharedFlowName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ContinueOnError") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ContinueOnError") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1FlowHookConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1FlowHookConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GenerateDownloadUrlRequest: Request for
// GenerateDownloadUrl method.
type GoogleCloudApigeeV1GenerateDownloadUrlRequest struct {
}

// GoogleCloudApigeeV1GenerateDownloadUrlResponse: Response for
// GenerateDownloadUrl method.
type GoogleCloudApigeeV1GenerateDownloadUrlResponse struct {
	// DownloadUri: The Google Cloud Storage signed URL that can be used to
	// download the Archive zip file.
	DownloadUri string `json:"downloadUri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DownloadUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DownloadUri") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GenerateDownloadUrlResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GenerateDownloadUrlResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GenerateUploadUrlRequest: Request for
// GenerateUploadUrl method.
type GoogleCloudApigeeV1GenerateUploadUrlRequest struct {
}

// GoogleCloudApigeeV1GenerateUploadUrlResponse: Response for
// GenerateUploadUrl method.
type GoogleCloudApigeeV1GenerateUploadUrlResponse struct {
	// UploadUri: The Google Cloud Storage signed URL that can be used to
	// upload a new Archive zip file.
	UploadUri string `json:"uploadUri,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "UploadUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "UploadUri") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GenerateUploadUrlResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GenerateUploadUrlResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GetAsyncQueryResultUrlResponse: The response for
// GetAsyncQueryResultUrl
type GoogleCloudApigeeV1GetAsyncQueryResultUrlResponse struct {
	// Urls: The list of Signed URLs generated by the CreateAsyncQuery
	// request
	Urls []*GoogleCloudApigeeV1GetAsyncQueryResultUrlResponseURLInfo `json:"urls,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Urls") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Urls") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GetAsyncQueryResultUrlResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GetAsyncQueryResultUrlResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GetAsyncQueryResultUrlResponseURLInfo: A Signed
// URL and the relevant metadata associated with it.
type GoogleCloudApigeeV1GetAsyncQueryResultUrlResponseURLInfo struct {
	// Md5: The MD5 Hash of the JSON data
	Md5 string `json:"md5,omitempty"`

	// SizeBytes: The size of the returned file in bytes
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`

	// Uri: The signed URL of the JSON data. Will be of the form
	// `https://storage.googleapis.com/example-bucket/cat.jpeg?X-Goog-Algorit
	// hm=
	// GOOG4-RSA-SHA256&X-Goog-Credential=example%40example-project.iam.gserv
	// iceaccount
	// .com%2F20181026%2Fus-central1%2Fstorage%2Fgoog4_request&X-Goog-Date=20
	// 181026T18
	// 1309Z&X-Goog-Expires=900&X-Goog-SignedHeaders=host&X-Goog-Signature=24
	// 7a2aa45f16
	// 9edf4d187d54e7cc46e4731b1e6273242c4f4c39a1d2507a0e58706e25e3a85a7dbb89
	// 1d62afa849
	// 6def8e260c1db863d9ace85ff0a184b894b117fe46d1225c82f2aa19efd52cf21d3e20
	// 22b3b868dc
	// c1aca2741951ed5bf3bb25a34f5e9316a2841e8ff4c530b22ceaa1c5ce09c7cbb57326
	// 31510c2058
	// 0e61723f5594de3aea497f195456a2ff2bdd0d13bad47289d8611b6f9cfeef0c46c91a
	// 455b94e90a
	// 66924f722292d21e24d31dcfb38ce0c0f353ffa5a9756fc2a9f2b40bc2113206a81e32
	// 4fc4fd6823
	// a29163fa845c8ae7eca1fcf6e5bb48b3200983c56c5ca81fffb151cca7402beddfc4a7
	// 6b13344703 2ea7abedc098d2eb14a7`
	Uri string `json:"uri,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Md5") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Md5") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GetAsyncQueryResultUrlResponseURLInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GetAsyncQueryResultUrlResponseURLInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GetSyncAuthorizationRequest: Request for
// GetSyncAuthorization.
type GoogleCloudApigeeV1GetSyncAuthorizationRequest struct {
}

// GoogleCloudApigeeV1GraphQLOperation: Represents the pairing of
// GraphQL operation types and the GraphQL operation name.
type GoogleCloudApigeeV1GraphQLOperation struct {
	// Operation: GraphQL operation name. The name and operation type will
	// be used to apply quotas. If no name is specified, the quota will be
	// applied to all GraphQL operations irrespective of their operation
	// names in the payload.
	Operation string `json:"operation,omitempty"`

	// OperationTypes: Required. GraphQL operation types. Valid values
	// include `query` or `mutation`. **Note**: Apigee does not currently
	// support `subscription` types.
	OperationTypes []string `json:"operationTypes,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Operation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Operation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GraphQLOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GraphQLOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GraphQLOperationConfig: Binds the resources in a
// proxy or remote service with the GraphQL operation and its associated
// quota enforcement.
type GoogleCloudApigeeV1GraphQLOperationConfig struct {
	// ApiSource: Required. Name of the API proxy endpoint or remote service
	// with which the GraphQL operation and quota are associated.
	ApiSource string `json:"apiSource,omitempty"`

	// Attributes: Custom attributes associated with the operation.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// Operations: Required. List of GraphQL name/operation type pairs for
	// the proxy or remote service to which quota will be applied. If only
	// operation types are specified, the quota will be applied to all
	// GraphQL requests irrespective of the GraphQL name. **Note**:
	// Currently, you can specify only a single GraphQLOperation. Specifying
	// more than one will cause the operation to fail.
	Operations []*GoogleCloudApigeeV1GraphQLOperation `json:"operations,omitempty"`

	// Quota: Quota parameters to be enforced for the resources, methods,
	// and API source combination. If none are specified, quota enforcement
	// will not be done.
	Quota *GoogleCloudApigeeV1Quota `json:"quota,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GraphQLOperationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GraphQLOperationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GraphQLOperationGroup: List of graphQL operation
// configuration details associated with Apigee API proxies or remote
// services. Remote services are non-Apigee proxies, such as
// Istio-Envoy.
type GoogleCloudApigeeV1GraphQLOperationGroup struct {
	// OperationConfigType: Flag that specifies whether the configuration is
	// for Apigee API proxy or a remote service. Valid values include
	// `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when
	// Apigee API proxies are associated with the API product. Set to
	// `remoteservice` when non-Apigee proxies like Istio-Envoy are
	// associated with the API product.
	OperationConfigType string `json:"operationConfigType,omitempty"`

	// OperationConfigs: Required. List of operation configurations for
	// either Apigee API proxies or other remote services that are
	// associated with this API product.
	OperationConfigs []*GoogleCloudApigeeV1GraphQLOperationConfig `json:"operationConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperationConfigType")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperationConfigType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GraphQLOperationGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GraphQLOperationGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GraphqlDocumentation: GraphQL documentation for a
// catalog item.
type GoogleCloudApigeeV1GraphqlDocumentation struct {
	// EndpointUri: Required. The GraphQL endpoint URI to be queried by API
	// consumers. Max length is 2,083 characters.
	EndpointUri string `json:"endpointUri,omitempty"`

	// Schema: Required. The documentation file contents for the GraphQL
	// schema.
	Schema *GoogleCloudApigeeV1DocumentationFile `json:"schema,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndpointUri") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndpointUri") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GraphqlDocumentation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GraphqlDocumentation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GrpcOperationConfig: Binds the resources in a
// proxy or remote service with the gRPC operation and its associated
// quota enforcement.
type GoogleCloudApigeeV1GrpcOperationConfig struct {
	// ApiSource: Required. Name of the API proxy with which the gRPC
	// operation and quota are associated.
	ApiSource string `json:"apiSource,omitempty"`

	// Attributes: Custom attributes associated with the operation.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// Methods: List of unqualified gRPC method names for the proxy to which
	// quota will be applied. If this field is empty, the Quota will apply
	// to all operations on the gRPC service defined on the proxy. Example:
	// Given a proxy that is configured to serve com.petstore.PetService,
	// the methods com.petstore.PetService.ListPets and
	// com.petstore.PetService.GetPet would be specified here as simply
	// ["ListPets", "GetPet"].
	Methods []string `json:"methods,omitempty"`

	// Quota: Quota parameters to be enforced for the methods and API source
	// combination. If none are specified, quota enforcement will not be
	// done.
	Quota *GoogleCloudApigeeV1Quota `json:"quota,omitempty"`

	// Service: Required. gRPC Service name associated to be associated with
	// the API proxy, on which quota rules can be applied upon.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GrpcOperationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GrpcOperationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1GrpcOperationGroup: List of gRPC operation
// configuration details associated with Apigee API proxies.
type GoogleCloudApigeeV1GrpcOperationGroup struct {
	// OperationConfigs: Required. List of operation configurations for
	// either Apigee API proxies that are associated with this API product.
	OperationConfigs []*GoogleCloudApigeeV1GrpcOperationConfig `json:"operationConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperationConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperationConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1GrpcOperationGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1GrpcOperationGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1IngressConfig struct {
	// EnvironmentGroups: List of environment groups in the organization.
	EnvironmentGroups []*GoogleCloudApigeeV1EnvironmentGroupConfig `json:"environmentGroups,omitempty"`

	// Name: Name of the resource in the following format:
	// `organizations/{org}/deployedIngressConfig`.
	Name string `json:"name,omitempty"`

	// RevisionCreateTime: Time at which the IngressConfig revision was
	// created.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`

	// RevisionId: Revision id that defines the ordering on IngressConfig
	// resources. The higher the revision, the more recently the
	// configuration was deployed.
	RevisionId int64 `json:"revisionId,omitempty,string"`

	// Uid: A unique id for the ingress config that will only change if the
	// organization is deleted and recreated.
	Uid string `json:"uid,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EnvironmentGroups")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnvironmentGroups") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1IngressConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1IngressConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Instance: Apigee runtime instance.
type GoogleCloudApigeeV1Instance struct {
	// AccessLoggingConfig: Optional. Access logging configuration enables
	// the access logging feature at the instance. Apigee customers can
	// enable access logging to ship the access logs to their own project's
	// cloud logging.
	AccessLoggingConfig *GoogleCloudApigeeV1AccessLoggingConfig `json:"accessLoggingConfig,omitempty"`

	// ConsumerAcceptList: Optional. Customer accept list represents the
	// list of projects (id/number) on customer side that can privately
	// connect to the service attachment. It is an optional field which the
	// customers can provide during the instance creation. By default, the
	// customer project associated with the Apigee organization will be
	// included to the list.
	ConsumerAcceptList []string `json:"consumerAcceptList,omitempty"`

	// CreatedAt: Output only. Time the instance was created in milliseconds
	// since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Description: Optional. Description of the instance.
	Description string `json:"description,omitempty"`

	// DiskEncryptionKeyName: Customer Managed Encryption Key (CMEK) used
	// for disk and volume encryption. Required for Apigee paid
	// subscriptions only. Use the following format:
	// `projects/([^/]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+
	// )`
	DiskEncryptionKeyName string `json:"diskEncryptionKeyName,omitempty"`

	// DisplayName: Optional. Display name for the instance.
	DisplayName string `json:"displayName,omitempty"`

	// Host: Output only. Internal hostname or IP address of the Apigee
	// endpoint used by clients to connect to the service.
	Host string `json:"host,omitempty"`

	// IpRange: Optional. Comma-separated list of CIDR blocks of length 22
	// and/or 28 used to create the Apigee instance. Providing CIDR ranges
	// is optional. You can provide just /22 or /28 or both (or neither).
	// Ranges you provide should be freely available as part of a larger
	// named range you have allocated to the Service Networking peering. If
	// this parameter is not provided, Apigee automatically requests an
	// available /22 and /28 CIDR block from Service Networking. Use the /22
	// CIDR block for configuring your firewall needs to allow traffic from
	// Apigee. Input formats: `a.b.c.d/22` or `e.f.g.h/28` or
	// `a.b.c.d/22,e.f.g.h/28`
	IpRange string `json:"ipRange,omitempty"`

	// LastModifiedAt: Output only. Time the instance was last modified in
	// milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Location: Required. Compute Engine location where the instance
	// resides.
	Location string `json:"location,omitempty"`

	// Name: Required. Resource ID of the instance. Values must match the
	// regular expression `^a-z{0,30}[a-z\d]$`.
	Name string `json:"name,omitempty"`

	// PeeringCidrRange: Optional. Size of the CIDR block range that will be
	// reserved by the instance. PAID organizations support `SLASH_16` to
	// `SLASH_20` and defaults to `SLASH_16`. Evaluation organizations
	// support only `SLASH_23`.
	//
	// Possible values:
	//   "CIDR_RANGE_UNSPECIFIED" - Range not specified.
	//   "SLASH_16" - `/16` CIDR range.
	//   "SLASH_17" - `/17` CIDR range.
	//   "SLASH_18" - `/18` CIDR range.
	//   "SLASH_19" - `/19` CIDR range.
	//   "SLASH_20" - `/20` CIDR range.
	//   "SLASH_22" - `/22` CIDR range. Supported for evaluation only.
	//   "SLASH_23" - `/23` CIDR range. Supported for evaluation only.
	PeeringCidrRange string `json:"peeringCidrRange,omitempty"`

	// Port: Output only. Port number of the exposed Apigee endpoint.
	Port string `json:"port,omitempty"`

	// RuntimeVersion: Output only. Version of the runtime system running in
	// the instance. The runtime system is the set of components that serve
	// the API Proxy traffic in your Environments.
	RuntimeVersion string `json:"runtimeVersion,omitempty"`

	// ServiceAttachment: Output only. Resource name of the service
	// attachment created for the instance in the format:
	// `projects/*/regions/*/serviceAttachments/*` Apigee customers can
	// privately forward traffic to this service attachment using the PSC
	// endpoints.
	ServiceAttachment string `json:"serviceAttachment,omitempty"`

	// State: Output only. State of the instance. Values other than `ACTIVE`
	// means the resource is not ready to use.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Resource is in an unspecified state.
	//   "CREATING" - Resource is being created.
	//   "ACTIVE" - Resource is provisioned and ready to use.
	//   "DELETING" - The resource is being deleted.
	//   "UPDATING" - The resource is being updated.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AccessLoggingConfig")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessLoggingConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Instance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Instance
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1InstanceAttachment: InstanceAttachment represents
// the installation of an environment onto an instance.
type GoogleCloudApigeeV1InstanceAttachment struct {
	// CreatedAt: Output only. Time the attachment was created in
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Environment: ID of the attached environment.
	Environment string `json:"environment,omitempty"`

	// Name: Output only. ID of the attachment.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreatedAt") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreatedAt") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1InstanceAttachment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1InstanceAttachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1InstanceDeploymentStatus: The status of a
// deployment as reported by a single instance.
type GoogleCloudApigeeV1InstanceDeploymentStatus struct {
	// DeployedRevisions: Revisions currently deployed in MPs.
	DeployedRevisions []*GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision `json:"deployedRevisions,omitempty"`

	// DeployedRoutes: Current routes deployed in the ingress routing table.
	// A route which is missing will appear in `missing_routes`.
	DeployedRoutes []*GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute `json:"deployedRoutes,omitempty"`

	// Instance: ID of the instance reporting the status.
	Instance string `json:"instance,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DeployedRevisions")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeployedRevisions") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1InstanceDeploymentStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1InstanceDeploymentStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision:
// Revisions deployed in the MPs.
type GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision struct {
	// Percentage: Percentage of MP replicas reporting this revision.
	Percentage int64 `json:"percentage,omitempty"`

	// Revision: API proxy revision reported as deployed.
	Revision string `json:"revision,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Percentage") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Percentage") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRevision
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute: Route
// deployed in the ingress routing table.
type GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute struct {
	// Basepath: Base path in the routing table.
	Basepath string `json:"basepath,omitempty"`

	// Envgroup: Environment group where this route is installed.
	Envgroup string `json:"envgroup,omitempty"`

	// Environment: Destination environment. This will be empty if the route
	// is not yet reported.
	Environment string `json:"environment,omitempty"`

	// Percentage: Percentage of ingress replicas reporting this route.
	Percentage int64 `json:"percentage,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Basepath") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Basepath") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1InstanceDeploymentStatusDeployedRoute
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1IntegrationConfig: Configuration for the
// Integration add-on.
type GoogleCloudApigeeV1IntegrationConfig struct {
	// Enabled: Flag that specifies whether the Integration add-on is
	// enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1IntegrationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1IntegrationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1KeyAliasReference struct {
	// AliasId: Alias ID. Must exist in the keystore referred to by the
	// reference.
	AliasId string `json:"aliasId,omitempty"`

	// Reference: Reference name in the following format:
	// `organizations/{org}/environments/{env}/references/{reference}`
	Reference string `json:"reference,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AliasId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AliasId") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1KeyAliasReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1KeyAliasReference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1KeyValueEntry: Key value map pair where the value
// represents the data associated with the corresponding key. **Note**:
// Supported for Apigee hybrid 1.8.x and higher.
type GoogleCloudApigeeV1KeyValueEntry struct {
	// Name: Resource URI that can be used to identify the scope of the key
	// value map entries.
	Name string `json:"name,omitempty"`

	// Value: Required. Data or payload that is being retrieved and
	// associated with the unique key.
	Value string `json:"value,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1KeyValueEntry) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1KeyValueEntry
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1KeyValueMap: Collection of key/value string pairs.
type GoogleCloudApigeeV1KeyValueMap struct {
	// Encrypted: Required. Flag that specifies whether entry values will be
	// encrypted. This field is retained for backward compatibility and the
	// value of encrypted will always be `true`. Apigee X and hybrid do not
	// support unencrypted key value maps.
	Encrypted bool `json:"encrypted,omitempty"`

	// Name: Required. ID of the key value map.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Encrypted") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Encrypted") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1KeyValueMap) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1KeyValueMap
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Keystore: Datastore for Certificates and Aliases.
type GoogleCloudApigeeV1Keystore struct {
	// Aliases: Output only. Aliases in this keystore.
	Aliases []string `json:"aliases,omitempty"`

	// Name: Required. Resource ID for this keystore. Values must match the
	// regular expression `[\w[:space:].-]{1,255}`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Aliases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Aliases") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Keystore) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Keystore
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1KeystoreConfig struct {
	// Aliases: Aliases in the keystore.
	Aliases []*GoogleCloudApigeeV1AliasRevisionConfig `json:"aliases,omitempty"`

	// Name: Resource name in the following format:
	// `organizations/{org}/environments/{env}/keystores/{keystore}`
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Aliases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Aliases") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1KeystoreConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1KeystoreConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListApiCategoriesResponse: The response for
// `ListApiCategoriesRequest`. Next ID: 6
type GoogleCloudApigeeV1ListApiCategoriesResponse struct {
	// Data: The API category resources.
	Data []*GoogleCloudApigeeV1ApiCategory `json:"data,omitempty"`

	// ErrorCode: Unique error code for the request, if any.
	ErrorCode string `json:"errorCode,omitempty"`

	// Message: Description of the operation.
	Message string `json:"message,omitempty"`

	// RequestId: Unique ID of the request.
	RequestId string `json:"requestId,omitempty"`

	// Status: Status of the operation.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListApiCategoriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListApiCategoriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListApiDocsResponse struct {
	// Data: The catalog item resources.
	Data []*GoogleCloudApigeeV1ApiDoc `json:"data,omitempty"`

	// ErrorCode: Unique error code for the request, if any.
	ErrorCode string `json:"errorCode,omitempty"`

	// Message: Description of the operation.
	Message string `json:"message,omitempty"`

	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// RequestId: Unique ID of the request.
	RequestId string `json:"requestId,omitempty"`

	// Status: Status of the operation.
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListApiDocsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListApiDocsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListApiProductsResponse struct {
	// ApiProduct: Lists all API product names defined for an organization.
	ApiProduct []*GoogleCloudApigeeV1ApiProduct `json:"apiProduct,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProduct") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProduct") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListApiProductsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListApiProductsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListApiProxiesResponse: To change this message, in
// the same CL add a change log in go/changing-api-proto-breaks-ui
type GoogleCloudApigeeV1ListApiProxiesResponse struct {
	Proxies []*GoogleCloudApigeeV1ApiProxy `json:"proxies,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Proxies") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Proxies") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListApiProxiesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListApiProxiesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListAppGroupAppsResponse: Response for
// ListAppGroupApps
type GoogleCloudApigeeV1ListAppGroupAppsResponse struct {
	// AppGroupApps: List of AppGroup apps and their credentials.
	AppGroupApps []*GoogleCloudApigeeV1AppGroupApp `json:"appGroupApps,omitempty"`

	// NextPageToken: Token that can be sent as `next_page_token` to
	// retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppGroupApps") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppGroupApps") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListAppGroupAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListAppGroupAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListAppGroupsResponse: ListAppGroupsResponse
// contains the 0 or more AppGroups, along with the optional page token
// and the total count of apps.
type GoogleCloudApigeeV1ListAppGroupsResponse struct {
	// AppGroups: List of AppGroups.
	AppGroups []*GoogleCloudApigeeV1AppGroup `json:"appGroups,omitempty"`

	// NextPageToken: Token that can be sent as `next_page_token` to
	// retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total count of AppGroups.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AppGroups") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppGroups") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListAppGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListAppGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListAppsResponse struct {
	App []*GoogleCloudApigeeV1App `json:"app,omitempty"`

	// NextPageToken: Token that can be sent as `next_page_token` to
	// retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TotalSize: Total count of Apps.
	TotalSize int64 `json:"totalSize,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "App") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "App") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListArchiveDeploymentsResponse: Response for
// ListArchiveDeployments method.
type GoogleCloudApigeeV1ListArchiveDeploymentsResponse struct {
	// ArchiveDeployments: Archive Deployments in the specified environment.
	ArchiveDeployments []*GoogleCloudApigeeV1ArchiveDeployment `json:"archiveDeployments,omitempty"`

	// NextPageToken: Page token that you can include in a
	// ListArchiveDeployments request to retrieve the next page. If omitted,
	// no subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ArchiveDeployments")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ArchiveDeployments") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListArchiveDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListArchiveDeploymentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListAsyncQueriesResponse: The response for
// ListAsyncQueries.
type GoogleCloudApigeeV1ListAsyncQueriesResponse struct {
	// Queries: The asynchronous queries belong to requested resource name.
	Queries []*GoogleCloudApigeeV1AsyncQuery `json:"queries,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Queries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Queries") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListAsyncQueriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListAsyncQueriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListCustomReportsResponse: This message
// encapsulates a list of custom report definitions
type GoogleCloudApigeeV1ListCustomReportsResponse struct {
	Qualifier []*GoogleCloudApigeeV1CustomReport `json:"qualifier,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Qualifier") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Qualifier") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListCustomReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListCustomReportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListDataCollectorsResponse: Response for
// ListDataCollectors.
type GoogleCloudApigeeV1ListDataCollectorsResponse struct {
	// DataCollectors: Data collectors in the specified organization.
	DataCollectors []*GoogleCloudApigeeV1DataCollector `json:"dataCollectors,omitempty"`

	// NextPageToken: Page token that you can include in a
	// ListDataCollectors request to retrieve the next page. If omitted, no
	// subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DataCollectors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DataCollectors") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListDataCollectorsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListDataCollectorsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListDatastoresResponse: The response for
// ListDatastores
type GoogleCloudApigeeV1ListDatastoresResponse struct {
	// Datastores: A list of datastores
	Datastores []*GoogleCloudApigeeV1Datastore `json:"datastores,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Datastores") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Datastores") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListDatastoresResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListDatastoresResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListDebugSessionsResponse struct {
	// NextPageToken: Page token that you can include in a
	// ListDebugSessionsRequest to retrieve the next page. If omitted, no
	// subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Sessions: Session info that includes debug session ID and the first
	// transaction creation timestamp.
	Sessions []*GoogleCloudApigeeV1Session `json:"sessions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListDebugSessionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListDebugSessionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListDeploymentsResponse struct {
	// Deployments: List of deployments.
	Deployments []*GoogleCloudApigeeV1Deployment `json:"deployments,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Deployments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Deployments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListDeploymentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListDeploymentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListDeveloperAppsResponse struct {
	// App: List of developer apps and their credentials.
	App []*GoogleCloudApigeeV1DeveloperApp `json:"app,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "App") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "App") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListDeveloperAppsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListDeveloperAppsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListDeveloperSubscriptionsResponse: Response for
// ListDeveloperSubscriptions.
type GoogleCloudApigeeV1ListDeveloperSubscriptionsResponse struct {
	// DeveloperSubscriptions: List of all subscriptions.
	DeveloperSubscriptions []*GoogleCloudApigeeV1DeveloperSubscription `json:"developerSubscriptions,omitempty"`

	// NextStartKey: Value that can be sent as `startKey` to retrieve the
	// next page of content. If this field is omitted, there are no
	// subsequent pages.
	NextStartKey string `json:"nextStartKey,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "DeveloperSubscriptions") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DeveloperSubscriptions")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListDeveloperSubscriptionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListDeveloperSubscriptionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListEndpointAttachmentsResponse: Response for
// ListEndpointAttachments method.
type GoogleCloudApigeeV1ListEndpointAttachmentsResponse struct {
	// EndpointAttachments: Endpoint attachments in the specified
	// organization.
	EndpointAttachments []*GoogleCloudApigeeV1EndpointAttachment `json:"endpointAttachments,omitempty"`

	// NextPageToken: Page token that you can include in an
	// `ListEndpointAttachments` request to retrieve the next page. If
	// omitted, no subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EndpointAttachments")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndpointAttachments") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListEndpointAttachmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListEndpointAttachmentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListEnvironmentGroupAttachmentsResponse: Response
// for ListEnvironmentGroupAttachments.
type GoogleCloudApigeeV1ListEnvironmentGroupAttachmentsResponse struct {
	// EnvironmentGroupAttachments: EnvironmentGroupAttachments for the
	// specified environment group.
	EnvironmentGroupAttachments []*GoogleCloudApigeeV1EnvironmentGroupAttachment `json:"environmentGroupAttachments,omitempty"`

	// NextPageToken: Page token that you can include in a
	// ListEnvironmentGroupAttachments request to retrieve the next page. If
	// omitted, no subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "EnvironmentGroupAttachments") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "EnvironmentGroupAttachments") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListEnvironmentGroupAttachmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListEnvironmentGroupAttachmentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListEnvironmentGroupsResponse: Response for
// ListEnvironmentGroups.
type GoogleCloudApigeeV1ListEnvironmentGroupsResponse struct {
	// EnvironmentGroups: EnvironmentGroups in the specified organization.
	EnvironmentGroups []*GoogleCloudApigeeV1EnvironmentGroup `json:"environmentGroups,omitempty"`

	// NextPageToken: Page token that you can include in a
	// ListEnvironmentGroups request to retrieve the next page. If omitted,
	// no subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "EnvironmentGroups")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EnvironmentGroups") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListEnvironmentGroupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListEnvironmentGroupsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListEnvironmentResourcesResponse: Response for
// ListEnvironmentResources
type GoogleCloudApigeeV1ListEnvironmentResourcesResponse struct {
	// ResourceFile: List of resources files.
	ResourceFile []*GoogleCloudApigeeV1ResourceFile `json:"resourceFile,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ResourceFile") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceFile") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListEnvironmentResourcesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListEnvironmentResourcesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListExportsResponse: The response for ListExports
type GoogleCloudApigeeV1ListExportsResponse struct {
	// Exports: Details of the export jobs.
	Exports []*GoogleCloudApigeeV1Export `json:"exports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Exports") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Exports") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListExportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListExportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListHybridIssuersResponse struct {
	// Issuers: Lists of hybrid services and its trusted issuer email ids.
	Issuers []*GoogleCloudApigeeV1ServiceIssuersMapping `json:"issuers,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Issuers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Issuers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListHybridIssuersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListHybridIssuersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListInstanceAttachmentsResponse: Response for
// ListInstanceAttachments.
type GoogleCloudApigeeV1ListInstanceAttachmentsResponse struct {
	// Attachments: Attachments for the instance.
	Attachments []*GoogleCloudApigeeV1InstanceAttachment `json:"attachments,omitempty"`

	// NextPageToken: Page token that you can include in a
	// ListInstanceAttachments request to retrieve the next page of content.
	// If omitted, no subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attachments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attachments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListInstanceAttachmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListInstanceAttachmentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListInstancesResponse: Response for ListInstances.
type GoogleCloudApigeeV1ListInstancesResponse struct {
	// Instances: Instances in the specified organization.
	Instances []*GoogleCloudApigeeV1Instance `json:"instances,omitempty"`

	// NextPageToken: Page token that you can include in a ListInstance
	// request to retrieve the next page of content. If omitted, no
	// subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Instances") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListInstancesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListInstancesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListKeyValueEntriesResponse: The request structure
// for listing key value map keys and its corresponding values.
type GoogleCloudApigeeV1ListKeyValueEntriesResponse struct {
	// KeyValueEntries: One or more key value map keys and values.
	KeyValueEntries []*GoogleCloudApigeeV1KeyValueEntry `json:"keyValueEntries,omitempty"`

	// NextPageToken: Token that can be sent as `next_page_token` to
	// retrieve the next page. If this field is omitted, there are no
	// subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "KeyValueEntries") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "KeyValueEntries") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListKeyValueEntriesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListKeyValueEntriesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListNatAddressesResponse: Response for
// ListNatAddresses.
type GoogleCloudApigeeV1ListNatAddressesResponse struct {
	// NatAddresses: List of NAT Addresses for the instance.
	NatAddresses []*GoogleCloudApigeeV1NatAddress `json:"natAddresses,omitempty"`

	// NextPageToken: Page token that you can include in a ListNatAddresses
	// request to retrieve the next page of content. If omitted, no
	// subsequent pages exist.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NatAddresses") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NatAddresses") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListNatAddressesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListNatAddressesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListOfDevelopersResponse struct {
	// Developer: List of developers.
	Developer []*GoogleCloudApigeeV1Developer `json:"developer,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Developer") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Developer") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListOfDevelopersResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListOfDevelopersResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ListOrganizationsResponse struct {
	// Organizations: List of Apigee organizations and associated Google
	// Cloud projects.
	Organizations []*GoogleCloudApigeeV1OrganizationProjectMapping `json:"organizations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Organizations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Organizations") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListOrganizationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListOrganizationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListRatePlansResponse: Response for ListRatePlans.
type GoogleCloudApigeeV1ListRatePlansResponse struct {
	// NextStartKey: Value that can be sent as `startKey` to retrieve the
	// next page of content. If this field is omitted, there are no
	// subsequent pages.
	NextStartKey string `json:"nextStartKey,omitempty"`

	// RatePlans: List of rate plans in an organization.
	RatePlans []*GoogleCloudApigeeV1RatePlan `json:"ratePlans,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextStartKey") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextStartKey") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListRatePlansResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListRatePlansResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListSecurityActionsResponse: Contains a list of
// SecurityActions in response to a ListSecurityActionRequest.
type GoogleCloudApigeeV1ListSecurityActionsResponse struct {
	// NextPageToken: A token, which can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SecurityActions: The SecurityActions for the specified environment.
	SecurityActions []*GoogleCloudApigeeV1SecurityAction `json:"securityActions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListSecurityActionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListSecurityActionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListSecurityIncidentsResponse: Response for
// ListSecurityIncidents.
type GoogleCloudApigeeV1ListSecurityIncidentsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SecurityIncidents: List of security incidents in the organization
	SecurityIncidents []*GoogleCloudApigeeV1SecurityIncident `json:"securityIncidents,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListSecurityIncidentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListSecurityIncidentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListSecurityProfileRevisionsResponse: Response for
// ListSecurityProfileRevisions.
type GoogleCloudApigeeV1ListSecurityProfileRevisionsResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SecurityProfiles: List of security profile revisions. The revisions
	// may be attached or unattached to any environment.
	SecurityProfiles []*GoogleCloudApigeeV1SecurityProfile `json:"securityProfiles,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListSecurityProfileRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListSecurityProfileRevisionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListSecurityProfilesResponse: Response for
// ListSecurityProfiles.
type GoogleCloudApigeeV1ListSecurityProfilesResponse struct {
	// NextPageToken: A token that can be sent as `page_token` to retrieve
	// the next page. If this field is omitted, there are no subsequent
	// pages.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SecurityProfiles: List of security profiles in the organization. The
	// profiles may be attached or unattached to any environment. This will
	// return latest revision of each profile.
	SecurityProfiles []*GoogleCloudApigeeV1SecurityProfile `json:"securityProfiles,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListSecurityProfilesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListSecurityProfilesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListSecurityReportsResponse: The response for
// SecurityReports.
type GoogleCloudApigeeV1ListSecurityReportsResponse struct {
	// NextPageToken: If the number of security reports exceeded the page
	// size requested, the token can be used to fetch the next page in a
	// subsequent call. If the response is the last page and there are no
	// more reports to return this field is left empty.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// SecurityReports: The security reports belong to requested resource
	// name.
	SecurityReports []*GoogleCloudApigeeV1SecurityReport `json:"securityReports,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListSecurityReportsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListSecurityReportsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListSharedFlowsResponse: To change this message,
// in the same CL add a change log in go/changing-api-proto-breaks-ui
type GoogleCloudApigeeV1ListSharedFlowsResponse struct {
	SharedFlows []*GoogleCloudApigeeV1SharedFlow `json:"sharedFlows,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "SharedFlows") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SharedFlows") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListSharedFlowsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListSharedFlowsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ListTraceConfigOverridesResponse: Response for
// ListTraceConfigOverrides.
type GoogleCloudApigeeV1ListTraceConfigOverridesResponse struct {
	// NextPageToken: Token value that can be passed as `page_token` to
	// retrieve the next page of content.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// TraceConfigOverrides: List all trace configuration overrides in an
	// environment.
	TraceConfigOverrides []*GoogleCloudApigeeV1TraceConfigOverride `json:"traceConfigOverrides,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ListTraceConfigOverridesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ListTraceConfigOverridesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Metadata: Encapsulates additional information
// about query execution.
type GoogleCloudApigeeV1Metadata struct {
	// Errors: List of error messages as strings.
	Errors []string `json:"errors,omitempty"`

	// Notices: List of additional information such as data source, if
	// result was truncated. For example: ``` "notices": [
	// "Source:Postgres", "PG Host:uappg0rw.e2e.apigeeks.net", "query served
	// by:4b64601e-40de-4eb1-bfb9-eeee7ac929ed", "Table used:
	// edge.api.uapgroup2.agg_api" ]```
	Notices []string `json:"notices,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Metadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Metadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Metric: Encapsulates the metric data point. For
// example: ```{ "name": "sum(message_count)", "values" : [ {
// "timestamp": 1549004400000, "value": "39.0" }, { "timestamp" :
// 1548997200000, "value" : "0.0" } ] }``` or ```{ "name":
// "sum(message_count)", "values" : ["39.0"] }```
type GoogleCloudApigeeV1Metric struct {
	// Name: Metric name.
	Name string `json:"name,omitempty"`

	// Values: List of metric values. Possible value formats include:
	// "values":["39.0"]` or "values":[ { "value": "39.0", "timestamp":
	// 1232434354} ]`
	Values []interface{} `json:"values,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Metric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Metric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1MetricAggregation: The optionally aggregated
// metric to query with its ordering.
type GoogleCloudApigeeV1MetricAggregation struct {
	// Aggregation: Aggregation function associated with the metric.
	//
	// Possible values:
	//   "AGGREGATION_FUNCTION_UNSPECIFIED" - Unspecified Aggregation
	// function.
	//   "AVG" - Average.
	//   "SUM" - Summation.
	//   "MIN" - Min.
	//   "MAX" - Max.
	//   "COUNT_DISTINCT" - Count distinct
	Aggregation string `json:"aggregation,omitempty"`

	// Name: Name of the metric
	Name string `json:"name,omitempty"`

	// Order: Ordering for this aggregation in the result. For time series
	// this is ignored since the ordering of points depends only on the
	// timestamp, not the values.
	//
	// Possible values:
	//   "ORDER_UNSPECIFIED" - Unspecified order. Default is Descending.
	//   "ASCENDING" - Ascending sort order.
	//   "DESCENDING" - Descending sort order.
	Order string `json:"order,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Aggregation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Aggregation") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1MetricAggregation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1MetricAggregation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1MonetizationConfig: Configuration for the
// Monetization add-on.
type GoogleCloudApigeeV1MonetizationConfig struct {
	// Enabled: Flag that specifies whether the Monetization add-on is
	// enabled.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1MonetizationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1MonetizationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1NatAddress: Apigee NAT(network address
// translation) address. A NAT address is a static external IP address
// used for Internet egress traffic.
type GoogleCloudApigeeV1NatAddress struct {
	// IpAddress: Output only. The static IPV4 address.
	IpAddress string `json:"ipAddress,omitempty"`

	// Name: Required. Resource ID of the NAT address.
	Name string `json:"name,omitempty"`

	// State: Output only. State of the nat address.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The resource is in an unspecified state.
	//   "CREATING" - The NAT address is being created.
	//   "RESERVED" - The NAT address is reserved but not yet used for
	// Internet egress.
	//   "ACTIVE" - The NAT address is active and used for Internet egress.
	//   "DELETING" - The NAT address is being deleted.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "IpAddress") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "IpAddress") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1NatAddress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1NatAddress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1NodeConfig: NodeConfig for setting the min/max
// number of nodes associated with the environment.
type GoogleCloudApigeeV1NodeConfig struct {
	// CurrentAggregateNodeCount: Output only. The current total number of
	// gateway nodes that each environment currently has across all
	// instances.
	CurrentAggregateNodeCount int64 `json:"currentAggregateNodeCount,omitempty,string"`

	// MaxNodeCount: Optional. The maximum total number of gateway nodes
	// that the is reserved for all instances that has the specified
	// environment. If not specified, the default is determined by the
	// recommended maximum number of nodes for that gateway.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty,string"`

	// MinNodeCount: Optional. The minimum total number of gateway nodes
	// that the is reserved for all instances that has the specified
	// environment. If not specified, the default is determined by the
	// recommended minimum number of nodes for that gateway.
	MinNodeCount int64 `json:"minNodeCount,omitempty,string"`

	// ForceSendFields is a list of field names (e.g.
	// "CurrentAggregateNodeCount") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "CurrentAggregateNodeCount") to include in API requests with the JSON
	// null value. By default, fields with empty values are omitted from API
	// requests. However, any field with an empty value appearing in
	// NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1NodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1NodeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1OASDocumentation: OpenAPI Specification
// documentation for a catalog item.
type GoogleCloudApigeeV1OASDocumentation struct {
	// Format: Output only. The format of the input specification file
	// contents.
	//
	// Possible values:
	//   "FORMAT_UNSPECIFIED" - The format is not available.
	//   "YAML" - YAML format.
	//   "JSON" - JSON format.
	Format string `json:"format,omitempty"`

	// Spec: Required. The documentation file contents for the OpenAPI
	// Specification. JSON and YAML file formats are supported.
	Spec *GoogleCloudApigeeV1DocumentationFile `json:"spec,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Format") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Format") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OASDocumentation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OASDocumentation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Operation: Represents the pairing of REST resource
// path and the actions (verbs) allowed on the resource path.
type GoogleCloudApigeeV1Operation struct {
	// Methods: methods refers to the REST verbs as in
	// https://www.w3.org/Protocols/rfc2616/rfc2616-sec9.html. When none
	// specified, all verb types are allowed.
	Methods []string `json:"methods,omitempty"`

	// Resource: Required. REST resource path associated with the API proxy
	// or remote service.
	Resource string `json:"resource,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Methods") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Methods") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Operation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Operation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1OperationConfig: Binds the resources in an API
// proxy or remote service with the allowed REST methods and associated
// quota enforcement.
type GoogleCloudApigeeV1OperationConfig struct {
	// ApiSource: Required. Name of the API proxy or remote service with
	// which the resources, methods, and quota are associated.
	ApiSource string `json:"apiSource,omitempty"`

	// Attributes: Custom attributes associated with the operation.
	Attributes []*GoogleCloudApigeeV1Attribute `json:"attributes,omitempty"`

	// Operations: List of resource/method pairs for the API proxy or remote
	// service to which quota will applied. **Note**: Currently, you can
	// specify only a single resource/method pair. The call will fail if
	// more than one resource/method pair is provided.
	Operations []*GoogleCloudApigeeV1Operation `json:"operations,omitempty"`

	// Quota: Quota parameters to be enforced for the resources, methods,
	// and API source combination. If none are specified, quota enforcement
	// will not be done.
	Quota *GoogleCloudApigeeV1Quota `json:"quota,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiSource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiSource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OperationConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OperationConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1OperationGroup: List of operation configuration
// details associated with Apigee API proxies or remote services. Remote
// services are non-Apigee proxies, such as Istio-Envoy.
type GoogleCloudApigeeV1OperationGroup struct {
	// OperationConfigType: Flag that specifes whether the configuration is
	// for Apigee API proxy or a remote service. Valid values include
	// `proxy` or `remoteservice`. Defaults to `proxy`. Set to `proxy` when
	// Apigee API proxies are associated with the API product. Set to
	// `remoteservice` when non-Apigee proxies like Istio-Envoy are
	// associated with the API product.
	OperationConfigType string `json:"operationConfigType,omitempty"`

	// OperationConfigs: Required. List of operation configurations for
	// either Apigee API proxies or other remote services that are
	// associated with this API product.
	OperationConfigs []*GoogleCloudApigeeV1OperationConfig `json:"operationConfigs,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperationConfigType")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperationConfigType") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OperationGroup) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OperationGroup
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1OperationMetadata: Metadata describing an
// Operation.
type GoogleCloudApigeeV1OperationMetadata struct {
	// Possible values:
	//   "OPERATION_TYPE_UNSPECIFIED"
	//   "INSERT"
	//   "DELETE"
	//   "UPDATE"
	OperationType string `json:"operationType,omitempty"`

	// Progress: Progress of the operation.
	Progress *GoogleCloudApigeeV1OperationMetadataProgress `json:"progress,omitempty"`

	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "NOT_STARTED"
	//   "IN_PROGRESS"
	//   "FINISHED"
	State string `json:"state,omitempty"`

	// TargetResourceName: Name of the resource for which the operation is
	// operating on.
	TargetResourceName string `json:"targetResourceName,omitempty"`

	// Warnings: Warnings encountered while executing the operation.
	Warnings []string `json:"warnings,omitempty"`

	// ForceSendFields is a list of field names (e.g. "OperationType") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "OperationType") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1OperationMetadataProgress: Information about
// operation progress.
type GoogleCloudApigeeV1OperationMetadataProgress struct {
	// Description: Description of the operation's progress.
	Description string `json:"description,omitempty"`

	// Details: The additional details of the progress.
	Details googleapi.RawMessage `json:"details,omitempty"`

	// PercentDone: The percentage of the operation progress.
	PercentDone int64 `json:"percentDone,omitempty"`

	// State: State of the operation.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED"
	//   "NOT_STARTED"
	//   "IN_PROGRESS"
	//   "FINISHED"
	State string `json:"state,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OperationMetadataProgress) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OperationMetadataProgress
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1OptimizedStats struct {
	// Response: Wraps the `stats` response for JavaScript Optimized
	// Scenario with a response key. For example: ```{ "Response": {
	// "TimeUnit": [], "metaData": { "errors": [], "notices": [
	// "Source:Postgres", "Table used: edge.api.aaxgroup001.agg_api", "PG
	// Host:ruappg08-ro.production.apigeeks.net", "query served
	// by:80c4ebca-6a10-4a2e-8faf-c60c1ee306ca" ] }, "resultTruncated":
	// false, "stats": { "data": [ { "identifier": { "names": [ "apiproxy"
	// ], "values": [ "sirjee" ] }, "metric": [ { "env": "prod", "name":
	// "sum(message_count)", "values": [ 36.0 ] }, { "env": "prod", "name":
	// "sum(is_error)", "values": [ 36.0 ] } ] } ] } } }```
	Response *GoogleCloudApigeeV1OptimizedStatsResponse `json:"Response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Response") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Response") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OptimizedStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OptimizedStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1OptimizedStatsNode: Encapsulates a data node as
// represented below: ``` { "identifier": { "names": [ "apiproxy" ],
// "values": [ "sirjee" ] }, "metric": [ { "env": "prod", "name":
// "sum(message_count)", "values": [ 36.0 ] } ] }``` or ``` { "env":
// "prod", "name": "sum(message_count)", "values": [ 36.0 ] }```
// Depending on whether a dimension is present in the query or not the
// data node type can be a simple metric value or dimension identifier
// with list of metrics.
type GoogleCloudApigeeV1OptimizedStatsNode struct {
	Data []interface{} `json:"data,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Data") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Data") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OptimizedStatsNode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OptimizedStatsNode
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1OptimizedStatsResponse: Encapsulates a response
// format for JavaScript Optimized Scenario.
type GoogleCloudApigeeV1OptimizedStatsResponse struct {
	// TimeUnit: List of time unit values. Time unit refers to an epoch
	// timestamp value.
	TimeUnit googleapi.Int64s `json:"TimeUnit,omitempty"`

	// MetaData: Metadata information about the query executed.
	MetaData *GoogleCloudApigeeV1Metadata `json:"metaData,omitempty"`

	// ResultTruncated: Boolean flag that indicates whether the results were
	// truncated based on the limit parameter.
	ResultTruncated bool `json:"resultTruncated,omitempty"`

	// Stats: `stats` results.
	Stats *GoogleCloudApigeeV1OptimizedStatsNode `json:"stats,omitempty"`

	// ForceSendFields is a list of field names (e.g. "TimeUnit") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "TimeUnit") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OptimizedStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OptimizedStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Organization struct {
	// AddonsConfig: Addon configurations of the Apigee organization.
	AddonsConfig *GoogleCloudApigeeV1AddonsConfig `json:"addonsConfig,omitempty"`

	// AnalyticsRegion: Required. DEPRECATED: This field will eventually be
	// deprecated and replaced with a differently-named field. Primary
	// Google Cloud region for analytics data storage. For valid values, see
	// Create an Apigee organization
	// (https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
	AnalyticsRegion string `json:"analyticsRegion,omitempty"`

	// ApiConsumerDataEncryptionKeyName: Cloud KMS key name used for
	// encrypting API consumer data. Required for US/EU regions when
	// BillingType (#BillingType) is `SUBSCRIPTION`. When BillingType
	// (#BillingType) is `EVALUATION` or the region is not US/EU, a
	// Google-Managed encryption key will be used. Format:
	// `projects/*/locations/*/keyRings/*/cryptoKeys/*`
	ApiConsumerDataEncryptionKeyName string `json:"apiConsumerDataEncryptionKeyName,omitempty"`

	// ApiConsumerDataLocation: This field is needed only for customers with
	// control plane in US or EU. Apigee stores some control plane data only
	// in single region. This field determines which single region Apigee
	// should use. For example: "us-west1" when control plane is in US or
	// "europe-west2" when control plane is in EU.
	ApiConsumerDataLocation string `json:"apiConsumerDataLocation,omitempty"`

	// ApigeeProjectId: Output only. Apigee Project ID associated with the
	// organization. Use this project to allowlist Apigee in the Service
	// Attachment when using private service connect with Apigee.
	ApigeeProjectId string `json:"apigeeProjectId,omitempty"`

	// Attributes: Not used by Apigee.
	Attributes []string `json:"attributes,omitempty"`

	// AuthorizedNetwork: Compute Engine network used for Service Networking
	// to be peered with Apigee runtime instances. See Getting started with
	// the Service Networking API
	// (https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
	// Valid only when RuntimeType (#RuntimeType) is set to `CLOUD`. The
	// value must be set before the creation of a runtime instance and can
	// be updated only when there are no runtime instances. For example:
	// `default`. Apigee also supports shared VPC (that is, the host network
	// project is not the same as the one that is peering with Apigee). See
	// Shared VPC overview (https://cloud.google.com/vpc/docs/shared-vpc).
	// To use a shared VPC network, use the following format:
	// `projects/{host-project-id}/{region}/networks/{network-name}`. For
	// example: `projects/my-sharedvpc-host/global/networks/mynetwork`
	// **Note:** Not supported for Apigee hybrid.
	AuthorizedNetwork string `json:"authorizedNetwork,omitempty"`

	// BillingType: Billing type of the Apigee organization. See Apigee
	// pricing (https://cloud.google.com/apigee/pricing).
	//
	// Possible values:
	//   "BILLING_TYPE_UNSPECIFIED" - Billing type not specified.
	//   "SUBSCRIPTION" - A pre-paid subscription to Apigee.
	//   "EVALUATION" - Free and limited access to Apigee for evaluation
	// purposes only.
	//   "PAYG" - Access to Apigee using a Pay-As-You-Go plan.
	BillingType string `json:"billingType,omitempty"`

	// CaCertificate: Output only. Base64-encoded public certificate for the
	// root CA of the Apigee organization. Valid only when RuntimeType
	// (#RuntimeType) is `CLOUD`.
	CaCertificate string `json:"caCertificate,omitempty"`

	// ControlPlaneEncryptionKeyName: Cloud KMS key name used for encrypting
	// control plane data that is stored in a multi region. Required when
	// BillingType (#BillingType) is `SUBSCRIPTION`. When BillingType
	// (#BillingType) is `EVALUATION`, a Google-Managed encryption key will
	// be used. Format: `projects/*/locations/*/keyRings/*/cryptoKeys/*`
	ControlPlaneEncryptionKeyName string `json:"controlPlaneEncryptionKeyName,omitempty"`

	// CreatedAt: Output only. Time that the Apigee organization was created
	// in milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// CustomerName: Not used by Apigee.
	CustomerName string `json:"customerName,omitempty"`

	// Description: Description of the Apigee organization.
	Description string `json:"description,omitempty"`

	// DisableVpcPeering: Optional. Flag that specifies whether the VPC
	// Peering through Private Google Access should be disabled between the
	// consumer network and Apigee. Valid only when RuntimeType is set to
	// CLOUD. Required if an authorizedNetwork on the consumer project is
	// not provided, in which case the flag should be set to true. The value
	// must be set before the creation of any Apigee runtime instance and
	// can be updated only when there are no runtime instances. **Note:**
	// Apigee will be deprecating the vpc peering model that requires you to
	// provide 'authorizedNetwork', by making the non-peering model as the
	// default way of provisioning Apigee organization in future. So, this
	// will be a temporary flag to enable the transition. Not supported for
	// Apigee hybrid.
	DisableVpcPeering bool `json:"disableVpcPeering,omitempty"`

	// DisplayName: Display name for the Apigee organization. Unused, but
	// reserved for future use.
	DisplayName string `json:"displayName,omitempty"`

	// Environments: Output only. List of environments in the Apigee
	// organization.
	Environments []string `json:"environments,omitempty"`

	// ExpiresAt: Output only. Time that the Apigee organization is
	// scheduled for deletion.
	ExpiresAt int64 `json:"expiresAt,omitempty,string"`

	// LastModifiedAt: Output only. Time that the Apigee organization was
	// last modified in milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Output only. Name of the Apigee organization.
	Name string `json:"name,omitempty"`

	// PortalDisabled: Configuration for the Portals settings.
	PortalDisabled bool `json:"portalDisabled,omitempty"`

	// ProjectId: Output only. Project ID associated with the Apigee
	// organization.
	ProjectId string `json:"projectId,omitempty"`

	// Properties: Properties defined in the Apigee organization profile.
	Properties *GoogleCloudApigeeV1Properties `json:"properties,omitempty"`

	// RuntimeDatabaseEncryptionKeyName: Cloud KMS key name used for
	// encrypting the data that is stored and replicated across runtime
	// instances. Update is not allowed after the organization is created.
	// Required when RuntimeType (#RuntimeType) is `CLOUD`. If not specified
	// when RuntimeType (#RuntimeType) is `TRIAL`, a Google-Managed
	// encryption key will be used. For example:
	// "projects/foo/locations/us/keyRings/bar/cryptoKeys/baz". **Note:**
	// Not supported for Apigee hybrid.
	RuntimeDatabaseEncryptionKeyName string `json:"runtimeDatabaseEncryptionKeyName,omitempty"`

	// RuntimeType: Required. Runtime type of the Apigee organization based
	// on the Apigee subscription purchased.
	//
	// Possible values:
	//   "RUNTIME_TYPE_UNSPECIFIED" - Runtime type not specified.
	//   "CLOUD" - Google-managed Apigee runtime.
	//   "HYBRID" - User-managed Apigee hybrid runtime.
	RuntimeType string `json:"runtimeType,omitempty"`

	// State: Output only. State of the organization. Values other than
	// ACTIVE means the resource is not ready to use.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Resource is in an unspecified state.
	//   "CREATING" - Resource is being created.
	//   "ACTIVE" - Resource is provisioned and ready to use.
	//   "DELETING" - The resource is being deleted.
	//   "UPDATING" - The resource is being updated.
	State string `json:"state,omitempty"`

	// SubscriptionPlan: Output only. Subscription plan that the customer
	// has purchased. Output only.
	//
	// Possible values:
	//   "SUBSCRIPTION_PLAN_UNSPECIFIED" - Subscription plan not specified.
	//   "SUBSCRIPTION_2021" - Traditional subscription plan.
	//   "SUBSCRIPTION_2024" - New subscription plan that provides standard
	// proxy and scaled proxy implementation.
	SubscriptionPlan string `json:"subscriptionPlan,omitempty"`

	// SubscriptionType: Output only. DEPRECATED: This will eventually be
	// replaced by BillingType. Subscription type of the Apigee
	// organization. Valid values include trial (free, limited, and for
	// evaluation purposes only) or paid (full subscription has been
	// purchased). See Apigee pricing
	// (https://cloud.google.com/apigee/pricing/).
	//
	// Possible values:
	//   "SUBSCRIPTION_TYPE_UNSPECIFIED" - Subscription type not specified.
	//   "PAID" - Full subscription to Apigee has been purchased.
	//   "TRIAL" - Subscription to Apigee is free, limited, and used for
	// evaluation purposes only.
	SubscriptionType string `json:"subscriptionType,omitempty"`

	// Type: Not used by Apigee.
	//
	// Possible values:
	//   "TYPE_UNSPECIFIED" - Subscription type not specified.
	//   "TYPE_TRIAL" - Subscription to Apigee is free, limited, and used
	// for evaluation purposes only.
	//   "TYPE_PAID" - Full subscription to Apigee has been purchased. See
	// [Apigee pricing](https://cloud.google.com/apigee/pricing/).
	//   "TYPE_INTERNAL" - For internal users only.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AddonsConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddonsConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Organization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Organization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1OrganizationProjectMapping struct {
	// Location: Output only. The Google Cloud region where control plane
	// data is located. For more information, see
	// https://cloud.google.com/about/locations/.
	Location string `json:"location,omitempty"`

	// Organization: Name of the Apigee organization.
	Organization string `json:"organization,omitempty"`

	// ProjectId: Google Cloud project associated with the Apigee
	// organization
	ProjectId string `json:"projectId,omitempty"`

	// ProjectIds: DEPRECATED: Use `project_id`. An Apigee Organization is
	// mapped to a single project.
	ProjectIds []string `json:"projectIds,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Location") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1OrganizationProjectMapping) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1OrganizationProjectMapping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1PodStatus struct {
	// AppVersion: Version of the application running in the pod.
	AppVersion string `json:"appVersion,omitempty"`

	// DeploymentStatus: Status of the deployment. Valid values include: -
	// `deployed`: Successful. - `error` : Failed. - `pending` : Pod has not
	// yet reported on the deployment.
	DeploymentStatus string `json:"deploymentStatus,omitempty"`

	// DeploymentStatusTime: Time the deployment status was reported in
	// milliseconds since epoch.
	DeploymentStatusTime int64 `json:"deploymentStatusTime,omitempty,string"`

	// DeploymentTime: Time the proxy was deployed in milliseconds since
	// epoch.
	DeploymentTime int64 `json:"deploymentTime,omitempty,string"`

	// PodName: Name of the pod which is reporting the status.
	PodName string `json:"podName,omitempty"`

	// PodStatus: Overall status of the pod (not this specific deployment).
	// Valid values include: - `active`: Up to date. - `stale` : Recently
	// out of date. Pods that have not reported status in a long time are
	// excluded from the output.
	PodStatus string `json:"podStatus,omitempty"`

	// PodStatusTime: Time the pod status was reported in milliseconds since
	// epoch.
	PodStatusTime int64 `json:"podStatusTime,omitempty,string"`

	// StatusCode: Code associated with the deployment status.
	StatusCode string `json:"statusCode,omitempty"`

	// StatusCodeDetails: Human-readable message associated with the status
	// code.
	StatusCodeDetails string `json:"statusCodeDetails,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AppVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AppVersion") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1PodStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1PodStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Point: Point is a group of information collected
// by runtime plane at critical points of the message flow of the
// processed API request. This is a list of supported point IDs,
// categorized to three major buckets. For each category, debug points
// that we are currently supporting are listed below: - Flow status
// debug points: StateChange FlowInfo Condition Execution DebugMask
// Error - Flow control debug points: FlowCallout Paused Resumed
// FlowReturn BreakFlow Error - Runtime debug points: ScriptExecutor
// FlowCalloutStepDefinition CustomTarget StepDefinition
// Oauth2ServicePoint RaiseFault NodeJS The detail information of the
// given debug point is stored in a list of results.
type GoogleCloudApigeeV1Point struct {
	// Id: Name of a step in the transaction.
	Id string `json:"id,omitempty"`

	// Results: List of results extracted from a given debug point.
	Results []*GoogleCloudApigeeV1Result `json:"results,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Point) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Point
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ProfileConfig: ProfileConfig defines a set of
// categories and policies which will be used to compute security score.
type GoogleCloudApigeeV1ProfileConfig struct {
	// Categories: List of categories of profile config.
	Categories []*GoogleCloudApigeeV1ProfileConfigCategory `json:"categories,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Categories") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Categories") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ProfileConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ProfileConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ProfileConfigAbuse: Checks for abuse, which
// includes any requests sent to the API for purposes other than what it
// is intended for, such as high volumes of requests, data scraping, and
// abuse related to authorization.
type GoogleCloudApigeeV1ProfileConfigAbuse struct {
}

// GoogleCloudApigeeV1ProfileConfigAuthorization: By default, following
// policies will be included: - JWS - JWT - OAuth - BasicAuth - APIKey
type GoogleCloudApigeeV1ProfileConfigAuthorization struct {
}

// GoogleCloudApigeeV1ProfileConfigCORS: Checks to see if you have CORS
// policy in place.
type GoogleCloudApigeeV1ProfileConfigCORS struct {
}

// GoogleCloudApigeeV1ProfileConfigCategory: Advanced API Security
// provides security profile that scores the following categories.
type GoogleCloudApigeeV1ProfileConfigCategory struct {
	// Abuse: Checks for abuse, which includes any requests sent to the API
	// for purposes other than what it is intended for, such as high volumes
	// of requests, data scraping, and abuse related to authorization.
	Abuse *GoogleCloudApigeeV1ProfileConfigAbuse `json:"abuse,omitempty"`

	// Authorization: Checks to see if you have an authorization policy in
	// place.
	Authorization *GoogleCloudApigeeV1ProfileConfigAuthorization `json:"authorization,omitempty"`

	// Cors: Checks to see if you have CORS policy in place.
	Cors *GoogleCloudApigeeV1ProfileConfigCORS `json:"cors,omitempty"`

	// Mediation: Checks to see if you have a mediation policy in place.
	Mediation *GoogleCloudApigeeV1ProfileConfigMediation `json:"mediation,omitempty"`

	// Mtls: Checks to see if you have configured mTLS for the target
	// server.
	Mtls *GoogleCloudApigeeV1ProfileConfigMTLS `json:"mtls,omitempty"`

	// Threat: Checks to see if you have a threat protection policy in
	// place.
	Threat *GoogleCloudApigeeV1ProfileConfigThreat `json:"threat,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Abuse") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Abuse") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ProfileConfigCategory) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ProfileConfigCategory
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ProfileConfigMTLS: Checks to see if you have
// configured mTLS for the target server.
type GoogleCloudApigeeV1ProfileConfigMTLS struct {
}

// GoogleCloudApigeeV1ProfileConfigMediation: By default, following
// policies will be included: - OASValidation - SOAPMessageValidation
type GoogleCloudApigeeV1ProfileConfigMediation struct {
}

// GoogleCloudApigeeV1ProfileConfigThreat: By default, following
// policies will be included: - XMLThreatProtection -
// JSONThreatProtection
type GoogleCloudApigeeV1ProfileConfigThreat struct {
}

// GoogleCloudApigeeV1Properties: Message for compatibility with legacy
// Edge specification for Java Properties object in JSON.
type GoogleCloudApigeeV1Properties struct {
	// Property: List of all properties in the object
	Property []*GoogleCloudApigeeV1Property `json:"property,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Property") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Properties) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Properties
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Property: A single property entry in the
// Properties message.
type GoogleCloudApigeeV1Property struct {
	// Name: The property key
	Name string `json:"name,omitempty"`

	// Value: The property value
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Property) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Property
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ProvisionOrganizationRequest: Request for
// ProvisionOrganization.
type GoogleCloudApigeeV1ProvisionOrganizationRequest struct {
	// AnalyticsRegion: Primary Cloud Platform region for analytics data
	// storage. For valid values, see Create an organization
	// (https://cloud.google.com/apigee/docs/hybrid/latest/precog-provision).
	// Defaults to `us-west1`.
	AnalyticsRegion string `json:"analyticsRegion,omitempty"`

	// AuthorizedNetwork: Compute Engine network used for Service Networking
	// to be peered with Apigee runtime instances. See Getting started with
	// the Service Networking API
	// (https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
	// Apigee also supports shared VPC (that is, the host network project is
	// not the same as the one that is peering with Apigee). See Shared VPC
	// overview (https://cloud.google.com/vpc/docs/shared-vpc). To use a
	// shared VPC network, use the following format:
	// `projects/{host-project-id}/{region}/networks/{network-name}`. For
	// example: `projects/my-sharedvpc-host/global/networks/mynetwork`
	AuthorizedNetwork string `json:"authorizedNetwork,omitempty"`

	// DisableVpcPeering: Optional. Flag that specifies whether the VPC
	// Peering through Private Google Access should be disabled between the
	// consumer network and Apigee. Required if an authorizedNetwork on the
	// consumer project is not provided, in which case the flag should be
	// set to true. The value must be set before the creation of any Apigee
	// runtime instance and can be updated only when there are no runtime
	// instances. **Note:** Apigee will be deprecating the vpc peering model
	// that requires you to provide 'authorizedNetwork', by making the
	// non-peering model as the default way of provisioning Apigee
	// organization in future. So, this will be a temporary flag to enable
	// the transition. Not supported for Apigee hybrid.
	DisableVpcPeering bool `json:"disableVpcPeering,omitempty"`

	// RuntimeLocation: Cloud Platform location for the runtime instance.
	// Defaults to zone `us-west1-a`. If a region is provided, `EVAL`
	// organizations will use the region for automatically selecting a zone
	// for the runtime instance.
	RuntimeLocation string `json:"runtimeLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalyticsRegion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalyticsRegion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ProvisionOrganizationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ProvisionOrganizationRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1Query struct {
	// CsvDelimiter: Delimiter used in the CSV file, if `outputFormat` is
	// set to `csv`. Defaults to the `,` (comma) character. Supported
	// delimiter characters include comma (`,`), pipe (`|`), and tab (`\t`).
	CsvDelimiter string `json:"csvDelimiter,omitempty"`

	// Dimensions: A list of dimensions.
	// https://docs.apigee.com/api-platform/analytics/analytics-reference#dimensions
	Dimensions []string `json:"dimensions,omitempty"`

	// EnvgroupHostname: Hostname needs to be specified if query intends to
	// run at host level. This field is only allowed when query is submitted
	// by CreateHostAsyncQuery where analytics data will be grouped by
	// organization and hostname.
	EnvgroupHostname string `json:"envgroupHostname,omitempty"`

	// Filter: Boolean expression that can be used to filter data. Filter
	// expressions can be combined using AND/OR terms and should be fully
	// parenthesized to avoid ambiguity. See Analytics metrics, dimensions,
	// and filters reference
	// https://docs.apigee.com/api-platform/analytics/analytics-reference
	// for more information on the fields available to filter on. For more
	// information on the tokens that you use to build filter expressions,
	// see Filter expression syntax.
	// https://docs.apigee.com/api-platform/analytics/asynch-reports-api#filter-expression-syntax
	Filter string `json:"filter,omitempty"`

	// GroupByTimeUnit: Time unit used to group the result set. Valid values
	// include: second, minute, hour, day, week, or month. If a query
	// includes groupByTimeUnit, then the result is an aggregation based on
	// the specified time unit and the resultant timestamp does not include
	// milliseconds precision. If a query omits groupByTimeUnit, then the
	// resultant timestamp includes milliseconds precision.
	GroupByTimeUnit string `json:"groupByTimeUnit,omitempty"`

	// Limit: Maximum number of rows that can be returned in the result.
	Limit int64 `json:"limit,omitempty"`

	// Metrics: A list of Metrics.
	Metrics []*GoogleCloudApigeeV1QueryMetric `json:"metrics,omitempty"`

	// Name: Asynchronous Query Name.
	Name string `json:"name,omitempty"`

	// OutputFormat: Valid values include: `csv` or `json`. Defaults to
	// `json`. Note: Configure the delimiter for CSV output using the
	// csvDelimiter property.
	OutputFormat string `json:"outputFormat,omitempty"`

	// ReportDefinitionId: Asynchronous Report ID.
	ReportDefinitionId string `json:"reportDefinitionId,omitempty"`

	// TimeRange: Required. Time range for the query. Can use the following
	// predefined strings to specify the time range: `last60minutes`
	// `last24hours` `last7days` Or, specify the timeRange as a structure
	// describing start and end timestamps in the ISO format:
	// yyyy-mm-ddThh:mm:ssZ. Example: "timeRange": { "start":
	// "2018-07-29T00:13:00Z", "end": "2018-08-01T00:18:00Z" }
	TimeRange interface{} `json:"timeRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CsvDelimiter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CsvDelimiter") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Query) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Query
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1QueryMetadata struct {
	// Dimensions: Dimensions of the AsyncQuery.
	Dimensions []string `json:"dimensions,omitempty"`

	// EndTimestamp: End timestamp of the query range.
	EndTimestamp string `json:"endTimestamp,omitempty"`

	// Metrics: Metrics of the AsyncQuery. Example:
	// ["name:message_count,func:sum,alias:sum_message_count"]
	Metrics []string `json:"metrics,omitempty"`

	// OutputFormat: Output format.
	OutputFormat string `json:"outputFormat,omitempty"`

	// StartTimestamp: Start timestamp of the query range.
	StartTimestamp string `json:"startTimestamp,omitempty"`

	// TimeUnit: Query GroupBy time unit.
	TimeUnit string `json:"timeUnit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1QueryMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1QueryMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1QueryMetric: More info about Metric:
// https://docs.apigee.com/api-platform/analytics/analytics-reference#metrics
type GoogleCloudApigeeV1QueryMetric struct {
	// Alias: Alias for the metric. Alias will be used to replace metric
	// name in query results.
	Alias string `json:"alias,omitempty"`

	// Function: Aggregation function: avg, min, max, or sum.
	Function string `json:"function,omitempty"`

	// Name: Required. Metric name.
	Name string `json:"name,omitempty"`

	// Operator: One of `+`, `-`, `/`, `%`, `*`.
	Operator string `json:"operator,omitempty"`

	// Value: Operand value should be provided when operator is set.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Alias") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Alias") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1QueryMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1QueryMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1QueryTabularStatsRequest: Request payload
// representing the query to be run for fetching security statistics as
// rows.
type GoogleCloudApigeeV1QueryTabularStatsRequest struct {
	// Dimensions: Required. List of dimension names to group the
	// aggregations by.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filter further on specific dimension values. Follows the same
	// grammar as custom report's filter expressions. Example, apiproxy eq
	// 'foobar'.
	// https://cloud.google.com/apigee/docs/api-platform/analytics/analytics-reference#filters
	Filter string `json:"filter,omitempty"`

	// Metrics: Required. List of metrics and their aggregations.
	Metrics []*GoogleCloudApigeeV1MetricAggregation `json:"metrics,omitempty"`

	// PageSize: Page size represents the number of rows.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: Identifies a sequence of rows.
	PageToken string `json:"pageToken,omitempty"`

	// TimeRange: Time range for the stats.
	TimeRange *GoogleTypeInterval `json:"timeRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1QueryTabularStatsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1QueryTabularStatsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1QueryTabularStatsResponse: Encapsulates two kinds
// of stats that are results of the dimensions and aggregations
// requested. - Tabular rows. - Time series data. Example of tabular
// rows, Represents security stats results as a row of flat values.
type GoogleCloudApigeeV1QueryTabularStatsResponse struct {
	// Columns: Column names corresponding to the same order as the inner
	// values in the stats field.
	Columns []string `json:"columns,omitempty"`

	// NextPageToken: Next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Values: Resultant rows from the executed query.
	Values [][]interface{} `json:"values,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Columns") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Columns") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1QueryTabularStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1QueryTabularStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1QueryTimeSeriesStatsRequest:
// QueryTimeSeriesStatsRequest represents a query that returns a
// collection of time series sequences grouped by their values.
type GoogleCloudApigeeV1QueryTimeSeriesStatsRequest struct {
	// Dimensions: List of dimension names to group the aggregations by. If
	// no dimensions are passed, a single trend line representing the
	// requested metric aggregations grouped by environment is returned.
	Dimensions []string `json:"dimensions,omitempty"`

	// Filter: Filter further on specific dimension values. Follows the same
	// grammar as custom report's filter expressions. Example, apiproxy eq
	// 'foobar'.
	// https://cloud.google.com/apigee/docs/api-platform/analytics/analytics-reference#filters
	Filter string `json:"filter,omitempty"`

	// Metrics: Required. List of metrics and their aggregations.
	Metrics []*GoogleCloudApigeeV1MetricAggregation `json:"metrics,omitempty"`

	// PageSize: Page size represents the number of time series sequences,
	// one per unique set of dimensions and their values.
	PageSize int64 `json:"pageSize,omitempty"`

	// PageToken: Page token stands for a specific collection of time series
	// sequences.
	PageToken string `json:"pageToken,omitempty"`

	// TimeRange: Required. Time range for the stats.
	TimeRange *GoogleTypeInterval `json:"timeRange,omitempty"`

	// TimestampOrder: Order the sequences in increasing or decreasing order
	// of timestamps. Default is descending order of timestamps (latest
	// first).
	//
	// Possible values:
	//   "ORDER_UNSPECIFIED" - Unspecified order. Default is Descending.
	//   "ASCENDING" - Ascending sort order.
	//   "DESCENDING" - Descending sort order.
	TimestampOrder string `json:"timestampOrder,omitempty"`

	// WindowSize: Time buckets to group the stats by.
	//
	// Possible values:
	//   "WINDOW_SIZE_UNSPECIFIED" - Unspecified window size. Default is 1
	// hour.
	//   "MINUTE" - 1 Minute window
	//   "HOUR" - 1 Hour window
	//   "DAY" - 1 Day window
	//   "MONTH" - 1 Month window
	WindowSize string `json:"windowSize,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1QueryTimeSeriesStatsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1QueryTimeSeriesStatsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1QueryTimeSeriesStatsResponse: Represents security
// stats result as a collection of time series sequences.
type GoogleCloudApigeeV1QueryTimeSeriesStatsResponse struct {
	// Columns: Column names corresponding to the same order as the inner
	// values in the stats field.
	Columns []string `json:"columns,omitempty"`

	// NextPageToken: Next page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Values: Results of the query returned as a JSON array.
	Values []*GoogleCloudApigeeV1QueryTimeSeriesStatsResponseSequence `json:"values,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Columns") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Columns") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1QueryTimeSeriesStatsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1QueryTimeSeriesStatsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1QueryTimeSeriesStatsResponseSequence: A sequence
// of time series.
type GoogleCloudApigeeV1QueryTimeSeriesStatsResponseSequence struct {
	// Dimensions: Map of dimensions and their values that uniquely
	// identifies a time series sequence.
	Dimensions map[string]string `json:"dimensions,omitempty"`

	// Points: List of points. First value of each inner list is a
	// timestamp.
	Points [][]interface{} `json:"points,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1QueryTimeSeriesStatsResponseSequence) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1QueryTimeSeriesStatsResponseSequence
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Quota: Quota contains the essential parameters
// needed that can be applied on the resources, methods, API source
// combination associated with this API product. While Quota is
// optional, setting it prevents requests from exceeding the provisioned
// parameters.
type GoogleCloudApigeeV1Quota struct {
	// Interval: Required. Time interval over which the number of request
	// messages is calculated.
	Interval string `json:"interval,omitempty"`

	// Limit: Required. Upper limit allowed for the time interval and time
	// unit specified. Requests exceeding this limit will be rejected.
	Limit string `json:"limit,omitempty"`

	// TimeUnit: Time unit defined for the `interval`. Valid values include
	// `minute`, `hour`, `day`, or `month`. If `limit` and `interval` are
	// valid, the default value is `hour`; otherwise, the default is null.
	TimeUnit string `json:"timeUnit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Interval") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Interval") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Quota) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Quota
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RatePlan: Rate plan details.
type GoogleCloudApigeeV1RatePlan struct {
	// Apiproduct: Name of the API product that the rate plan is associated
	// with.
	Apiproduct string `json:"apiproduct,omitempty"`

	// BillingPeriod: Frequency at which the customer will be billed.
	//
	// Possible values:
	//   "BILLING_PERIOD_UNSPECIFIED" - Billing period not specified.
	//   "WEEKLY" - Weekly billing period. **Note**: Not supported by Apigee
	// at this time.
	//   "MONTHLY" - Monthly billing period.
	BillingPeriod string `json:"billingPeriod,omitempty"`

	// ConsumptionPricingRates: API call volume ranges and the fees charged
	// when the total number of API calls is within a given range. The
	// method used to calculate the final fee depends on the selected
	// pricing model. For example, if the pricing model is `STAIRSTEP` and
	// the ranges are defined as follows: ``` { "start": 1, "end": 100,
	// "fee": 75 }, { "start": 101, "end": 200, "fee": 100 }, } ``` Then the
	// following fees would be charged based on the total number of API
	// calls (assuming the currency selected is `USD`): * 1 call costs $75 *
	// 50 calls cost $75 * 150 calls cost $100 The number of API calls
	// cannot exceed 200.
	ConsumptionPricingRates []*GoogleCloudApigeeV1RateRange `json:"consumptionPricingRates,omitempty"`

	// ConsumptionPricingType: Pricing model used for consumption-based
	// charges.
	//
	// Possible values:
	//   "CONSUMPTION_PRICING_TYPE_UNSPECIFIED" - Pricing model not
	// specified. This is the default.
	//   "FIXED_PER_UNIT" - Fixed rate charged for each API call.
	//   "BANDED" - Variable rate charged for each API call based on price
	// tiers. Example: * 1-100 calls cost $2 per call * 101-200 calls cost
	// $1.50 per call * 201-300 calls cost $1 per call * Total price for 50
	// calls: 50 x $2 = $100 * Total price for 150 calls: 100 x $2 + 50 x
	// $1.5 = $275 * Total price for 250 calls: 100 x $2 + 100 x $1.5 + 50 x
	// $1 = $400. **Note**: Not supported by Apigee at this time.
	//   "TIERED" - **Note**: Not supported by Apigee at this time.
	//   "STAIRSTEP" - **Note**: Not supported by Apigee at this time.
	ConsumptionPricingType string `json:"consumptionPricingType,omitempty"`

	// CreatedAt: Output only. Time that the rate plan was created in
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// CurrencyCode: Currency to be used for billing. Consists of a
	// three-letter code as defined by the ISO 4217
	// (https://en.wikipedia.org/wiki/ISO_4217) standard.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Description: Description of the rate plan.
	Description string `json:"description,omitempty"`

	// DisplayName: Display name of the rate plan.
	DisplayName string `json:"displayName,omitempty"`

	// EndTime: Time when the rate plan will expire in milliseconds since
	// epoch. Set to 0 or `null` to indicate that the rate plan should never
	// expire.
	EndTime int64 `json:"endTime,omitempty,string"`

	// FixedFeeFrequency: Frequency at which the fixed fee is charged.
	FixedFeeFrequency int64 `json:"fixedFeeFrequency,omitempty"`

	// FixedRecurringFee: Fixed amount that is charged at a defined interval
	// and billed in advance of use of the API product. The fee will be
	// prorated for the first billing period.
	FixedRecurringFee *GoogleTypeMoney `json:"fixedRecurringFee,omitempty"`

	// LastModifiedAt: Output only. Time the rate plan was last modified in
	// milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: Output only. Name of the rate plan.
	Name string `json:"name,omitempty"`

	// PaymentFundingModel: DEPRECATED: This field is no longer supported
	// and will eventually be removed when Apigee Hybrid 1.5/1.6 is no
	// longer supported. Instead, use the `billingType` field inside
	// `DeveloperMonetizationConfig` resource. Flag that specifies the
	// billing account type, prepaid or postpaid.
	//
	// Possible values:
	//   "PAYMENT_FUNDING_MODEL_UNSPECIFIED" - Billing account type not
	// specified.
	//   "PREPAID" - Prepaid billing account type. Developer pays in advance
	// for the use of your API products. Funds are deducted from their
	// prepaid account balance. **Note**: Not supported by Apigee at this
	// time.
	//   "POSTPAID" - Postpaid billing account type. Developer is billed
	// through an invoice after using your API products.
	PaymentFundingModel string `json:"paymentFundingModel,omitempty"`

	// RevenueShareRates: Details of the revenue sharing model.
	RevenueShareRates []*GoogleCloudApigeeV1RevenueShareRange `json:"revenueShareRates,omitempty"`

	// RevenueShareType: Method used to calculate the revenue that is shared
	// with developers.
	//
	// Possible values:
	//   "REVENUE_SHARE_TYPE_UNSPECIFIED" - Revenue share type is not
	// specified.
	//   "FIXED" - Fixed percentage of the total revenue will be shared. The
	// percentage to be shared can be configured by the API provider.
	//   "VOLUME_BANDED" - Amount of revenue shared depends on the number of
	// API calls. The API call volume ranges and the revenue share
	// percentage for each volume can be configured by the API provider.
	// **Note**: Not supported by Apigee at this time.
	RevenueShareType string `json:"revenueShareType,omitempty"`

	// SetupFee: Initial, one-time fee paid when purchasing the API product.
	SetupFee *GoogleTypeMoney `json:"setupFee,omitempty"`

	// StartTime: Time when the rate plan becomes active in milliseconds
	// since epoch.
	StartTime int64 `json:"startTime,omitempty,string"`

	// State: Current state of the rate plan (draft or published).
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - State of the rate plan is not specified.
	//   "DRAFT" - Rate plan is in draft mode and only visible to API
	// providers.
	//   "PUBLISHED" - Rate plan is published and will become visible to
	// developers for the configured duration (between `startTime` and
	// `endTime`).
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Apiproduct") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Apiproduct") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RatePlan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RatePlan
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RateRange: API call volume range and the fees
// charged when the total number of API calls is within the range.
type GoogleCloudApigeeV1RateRange struct {
	// End: Ending value of the range. Set to 0 or `null` for the last range
	// of values.
	End int64 `json:"end,omitempty,string"`

	// Fee: Fee to charge when total number of API calls falls within this
	// range.
	Fee *GoogleTypeMoney `json:"fee,omitempty"`

	// Start: Starting value of the range. Set to 0 or `null` for the
	// initial range of values.
	Start int64 `json:"start,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "End") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "End") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RateRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RateRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Reference: A Reference configuration. References
// must refer to a keystore that also exists in the parent environment.
type GoogleCloudApigeeV1Reference struct {
	// Description: Optional. A human-readable description of this
	// reference.
	Description string `json:"description,omitempty"`

	// Name: Required. The resource id of this reference. Values must match
	// the regular expression [\w\s\-.]+.
	Name string `json:"name,omitempty"`

	// Refers: Required. The id of the resource to which this reference
	// refers. Must be the id of a resource that exists in the parent
	// environment and is of the given resource_type.
	Refers string `json:"refers,omitempty"`

	// ResourceType: The type of resource referred to by this reference.
	// Valid values are 'KeyStore' or 'TrustStore'.
	ResourceType string `json:"resourceType,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Reference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Reference
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ReferenceConfig struct {
	// Name: Name of the reference in the following format:
	// `organizations/{org}/environments/{env}/references/{reference}`
	Name string `json:"name,omitempty"`

	// ResourceName: Name of the referenced resource in the following
	// format: `organizations/{org}/environments/{env}/keystores/{keystore}`
	// Only references to keystore resources are supported.
	ResourceName string `json:"resourceName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ReferenceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ReferenceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ReportInstanceStatusRequest: Request for
// ReportInstanceStatus.
type GoogleCloudApigeeV1ReportInstanceStatusRequest struct {
	// InstanceUid: A unique ID for the instance which is guaranteed to be
	// unique in case the user installs multiple hybrid runtimes with the
	// same instance ID.
	InstanceUid string `json:"instanceUid,omitempty"`

	// ReportTime: The time the report was generated in the runtime. Used to
	// prevent an old status from overwriting a newer one. An instance
	// should space out it's status reports so that clock skew does not play
	// a factor.
	ReportTime string `json:"reportTime,omitempty"`

	// Resources: Status for config resources
	Resources []*GoogleCloudApigeeV1ResourceStatus `json:"resources,omitempty"`

	// ForceSendFields is a list of field names (e.g. "InstanceUid") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "InstanceUid") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ReportInstanceStatusRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ReportInstanceStatusRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ReportInstanceStatusResponse: Placeholder for
// future enhancements to status reporting protocol
type GoogleCloudApigeeV1ReportInstanceStatusResponse struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

type GoogleCloudApigeeV1ReportProperty struct {
	// Property: name of the property
	Property string `json:"property,omitempty"`

	// Value: property values
	Value []*GoogleCloudApigeeV1Attribute `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Property") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Property") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ReportProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ReportProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ResourceConfig struct {
	// Location: Location of the resource as a URI.
	Location string `json:"location,omitempty"`

	// Name: Resource name in the following format:
	// `organizations/{org}/environments/{env}/resourcefiles/{type}/{file}/re
	// visions/{rev}` Only environment-scoped resource files are supported.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Location") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ResourceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ResourceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ResourceFile: Metadata about a resource file.
type GoogleCloudApigeeV1ResourceFile struct {
	// Name: ID of the resource file.
	Name string `json:"name,omitempty"`

	// Type: Resource file type. {{ resource_file_type }}
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ResourceFile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ResourceFile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ResourceFiles: List of resource files.
type GoogleCloudApigeeV1ResourceFiles struct {
	// ResourceFile: List of resource files.
	ResourceFile []*GoogleCloudApigeeV1ResourceFile `json:"resourceFile,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResourceFile") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResourceFile") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ResourceFiles) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ResourceFiles
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ResourceStatus: The status of a resource loaded in
// the runtime.
type GoogleCloudApigeeV1ResourceStatus struct {
	// Resource: The resource name. Currently only two resources are
	// supported: EnvironmentGroup -
	// organizations/{org}/envgroups/{envgroup} EnvironmentConfig -
	// organizations/{org}/environments/{environment}/deployedConfig
	Resource string `json:"resource,omitempty"`

	// Revisions: Revisions of the resource currently deployed in the
	// instance.
	Revisions []*GoogleCloudApigeeV1RevisionStatus `json:"revisions,omitempty"`

	// TotalReplicas: The total number of replicas that should have this
	// resource.
	TotalReplicas int64 `json:"totalReplicas,omitempty"`

	// Uid: The uid of the resource. In the unexpected case that the
	// instance has multiple uids for the same name, they should be reported
	// under separate ResourceStatuses.
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Resource") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Resource") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ResourceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ResourceStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Result: Result is short for "action result", could
// be different types identified by "action_result" field. Supported
// types: 1. DebugInfo : generic debug info collected by runtime
// recorded as a list of properties. For example, the contents could be
// virtual host info, state change result, or execution metadata.
// Required fields : properties, timestamp 2. RequestMessage:
// information of a http request. Contains headers, request URI and http
// methods type.Required fields : headers, uri, verb 3. ResponseMessage:
// information of a http response. Contains headers, reason phrase and
// http status code. Required fields : headers, reasonPhrase, statusCode
// 4. ErrorMessage: information of a http error message. Contains detail
// error message, reason phrase and status code. Required fields :
// content, headers, reasonPhrase, statusCode 5. VariableAccess: a list
// of variable access actions, can be Get, Set and Remove. Required
// fields : accessList
type GoogleCloudApigeeV1Result struct {
	// ActionResult: Type of the action result. Can be one of the five:
	// DebugInfo, RequestMessage, ResponseMessage, ErrorMessage,
	// VariableAccess
	ActionResult string `json:"ActionResult,omitempty"`

	// AccessList: A list of variable access actions agaist the api proxy.
	// Supported values: Get, Set, Remove.
	AccessList []*GoogleCloudApigeeV1Access `json:"accessList,omitempty"`

	// Content: Error message content. for example, "content" :
	// "{\"fault\":{\"faultstring\":\"API timed
	// out\",\"detail\":{\"errorcode\":\"flow.APITimedOut\"}}}"
	Content string `json:"content,omitempty"`

	// Headers: A list of HTTP headers. for example, '"headers" : [ { "name"
	// : "Content-Length", "value" : "83" }, { "name" : "Content-Type",
	// "value" : "application/json" } ]'
	Headers []*GoogleCloudApigeeV1Property `json:"headers,omitempty"`

	// Properties: Name value pairs used for DebugInfo ActionResult.
	Properties *GoogleCloudApigeeV1Properties `json:"properties,omitempty"`

	// ReasonPhrase: HTTP response phrase
	ReasonPhrase string `json:"reasonPhrase,omitempty"`

	// StatusCode: HTTP response code
	StatusCode string `json:"statusCode,omitempty"`

	// Timestamp: Timestamp of when the result is recorded. Its format is
	// dd-mm-yy hh:mm:ss:xxx. For example, "timestamp" : "12-08-19
	// 00:31:59:960"
	Timestamp string `json:"timestamp,omitempty"`

	// URI: The relative path of the api proxy. for example, "uRI" :
	// "/iloveapis"
	URI string `json:"uRI,omitempty"`

	// Verb: HTTP method verb
	Verb string `json:"verb,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionResult") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionResult") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Result) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Result
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RevenueShareRange: API call volume range and the
// percentage of revenue to share with the developer when the total
// number of API calls is within the range.
type GoogleCloudApigeeV1RevenueShareRange struct {
	// End: Ending value of the range. Set to 0 or `null` for the last range
	// of values.
	End int64 `json:"end,omitempty,string"`

	// SharePercentage: Percentage of the revenue to be shared with the
	// developer. For example, to share 21 percent of the total revenue with
	// the developer, set this value to 21. Specify a decimal number with a
	// maximum of two digits following the decimal point.
	SharePercentage float64 `json:"sharePercentage,omitempty"`

	// Start: Starting value of the range. Set to 0 or `null` for the
	// initial range of values.
	Start int64 `json:"start,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "End") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "End") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RevenueShareRange) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RevenueShareRange
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudApigeeV1RevenueShareRange) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudApigeeV1RevenueShareRange
	var s1 struct {
		SharePercentage gensupport.JSONFloat64 `json:"sharePercentage"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SharePercentage = float64(s1.SharePercentage)
	return nil
}

// GoogleCloudApigeeV1RevisionStatus: The status of a specific resource
// revision.
type GoogleCloudApigeeV1RevisionStatus struct {
	// Errors: Errors reported when attempting to load this revision.
	Errors []*GoogleCloudApigeeV1UpdateError `json:"errors,omitempty"`

	// JsonSpec: The json content of the resource revision. Large specs
	// should be sent individually via the spec field to avoid hitting
	// request size limits.
	JsonSpec string `json:"jsonSpec,omitempty"`

	// Replicas: The number of replicas that have successfully loaded this
	// revision.
	Replicas int64 `json:"replicas,omitempty"`

	// RevisionId: The revision of the resource.
	RevisionId string `json:"revisionId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Errors") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RevisionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RevisionStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1RoutingRule struct {
	// Basepath: URI path prefix used to route to the specified environment.
	// May contain one or more wildcards. For example, path segments
	// consisting of a single `*` character will match any string.
	Basepath string `json:"basepath,omitempty"`

	// DeploymentGroup: Name of a deployment group in an environment bound
	// to the environment group in the following format:
	// `organizations/{org}/environment/{env}/deploymentGroups/{group}` Only
	// one of environment or deployment_group will be set.
	DeploymentGroup string `json:"deploymentGroup,omitempty"`

	// EnvGroupRevision: The env group config revision_id when this rule was
	// added or last updated. This value is set when the rule is created and
	// will only update if the the environment_id changes. It is used to
	// determine if the runtime is up to date with respect to this rule.
	// This field is omitted from the IngressConfig unless the
	// GetDeployedIngressConfig API is called with view=FULL.
	EnvGroupRevision int64 `json:"envGroupRevision,omitempty,string"`

	// Environment: Name of an environment bound to the environment group in
	// the following format: `organizations/{org}/environments/{env}`. Only
	// one of environment or deployment_group will be set.
	Environment string `json:"environment,omitempty"`

	// OtherTargets: Conflicting targets, which will be resource names
	// specifying either deployment groups or environments.
	OtherTargets []string `json:"otherTargets,omitempty"`

	// Receiver: The resource name of the proxy revision that is receiving
	// this basepath in the following format:
	// `organizations/{org}/apis/{api}/revisions/{rev}`. This field is
	// omitted from the IngressConfig unless the GetDeployedIngressConfig
	// API is called with view=FULL.
	Receiver string `json:"receiver,omitempty"`

	// UpdateTime: The unix timestamp when this rule was updated. This is
	// updated whenever env_group_revision is updated. This field is omitted
	// from the IngressConfig unless the GetDeployedIngressConfig API is
	// called with view=FULL.
	UpdateTime string `json:"updateTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Basepath") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Basepath") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RoutingRule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RoutingRule
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RuntimeAddonsConfig: RuntimeAddonsConfig defines
// the runtime configurations for add-ons in an environment.
type GoogleCloudApigeeV1RuntimeAddonsConfig struct {
	// AnalyticsConfig: Runtime configuration for Analytics add-on.
	AnalyticsConfig *GoogleCloudApigeeV1RuntimeAnalyticsConfig `json:"analyticsConfig,omitempty"`

	// ApiSecurityConfig: Runtime configuration for API Security add-on.
	ApiSecurityConfig *GoogleCloudApigeeV1RuntimeApiSecurityConfig `json:"apiSecurityConfig,omitempty"`

	// Name: Name of the addons config in the format:
	// `organizations/{org}/environments/{env}/addonsConfig`
	Name string `json:"name,omitempty"`

	// RevisionId: Revision number used by the runtime to detect config
	// changes.
	RevisionId string `json:"revisionId,omitempty"`

	// Uid: UID is to detect if config is recreated after deletion. The
	// add-on config will only be deleted when the environment itself gets
	// deleted, thus it will always be the same as the UID of
	// EnvironmentConfig.
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalyticsConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalyticsConfig") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RuntimeAddonsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RuntimeAddonsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RuntimeAnalyticsConfig: Runtime configuration for
// the Analytics add-on.
type GoogleCloudApigeeV1RuntimeAnalyticsConfig struct {
	// BillingPipelineEnabled: If Runtime should send billing data to AX or
	// not.
	BillingPipelineEnabled bool `json:"billingPipelineEnabled,omitempty"`

	// Enabled: If the Analytics is enabled or not.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "BillingPipelineEnabled") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BillingPipelineEnabled")
	// to include in API requests with the JSON null value. By default,
	// fields with empty values are omitted from API requests. However, any
	// field with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RuntimeAnalyticsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RuntimeAnalyticsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RuntimeApiSecurityConfig: Runtime configuration
// for the API Security add-on.
type GoogleCloudApigeeV1RuntimeApiSecurityConfig struct {
	// Enabled: If the API Security is enabled or not.
	Enabled bool `json:"enabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RuntimeApiSecurityConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RuntimeApiSecurityConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RuntimeConfig: Runtime configuration for the
// organization. Response for GetRuntimeConfig.
type GoogleCloudApigeeV1RuntimeConfig struct {
	// AnalyticsBucket: Cloud Storage bucket used for uploading Analytics
	// records.
	AnalyticsBucket string `json:"analyticsBucket,omitempty"`

	// Name: Name of the resource in the following format:
	// `organizations/{org}/runtimeConfig`.
	Name string `json:"name,omitempty"`

	// TenantProjectId: Output only. Tenant project ID associated with the
	// Apigee organization. The tenant project is used to host
	// Google-managed resources that are dedicated to this Apigee
	// organization. Clients have limited access to resources within the
	// tenant project used to support Apigee runtime instances. Access to
	// the tenant project is managed using SetSyncAuthorization. It can be
	// empty if the tenant project hasn't been created yet.
	TenantProjectId string `json:"tenantProjectId,omitempty"`

	// TraceBucket: Cloud Storage bucket used for uploading Trace records.
	TraceBucket string `json:"traceBucket,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AnalyticsBucket") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalyticsBucket") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RuntimeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RuntimeConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RuntimeTraceConfig: NEXT ID: 8 RuntimeTraceConfig
// defines the configurations for distributed trace in an environment.
type GoogleCloudApigeeV1RuntimeTraceConfig struct {
	// Endpoint: Endpoint of the exporter.
	Endpoint string `json:"endpoint,omitempty"`

	// Exporter: Exporter that is used to view the distributed trace
	// captured using OpenCensus. An exporter sends traces to any backend
	// that is capable of consuming them. Recorded spans can be exported by
	// registered exporters.
	//
	// Possible values:
	//   "EXPORTER_UNSPECIFIED" - Exporter unspecified
	//   "JAEGER" - Jaeger exporter
	//   "CLOUD_TRACE" - Cloudtrace exporter
	Exporter string `json:"exporter,omitempty"`

	// Name: Name of the trace config in the following format:
	// `organizations/{org}/environment/{env}/traceConfig`
	Name string `json:"name,omitempty"`

	// Overrides: List of trace configuration overrides for spicific API
	// proxies.
	Overrides []*GoogleCloudApigeeV1RuntimeTraceConfigOverride `json:"overrides,omitempty"`

	// RevisionCreateTime: The timestamp that the revision was created or
	// updated.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`

	// RevisionId: Revision number which can be used by the runtime to
	// detect if the trace config has changed between two versions.
	RevisionId string `json:"revisionId,omitempty"`

	// SamplingConfig: Trace configuration for all API proxies in an
	// environment.
	SamplingConfig *GoogleCloudApigeeV1RuntimeTraceSamplingConfig `json:"samplingConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Endpoint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Endpoint") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RuntimeTraceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RuntimeTraceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RuntimeTraceConfigOverride: NEXT ID: 7 Trace
// configuration override for a specific API proxy in an environment.
type GoogleCloudApigeeV1RuntimeTraceConfigOverride struct {
	// ApiProxy: Name of the API proxy that will have its trace
	// configuration overridden following format:
	// `organizations/{org}/apis/{api}`
	ApiProxy string `json:"apiProxy,omitempty"`

	// Name: Name of the trace config override in the following format:
	// `organizations/{org}/environment/{env}/traceConfig/overrides/{override
	// }`
	Name string `json:"name,omitempty"`

	// RevisionCreateTime: The timestamp that the revision was created or
	// updated.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`

	// RevisionId: Revision number which can be used by the runtime to
	// detect if the trace config override has changed between two versions.
	RevisionId string `json:"revisionId,omitempty"`

	// SamplingConfig: Trace configuration override for a specific API proxy
	// in an environment.
	SamplingConfig *GoogleCloudApigeeV1RuntimeTraceSamplingConfig `json:"samplingConfig,omitempty"`

	// Uid: Unique ID for the configuration override. The ID will only
	// change if the override is deleted and recreated. Corresponds to
	// name's "override" field.
	Uid string `json:"uid,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ApiProxy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProxy") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RuntimeTraceConfigOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RuntimeTraceConfigOverride
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1RuntimeTraceSamplingConfig: NEXT ID: 3
// RuntimeTraceSamplingConfig represents the detail settings of
// distributed tracing. Only the fields that are defined in the
// distributed trace configuration can be overridden using the
// distribute trace configuration override APIs.
type GoogleCloudApigeeV1RuntimeTraceSamplingConfig struct {
	// Sampler: Sampler of distributed tracing. OFF is the default value.
	//
	// Possible values:
	//   "SAMPLER_UNSPECIFIED" - Sampler unspecified.
	//   "OFF" - OFF means distributed trace is disabled, or the sampling
	// probability is 0.
	//   "PROBABILITY" - PROBABILITY means traces are captured on a
	// probability that defined by sampling_rate. The sampling rate is
	// limited to 0 to 0.5 when this is set.
	Sampler string `json:"sampler,omitempty"`

	// SamplingRate: Field sampling rate. This value is only applicable when
	// using the PROBABILITY sampler. The supported values are > 0 and <=
	// 0.5.
	SamplingRate float64 `json:"samplingRate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Sampler") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Sampler") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1RuntimeTraceSamplingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1RuntimeTraceSamplingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudApigeeV1RuntimeTraceSamplingConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudApigeeV1RuntimeTraceSamplingConfig
	var s1 struct {
		SamplingRate gensupport.JSONFloat64 `json:"samplingRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplingRate = float64(s1.SamplingRate)
	return nil
}

// GoogleCloudApigeeV1Schema: Response for Schema call
type GoogleCloudApigeeV1Schema struct {
	// Dimensions: List of schema fields grouped as dimensions.
	Dimensions []*GoogleCloudApigeeV1SchemaSchemaElement `json:"dimensions,omitempty"`

	// Meta: Additional metadata associated with schema. This is a legacy
	// field and usually consists of an empty array of strings.
	Meta []string `json:"meta,omitempty"`

	// Metrics: List of schema fields grouped as dimensions that can be used
	// with an aggregate function such as `sum`, `avg`, `min`, and `max`.
	Metrics []*GoogleCloudApigeeV1SchemaSchemaElement `json:"metrics,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Schema) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Schema
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SchemaSchemaElement: Message type for the schema
// element
type GoogleCloudApigeeV1SchemaSchemaElement struct {
	// Name: Name of the field.
	Name string `json:"name,omitempty"`

	// Properties: Properties for the schema field. For example: {
	// "createTime": "2016-02-26T10:23:09.592Z", "custom": "false", "type":
	// "string" }
	Properties *GoogleCloudApigeeV1SchemaSchemaProperty `json:"properties,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SchemaSchemaElement) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SchemaSchemaElement
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SchemaSchemaProperty: Properties for the schema
// field.
type GoogleCloudApigeeV1SchemaSchemaProperty struct {
	// CreateTime: Time the field was created in RFC3339 string form. For
	// example: `2016-02-26T10:23:09.592Z`.
	CreateTime string `json:"createTime,omitempty"`

	// Custom: Flag that specifies whether the field is standard in the
	// dataset or a custom field created by the customer. `true` indicates
	// that it is a custom field.
	Custom string `json:"custom,omitempty"`

	// Type: Data type of the field.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SchemaSchemaProperty) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SchemaSchemaProperty
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Score: Represents Security Score.
type GoogleCloudApigeeV1Score struct {
	// Component: Component containing score, recommendations and actions.
	Component *GoogleCloudApigeeV1ScoreComponent `json:"component,omitempty"`

	// Subcomponents: List of all the drilldown score components.
	Subcomponents []*GoogleCloudApigeeV1ScoreComponent `json:"subcomponents,omitempty"`

	// TimeRange: Start and end time for the score.
	TimeRange *GoogleTypeInterval `json:"timeRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Component") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Component") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Score) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Score
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ScoreComponent: Component is an individual
// security element that is scored.
type GoogleCloudApigeeV1ScoreComponent struct {
	// CalculateTime: Time when score was calculated.
	CalculateTime string `json:"calculateTime,omitempty"`

	// DataCaptureTime: Time in the requested time period when data was last
	// captured to compute the score.
	DataCaptureTime string `json:"dataCaptureTime,omitempty"`

	// DrilldownPaths: List of paths for next components.
	DrilldownPaths []string `json:"drilldownPaths,omitempty"`

	// Recommendations: List of recommendations to improve API security.
	Recommendations []*GoogleCloudApigeeV1ScoreComponentRecommendation `json:"recommendations,omitempty"`

	// Score: Score for the component.
	Score int64 `json:"score,omitempty"`

	// ScorePath: Path of the component. Example:
	// /org@myorg/envgroup@myenvgroup/proxies/proxy@myproxy
	ScorePath string `json:"scorePath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CalculateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CalculateTime") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ScoreComponent) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ScoreComponent
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ScoreComponentRecommendation: Recommendation based
// on security concerns and score.
type GoogleCloudApigeeV1ScoreComponentRecommendation struct {
	// Actions: Actions for the recommendation to improve the security
	// score.
	Actions []*GoogleCloudApigeeV1ScoreComponentRecommendationAction `json:"actions,omitempty"`

	// Description: Description of the recommendation.
	Description string `json:"description,omitempty"`

	// Impact: Potential impact of this recommendation on the overall score.
	// This denotes how important this recommendation is to improve the
	// score.
	Impact int64 `json:"impact,omitempty"`

	// Title: Title represents recommendation title.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Actions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Actions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ScoreComponentRecommendation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ScoreComponentRecommendation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ScoreComponentRecommendationAction: Action to
// improve security score.
type GoogleCloudApigeeV1ScoreComponentRecommendationAction struct {
	// ActionContext: Action context for the action.
	ActionContext *GoogleCloudApigeeV1ScoreComponentRecommendationActionActionContext `json:"actionContext,omitempty"`

	// Description: Description of the action.
	Description string `json:"description,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ActionContext") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ActionContext") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ScoreComponentRecommendationAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ScoreComponentRecommendationAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1ScoreComponentRecommendationActionActionContext:
// Action context are all the relevant details for the action.
type GoogleCloudApigeeV1ScoreComponentRecommendationActionActionContext struct {
	// DocumentationLink: Documentation link for the action.
	DocumentationLink string `json:"documentationLink,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DocumentationLink")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DocumentationLink") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ScoreComponentRecommendationActionActionContext) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ScoreComponentRecommendationActionActionContext
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityAction: A SecurityAction is rule that can
// be enforced at an environment level. The result is one of: - A denied
// API call - An explicitly allowed API call - A flagged API call (HTTP
// headers added before the target receives it) At least one condition
// is required to create a SecurityAction.
type GoogleCloudApigeeV1SecurityAction struct {
	// Allow: Allow a request through if it matches this SecurityAction.
	Allow *GoogleCloudApigeeV1SecurityActionAllow `json:"allow,omitempty"`

	// ConditionConfig: Required. A valid SecurityAction must contain at
	// least one condition.
	ConditionConfig *GoogleCloudApigeeV1SecurityActionConditionConfig `json:"conditionConfig,omitempty"`

	// CreateTime: Output only. The create time for this SecurityAction.
	CreateTime string `json:"createTime,omitempty"`

	// Deny: Deny a request through if it matches this SecurityAction.
	Deny *GoogleCloudApigeeV1SecurityActionDeny `json:"deny,omitempty"`

	// Description: Optional. An optional user provided description of the
	// SecurityAction.
	Description string `json:"description,omitempty"`

	// ExpireTime: The expiration for this SecurityAction.
	ExpireTime string `json:"expireTime,omitempty"`

	// Flag: Flag a request through if it matches this SecurityAction.
	Flag *GoogleCloudApigeeV1SecurityActionFlag `json:"flag,omitempty"`

	// Name: Immutable. This field is ignored during creation as per
	// AIP-133. Please set the `security_action_id` field in the
	// CreateSecurityActionRequest when creating a new SecurityAction.
	// Format:
	// organizations/{org}/environments/{env}/securityActions/{security_actio
	// n}
	Name string `json:"name,omitempty"`

	// State: Required. Only an ENABLED SecurityAction is enforced. An
	// ENABLED SecurityAction past its expiration time will not be enforced.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This only exists for
	// forward compatibility. A create request with this value will be
	// rejected.
	//   "ENABLED" - An ENABLED SecurityAction is actively enforced if the
	// `expiration_time` is in the future.
	//   "DISABLED" - A disabled SecurityAction is never enforced.
	State string `json:"state,omitempty"`

	// Ttl: Input only. The TTL for this SecurityAction.
	Ttl string `json:"ttl,omitempty"`

	// UpdateTime: Output only. The update time for this SecurityAction.
	// This reflects when this SecurityAction changed states.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Allow") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Allow") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityAction
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityActionAllow: Message that should be set in
// case of an Allow Action. This does not have any fields.
type GoogleCloudApigeeV1SecurityActionAllow struct {
}

// GoogleCloudApigeeV1SecurityActionConditionConfig: The following are a
// list of conditions. A valid SecurityAction must contain at least one
// condition. Within a condition, each element is ORed. Across
// conditions elements are ANDed. For example if a SecurityAction has
// the following: ip_address_ranges: ["ip1", "ip2"] and bot_reasons:
// ["Flooder", "Robot Abuser"] then this is interpreted as: enforce the
// action if the incoming request has ((ip_address_ranges = "ip1" OR
// ip_address_ranges = "ip2") AND (bot_reasons="Flooder" OR
// bot_reasons="Robot Abuser")). Conditions other than ip_address_ranges
// and bot_reasons cannot be ANDed.
type GoogleCloudApigeeV1SecurityActionConditionConfig struct {
	// AccessTokens: Optional. A list of access_tokens. Limit 1000 per
	// action.
	AccessTokens []string `json:"accessTokens,omitempty"`

	// ApiKeys: Optional. A list of API keys. Limit 1000 per action.
	ApiKeys []string `json:"apiKeys,omitempty"`

	// ApiProducts: Optional. A list of API Products. Limit 1000 per action.
	ApiProducts []string `json:"apiProducts,omitempty"`

	// BotReasons: Optional. A list of Bot Reasons. Current options:
	// Flooder, Brute Guessor, Static Content Scraper, OAuth Abuser, Robot
	// Abuser, TorListRule, Advanced Anomaly Detection, Advanced API
	// Scraper, Search Engine Crawlers, Public Clouds, Public Cloud AWS,
	// Public Cloud Azure, and Public Cloud Google.
	BotReasons []string `json:"botReasons,omitempty"`

	// DeveloperApps: Optional. A list of developer apps. Limit 1000 per
	// action.
	DeveloperApps []string `json:"developerApps,omitempty"`

	// Developers: Optional. A list of developers. Limit 1000 per action.
	Developers []string `json:"developers,omitempty"`

	// IpAddressRanges: Optional. A list of IP addresses. This could be
	// either IPv4 or IPv6. Limited to 100 per action.
	IpAddressRanges []string `json:"ipAddressRanges,omitempty"`

	// UserAgents: Optional. A list of user agents to deny. We look for
	// exact matches. Limit 50 per action.
	UserAgents []string `json:"userAgents,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AccessTokens") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AccessTokens") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityActionConditionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityActionConditionConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityActionDeny: Message that should be set in
// case of a Deny Action.
type GoogleCloudApigeeV1SecurityActionDeny struct {
	// ResponseCode: Optional. The HTTP response code if the Action = DENY.
	ResponseCode int64 `json:"responseCode,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ResponseCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ResponseCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityActionDeny) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityActionDeny
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityActionFlag: The message that should be set
// in the case of a Flag action.
type GoogleCloudApigeeV1SecurityActionFlag struct {
	// Headers: Optional. A list of HTTP headers to be sent to the target in
	// case of a FLAG SecurityAction. Limit 5 headers per SecurityAction. At
	// least one is mandatory.
	Headers []*GoogleCloudApigeeV1SecurityActionHttpHeader `json:"headers,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Headers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Headers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityActionFlag) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityActionFlag
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityActionHttpHeader: An HTTP header.
type GoogleCloudApigeeV1SecurityActionHttpHeader struct {
	// Name: The header name to be sent to the target.
	Name string `json:"name,omitempty"`

	// Value: The header value to be sent to the target.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityActionHttpHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityActionHttpHeader
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityActionsConfig: SecurityActionsConfig
// reflects the current state of the SecurityActions feature. This is a
// singleton resource: https://google.aip.dev/156
type GoogleCloudApigeeV1SecurityActionsConfig struct {
	// Enabled: The flag that controls whether this feature is enabled. This
	// is `unset` by default. When this flag is `false`, even if individual
	// rules are enabled, no SecurityActions will be enforced.
	Enabled bool `json:"enabled,omitempty"`

	// Name: This is a singleton resource, the name will always be set by
	// SecurityActions and any user input will be ignored. The name is
	// always:
	// `organizations/{org}/environments/{env}/security_actions_config`
	Name string `json:"name,omitempty"`

	// UpdateTime: Output only. The update time for configuration.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityActionsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityActionsConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityIncident: Represents an SecurityIncident
// resource.
type GoogleCloudApigeeV1SecurityIncident struct {
	// DetectionTypes: Output only. Detection types which are part of the
	// incident. Examples: Flooder, OAuth Abuser, Static Content Scraper,
	// Anomaly Detection.
	DetectionTypes []string `json:"detectionTypes,omitempty"`

	// DisplayName: Optional. Display name of the security incident.
	DisplayName string `json:"displayName,omitempty"`

	// FirstDetectedTime: Output only. The time when events associated with
	// the incident were first detected.
	FirstDetectedTime string `json:"firstDetectedTime,omitempty"`

	// LastDetectedTime: Output only. The time when events associated with
	// the incident were last detected.
	LastDetectedTime string `json:"lastDetectedTime,omitempty"`

	// LastObservabilityChangeTime: Output only. The time when the incident
	// observability was last changed.
	LastObservabilityChangeTime string `json:"lastObservabilityChangeTime,omitempty"`

	// Name: Immutable. Name of the security incident resource. Format:
	// organizations/{org}/environments/{environment}/securityIncidents/{inci
	// dent} Example:
	// organizations/apigee-org/environments/dev/securityIncidents/1234-5678-
	// 9101-1111
	Name string `json:"name,omitempty"`

	// Observability: Optional. Indicates if the user archived this
	// incident.
	//
	// Possible values:
	//   "OBSERVABILITY_UNSPECIFIED" - The incident observability is
	// unspecified.
	//   "ACTIVE" - The incident is currently active. Can change to this
	// status from archived.
	//   "ARCHIVED" - The incident is currently archived and was archived by
	// the customer.
	Observability string `json:"observability,omitempty"`

	// RiskLevel: Output only. Risk level of the incident.
	//
	// Possible values:
	//   "RISK_LEVEL_UNSPECIFIED" - Risk Level Unspecified.
	//   "LOW" - Risk level of the incident is low.
	//   "MODERATE" - Risk level of the incident is moderate.
	//   "SEVERE" - Risk level of the incident is severe.
	RiskLevel string `json:"riskLevel,omitempty"`

	// TrafficCount: Total traffic detected as part of the incident.
	TrafficCount int64 `json:"trafficCount,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "DetectionTypes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DetectionTypes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityIncident) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityIncident
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityProfile: Represents a SecurityProfile
// resource.
type GoogleCloudApigeeV1SecurityProfile struct {
	// Description: Description of the security profile.
	Description string `json:"description,omitempty"`

	// DisplayName: DEPRECATED: DO NOT USE Display name of the security
	// profile.
	DisplayName string `json:"displayName,omitempty"`

	// Environments: List of environments attached to security profile.
	Environments []*GoogleCloudApigeeV1SecurityProfileEnvironment `json:"environments,omitempty"`

	// MaxScore: Output only. Maximum security score that can be generated
	// by this profile.
	MaxScore int64 `json:"maxScore,omitempty"`

	// MinScore: Output only. Minimum security score that can be generated
	// by this profile.
	MinScore int64 `json:"minScore,omitempty"`

	// Name: Immutable. Name of the security profile resource. Format:
	// organizations/{org}/securityProfiles/{profile}
	Name string `json:"name,omitempty"`

	// ProfileConfig: Required. Customized profile configuration that
	// computes the security score.
	ProfileConfig *GoogleCloudApigeeV1ProfileConfig `json:"profileConfig,omitempty"`

	// RevisionCreateTime: Output only. The time when revision was created.
	RevisionCreateTime string `json:"revisionCreateTime,omitempty"`

	// RevisionId: Output only. Revision ID of the security profile.
	RevisionId int64 `json:"revisionId,omitempty,string"`

	// RevisionPublishTime: Output only. DEPRECATED: DO NOT USE The time
	// when revision was published. Once published, the security profile
	// revision cannot be updated further and can be attached to
	// environments.
	RevisionPublishTime string `json:"revisionPublishTime,omitempty"`

	// RevisionUpdateTime: Output only. The time when revision was updated.
	RevisionUpdateTime string `json:"revisionUpdateTime,omitempty"`

	// ScoringConfigs: List of profile scoring configs in this revision.
	ScoringConfigs []*GoogleCloudApigeeV1SecurityProfileScoringConfig `json:"scoringConfigs,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityProfile) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityProfile
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityProfileEnvironment: Environment
// information of attached environments. Scoring an environment is
// enabled only if it is attached to a security profile.
type GoogleCloudApigeeV1SecurityProfileEnvironment struct {
	// AttachTime: Output only. Time at which environment was attached to
	// the security profile.
	AttachTime string `json:"attachTime,omitempty"`

	// Environment: Output only. Name of the environment.
	Environment string `json:"environment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AttachTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityProfileEnvironment) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityProfileEnvironment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityProfileEnvironmentAssociation: Represents
// a SecurityProfileEnvironmentAssociation resource.
type GoogleCloudApigeeV1SecurityProfileEnvironmentAssociation struct {
	// AttachTime: Output only. The time when environment was attached to
	// the security profile.
	AttachTime string `json:"attachTime,omitempty"`

	// Name: Immutable. Name of the environment that the profile is attached
	// to.
	Name string `json:"name,omitempty"`

	// SecurityProfileRevisionId: DEPRECATED: DO NOT USE Revision ID of the
	// security profile.
	SecurityProfileRevisionId int64 `json:"securityProfileRevisionId,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AttachTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AttachTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityProfileEnvironmentAssociation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityProfileEnvironmentAssociation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityProfileScoringConfig: Security
// configurations to manage scoring.
type GoogleCloudApigeeV1SecurityProfileScoringConfig struct {
	// Description: Description of the config.
	Description string `json:"description,omitempty"`

	// ScorePath: Path of the component config used for scoring.
	ScorePath string `json:"scorePath,omitempty"`

	// Title: Title of the config.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityProfileScoringConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityProfileScoringConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityReport: SecurityReport saves all the
// information about the created security report.
type GoogleCloudApigeeV1SecurityReport struct {
	// Created: Creation time of the query.
	Created string `json:"created,omitempty"`

	// DisplayName: Display Name specified by the user.
	DisplayName string `json:"displayName,omitempty"`

	// EnvgroupHostname: Hostname is available only when query is executed
	// at host level.
	EnvgroupHostname string `json:"envgroupHostname,omitempty"`

	// Error: Error is set when query fails.
	Error string `json:"error,omitempty"`

	// ExecutionTime: ExecutionTime is available only after the query is
	// completed.
	ExecutionTime string `json:"executionTime,omitempty"`

	// QueryParams: Contains information like metrics, dimenstions etc of
	// the Security Report.
	QueryParams *GoogleCloudApigeeV1SecurityReportMetadata `json:"queryParams,omitempty"`

	// ReportDefinitionId: Report Definition ID.
	ReportDefinitionId string `json:"reportDefinitionId,omitempty"`

	// Result: Result is available only after the query is completed.
	Result *GoogleCloudApigeeV1SecurityReportResultMetadata `json:"result,omitempty"`

	// ResultFileSize: ResultFileSize is available only after the query is
	// completed.
	ResultFileSize string `json:"resultFileSize,omitempty"`

	// ResultRows: ResultRows is available only after the query is
	// completed.
	ResultRows int64 `json:"resultRows,omitempty,string"`

	// Self: Self link of the query. Example:
	// `/organizations/myorg/environments/myenv/securityReports/9cfc0d85-0f30
	// -46d6-ae6f-318d0cb961bd` or following format if query is running at
	// host level:
	// `/organizations/myorg/hostSecurityReports/9cfc0d85-0f30-46d6-ae6f-318d
	// 0cb961bd`
	Self string `json:"self,omitempty"`

	// State: Query state could be "enqueued", "running", "completed",
	// "expired" and "failed".
	State string `json:"state,omitempty"`

	// Updated: Output only. Last updated timestamp for the query.
	Updated string `json:"updated,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Created") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Created") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityReport) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityReport
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityReportMetadata: Metadata for the security
// report.
type GoogleCloudApigeeV1SecurityReportMetadata struct {
	// Dimensions: Dimensions of the SecurityReport.
	Dimensions []string `json:"dimensions,omitempty"`

	// EndTimestamp: End timestamp of the query range.
	EndTimestamp string `json:"endTimestamp,omitempty"`

	// Metrics: Metrics of the SecurityReport. Example:
	// ["name:bot_count,func:sum,alias:sum_bot_count"]
	Metrics []string `json:"metrics,omitempty"`

	// MimeType: MIME type / Output format.
	MimeType string `json:"mimeType,omitempty"`

	// StartTimestamp: Start timestamp of the query range.
	StartTimestamp string `json:"startTimestamp,omitempty"`

	// TimeUnit: Query GroupBy time unit. Example: "seconds", "minute",
	// "hour"
	TimeUnit string `json:"timeUnit,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityReportMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityReportMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityReportQuery: Body structure when user
// makes a request to create a security report.
type GoogleCloudApigeeV1SecurityReportQuery struct {
	// CsvDelimiter: Delimiter used in the CSV file, if `outputFormat` is
	// set to `csv`. Defaults to the `,` (comma) character. Supported
	// delimiter characters include comma (`,`), pipe (`|`), and tab (`\t`).
	CsvDelimiter string `json:"csvDelimiter,omitempty"`

	// Dimensions: A list of dimensions.
	// https://docs.apigee.com/api-platform/analytics/analytics-reference#dimensions
	Dimensions []string `json:"dimensions,omitempty"`

	// DisplayName: Security Report display name which users can specify.
	DisplayName string `json:"displayName,omitempty"`

	// EnvgroupHostname: Hostname needs to be specified if query intends to
	// run at host level. This field is only allowed when query is submitted
	// by CreateHostSecurityReport where analytics data will be grouped by
	// organization and hostname.
	EnvgroupHostname string `json:"envgroupHostname,omitempty"`

	// Filter: Boolean expression that can be used to filter data. Filter
	// expressions can be combined using AND/OR terms and should be fully
	// parenthesized to avoid ambiguity. See Analytics metrics, dimensions,
	// and filters reference
	// https://docs.apigee.com/api-platform/analytics/analytics-reference
	// for more information on the fields available to filter on. For more
	// information on the tokens that you use to build filter expressions,
	// see Filter expression syntax.
	// https://docs.apigee.com/api-platform/analytics/asynch-reports-api#filter-expression-syntax
	Filter string `json:"filter,omitempty"`

	// GroupByTimeUnit: Time unit used to group the result set. Valid values
	// include: second, minute, hour, day, week, or month. If a query
	// includes groupByTimeUnit, then the result is an aggregation based on
	// the specified time unit and the resultant timestamp does not include
	// milliseconds precision. If a query omits groupByTimeUnit, then the
	// resultant timestamp includes milliseconds precision.
	GroupByTimeUnit string `json:"groupByTimeUnit,omitempty"`

	// Limit: Maximum number of rows that can be returned in the result.
	Limit int64 `json:"limit,omitempty"`

	// Metrics: A list of Metrics.
	Metrics []*GoogleCloudApigeeV1SecurityReportQueryMetric `json:"metrics,omitempty"`

	// MimeType: Valid values include: `csv` or `json`. Defaults to `json`.
	// Note: Configure the delimiter for CSV output using the csvDelimiter
	// property.
	MimeType string `json:"mimeType,omitempty"`

	// ReportDefinitionId: Report Definition ID.
	ReportDefinitionId string `json:"reportDefinitionId,omitempty"`

	// TimeRange: Required. Time range for the query. Can use the following
	// predefined strings to specify the time range: `last60minutes`
	// `last24hours` `last7days` Or, specify the timeRange as a structure
	// describing start and end timestamps in the ISO format:
	// yyyy-mm-ddThh:mm:ssZ. Example: "timeRange": { "start":
	// "2018-07-29T00:13:00Z", "end": "2018-08-01T00:18:00Z" }
	TimeRange interface{} `json:"timeRange,omitempty"`

	// ForceSendFields is a list of field names (e.g. "CsvDelimiter") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CsvDelimiter") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityReportQuery) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityReportQuery
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityReportQueryMetric: Metric of the Query
type GoogleCloudApigeeV1SecurityReportQueryMetric struct {
	// AggregationFunction: Aggregation function: avg, min, max, or sum.
	AggregationFunction string `json:"aggregationFunction,omitempty"`

	// Alias: Alias for the metric. Alias will be used to replace metric
	// name in query results.
	Alias string `json:"alias,omitempty"`

	// Name: Required. Metric name.
	Name string `json:"name,omitempty"`

	// Operator: One of `+`, `-`, `/`, `%`, `*`.
	Operator string `json:"operator,omitempty"`

	// Value: Operand value should be provided when operator is set.
	Value string `json:"value,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AggregationFunction")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AggregationFunction") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityReportQueryMetric) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityReportQueryMetric
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityReportResultMetadata: Contains
// informations about the security report results.
type GoogleCloudApigeeV1SecurityReportResultMetadata struct {
	// Expires: Output only. Expire_time is set to 7 days after report
	// creation. Query result will be unaccessable after this time. Example:
	// "2021-05-04T13:38:52-07:00"
	Expires string `json:"expires,omitempty"`

	// Self: Self link of the query results. Example:
	// `/organizations/myorg/environments/myenv/securityReports/9cfc0d85-0f30
	// -46d6-ae6f-318d0cb961bd/result` or following format if query is
	// running at host level:
	// `/organizations/myorg/hostSecurityReports/9cfc0d85-0f30-46d6-ae6f-318d
	// 0cb961bd/result`
	Self string `json:"self,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Expires") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Expires") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityReportResultMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityReportResultMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecurityReportResultView: The response for
// security report result view APIs.
type GoogleCloudApigeeV1SecurityReportResultView struct {
	// Code: Error code when there is a failure.
	Code int64 `json:"code,omitempty"`

	// Error: Error message when there is a failure.
	Error string `json:"error,omitempty"`

	// Metadata: Metadata contains information like metrics, dimenstions etc
	// of the security report.
	Metadata *GoogleCloudApigeeV1SecurityReportMetadata `json:"metadata,omitempty"`

	// Rows: Rows of security report result. Each row is a JSON object.
	// Example: {sum(message_count): 1, developer_app: "(not set)",…}
	Rows []interface{} `json:"rows,omitempty"`

	// State: State of retrieving ResultView.
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecurityReportResultView) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecurityReportResultView
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SecuritySettings: SecuritySettings reflects the
// current state of the SecuritySettings feature.
type GoogleCloudApigeeV1SecuritySettings struct {
	// MlRetrainingFeedbackEnabled: Optional. If true the user consents to
	// the use of ML models for Abuse detection.
	MlRetrainingFeedbackEnabled bool `json:"mlRetrainingFeedbackEnabled,omitempty"`

	// Name: Identifier. Full resource name is always
	// `organizations/{org}/securitySettings`.
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "MlRetrainingFeedbackEnabled") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted
	// from API requests. However, any non-pointer, non-interface field
	// appearing in ForceSendFields will be sent to the server regardless of
	// whether the field is empty or not. This may be used to include empty
	// fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g.
	// "MlRetrainingFeedbackEnabled") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted
	// from API requests. However, any field with an empty value appearing
	// in NullFields will be sent to the server as null. It is an error if a
	// field in this list has a non-empty value. This may be used to include
	// null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SecuritySettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SecuritySettings
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1ServiceIssuersMapping struct {
	// EmailIds: List of trusted issuer email ids.
	EmailIds []string `json:"emailIds,omitempty"`

	// Service: String indicating the Apigee service name.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EmailIds") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EmailIds") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1ServiceIssuersMapping) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1ServiceIssuersMapping
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Session: Session carries the debug session id and
// its creation time.
type GoogleCloudApigeeV1Session struct {
	// Id: The debug session ID.
	Id string `json:"id,omitempty"`

	// TimestampMs: The first transaction creation timestamp in millisecond,
	// recorded by UAP.
	TimestampMs int64 `json:"timestampMs,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "Id") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Id") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Session) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Session
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SetAddonEnablementRequest: Request for
// SetAddonEnablement.
type GoogleCloudApigeeV1SetAddonEnablementRequest struct {
	// AnalyticsEnabled: If the Analytics should be enabled in the
	// environment.
	AnalyticsEnabled bool `json:"analyticsEnabled,omitempty"`

	// ApiSecurityEnabled: If the API Security should be enabled in the
	// environment.
	ApiSecurityEnabled bool `json:"apiSecurityEnabled,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AnalyticsEnabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AnalyticsEnabled") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SetAddonEnablementRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SetAddonEnablementRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SetAddonsRequest: Request for SetAddons.
type GoogleCloudApigeeV1SetAddonsRequest struct {
	// AddonsConfig: Required. Add-on configurations.
	AddonsConfig *GoogleCloudApigeeV1AddonsConfig `json:"addonsConfig,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AddonsConfig") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AddonsConfig") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SetAddonsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SetAddonsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SharedFlow: The metadata describing a shared flow
type GoogleCloudApigeeV1SharedFlow struct {
	// LatestRevisionId: The id of the most recently created revision for
	// this shared flow.
	LatestRevisionId string `json:"latestRevisionId,omitempty"`

	// MetaData: Metadata describing the shared flow.
	MetaData *GoogleCloudApigeeV1EntityMetadata `json:"metaData,omitempty"`

	// Name: The ID of the shared flow.
	Name string `json:"name,omitempty"`

	// Revision: A list of revisions of this shared flow.
	Revision []string `json:"revision,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "LatestRevisionId") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "LatestRevisionId") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SharedFlow) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SharedFlow
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1SharedFlowRevision: The metadata describing a
// shared flow revision.
type GoogleCloudApigeeV1SharedFlowRevision struct {
	// ConfigurationVersion: The version of the configuration schema to
	// which this shared flow conforms. The only supported value currently
	// is majorVersion 4 and minorVersion 0. This setting may be used in the
	// future to enable evolution of the shared flow format.
	ConfigurationVersion *GoogleCloudApigeeV1ConfigVersion `json:"configurationVersion,omitempty"`

	// ContextInfo: A textual description of the shared flow revision.
	ContextInfo string `json:"contextInfo,omitempty"`

	// CreatedAt: Time at which this shared flow revision was created, in
	// milliseconds since epoch.
	CreatedAt int64 `json:"createdAt,omitempty,string"`

	// Description: Description of the shared flow revision.
	Description string `json:"description,omitempty"`

	// DisplayName: The human readable name of this shared flow.
	DisplayName string `json:"displayName,omitempty"`

	// EntityMetaDataAsProperties: A Key-Value map of metadata about this
	// shared flow revision.
	EntityMetaDataAsProperties map[string]string `json:"entityMetaDataAsProperties,omitempty"`

	// LastModifiedAt: Time at which this shared flow revision was most
	// recently modified, in milliseconds since epoch.
	LastModifiedAt int64 `json:"lastModifiedAt,omitempty,string"`

	// Name: The resource ID of the parent shared flow.
	Name string `json:"name,omitempty"`

	// Policies: A list of policy names included in this shared flow
	// revision.
	Policies []string `json:"policies,omitempty"`

	// ResourceFiles: The resource files included in this shared flow
	// revision.
	ResourceFiles *GoogleCloudApigeeV1ResourceFiles `json:"resourceFiles,omitempty"`

	// Resources: A list of the resources included in this shared flow
	// revision formatted as "{type}://{name}".
	Resources []string `json:"resources,omitempty"`

	// Revision: The resource ID of this revision.
	Revision string `json:"revision,omitempty"`

	// SharedFlows: A list of the shared flow names included in this shared
	// flow revision.
	SharedFlows []string `json:"sharedFlows,omitempty"`

	// Type: The string "Application"
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g.
	// "ConfigurationVersion") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ConfigurationVersion") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SharedFlowRevision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SharedFlowRevision
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Stats: Encapsulates a `stats` response.
type GoogleCloudApigeeV1Stats struct {
	// Environments: List of query results on the environment level.
	Environments []*GoogleCloudApigeeV1StatsEnvironmentStats `json:"environments,omitempty"`

	// Hosts: List of query results grouped by host.
	Hosts []*GoogleCloudApigeeV1StatsHostStats `json:"hosts,omitempty"`

	// MetaData: Metadata information.
	MetaData *GoogleCloudApigeeV1Metadata `json:"metaData,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Environments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Environments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Stats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Stats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1StatsEnvironmentStats: Encapsulates the
// environment wrapper: ``` "environments": [ { "metrics": [ { "name":
// "sum(message_count)", "values": [ "2.52056245E8" ] } ], "name":
// "prod" } ]```
type GoogleCloudApigeeV1StatsEnvironmentStats struct {
	// Dimensions: List of metrics grouped under dimensions.
	Dimensions []*GoogleCloudApigeeV1DimensionMetric `json:"dimensions,omitempty"`

	// Metrics: In the final response, only one of the following fields will
	// be present based on the dimensions provided. If no dimensions are
	// provided, then only top-level metrics is provided. If dimensions are
	// included, then there will be a top-level dimensions field under
	// environments which will contain metrics values and the dimension
	// name. Example: ``` "environments": [ { "dimensions": [ { "metrics": [
	// { "name": "sum(message_count)", "values": [ "2.14049521E8" ] } ],
	// "name": "nit_proxy" } ], "name": "prod" } ]``` or ``"environments":
	// [ { "metrics": [ { "name": "sum(message_count)", "values": [
	// "2.19026331E8" ] } ], "name": "prod" } ]``` List of metric values.
	Metrics []*GoogleCloudApigeeV1Metric `json:"metrics,omitempty"`

	// Name: Name of the environment.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1StatsEnvironmentStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1StatsEnvironmentStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1StatsHostStats: Encapsulates the hostname wrapper:
// ``` "hosts": [ { "metrics": [ { "name": "sum(message_count)",
// "values": [ "2.52056245E8" ] } ], "name": "example.com" } ]```
type GoogleCloudApigeeV1StatsHostStats struct {
	// Dimensions: List of metrics grouped under dimensions.
	Dimensions []*GoogleCloudApigeeV1DimensionMetric `json:"dimensions,omitempty"`

	// Metrics: In the final response, only one of the following fields will
	// be present based on the dimensions provided. If no dimensions are
	// provided, then only the top-level metrics are provided. If dimensions
	// are included, then there will be a top-level dimensions field under
	// hostnames which will contain metrics values and the dimension name.
	// Example: ``` "hosts": [ { "dimensions": [ { "metrics": [ { "name":
	// "sum(message_count)", "values": [ "2.14049521E8" ] } ], "name":
	// "nit_proxy" } ], "name": "example.com" } ]``` OR ``"hosts": [ {
	// "metrics": [ { "name": "sum(message_count)", "values": [
	// "2.19026331E8" ] } ], "name": "example.com" } ]``` List of metric
	// values.
	Metrics []*GoogleCloudApigeeV1Metric `json:"metrics,omitempty"`

	// Name: Hostname used in query.
	Name string `json:"name,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Dimensions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Dimensions") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1StatsHostStats) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1StatsHostStats
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1Subscription: Pub/Sub subscription of an
// environment.
type GoogleCloudApigeeV1Subscription struct {
	// Name: Full name of the Pub/Sub subcription. Use the following
	// structure in your request: `subscription
	// "projects/foo/subscription/bar"
	Name string `json:"name,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Name") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Name") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1Subscription) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1Subscription
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1SyncAuthorization struct {
	// Etag: Entity tag (ETag) used for optimistic concurrency control as a
	// way to help prevent simultaneous updates from overwriting each other.
	// For example, when you call getSyncAuthorization
	// (organizations/getSyncAuthorization) an ETag is returned in the
	// response. Pass that ETag when calling the setSyncAuthorization
	// (organizations/setSyncAuthorization) to ensure that you are updating
	// the correct version. If you don't pass the ETag in the call to
	// `setSyncAuthorization`, then the existing authorization is
	// overwritten indiscriminately. **Note**: We strongly recommend that
	// you use the ETag in the read-modify-write cycle to avoid race
	// conditions.
	Etag string `json:"etag,omitempty"`

	// Identities: Required. Array of service accounts to grant access to
	// control plane resources, each specified using the following format:
	// `serviceAccount:` service-account-name. The service-account-name is
	// formatted like an email address. For example:
	// `my-synchronizer-manager-service_account@my_project_id.iam.gserviceacc
	// ount.com` You might specify multiple service accounts, for example,
	// if you have multiple environments and wish to assign a unique service
	// account to each one. The service accounts must have **Apigee
	// Synchronizer Manager** role. See also Create service accounts
	// (https://cloud.google.com/apigee/docs/hybrid/latest/sa-about#create-the-service-accounts).
	Identities []string `json:"identities,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Etag") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Etag") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1SyncAuthorization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1SyncAuthorization
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1TargetServer: TargetServer configuration.
// TargetServers are used to decouple a proxy TargetEndpoint
// HTTPTargetConnections from concrete URLs for backend services.
type GoogleCloudApigeeV1TargetServer struct {
	// Description: Optional. A human-readable description of this
	// TargetServer.
	Description string `json:"description,omitempty"`

	// Host: Required. The host name this target connects to. Value must be
	// a valid hostname as described by RFC-1123.
	Host string `json:"host,omitempty"`

	// IsEnabled: Optional. Enabling/disabling a TargetServer is useful when
	// TargetServers are used in load balancing configurations, and one or
	// more TargetServers need to taken out of rotation periodically.
	// Defaults to true.
	IsEnabled bool `json:"isEnabled,omitempty"`

	// Name: Required. The resource id of this target server. Values must
	// match the regular expression
	Name string `json:"name,omitempty"`

	// Port: Required. The port number this target connects to on the given
	// host. Value must be between 1 and 65535, inclusive.
	Port int64 `json:"port,omitempty"`

	// Protocol: Immutable. The protocol used by this TargetServer.
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - UNSPECIFIED defaults to HTTP for backwards
	// compatibility.
	//   "HTTP" - The TargetServer uses HTTP.
	//   "HTTP2" - The TargetSever uses HTTP2.
	//   "GRPC_TARGET" - The TargetServer uses GRPC.
	//   "GRPC" - GRPC TargetServer to be used in ExternalCallout Policy.
	// Prefer to use EXTERNAL_CALLOUT instead. TODO(b/266125112) deprecate
	// once EXTERNAL _CALLOUT generally available.
	//   "EXTERNAL_CALLOUT" - The TargetServer is to be used in the
	// ExternalCallout Policy
	Protocol string `json:"protocol,omitempty"`

	// SSLInfo: Optional. Specifies TLS configuration info for this
	// TargetServer. The JSON name is `sSLInfo` for legacy/backwards
	// compatibility reasons -- Edge originally supported SSL, and the name
	// is still used for TLS configuration.
	SSLInfo *GoogleCloudApigeeV1TlsInfo `json:"sSLInfo,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TargetServer) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TargetServer
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1TargetServerConfig struct {
	// Enabled: Whether the target server is enabled. An empty/omitted value
	// for this field should be interpreted as true.
	Enabled bool `json:"enabled,omitempty"`

	// Host: Host name of the target server.
	Host string `json:"host,omitempty"`

	// Name: Target server revision name in the following format:
	// `organizations/{org}/environments/{env}/targetservers/{targetserver}/r
	// evisions/{rev}`
	Name string `json:"name,omitempty"`

	// Port: Port number for the target server.
	Port int64 `json:"port,omitempty"`

	// Protocol: The protocol used by this target server.
	//
	// Possible values:
	//   "PROTOCOL_UNSPECIFIED" - UNSPECIFIED defaults to HTTP for backwards
	// compatibility.
	//   "HTTP" - The TargetServer uses HTTP.
	//   "HTTP2" - The TargetSever uses HTTP2.
	//   "GRPC_TARGET" - The TargetServer uses GRPC.
	//   "GRPC" - GRPC TargetServer to be used in ExternalCallout Policy.
	// Prefer to use EXTERNAL_CALLOUT instead. TODO(b/266125112) deprecate
	// once EXTERNAL _CALLOUT generally available.
	//   "EXTERNAL_CALLOUT" - The TargetServer is to be used in the
	// ExternalCallout Policy
	Protocol string `json:"protocol,omitempty"`

	// TlsInfo: TLS settings for the target server.
	TlsInfo *GoogleCloudApigeeV1TlsInfoConfig `json:"tlsInfo,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Enabled") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Enabled") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TargetServerConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TargetServerConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1TestDatastoreResponse: The response for
// TestDatastore
type GoogleCloudApigeeV1TestDatastoreResponse struct {
	// Error: Output only. Error message of test connection failure
	Error string `json:"error,omitempty"`

	// State: Output only. It could be `completed` or `failed`
	State string `json:"state,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Error") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Error") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TestDatastoreResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TestDatastoreResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1TlsInfo: TLS configuration information for virtual
// hosts and TargetServers.
type GoogleCloudApigeeV1TlsInfo struct {
	// Ciphers: The SSL/TLS cipher suites to be used. For programmable
	// proxies, it must be one of the cipher suite names listed in:
	// http://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html#ciphersuites.
	// For configurable proxies, it must follow the configuration specified
	// in:
	// https://commondatastorage.googleapis.com/chromium-boringssl-docs/ssl.h.html#Cipher-suite-configuration.
	// This setting has no effect for configurable proxies when negotiating
	// TLS 1.3.
	Ciphers []string `json:"ciphers,omitempty"`

	// ClientAuthEnabled: Optional. Enables two-way TLS.
	ClientAuthEnabled bool `json:"clientAuthEnabled,omitempty"`

	// CommonName: The TLS Common Name of the certificate.
	CommonName *GoogleCloudApigeeV1TlsInfoCommonName `json:"commonName,omitempty"`

	// Enabled: Required. Enables TLS. If false, neither one-way nor two-way
	// TLS will be enabled.
	Enabled bool `json:"enabled,omitempty"`

	// IgnoreValidationErrors: If true, Edge ignores TLS certificate errors.
	// Valid when configuring TLS for target servers and target endpoints,
	// and when configuring virtual hosts that use 2-way TLS. When used with
	// a target endpoint/target server, if the backend system uses SNI and
	// returns a cert with a subject Distinguished Name (DN) that does not
	// match the hostname, there is no way to ignore the error and the
	// connection fails.
	IgnoreValidationErrors bool `json:"ignoreValidationErrors,omitempty"`

	// KeyAlias: Required if `client_auth_enabled` is true. The resource ID
	// for the alias containing the private key and cert.
	KeyAlias string `json:"keyAlias,omitempty"`

	// KeyStore: Required if `client_auth_enabled` is true. The resource ID
	// of the keystore.
	KeyStore string `json:"keyStore,omitempty"`

	// Protocols: The TLS versioins to be used.
	Protocols []string `json:"protocols,omitempty"`

	// TrustStore: The resource ID of the truststore.
	TrustStore string `json:"trustStore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Ciphers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ciphers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TlsInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TlsInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1TlsInfoCommonName struct {
	// Value: The TLS Common Name string of the certificate.
	Value string `json:"value,omitempty"`

	// WildcardMatch: Indicates whether the cert should be matched against
	// as a wildcard cert.
	WildcardMatch bool `json:"wildcardMatch,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Value") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Value") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TlsInfoCommonName) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TlsInfoCommonName
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

type GoogleCloudApigeeV1TlsInfoConfig struct {
	// Ciphers: List of ciphers that are granted access.
	Ciphers []string `json:"ciphers,omitempty"`

	// ClientAuthEnabled: Flag that specifies whether client-side
	// authentication is enabled for the target server. Enables two-way TLS.
	ClientAuthEnabled bool `json:"clientAuthEnabled,omitempty"`

	// CommonName: Common name to validate the target server against.
	CommonName *GoogleCloudApigeeV1CommonNameConfig `json:"commonName,omitempty"`

	// Enabled: Flag that specifies whether one-way TLS is enabled. Set to
	// `true` to enable one-way TLS.
	Enabled bool `json:"enabled,omitempty"`

	// IgnoreValidationErrors: Flag that specifies whether to ignore TLS
	// certificate validation errors. Set to `true` to ignore errors.
	IgnoreValidationErrors bool `json:"ignoreValidationErrors,omitempty"`

	// KeyAlias: Name of the alias used for client-side authentication in
	// the following format:
	// `organizations/{org}/environments/{env}/keystores/{keystore}/aliases/{
	// alias}`
	KeyAlias string `json:"keyAlias,omitempty"`

	// KeyAliasReference: Reference name and alias pair to use for
	// client-side authentication.
	KeyAliasReference *GoogleCloudApigeeV1KeyAliasReference `json:"keyAliasReference,omitempty"`

	// Protocols: List of TLS protocols that are granted access.
	Protocols []string `json:"protocols,omitempty"`

	// TrustStore: Name of the keystore or keystore reference containing
	// trusted certificates for the server in the following format:
	// `organizations/{org}/environments/{env}/keystores/{keystore}` or
	// `organizations/{org}/environments/{env}/references/{reference}`
	TrustStore string `json:"trustStore,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Ciphers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Ciphers") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TlsInfoConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TlsInfoConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1TraceConfig: TraceConfig defines the
// configurations in an environment of distributed trace.
type GoogleCloudApigeeV1TraceConfig struct {
	// Endpoint: Required. Endpoint of the exporter.
	Endpoint string `json:"endpoint,omitempty"`

	// Exporter: Required. Exporter that is used to view the distributed
	// trace captured using OpenCensus. An exporter sends traces to any
	// backend that is capable of consuming them. Recorded spans can be
	// exported by registered exporters.
	//
	// Possible values:
	//   "EXPORTER_UNSPECIFIED" - Exporter unspecified
	//   "JAEGER" - Jaeger exporter
	//   "CLOUD_TRACE" - Cloudtrace exporter
	Exporter string `json:"exporter,omitempty"`

	// SamplingConfig: Distributed trace configuration for all API proxies
	// in an environment. You can also override the configuration for a
	// specific API proxy using the distributed trace configuration
	// overrides API.
	SamplingConfig *GoogleCloudApigeeV1TraceSamplingConfig `json:"samplingConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Endpoint") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Endpoint") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TraceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TraceConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1TraceConfigOverride: A representation of a
// configuration override.
type GoogleCloudApigeeV1TraceConfigOverride struct {
	// ApiProxy: ID of the API proxy that will have its trace configuration
	// overridden.
	ApiProxy string `json:"apiProxy,omitempty"`

	// Name: ID of the trace configuration override specified as a
	// system-generated UUID.
	Name string `json:"name,omitempty"`

	// SamplingConfig: Trace configuration to override.
	SamplingConfig *GoogleCloudApigeeV1TraceSamplingConfig `json:"samplingConfig,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "ApiProxy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ApiProxy") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TraceConfigOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TraceConfigOverride
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1TraceSamplingConfig: TraceSamplingConfig
// represents the detail settings of distributed tracing. Only the
// fields that are defined in the distributed trace configuration can be
// overridden using the distribute trace configuration override APIs.
type GoogleCloudApigeeV1TraceSamplingConfig struct {
	// Sampler: Sampler of distributed tracing. OFF is the default value.
	//
	// Possible values:
	//   "SAMPLER_UNSPECIFIED" - Sampler unspecified.
	//   "OFF" - OFF means distributed trace is disabled, or the sampling
	// probability is 0.
	//   "PROBABILITY" - PROBABILITY means traces are captured on a
	// probability that defined by sampling_rate. The sampling rate is
	// limited to 0 to 0.5 when this is set.
	Sampler string `json:"sampler,omitempty"`

	// SamplingRate: Field sampling rate. This value is only applicable when
	// using the PROBABILITY sampler. The supported values are > 0 and <=
	// 0.5.
	SamplingRate float64 `json:"samplingRate,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Sampler") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Sampler") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1TraceSamplingConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1TraceSamplingConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

func (s *GoogleCloudApigeeV1TraceSamplingConfig) UnmarshalJSON(data []byte) error {
	type NoMethod GoogleCloudApigeeV1TraceSamplingConfig
	var s1 struct {
		SamplingRate gensupport.JSONFloat64 `json:"samplingRate"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.SamplingRate = float64(s1.SamplingRate)
	return nil
}

// GoogleCloudApigeeV1UpdateAppGroupAppKeyRequest: Request for
// UpdateAppGroupAppKey
type GoogleCloudApigeeV1UpdateAppGroupAppKeyRequest struct {
	// Action: Approve or revoke the consumer key by setting this value to
	// `approve` or `revoke` respectively. The `Content-Type` header, if
	// set, must be set to `application/octet-stream`, with empty body.
	Action string `json:"action,omitempty"`

	// ApiProducts: The list of API products that will be associated with
	// the credential. This list will be appended to the existing list of
	// associated API Products for this App Key. Duplicates will be ignored.
	ApiProducts []string `json:"apiProducts,omitempty"`

	// AppGroupAppKey: The new AppGroupKey to be amended. Note that the
	// status can be updated only via action.
	AppGroupAppKey *GoogleCloudApigeeV1AppGroupAppKey `json:"appGroupAppKey,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Action") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Action") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1UpdateAppGroupAppKeyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1UpdateAppGroupAppKeyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1UpdateError: Details on why a resource update
// failed in the runtime.
type GoogleCloudApigeeV1UpdateError struct {
	// Code: Status code.
	//
	// Possible values:
	//   "OK" - Not an error; returned on success. HTTP Mapping: 200 OK
	//   "CANCELLED" - The operation was cancelled, typically by the caller.
	// HTTP Mapping: 499 Client Closed Request
	//   "UNKNOWN" - Unknown error. For example, this error may be returned
	// when a `Status` value received from another address space belongs to
	// an error space that is not known in this address space. Also errors
	// raised by APIs that do not return enough error information may be
	// converted to this error. HTTP Mapping: 500 Internal Server Error
	//   "INVALID_ARGUMENT" - The client specified an invalid argument. Note
	// that this differs from `FAILED_PRECONDITION`. `INVALID_ARGUMENT`
	// indicates arguments that are problematic regardless of the state of
	// the system (e.g., a malformed file name). HTTP Mapping: 400 Bad
	// Request
	//   "DEADLINE_EXCEEDED" - The deadline expired before the operation
	// could complete. For operations that change the state of the system,
	// this error may be returned even if the operation has completed
	// successfully. For example, a successful response from a server could
	// have been delayed long enough for the deadline to expire. HTTP
	// Mapping: 504 Gateway Timeout
	//   "NOT_FOUND" - Some requested entity (e.g., file or directory) was
	// not found. Note to server developers: if a request is denied for an
	// entire class of users, such as gradual feature rollout or
	// undocumented allowlist, `NOT_FOUND` may be used. If a request is
	// denied for some users within a class of users, such as user-based
	// access control, `PERMISSION_DENIED` must be used. HTTP Mapping: 404
	// Not Found
	//   "ALREADY_EXISTS" - The entity that a client attempted to create
	// (e.g., file or directory) already exists. HTTP Mapping: 409 Conflict
	//   "PERMISSION_DENIED" - The caller does not have permission to
	// execute the specified operation. `PERMISSION_DENIED` must not be used
	// for rejections caused by exhausting some resource (use
	// `RESOURCE_EXHAUSTED` instead for those errors). `PERMISSION_DENIED`
	// must not be used if the caller can not be identified (use
	// `UNAUTHENTICATED` instead for those errors). This error code does not
	// imply the request is valid or the requested entity exists or
	// satisfies other pre-conditions. HTTP Mapping: 403 Forbidden
	//   "UNAUTHENTICATED" - The request does not have valid authentication
	// credentials for the operation. HTTP Mapping: 401 Unauthorized
	//   "RESOURCE_EXHAUSTED" - Some resource has been exhausted, perhaps a
	// per-user quota, or perhaps the entire file system is out of space.
	// HTTP Mapping: 429 Too Many Requests
	//   "FAILED_PRECONDITION" - The operation was rejected because the
	// system is not in a state required for the operation's execution. For
	// example, the directory to be deleted is non-empty, an rmdir operation
	// is applied to a non-directory, etc. Service implementors can use the
	// following guidelines to decide between `FAILED_PRECONDITION`,
	// `ABORTED`, and `UNAVAILABLE`: (a) Use `UNAVAILABLE` if the client can
	// retry just the failing call. (b) Use `ABORTED` if the client should
	// retry at a higher level. For example, when a client-specified
	// test-and-set fails, indicating the client should restart a
	// read-modify-write sequence. (c) Use `FAILED_PRECONDITION` if the
	// client should not retry until the system state has been explicitly
	// fixed. For example, if an "rmdir" fails because the directory is
	// non-empty, `FAILED_PRECONDITION` should be returned since the client
	// should not retry unless the files are deleted from the directory.
	// HTTP Mapping: 400 Bad Request
	//   "ABORTED" - The operation was aborted, typically due to a
	// concurrency issue such as a sequencer check failure or transaction
	// abort. See the guidelines above for deciding between
	// `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping:
	// 409 Conflict
	//   "OUT_OF_RANGE" - The operation was attempted past the valid range.
	// E.g., seeking or reading past end-of-file. Unlike `INVALID_ARGUMENT`,
	// this error indicates a problem that may be fixed if the system state
	// changes. For example, a 32-bit file system will generate
	// `INVALID_ARGUMENT` if asked to read at an offset that is not in the
	// range [0,2^32-1], but it will generate `OUT_OF_RANGE` if asked to
	// read from an offset past the current file size. There is a fair bit
	// of overlap between `FAILED_PRECONDITION` and `OUT_OF_RANGE`. We
	// recommend using `OUT_OF_RANGE` (the more specific error) when it
	// applies so that callers who are iterating through a space can easily
	// look for an `OUT_OF_RANGE` error to detect when they are done. HTTP
	// Mapping: 400 Bad Request
	//   "UNIMPLEMENTED" - The operation is not implemented or is not
	// supported/enabled in this service. HTTP Mapping: 501 Not Implemented
	//   "INTERNAL" - Internal errors. This means that some invariants
	// expected by the underlying system have been broken. This error code
	// is reserved for serious errors. HTTP Mapping: 500 Internal Server
	// Error
	//   "UNAVAILABLE" - The service is currently unavailable. This is most
	// likely a transient condition, which can be corrected by retrying with
	// a backoff. Note that it is not always safe to retry non-idempotent
	// operations. See the guidelines above for deciding between
	// `FAILED_PRECONDITION`, `ABORTED`, and `UNAVAILABLE`. HTTP Mapping:
	// 503 Service Unavailable
	//   "DATA_LOSS" - Unrecoverable data loss or corruption. HTTP Mapping:
	// 500 Internal Server Error
	Code string `json:"code,omitempty"`

	// Message: User-friendly error message.
	Message string `json:"message,omitempty"`

	// Resource: The sub resource specific to this error (e.g. a proxy
	// deployed within the EnvironmentConfig). If empty the error refers to
	// the top level resource.
	Resource string `json:"resource,omitempty"`

	// Type: A string that uniquely identifies the type of error. This
	// provides a more reliable means to deduplicate errors across revisions
	// and instances.
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1UpdateError) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1UpdateError
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleCloudApigeeV1UpdateSecurityIncidentRequest: Request for
// UpdateSecurityIncident.
type GoogleCloudApigeeV1UpdateSecurityIncidentRequest struct {
	// SecurityIncident: Required. The security incident to update. Must
	// contain all existing populated fields of the current incident.
	SecurityIncident *GoogleCloudApigeeV1SecurityIncident `json:"securityIncident,omitempty"`

	// UpdateMask: Required. The list of fields to update. Allowed fields
	// are: LINT.IfChange(allowed_update_fields_comment) - observability
	// LINT.ThenChange()
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "SecurityIncident") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "SecurityIncident") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleCloudApigeeV1UpdateSecurityIncidentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudApigeeV1UpdateSecurityIncidentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a
// service. The configuration determines which permission types are
// logged, and what identities, if any, are exempted from logging. An
// AuditConfig must have one or more AuditLogConfigs. If there are
// AuditConfigs for both `allServices` and a specific service, the union
// of the two AuditConfigs is used for that service: the log_types
// specified in each AuditConfig are enabled, and the exempted_members
// in each AuditLogConfig are exempted. Example Policy with multiple
// AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members":
// [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, {
// "log_type": "ADMIN_READ" } ] }, { "service":
// "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type":
// "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [
// "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy
// enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts
// `jose@example.com` from DATA_READ logging, and `aliya@example.com`
// from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of
	// permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`

	// Service: Specifies a service that will be enabled for audit logging.
	// For example, `storage.googleapis.com`, `cloudsql.googleapis.com`.
	// `allServices` is a special value that covers all services.
	Service string `json:"service,omitempty"`

	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditLogConfigs") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a
// type of permissions. Example: { "audit_log_configs": [ { "log_type":
// "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, {
// "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and
// 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ
// logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging
	// for this type of permission. Follows the same format of
	// Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`

	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ExemptedMembers") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members`, or principals, with a
// `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the
	// current request. If the condition evaluates to `false`, then this
	// binding does not apply to the current request. However, a different
	// role binding might grant the same role to one or more of the
	// principals in this binding. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`

	// Members: Specifies the principals requesting access for a Google
	// Cloud resource. `members` can have the following values: *
	// `allUsers`: A special identifier that represents anyone who is on the
	// internet; with or without a Google account. *
	// `allAuthenticatedUsers`: A special identifier that represents anyone
	// who is authenticated with a Google account or a service account. Does
	// not include identities that come from external identity providers
	// (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address
	// that represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
	//  An identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`.
	// * `group:{emailid}`: An email address that represents a Google group.
	// For example, `admins@example.com`. * `domain:{domain}`: The G Suite
	// domain (primary) that represents all the users of that domain. For
	// example, `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_
	// id}/subject/{subject_attribute_value}`: A single identity in a
	// workforce identity pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/attribute.{attribute_name}/{attribute_value}`: All workforce
	// identities with a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{po
	// ol_id}/*`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/gl
	// obal/workloadIdentityPools/{pool_id}/subject/{subject_attribute_value}
	// `: A single identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/group/{group_id}`: A workload
	// identity pool group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{at
	// tribute_value}`: All identities in a workload identity pool with a
	// certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations
	// /global/workloadIdentityPools/{pool_id}/*`: All identities in a
	// workload identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An
	// email address (plus unique identifier) representing a user that has
	// been recently deleted. For example,
	// `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered
	// user retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
	// (plus unique identifier) representing a service account that has been
	// recently deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`.
	// If the service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains
	// the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`:
	// An email address (plus unique identifier) representing a Google group
	// that has been recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is
	// recovered, this value reverts to `group:{emailid}` and the recovered
	// group retains the role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePool
	// s/{pool_id}/subject/{subject_attribute_value}`: Deleted single
	// identity in a workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePool
	// s/my-pool-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`

	// Role: Role that is assigned to the list of `members`, or principals.
	// For example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
	// overview of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Condition") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy,
// which specifies access controls for Google Cloud resources. A
// `Policy` is a collection of `bindings`. A `binding` binds one or more
// `members`, or principals, to a single `role`. Principals can be user
// accounts, service accounts, Google groups, and domains (such as G
// Suite). A `role` is a named list of permissions; each `role` can be
// an IAM predefined role or a user-created custom role. For some types
// of Google Cloud resources, a `binding` can also specify a
// `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can
// add constraints based on attributes of the request, the resource, or
// both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
// **JSON example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com",
// "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, {
// "role": "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ],
// "etag": "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ```
// bindings: - members: - user:mike@example.com -
// group:admins@example.com - domain:google.com -
// serviceAccount:my-project-id@appspot.gserviceaccount.com role:
// roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access
// after Sep 2020 expression: request.time <
// timestamp('2020-10-01T00:00:00.000Z') etag: BwWWja0YfJA= version: 3
// ``` For a description of IAM and its features, see the IAM
// documentation (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this
	// policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`

	// Bindings: Associates a list of `members`, or principals, with a
	// `role`. Optionally, may specify a `condition` that determines how and
	// when the `bindings` are applied. Each of the `bindings` must contain
	// at least one principal. The `bindings` in a `Policy` can refer to up
	// to 1,500 principals; up to 250 of these principals can be Google
	// groups. Each occurrence of a principal counts towards these limits.
	// For example, if the `bindings` grant 50 different roles to
	// `user:alice@example.com`, and not to any other principal, then you
	// can add another 1,450 principals to the `bindings` in the `Policy`.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`

	// Etag: `etag` is used for optimistic concurrency control as a way to
	// help prevent simultaneous updates of a policy from overwriting each
	// other. It is strongly suggested that systems make use of the `etag`
	// in the read-modify-write cycle to perform policy updates in order to
	// avoid race conditions: An `etag` is returned in the response to
	// `getIamPolicy`, and systems are expected to put that etag in the
	// request to `setIamPolicy` to ensure that their change will be applied
	// to the same version of the policy. **Important:** If you use IAM
	// Conditions, you must include the `etag` field whenever you call
	// `setIamPolicy`. If you omit this field, then IAM allows you to
	// overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`

	// Version: Specifies the format of the policy. Valid values are `0`,
	// `1`, and `3`. Requests that specify an invalid value are rejected.
	// Any operation that affects conditional role bindings must specify
	// version `3`. This requirement applies to the following operations: *
	// Getting a policy that includes a conditional role binding * Adding a
	// conditional role binding to a policy * Changing a conditional role
	// binding in a policy * Removing any role binding, with or without a
	// condition, from a policy that includes conditions **Important:** If
	// you use IAM Conditions, you must include the `etag` field whenever
	// you call `setIamPolicy`. If you omit this field, then IAM allows you
	// to overwrite a version `3` policy with a version `1` policy, and all
	// of the conditions in the version `3` policy are lost. If a policy
	// does not include any conditions, operations on that policy may
	// specify any valid version or leave the field unset. To learn which
	// resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AuditConfigs") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1SetIamPolicyRequest: Request message for `SetIamPolicy`
// method.
type GoogleIamV1SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the
	// `resource`. The size of the policy is limited to a few 10s of KB. An
	// empty policy is a valid policy but certain Google Cloud services
	// (such as Projects) might reject them.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`

	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the
	// policy to modify. Only the fields in the mask will be modified. If no
	// mask is provided, the following default mask is used: `paths:
	// "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Policy") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1SetIamPolicyRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsRequest: Request message for
// `TestIamPermissions` method.
type GoogleIamV1TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`.
	// Permissions with wildcards (such as `*` or `storage.*`) are not
	// allowed. For more information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsResponse: Response message for
// `TestIamPermissions` method.
type GoogleIamV1TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that
	// the caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Permissions") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleIamV1TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// Operations: A list of operations that matches the specified filter in
	// the request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "NextPageToken") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in
	// progress. If `true`, the operation is completed, and either `error`
	// or `response` is available.
	Done bool `json:"done,omitempty"`

	// Error: The error result of the operation in case of failure or
	// cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`

	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as
	// create time. Some services might not provide such metadata. Any
	// method that returns a long-running operation should document the
	// metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`

	// Name: The server-assigned name, which is only unique within the same
	// service that originally returns it. If you use the default HTTP
	// mapping, the `name` should be a resource name ending with
	// `operations/{unique_id}`.
	Name string `json:"name,omitempty"`

	// Response: The normal, successful response of the operation. If the
	// original method returns no data on success, such as `Delete`, the
	// response is `google.protobuf.Empty`. If the original method is
	// standard `Get`/`Create`/`Update`, the response should be the
	// resource. For other methods, the response should have the type
	// `XxxResponse`, where `Xxx` is the original method name. For example,
	// if the original method name is `TakeSnapshot()`, the inferred
	// response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Done") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Done") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to
// avoid defining duplicated empty messages in your APIs. A typical
// example is to use it as the request or the response type of an API
// method. For instance: service Foo { rpc Bar(google.protobuf.Empty)
// returns (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcPreconditionFailure: Describes what preconditions have
// failed. For example, if an RPC failed because it required the Terms
// of Service to be acknowledged, it could list the terms of service
// violation in the PreconditionFailure message.
type GoogleRpcPreconditionFailure struct {
	// Violations: Describes all precondition violations.
	Violations []*GoogleRpcPreconditionFailureViolation `json:"violations,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Violations") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Violations") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcPreconditionFailure) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcPreconditionFailure
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleRpcPreconditionFailureViolation: A message type used to
// describe a single precondition failure.
type GoogleRpcPreconditionFailureViolation struct {
	// Description: A description of how the precondition failed. Developers
	// can use this description to understand how to fix the failure. For
	// example: "Terms of service not accepted".
	Description string `json:"description,omitempty"`

	// Subject: The subject, relative to the type, that failed. For example,
	// "google.com/cloud" relative to the "TOS" type would indicate which
	// terms of service is being referenced.
	Subject string `json:"subject,omitempty"`

	// Type: The type of PreconditionFailure. We recommend using a
	// service-specific enum type to define the supported precondition
	// violation subjects. For example, "TOS" for "Terms of Service
	// violation".
	Type string `json:"type,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcPreconditionFailureViolation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcPreconditionFailureViolation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that
// is suitable for different programming environments, including REST
// APIs and RPC APIs. It is used by gRPC (https://github.com/grpc). Each
// `Status` message contains three pieces of data: error code, error
// message, and error details. You can find out more about this error
// model and how to work with it in the API Design Guide
// (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of
	// google.rpc.Code.
	Code int64 `json:"code,omitempty"`

	// Details: A list of messages that carry the error details. There is a
	// common set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`

	// Message: A developer-facing error message, which should be in
	// English. Any user-facing error message should be localized and sent
	// in the google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Code") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Code") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common
// Expression Language (CEL) syntax. CEL is a C-like expression
// language. The syntax and semantics of CEL are documented at
// https://github.com/google/cel-spec. Example (Comparison): title:
// "Summary size limit" description: "Determines if a summary is less
// than 100 chars" expression: "document.summary.size() < 100" Example
// (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly
// visible" expression: "document.type != 'private' && document.type !=
// 'internal'" Example (Data Manipulation): title: "Notification string"
// description: "Create a notification string with a timestamp."
// expression: "'New message received at ' +
// string(document.create_time)" The exact variables and functions that
// may be referenced within an expression are determined by the service
// that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a
	// longer text which describes the expression, e.g. when hovered over it
	// in a UI.
	Description string `json:"description,omitempty"`

	// Expression: Textual representation of an expression in Common
	// Expression Language syntax.
	Expression string `json:"expression,omitempty"`

	// Location: Optional. String indicating the location of the expression
	// for error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`

	// Title: Optional. Title for the expression, i.e. a short string
	// describing its purpose. This can be used e.g. in UIs which allow to
	// enter the expression.
	Title string `json:"title,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Description") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeInterval: Represents a time interval, encoded as a
// Timestamp start (inclusive) and a Timestamp end (exclusive). The
// start must be less than or equal to the end. When the start equals
// the end, the interval is empty (matches no time). When both start and
// end are unspecified, the interval matches any time.
type GoogleTypeInterval struct {
	// EndTime: Optional. Exclusive end of the interval. If specified, a
	// Timestamp matching this interval will have to be before the end.
	EndTime string `json:"endTime,omitempty"`

	// StartTime: Optional. Inclusive start of the interval. If specified, a
	// Timestamp matching this interval will have to be the same or after
	// the start.
	StartTime string `json:"startTime,omitempty"`

	// ForceSendFields is a list of field names (e.g. "EndTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "EndTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeInterval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeInterval
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// GoogleTypeMoney: Represents an amount of money with its currency
// type.
type GoogleTypeMoney struct {
	// CurrencyCode: The three-letter currency code defined in ISO 4217.
	CurrencyCode string `json:"currencyCode,omitempty"`

	// Nanos: Number of nano (10^-9) units of the amount. The value must be
	// between -999,999,999 and +999,999,999 inclusive. If `units` is
	// positive, `nanos` must be positive or zero. If `units` is zero,
	// `nanos` can be positive, zero, or negative. If `units` is negative,
	// `nanos` must be negative or zero. For example $-1.75 is represented
	// as `units`=-1 and `nanos`=-750,000,000.
	Nanos int64 `json:"nanos,omitempty"`

	// Units: The whole units of the amount. For example if `currencyCode`
	// is "USD", then 1 unit is one US dollar.
	Units int64 `json:"units,omitempty,string"`

	// ForceSendFields is a list of field names (e.g. "CurrencyCode") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CurrencyCode") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *GoogleTypeMoney) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeMoney
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "apigee.hybrid.issuers.list":

type HybridIssuersListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists hybrid services and its trusted issuers service account
// ids. This api is authenticated and unauthorized(allow all the users)
// and used by runtime authn-authz service to query control plane's
// issuer service account ids.
//
// - name: Must be of the form `hybrid/issuers`.
func (r *HybridIssuersService) List(name string) *HybridIssuersListCall {
	c := &HybridIssuersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *HybridIssuersListCall) Fields(s ...googleapi.Field) *HybridIssuersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *HybridIssuersListCall) IfNoneMatch(entityTag string) *HybridIssuersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *HybridIssuersListCall) Context(ctx context.Context) *HybridIssuersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *HybridIssuersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *HybridIssuersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.hybrid.issuers.list" call.
// Exactly one of *GoogleCloudApigeeV1ListHybridIssuersResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListHybridIssuersResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *HybridIssuersListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListHybridIssuersResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListHybridIssuersResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists hybrid services and its trusted issuers service account ids. This api is authenticated and unauthorized(allow all the users) and used by runtime authn-authz service to query control plane's issuer service account ids.",
	//   "flatPath": "v1/hybrid/issuers",
	//   "httpMethod": "GET",
	//   "id": "apigee.hybrid.issuers.list",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Must be of the form `hybrid/issuers`.",
	//       "location": "path",
	//       "pattern": "^hybrid/issuers$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListHybridIssuersResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.create":

type OrganizationsCreateCall struct {
	s                               *Service
	googlecloudapigeev1organization *GoogleCloudApigeeV1Organization
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Create: Creates an Apigee organization. See Create an Apigee
// organization
// (https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
func (r *OrganizationsService) Create(googlecloudapigeev1organization *GoogleCloudApigeeV1Organization) *OrganizationsCreateCall {
	c := &OrganizationsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.googlecloudapigeev1organization = googlecloudapigeev1organization
	return c
}

// Parent sets the optional parameter "parent": Required. Name of the
// Google Cloud project in which to associate the Apigee organization.
// Pass the information as a query parameter using the following
// structure in your request: `projects/`
func (c *OrganizationsCreateCall) Parent(parent string) *OrganizationsCreateCall {
	c.urlParams_.Set("parent", parent)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsCreateCall) Fields(s ...googleapi.Field) *OrganizationsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsCreateCall) Context(ctx context.Context) *OrganizationsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1organization)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/organizations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.create" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an Apigee organization. See [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).",
	//   "flatPath": "v1/organizations",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.create",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the Google Cloud project in which to associate the Apigee organization. Pass the information as a query parameter using the following structure in your request: `projects/`",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/organizations",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1Organization"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.delete":

type OrganizationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an Apigee organization. For organizations with
// BillingType EVALUATION, an immediate deletion is performed. For paid
// organizations (Subscription or Pay-as-you-go), a soft-deletion is
// performed. The organization can be restored within the soft-deletion
// period, which is specified using the `retention` field in the request
// or by filing a support ticket with Apigee. During the data retention
// period specified in the request, the Apigee organization cannot be
// recreated in the same Google Cloud project. **IMPORTANT: The default
// data retention setting for this operation is 7 days. To permanently
// delete the organization in 24 hours, set the retention parameter to
// `MINIMUM`.**
//
//   - name: Name of the organization. Use the following structure in your
//     request: `organizations/{org}`.
func (r *OrganizationsService) Delete(name string) *OrganizationsDeleteCall {
	c := &OrganizationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Retention sets the optional parameter "retention": This setting is
// applicable only for organizations that are soft-deleted (i.e.,
// BillingType is not EVALUATION). It controls how long Organization
// data will be retained after the initial delete operation completes.
// During this period, the Organization may be restored to its last
// known state. After this period, the Organization will no longer be
// able to be restored. **Note: During the data retention period
// specified using this field, the Apigee organization cannot be
// recreated in the same GCP project.**
//
// Possible values:
//
//	"DELETION_RETENTION_UNSPECIFIED" - Default data retention setting
//
// of seven days will be applied.
//
//	"MINIMUM" - Organization data will be retained for the minimum
//
// period of 24 hours.
func (c *OrganizationsDeleteCall) Retention(retention string) *OrganizationsDeleteCall {
	c.urlParams_.Set("retention", retention)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsDeleteCall) Context(ctx context.Context) *OrganizationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.delete" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Delete an Apigee organization. For organizations with BillingType EVALUATION, an immediate deletion is performed. For paid organizations (Subscription or Pay-as-you-go), a soft-deletion is performed. The organization can be restored within the soft-deletion period, which is specified using the `retention` field in the request or by filing a support ticket with Apigee. During the data retention period specified in the request, the Apigee organization cannot be recreated in the same Google Cloud project. **IMPORTANT: The default data retention setting for this operation is 7 days. To permanently delete the organization in 24 hours, set the retention parameter to `MINIMUM`.**",
	//   "flatPath": "v1/organizations/{organizationsId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the organization. Use the following structure in your request: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "retention": {
	//       "description": "Optional. This setting is applicable only for organizations that are soft-deleted (i.e., BillingType is not EVALUATION). It controls how long Organization data will be retained after the initial delete operation completes. During this period, the Organization may be restored to its last known state. After this period, the Organization will no longer be able to be restored. **Note: During the data retention period specified using this field, the Apigee organization cannot be recreated in the same GCP project.**",
	//       "enum": [
	//         "DELETION_RETENTION_UNSPECIFIED",
	//         "MINIMUM"
	//       ],
	//       "enumDescriptions": [
	//         "Default data retention setting of seven days will be applied.",
	//         "Organization data will be retained for the minimum period of 24 hours."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.get":

type OrganizationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the profile for an Apigee organization. See Understanding
// organizations
// (https://cloud.google.com/apigee/docs/api-platform/fundamentals/organization-structure).
//
//   - name: Apigee organization name in the following format:
//     `organizations/{org}`.
func (r *OrganizationsService) Get(name string) *OrganizationsGetCall {
	c := &OrganizationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetCall) Fields(s ...googleapi.Field) *OrganizationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetCall) IfNoneMatch(entityTag string) *OrganizationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetCall) Context(ctx context.Context) *OrganizationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.get" call.
// Exactly one of *GoogleCloudApigeeV1Organization or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Organization.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Organization, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Organization{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the profile for an Apigee organization. See [Understanding organizations](https://cloud.google.com/apigee/docs/api-platform/fundamentals/organization-structure).",
	//   "flatPath": "v1/organizations/{organizationsId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Apigee organization name in the following format: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Organization"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.getDeployedIngressConfig":

type OrganizationsGetDeployedIngressConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDeployedIngressConfig: Gets the deployed ingress configuration for
// an organization.
//
//   - name: Name of the deployed configuration for the organization in
//     the following format: 'organizations/{org}/deployedIngressConfig'.
func (r *OrganizationsService) GetDeployedIngressConfig(name string) *OrganizationsGetDeployedIngressConfigCall {
	c := &OrganizationsGetDeployedIngressConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// View sets the optional parameter "view": When set to FULL, additional
// details about the specific deployments receiving traffic will be
// included in the IngressConfig response's RoutingRules.
//
// Possible values:
//
//	"INGRESS_CONFIG_VIEW_UNSPECIFIED" - The default/unset value. The
//
// API will default to the BASIC view.
//
//	"BASIC" - Include all ingress config data necessary for the runtime
//
// to configure ingress, but no more. Routing rules will include only
// basepath and destination environment. This the default value.
//
//	"FULL" - Include all ingress config data, including internal debug
//
// info for each routing rule such as the proxy claiming a particular
// basepath and when the routing rule first appeared in the env group.
func (c *OrganizationsGetDeployedIngressConfigCall) View(view string) *OrganizationsGetDeployedIngressConfigCall {
	c.urlParams_.Set("view", view)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetDeployedIngressConfigCall) Fields(s ...googleapi.Field) *OrganizationsGetDeployedIngressConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetDeployedIngressConfigCall) IfNoneMatch(entityTag string) *OrganizationsGetDeployedIngressConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetDeployedIngressConfigCall) Context(ctx context.Context) *OrganizationsGetDeployedIngressConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetDeployedIngressConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetDeployedIngressConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.getDeployedIngressConfig" call.
// Exactly one of *GoogleCloudApigeeV1IngressConfig or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1IngressConfig.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetDeployedIngressConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1IngressConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1IngressConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the deployed ingress configuration for an organization.",
	//   "flatPath": "v1/organizations/{organizationsId}/deployedIngressConfig",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.getDeployedIngressConfig",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the deployed configuration for the organization in the following format: 'organizations/{org}/deployedIngressConfig'.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/deployedIngressConfig$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "view": {
	//       "description": "When set to FULL, additional details about the specific deployments receiving traffic will be included in the IngressConfig response's RoutingRules.",
	//       "enum": [
	//         "INGRESS_CONFIG_VIEW_UNSPECIFIED",
	//         "BASIC",
	//         "FULL"
	//       ],
	//       "enumDescriptions": [
	//         "The default/unset value. The API will default to the BASIC view.",
	//         "Include all ingress config data necessary for the runtime to configure ingress, but no more. Routing rules will include only basepath and destination environment. This the default value.",
	//         "Include all ingress config data, including internal debug info for each routing rule such as the proxy claiming a particular basepath and when the routing rule first appeared in the env group."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1IngressConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.getProjectMapping":

type OrganizationsGetProjectMappingCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetProjectMapping: Gets the project ID and region for an Apigee
// organization.
//
//   - name: Apigee organization name in the following format:
//     `organizations/{org}`.
func (r *OrganizationsService) GetProjectMapping(name string) *OrganizationsGetProjectMappingCall {
	c := &OrganizationsGetProjectMappingCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetProjectMappingCall) Fields(s ...googleapi.Field) *OrganizationsGetProjectMappingCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetProjectMappingCall) IfNoneMatch(entityTag string) *OrganizationsGetProjectMappingCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetProjectMappingCall) Context(ctx context.Context) *OrganizationsGetProjectMappingCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetProjectMappingCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetProjectMappingCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getProjectMapping")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.getProjectMapping" call.
// Exactly one of *GoogleCloudApigeeV1OrganizationProjectMapping or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1OrganizationProjectMapping.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsGetProjectMappingCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1OrganizationProjectMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1OrganizationProjectMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the project ID and region for an Apigee organization.",
	//   "flatPath": "v1/organizations/{organizationsId}:getProjectMapping",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.getProjectMapping",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Apigee organization name in the following format: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:getProjectMapping",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1OrganizationProjectMapping"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.getRuntimeConfig":

type OrganizationsGetRuntimeConfigCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetRuntimeConfig: Get runtime config for an organization.
//
//   - name: Name of the runtime config for the organization in the
//     following format: 'organizations/{org}/runtimeConfig'.
func (r *OrganizationsService) GetRuntimeConfig(name string) *OrganizationsGetRuntimeConfigCall {
	c := &OrganizationsGetRuntimeConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetRuntimeConfigCall) Fields(s ...googleapi.Field) *OrganizationsGetRuntimeConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetRuntimeConfigCall) IfNoneMatch(entityTag string) *OrganizationsGetRuntimeConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetRuntimeConfigCall) Context(ctx context.Context) *OrganizationsGetRuntimeConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetRuntimeConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetRuntimeConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.getRuntimeConfig" call.
// Exactly one of *GoogleCloudApigeeV1RuntimeConfig or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1RuntimeConfig.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsGetRuntimeConfigCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1RuntimeConfig, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1RuntimeConfig{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get runtime config for an organization.",
	//   "flatPath": "v1/organizations/{organizationsId}/runtimeConfig",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.getRuntimeConfig",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the runtime config for the organization in the following format: 'organizations/{org}/runtimeConfig'.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/runtimeConfig$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1RuntimeConfig"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.getSecuritySettings":

type OrganizationsGetSecuritySettingsCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetSecuritySettings: GetSecuritySettings gets the security settings
// for API Security.
//
//   - name: The name of the SecuritySettings to retrieve. This will
//     always be: 'organizations/{org}/securitySettings'.
func (r *OrganizationsService) GetSecuritySettings(name string) *OrganizationsGetSecuritySettingsCall {
	c := &OrganizationsGetSecuritySettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetSecuritySettingsCall) Fields(s ...googleapi.Field) *OrganizationsGetSecuritySettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsGetSecuritySettingsCall) IfNoneMatch(entityTag string) *OrganizationsGetSecuritySettingsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetSecuritySettingsCall) Context(ctx context.Context) *OrganizationsGetSecuritySettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetSecuritySettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetSecuritySettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.getSecuritySettings" call.
// Exactly one of *GoogleCloudApigeeV1SecuritySettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1SecuritySettings.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsGetSecuritySettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1SecuritySettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1SecuritySettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "GetSecuritySettings gets the security settings for API Security.",
	//   "flatPath": "v1/organizations/{organizationsId}/securitySettings",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.getSecuritySettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The name of the SecuritySettings to retrieve. This will always be: 'organizations/{org}/securitySettings'.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/securitySettings$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1SecuritySettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.getSyncAuthorization":

type OrganizationsGetSyncAuthorizationCall struct {
	s                                              *Service
	name                                           string
	googlecloudapigeev1getsyncauthorizationrequest *GoogleCloudApigeeV1GetSyncAuthorizationRequest
	urlParams_                                     gensupport.URLParams
	ctx_                                           context.Context
	header_                                        http.Header
}

// GetSyncAuthorization: Lists the service accounts with the permissions
// required to allow the Synchronizer to download environment data from
// the control plane. An ETag is returned in the response to
// `getSyncAuthorization`. Pass that ETag when calling
// setSyncAuthorization (setSyncAuthorization) to ensure that you are
// updating the correct version. If you don't pass the ETag in the call
// to `setSyncAuthorization`, then the existing authorization is
// overwritten indiscriminately. For more information, see Configure the
// Synchronizer
// (https://cloud.google.com/apigee/docs/hybrid/latest/synchronizer-access).
// **Note**: Available to Apigee hybrid only.
//
//   - name: Name of the Apigee organization. Use the following structure
//     in your request: `organizations/{org}`.
func (r *OrganizationsService) GetSyncAuthorization(name string, googlecloudapigeev1getsyncauthorizationrequest *GoogleCloudApigeeV1GetSyncAuthorizationRequest) *OrganizationsGetSyncAuthorizationCall {
	c := &OrganizationsGetSyncAuthorizationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1getsyncauthorizationrequest = googlecloudapigeev1getsyncauthorizationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsGetSyncAuthorizationCall) Fields(s ...googleapi.Field) *OrganizationsGetSyncAuthorizationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsGetSyncAuthorizationCall) Context(ctx context.Context) *OrganizationsGetSyncAuthorizationCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsGetSyncAuthorizationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsGetSyncAuthorizationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1getsyncauthorizationrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:getSyncAuthorization")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.getSyncAuthorization" call.
// Exactly one of *GoogleCloudApigeeV1SyncAuthorization or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1SyncAuthorization.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsGetSyncAuthorizationCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1SyncAuthorization, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1SyncAuthorization{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the service accounts with the permissions required to allow the Synchronizer to download environment data from the control plane. An ETag is returned in the response to `getSyncAuthorization`. Pass that ETag when calling [setSyncAuthorization](setSyncAuthorization) to ensure that you are updating the correct version. If you don't pass the ETag in the call to `setSyncAuthorization`, then the existing authorization is overwritten indiscriminately. For more information, see [Configure the Synchronizer](https://cloud.google.com/apigee/docs/hybrid/latest/synchronizer-access). **Note**: Available to Apigee hybrid only.",
	//   "flatPath": "v1/organizations/{organizationsId}:getSyncAuthorization",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.getSyncAuthorization",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the Apigee organization. Use the following structure in your request: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:getSyncAuthorization",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1GetSyncAuthorizationRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1SyncAuthorization"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.list":

type OrganizationsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the Apigee organizations and associated Google Cloud
// projects that you have permission to access. See Understanding
// organizations
// (https://cloud.google.com/apigee/docs/api-platform/fundamentals/organization-structure).
//
//   - parent: Use the following structure in your request:
//     `organizations`.
func (r *OrganizationsService) List(parent string) *OrganizationsListCall {
	c := &OrganizationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsListCall) Fields(s ...googleapi.Field) *OrganizationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsListCall) IfNoneMatch(entityTag string) *OrganizationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsListCall) Context(ctx context.Context) *OrganizationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.list" call.
// Exactly one of *GoogleCloudApigeeV1ListOrganizationsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListOrganizationsResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListOrganizationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListOrganizationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the Apigee organizations and associated Google Cloud projects that you have permission to access. See [Understanding organizations](https://cloud.google.com/apigee/docs/api-platform/fundamentals/organization-structure).",
	//   "flatPath": "v1/organizations",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Use the following structure in your request: `organizations`",
	//       "location": "path",
	//       "pattern": "^organizations$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListOrganizationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.setAddons":

type OrganizationsSetAddonsCall struct {
	s                                   *Service
	org                                 string
	googlecloudapigeev1setaddonsrequest *GoogleCloudApigeeV1SetAddonsRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// SetAddons: Configures the add-ons for the Apigee organization. The
// existing add-on configuration will be fully replaced.
//
//   - org: Name of the organization. Use the following structure in your
//     request: `organizations/{org}`.
func (r *OrganizationsService) SetAddons(org string, googlecloudapigeev1setaddonsrequest *GoogleCloudApigeeV1SetAddonsRequest) *OrganizationsSetAddonsCall {
	c := &OrganizationsSetAddonsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.org = org
	c.googlecloudapigeev1setaddonsrequest = googlecloudapigeev1setaddonsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsSetAddonsCall) Fields(s ...googleapi.Field) *OrganizationsSetAddonsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsSetAddonsCall) Context(ctx context.Context) *OrganizationsSetAddonsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsSetAddonsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsSetAddonsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1setaddonsrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+org}:setAddons")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"org": c.org,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.setAddons" call.
// Exactly one of *GoogleLongrunningOperation or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsSetAddonsCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Configures the add-ons for the Apigee organization. The existing add-on configuration will be fully replaced.",
	//   "flatPath": "v1/organizations/{organizationsId}:setAddons",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.setAddons",
	//   "parameterOrder": [
	//     "org"
	//   ],
	//   "parameters": {
	//     "org": {
	//       "description": "Required. Name of the organization. Use the following structure in your request: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+org}:setAddons",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1SetAddonsRequest"
	//   },
	//   "response": {
	//     "$ref": "GoogleLongrunningOperation"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.setSyncAuthorization":

type OrganizationsSetSyncAuthorizationCall struct {
	s                                    *Service
	name                                 string
	googlecloudapigeev1syncauthorization *GoogleCloudApigeeV1SyncAuthorization
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// SetSyncAuthorization: Sets the permissions required to allow the
// Synchronizer to download environment data from the control plane. You
// must call this API to enable proper functioning of hybrid. Pass the
// ETag when calling `setSyncAuthorization` to ensure that you are
// updating the correct version. To get an ETag, call
// getSyncAuthorization (getSyncAuthorization). If you don't pass the
// ETag in the call to `setSyncAuthorization`, then the existing
// authorization is overwritten indiscriminately. For more information,
// see Configure the Synchronizer
// (https://cloud.google.com/apigee/docs/hybrid/latest/synchronizer-access).
// **Note**: Available to Apigee hybrid only.
//
//   - name: Name of the Apigee organization. Use the following structure
//     in your request: `organizations/{org}`.
func (r *OrganizationsService) SetSyncAuthorization(name string, googlecloudapigeev1syncauthorization *GoogleCloudApigeeV1SyncAuthorization) *OrganizationsSetSyncAuthorizationCall {
	c := &OrganizationsSetSyncAuthorizationCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1syncauthorization = googlecloudapigeev1syncauthorization
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsSetSyncAuthorizationCall) Fields(s ...googleapi.Field) *OrganizationsSetSyncAuthorizationCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsSetSyncAuthorizationCall) Context(ctx context.Context) *OrganizationsSetSyncAuthorizationCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsSetSyncAuthorizationCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsSetSyncAuthorizationCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1syncauthorization)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:setSyncAuthorization")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.setSyncAuthorization" call.
// Exactly one of *GoogleCloudApigeeV1SyncAuthorization or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1SyncAuthorization.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsSetSyncAuthorizationCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1SyncAuthorization, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1SyncAuthorization{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Sets the permissions required to allow the Synchronizer to download environment data from the control plane. You must call this API to enable proper functioning of hybrid. Pass the ETag when calling `setSyncAuthorization` to ensure that you are updating the correct version. To get an ETag, call [getSyncAuthorization](getSyncAuthorization). If you don't pass the ETag in the call to `setSyncAuthorization`, then the existing authorization is overwritten indiscriminately. For more information, see [Configure the Synchronizer](https://cloud.google.com/apigee/docs/hybrid/latest/synchronizer-access). **Note**: Available to Apigee hybrid only.",
	//   "flatPath": "v1/organizations/{organizationsId}:setSyncAuthorization",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.setSyncAuthorization",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the Apigee organization. Use the following structure in your request: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}:setSyncAuthorization",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1SyncAuthorization"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1SyncAuthorization"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.update":

type OrganizationsUpdateCall struct {
	s                               *Service
	name                            string
	googlecloudapigeev1organization *GoogleCloudApigeeV1Organization
	urlParams_                      gensupport.URLParams
	ctx_                            context.Context
	header_                         http.Header
}

// Update: Updates the properties for an Apigee organization. No other
// fields in the organization profile will be updated.
//
//   - name: Apigee organization name in the following format:
//     `organizations/{org}`.
func (r *OrganizationsService) Update(name string, googlecloudapigeev1organization *GoogleCloudApigeeV1Organization) *OrganizationsUpdateCall {
	c := &OrganizationsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1organization = googlecloudapigeev1organization
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsUpdateCall) Fields(s ...googleapi.Field) *OrganizationsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsUpdateCall) Context(ctx context.Context) *OrganizationsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1organization)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.update" call.
// Exactly one of *GoogleCloudApigeeV1Organization or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Organization.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Organization, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Organization{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the properties for an Apigee organization. No other fields in the organization profile will be updated.",
	//   "flatPath": "v1/organizations/{organizationsId}",
	//   "httpMethod": "PUT",
	//   "id": "apigee.organizations.update",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Apigee organization name in the following format: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1Organization"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Organization"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.updateSecuritySettings":

type OrganizationsUpdateSecuritySettingsCall struct {
	s                                   *Service
	name                                string
	googlecloudapigeev1securitysettings *GoogleCloudApigeeV1SecuritySettings
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// UpdateSecuritySettings: UpdateSecuritySettings updates the current
// security settings for API Security.
//
//   - name: Identifier. Full resource name is always
//     `organizations/{org}/securitySettings`.
func (r *OrganizationsService) UpdateSecuritySettings(name string, googlecloudapigeev1securitysettings *GoogleCloudApigeeV1SecuritySettings) *OrganizationsUpdateSecuritySettingsCall {
	c := &OrganizationsUpdateSecuritySettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1securitysettings = googlecloudapigeev1securitysettings
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of
// fields to update. Allowed fields are: -
// ml_retraining_feedback_enabled
func (c *OrganizationsUpdateSecuritySettingsCall) UpdateMask(updateMask string) *OrganizationsUpdateSecuritySettingsCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsUpdateSecuritySettingsCall) Fields(s ...googleapi.Field) *OrganizationsUpdateSecuritySettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsUpdateSecuritySettingsCall) Context(ctx context.Context) *OrganizationsUpdateSecuritySettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsUpdateSecuritySettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsUpdateSecuritySettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1securitysettings)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.updateSecuritySettings" call.
// Exactly one of *GoogleCloudApigeeV1SecuritySettings or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1SecuritySettings.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsUpdateSecuritySettingsCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1SecuritySettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1SecuritySettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "UpdateSecuritySettings updates the current security settings for API Security.",
	//   "flatPath": "v1/organizations/{organizationsId}/securitySettings",
	//   "httpMethod": "PATCH",
	//   "id": "apigee.organizations.updateSecuritySettings",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Identifier. Full resource name is always `organizations/{org}/securitySettings`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/securitySettings$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Optional. The list of fields to update. Allowed fields are: - ml_retraining_feedback_enabled",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1SecuritySettings"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1SecuritySettings"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.analytics.datastores.create":

type OrganizationsAnalyticsDatastoresCreateCall struct {
	s                            *Service
	parent                       string
	googlecloudapigeev1datastore *GoogleCloudApigeeV1Datastore
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Create: Create a Datastore for an org
//
//   - parent: The parent organization name. Must be of the form
//     `organizations/{org}`.
func (r *OrganizationsAnalyticsDatastoresService) Create(parent string, googlecloudapigeev1datastore *GoogleCloudApigeeV1Datastore) *OrganizationsAnalyticsDatastoresCreateCall {
	c := &OrganizationsAnalyticsDatastoresCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapigeev1datastore = googlecloudapigeev1datastore
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAnalyticsDatastoresCreateCall) Fields(s ...googleapi.Field) *OrganizationsAnalyticsDatastoresCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAnalyticsDatastoresCreateCall) Context(ctx context.Context) *OrganizationsAnalyticsDatastoresCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAnalyticsDatastoresCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAnalyticsDatastoresCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1datastore)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analytics/datastores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.analytics.datastores.create" call.
// Exactly one of *GoogleCloudApigeeV1Datastore or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Datastore.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAnalyticsDatastoresCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Datastore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Datastore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a Datastore for an org",
	//   "flatPath": "v1/organizations/{organizationsId}/analytics/datastores",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.analytics.datastores.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent organization name. Must be of the form `organizations/{org}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/analytics/datastores",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1Datastore"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Datastore"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.analytics.datastores.delete":

type OrganizationsAnalyticsDatastoresDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a Datastore from an org.
//
//   - name: Resource name of the Datastore to be deleted. Must be of the
//     form `organizations/{org}/analytics/datastores/{datastoreId}`.
func (r *OrganizationsAnalyticsDatastoresService) Delete(name string) *OrganizationsAnalyticsDatastoresDeleteCall {
	c := &OrganizationsAnalyticsDatastoresDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAnalyticsDatastoresDeleteCall) Fields(s ...googleapi.Field) *OrganizationsAnalyticsDatastoresDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAnalyticsDatastoresDeleteCall) Context(ctx context.Context) *OrganizationsAnalyticsDatastoresDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAnalyticsDatastoresDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAnalyticsDatastoresDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.analytics.datastores.delete" call.
// Exactly one of *GoogleProtobufEmpty or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAnalyticsDatastoresDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Delete a Datastore from an org.",
	//   "flatPath": "v1/organizations/{organizationsId}/analytics/datastores/{datastoresId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.analytics.datastores.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name of the Datastore to be deleted. Must be of the form `organizations/{org}/analytics/datastores/{datastoreId}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/analytics/datastores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleProtobufEmpty"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.analytics.datastores.get":

type OrganizationsAnalyticsDatastoresGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get a Datastore
//
//   - name: Resource name of the Datastore to be get. Must be of the form
//     `organizations/{org}/analytics/datastores/{datastoreId}`.
func (r *OrganizationsAnalyticsDatastoresService) Get(name string) *OrganizationsAnalyticsDatastoresGetCall {
	c := &OrganizationsAnalyticsDatastoresGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAnalyticsDatastoresGetCall) Fields(s ...googleapi.Field) *OrganizationsAnalyticsDatastoresGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsAnalyticsDatastoresGetCall) IfNoneMatch(entityTag string) *OrganizationsAnalyticsDatastoresGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAnalyticsDatastoresGetCall) Context(ctx context.Context) *OrganizationsAnalyticsDatastoresGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAnalyticsDatastoresGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAnalyticsDatastoresGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.analytics.datastores.get" call.
// Exactly one of *GoogleCloudApigeeV1Datastore or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Datastore.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAnalyticsDatastoresGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Datastore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Datastore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get a Datastore",
	//   "flatPath": "v1/organizations/{organizationsId}/analytics/datastores/{datastoresId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.analytics.datastores.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Resource name of the Datastore to be get. Must be of the form `organizations/{org}/analytics/datastores/{datastoreId}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/analytics/datastores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Datastore"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.analytics.datastores.list":

type OrganizationsAnalyticsDatastoresListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List Datastores
//
//   - parent: The parent organization name. Must be of the form
//     `organizations/{org}`.
func (r *OrganizationsAnalyticsDatastoresService) List(parent string) *OrganizationsAnalyticsDatastoresListCall {
	c := &OrganizationsAnalyticsDatastoresListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// TargetType sets the optional parameter "targetType": TargetType is
// used to fetch all Datastores that match the type
func (c *OrganizationsAnalyticsDatastoresListCall) TargetType(targetType string) *OrganizationsAnalyticsDatastoresListCall {
	c.urlParams_.Set("targetType", targetType)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAnalyticsDatastoresListCall) Fields(s ...googleapi.Field) *OrganizationsAnalyticsDatastoresListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsAnalyticsDatastoresListCall) IfNoneMatch(entityTag string) *OrganizationsAnalyticsDatastoresListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAnalyticsDatastoresListCall) Context(ctx context.Context) *OrganizationsAnalyticsDatastoresListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAnalyticsDatastoresListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAnalyticsDatastoresListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analytics/datastores")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.analytics.datastores.list" call.
// Exactly one of *GoogleCloudApigeeV1ListDatastoresResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListDatastoresResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsAnalyticsDatastoresListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListDatastoresResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListDatastoresResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "List Datastores",
	//   "flatPath": "v1/organizations/{organizationsId}/analytics/datastores",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.analytics.datastores.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent organization name. Must be of the form `organizations/{org}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "targetType": {
	//       "description": "Optional. TargetType is used to fetch all Datastores that match the type",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/analytics/datastores",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListDatastoresResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.analytics.datastores.test":

type OrganizationsAnalyticsDatastoresTestCall struct {
	s                            *Service
	parent                       string
	googlecloudapigeev1datastore *GoogleCloudApigeeV1Datastore
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Test: Test if Datastore configuration is correct. This includes
// checking if credentials provided by customer have required
// permissions in target destination storage
//
//   - parent: The parent organization name Must be of the form
//     `organizations/{org}`.
func (r *OrganizationsAnalyticsDatastoresService) Test(parent string, googlecloudapigeev1datastore *GoogleCloudApigeeV1Datastore) *OrganizationsAnalyticsDatastoresTestCall {
	c := &OrganizationsAnalyticsDatastoresTestCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapigeev1datastore = googlecloudapigeev1datastore
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAnalyticsDatastoresTestCall) Fields(s ...googleapi.Field) *OrganizationsAnalyticsDatastoresTestCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAnalyticsDatastoresTestCall) Context(ctx context.Context) *OrganizationsAnalyticsDatastoresTestCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAnalyticsDatastoresTestCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAnalyticsDatastoresTestCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1datastore)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/analytics/datastores:test")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.analytics.datastores.test" call.
// Exactly one of *GoogleCloudApigeeV1TestDatastoreResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1TestDatastoreResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsAnalyticsDatastoresTestCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1TestDatastoreResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1TestDatastoreResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Test if Datastore configuration is correct. This includes checking if credentials provided by customer have required permissions in target destination storage",
	//   "flatPath": "v1/organizations/{organizationsId}/analytics/datastores:test",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.analytics.datastores.test",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The parent organization name Must be of the form `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/analytics/datastores:test",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1Datastore"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1TestDatastoreResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.analytics.datastores.update":

type OrganizationsAnalyticsDatastoresUpdateCall struct {
	s                            *Service
	name                         string
	googlecloudapigeev1datastore *GoogleCloudApigeeV1Datastore
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// Update: Update a Datastore
//
//   - name: The resource name of datastore to be updated. Must be of the
//     form `organizations/{org}/analytics/datastores/{datastoreId}`.
func (r *OrganizationsAnalyticsDatastoresService) Update(name string, googlecloudapigeev1datastore *GoogleCloudApigeeV1Datastore) *OrganizationsAnalyticsDatastoresUpdateCall {
	c := &OrganizationsAnalyticsDatastoresUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1datastore = googlecloudapigeev1datastore
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAnalyticsDatastoresUpdateCall) Fields(s ...googleapi.Field) *OrganizationsAnalyticsDatastoresUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAnalyticsDatastoresUpdateCall) Context(ctx context.Context) *OrganizationsAnalyticsDatastoresUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAnalyticsDatastoresUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAnalyticsDatastoresUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1datastore)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.analytics.datastores.update" call.
// Exactly one of *GoogleCloudApigeeV1Datastore or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Datastore.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAnalyticsDatastoresUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Datastore, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Datastore{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update a Datastore",
	//   "flatPath": "v1/organizations/{organizationsId}/analytics/datastores/{datastoresId}",
	//   "httpMethod": "PUT",
	//   "id": "apigee.organizations.analytics.datastores.update",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The resource name of datastore to be updated. Must be of the form `organizations/{org}/analytics/datastores/{datastoreId}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/analytics/datastores/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1Datastore"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Datastore"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.attributes":

type OrganizationsApiproductsAttributesCall struct {
	s                             *Service
	name                          string
	googlecloudapigeev1attributes *GoogleCloudApigeeV1Attributes
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Attributes: Updates or creates API product attributes. This API
// **replaces** the current list of attributes with the attributes
// specified in the request body. In this way, you can update existing
// attributes, add new attributes, or delete existing attributes by
// omitting them from the request body. **Note**: OAuth access tokens
// and Key Management Service (KMS) entities (apps, developers, and API
// products) are cached for 180 seconds (current default). Any custom
// attributes associated with entities also get cached for at least 180
// seconds after entity is accessed during runtime. In this case, the
// `ExpiresIn` element on the OAuthV2 policy won't be able to expire an
// access token in less than 180 seconds.
//
//   - name: Name of the API product. Use the following structure in your
//     request: `organizations/{org}/apiproducts/{apiproduct}`.
func (r *OrganizationsApiproductsService) Attributes(name string, googlecloudapigeev1attributes *GoogleCloudApigeeV1Attributes) *OrganizationsApiproductsAttributesCall {
	c := &OrganizationsApiproductsAttributesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1attributes = googlecloudapigeev1attributes
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsAttributesCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsAttributesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsAttributesCall) Context(ctx context.Context) *OrganizationsApiproductsAttributesCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsAttributesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsAttributesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1attributes)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/attributes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.attributes" call.
// Exactly one of *GoogleCloudApigeeV1Attributes or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Attributes.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsAttributesCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Attributes, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Attributes{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates or creates API product attributes. This API **replaces** the current list of attributes with the attributes specified in the request body. In this way, you can update existing attributes, add new attributes, or delete existing attributes by omitting them from the request body. **Note**: OAuth access tokens and Key Management Service (KMS) entities (apps, developers, and API products) are cached for 180 seconds (current default). Any custom attributes associated with entities also get cached for at least 180 seconds after entity is accessed during runtime. In this case, the `ExpiresIn` element on the OAuthV2 policy won't be able to expire an access token in less than 180 seconds.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.apiproducts.attributes",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API product. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}/attributes",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1Attributes"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Attributes"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.create":

type OrganizationsApiproductsCreateCall struct {
	s                             *Service
	parent                        string
	googlecloudapigeev1apiproduct *GoogleCloudApigeeV1ApiProduct
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Create: Creates an API product in an organization. You create API
// products after you have proxied backend services using API proxies.
// An API product is a collection of API resources combined with quota
// settings and metadata that you can use to deliver customized and
// productized API bundles to your developer community. This metadata
// can include: - Scope - Environments - API proxies - Extensible
// profile API products enable you repackage APIs on the fly, without
// having to do any additional coding or configuration. Apigee
// recommends that you start with a simple API product including only
// required elements. You then provision credentials to apps to enable
// them to start testing your APIs. After you have authentication and
// authorization working against a simple API product, you can iterate
// to create finer-grained API products, defining different sets of API
// resources for each API product. **WARNING:** - If you don't specify
// an API proxy in the request body, *any* app associated with the
// product can make calls to *any* API in your entire organization. - If
// you don't specify an environment in the request body, the product
// allows access to all environments. For more information, see What is
// an API product?
//
//   - parent: Name of the organization in which the API product will be
//     created. Use the following structure in your request:
//     `organizations/{org}`.
func (r *OrganizationsApiproductsService) Create(parent string, googlecloudapigeev1apiproduct *GoogleCloudApigeeV1ApiProduct) *OrganizationsApiproductsCreateCall {
	c := &OrganizationsApiproductsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapigeev1apiproduct = googlecloudapigeev1apiproduct
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsCreateCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsCreateCall) Context(ctx context.Context) *OrganizationsApiproductsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1apiproduct)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apiproducts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.create" call.
// Exactly one of *GoogleCloudApigeeV1ApiProduct or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1ApiProduct.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an API product in an organization. You create API products after you have proxied backend services using API proxies. An API product is a collection of API resources combined with quota settings and metadata that you can use to deliver customized and productized API bundles to your developer community. This metadata can include: - Scope - Environments - API proxies - Extensible profile API products enable you repackage APIs on the fly, without having to do any additional coding or configuration. Apigee recommends that you start with a simple API product including only required elements. You then provision credentials to apps to enable them to start testing your APIs. After you have authentication and authorization working against a simple API product, you can iterate to create finer-grained API products, defining different sets of API resources for each API product. **WARNING:** - If you don't specify an API proxy in the request body, *any* app associated with the product can make calls to *any* API in your entire organization. - If you don't specify an environment in the request body, the product allows access to all environments. For more information, see What is an API product?",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.apiproducts.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the organization in which the API product will be created. Use the following structure in your request: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/apiproducts",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1ApiProduct"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.delete":

type OrganizationsApiproductsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an API product from an organization. Deleting an API
// product causes app requests to the resource URIs defined in the API
// product to fail. Ensure that you create a new API product to serve
// existing apps, unless your intention is to disable access to the
// resources defined in the API product. The API product name required
// in the request URL is the internal name of the product, not the
// display name. While they may be the same, it depends on whether the
// API product was created via the UI or the API. View the list of API
// products to verify the internal name.
//
//   - name: Name of the API product. Use the following structure in your
//     request: `organizations/{org}/apiproducts/{apiproduct}`.
func (r *OrganizationsApiproductsService) Delete(name string) *OrganizationsApiproductsDeleteCall {
	c := &OrganizationsApiproductsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsDeleteCall) Context(ctx context.Context) *OrganizationsApiproductsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.delete" call.
// Exactly one of *GoogleCloudApigeeV1ApiProduct or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1ApiProduct.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an API product from an organization. Deleting an API product causes app requests to the resource URIs defined in the API product to fail. Ensure that you create a new API product to serve existing apps, unless your intention is to disable access to the resources defined in the API product. The API product name required in the request URL is the internal name of the product, not the display name. While they may be the same, it depends on whether the API product was created via the UI or the API. View the list of API products to verify the internal name.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.apiproducts.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API product. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.get":

type OrganizationsApiproductsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets configuration details for an API product. The API product
// name required in the request URL is the internal name of the product,
// not the display name. While they may be the same, it depends on
// whether the API product was created via the UI or the API. View the
// list of API products to verify the internal name.
//
//   - name: Name of the API product. Use the following structure in your
//     request: `organizations/{org}/apiproducts/{apiproduct}`.
func (r *OrganizationsApiproductsService) Get(name string) *OrganizationsApiproductsGetCall {
	c := &OrganizationsApiproductsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsGetCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApiproductsGetCall) IfNoneMatch(entityTag string) *OrganizationsApiproductsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsGetCall) Context(ctx context.Context) *OrganizationsApiproductsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.get" call.
// Exactly one of *GoogleCloudApigeeV1ApiProduct or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1ApiProduct.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets configuration details for an API product. The API product name required in the request URL is the internal name of the product, not the display name. While they may be the same, it depends on whether the API product was created via the UI or the API. View the list of API products to verify the internal name.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apiproducts.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API product. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.list":

type OrganizationsApiproductsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all API product names for an organization. Filter the
// list by passing an `attributename` and `attibutevalue`. The maximum
// number of API products returned is 1000. You can paginate the list of
// API products returned using the `startKey` and `count` query
// parameters.
//
//   - parent: Name of the organization. Use the following structure in
//     your request: `organizations/{org}`.
func (r *OrganizationsApiproductsService) List(parent string) *OrganizationsApiproductsListCall {
	c := &OrganizationsApiproductsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Attributename sets the optional parameter "attributename": Name of
// the attribute used to filter the search.
func (c *OrganizationsApiproductsListCall) Attributename(attributename string) *OrganizationsApiproductsListCall {
	c.urlParams_.Set("attributename", attributename)
	return c
}

// Attributevalue sets the optional parameter "attributevalue": Value of
// the attribute used to filter the search.
func (c *OrganizationsApiproductsListCall) Attributevalue(attributevalue string) *OrganizationsApiproductsListCall {
	c.urlParams_.Set("attributevalue", attributevalue)
	return c
}

// Count sets the optional parameter "count": Enter the number of API
// products you want returned in the API call. The limit is 1000.
func (c *OrganizationsApiproductsListCall) Count(count int64) *OrganizationsApiproductsListCall {
	c.urlParams_.Set("count", fmt.Sprint(count))
	return c
}

// Expand sets the optional parameter "expand": Flag that specifies
// whether to expand the results. Set to `true` to get expanded details
// about each API.
func (c *OrganizationsApiproductsListCall) Expand(expand bool) *OrganizationsApiproductsListCall {
	c.urlParams_.Set("expand", fmt.Sprint(expand))
	return c
}

// StartKey sets the optional parameter "startKey": Gets a list of API
// products starting with a specific API product in the list. For
// example, if you're returning 50 API products at a time (using the
// `count` query parameter), you can view products 50-99 by entering the
// name of the 50th API product in the first API (without using
// `startKey`). Product name is case sensitive.
func (c *OrganizationsApiproductsListCall) StartKey(startKey string) *OrganizationsApiproductsListCall {
	c.urlParams_.Set("startKey", startKey)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsListCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApiproductsListCall) IfNoneMatch(entityTag string) *OrganizationsApiproductsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsListCall) Context(ctx context.Context) *OrganizationsApiproductsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apiproducts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.list" call.
// Exactly one of *GoogleCloudApigeeV1ListApiProductsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListApiProductsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApiproductsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListApiProductsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListApiProductsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all API product names for an organization. Filter the list by passing an `attributename` and `attibutevalue`. The maximum number of API products returned is 1000. You can paginate the list of API products returned using the `startKey` and `count` query parameters.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apiproducts.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "attributename": {
	//       "description": "Name of the attribute used to filter the search.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "attributevalue": {
	//       "description": "Value of the attribute used to filter the search.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "count": {
	//       "description": "Enter the number of API products you want returned in the API call. The limit is 1000.",
	//       "format": "int64",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "expand": {
	//       "description": "Flag that specifies whether to expand the results. Set to `true` to get expanded details about each API.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the organization. Use the following structure in your request: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "startKey": {
	//       "description": "Gets a list of API products starting with a specific API product in the list. For example, if you're returning 50 API products at a time (using the `count` query parameter), you can view products 50-99 by entering the name of the 50th API product in the first API (without using `startKey`). Product name is case sensitive.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/apiproducts",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListApiProductsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.update":

type OrganizationsApiproductsUpdateCall struct {
	s                             *Service
	name                          string
	googlecloudapigeev1apiproduct *GoogleCloudApigeeV1ApiProduct
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Update: Updates an existing API product. You must include all
// required values, whether or not you are updating them, as well as any
// optional values that you are updating. The API product name required
// in the request URL is the internal name of the product, not the
// display name. While they may be the same, it depends on whether the
// API product was created via UI or API. View the list of API products
// to identify their internal names.
//
//   - name: Name of the API product. Use the following structure in your
//     request: `organizations/{org}/apiproducts/{apiproduct}`.
func (r *OrganizationsApiproductsService) Update(name string, googlecloudapigeev1apiproduct *GoogleCloudApigeeV1ApiProduct) *OrganizationsApiproductsUpdateCall {
	c := &OrganizationsApiproductsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1apiproduct = googlecloudapigeev1apiproduct
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsUpdateCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsUpdateCall) Context(ctx context.Context) *OrganizationsApiproductsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1apiproduct)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.update" call.
// Exactly one of *GoogleCloudApigeeV1ApiProduct or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1ApiProduct.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProduct, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProduct{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing API product. You must include all required values, whether or not you are updating them, as well as any optional values that you are updating. The API product name required in the request URL is the internal name of the product, not the display name. While they may be the same, it depends on whether the API product was created via UI or API. View the list of API products to identify their internal names.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}",
	//   "httpMethod": "PUT",
	//   "id": "apigee.organizations.apiproducts.update",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API product. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1ApiProduct"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProduct"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.attributes.delete":

type OrganizationsApiproductsAttributesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an API product attribute.
//
//   - name: Name of the API product attribute. Use the following
//     structure in your request:
//     `organizations/{org}/apiproducts/{apiproduct}/attributes/{attribute}
//     `.
func (r *OrganizationsApiproductsAttributesService) Delete(name string) *OrganizationsApiproductsAttributesDeleteCall {
	c := &OrganizationsApiproductsAttributesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsAttributesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsAttributesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsAttributesDeleteCall) Context(ctx context.Context) *OrganizationsApiproductsAttributesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsAttributesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsAttributesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.attributes.delete" call.
// Exactly one of *GoogleCloudApigeeV1Attribute or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Attribute.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsAttributesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Attribute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Attribute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an API product attribute.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes/{attributesId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.apiproducts.attributes.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API product attribute. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}/attributes/{attribute}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Attribute"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.attributes.get":

type OrganizationsApiproductsAttributesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the value of an API product attribute.
//
//   - name: Name of the API product attribute. Use the following
//     structure in your request:
//     `organizations/{org}/apiproducts/{apiproduct}/attributes/{attribute}
//     `.
func (r *OrganizationsApiproductsAttributesService) Get(name string) *OrganizationsApiproductsAttributesGetCall {
	c := &OrganizationsApiproductsAttributesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsAttributesGetCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsAttributesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApiproductsAttributesGetCall) IfNoneMatch(entityTag string) *OrganizationsApiproductsAttributesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsAttributesGetCall) Context(ctx context.Context) *OrganizationsApiproductsAttributesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsAttributesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsAttributesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.attributes.get" call.
// Exactly one of *GoogleCloudApigeeV1Attribute or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Attribute.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsAttributesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Attribute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Attribute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the value of an API product attribute.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes/{attributesId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apiproducts.attributes.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API product attribute. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}/attributes/{attribute}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Attribute"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.attributes.list":

type OrganizationsApiproductsAttributesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all API product attributes.
//
//   - parent: Name of the API product. Use the following structure in
//     your request: `organizations/{org}/apiproducts/{apiproduct}`.
func (r *OrganizationsApiproductsAttributesService) List(parent string) *OrganizationsApiproductsAttributesListCall {
	c := &OrganizationsApiproductsAttributesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsAttributesListCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsAttributesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApiproductsAttributesListCall) IfNoneMatch(entityTag string) *OrganizationsApiproductsAttributesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsAttributesListCall) Context(ctx context.Context) *OrganizationsApiproductsAttributesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsAttributesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsAttributesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/attributes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.attributes.list" call.
// Exactly one of *GoogleCloudApigeeV1Attributes or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Attributes.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsAttributesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Attributes, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Attributes{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all API product attributes.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apiproducts.attributes.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the API product. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/attributes",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Attributes"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.attributes.updateApiProductAttribute":

type OrganizationsApiproductsAttributesUpdateApiProductAttributeCall struct {
	s                            *Service
	name                         string
	googlecloudapigeev1attribute *GoogleCloudApigeeV1Attribute
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// UpdateApiProductAttribute: Updates the value of an API product
// attribute. **Note**: OAuth access tokens and Key Management Service
// (KMS) entities (apps, developers, and API products) are cached for
// 180 seconds (current default). Any custom attributes associated with
// entities also get cached for at least 180 seconds after entity is
// accessed during runtime. In this case, the `ExpiresIn` element on the
// OAuthV2 policy won't be able to expire an access token in less than
// 180 seconds.
//
//   - name: Name of the API product. Use the following structure in your
//     request: `organizations/{org}/apiproducts/{apiproduct}`.
func (r *OrganizationsApiproductsAttributesService) UpdateApiProductAttribute(name string, googlecloudapigeev1attribute *GoogleCloudApigeeV1Attribute) *OrganizationsApiproductsAttributesUpdateApiProductAttributeCall {
	c := &OrganizationsApiproductsAttributesUpdateApiProductAttributeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1attribute = googlecloudapigeev1attribute
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsAttributesUpdateApiProductAttributeCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsAttributesUpdateApiProductAttributeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsAttributesUpdateApiProductAttributeCall) Context(ctx context.Context) *OrganizationsApiproductsAttributesUpdateApiProductAttributeCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsAttributesUpdateApiProductAttributeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsAttributesUpdateApiProductAttributeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1attribute)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.attributes.updateApiProductAttribute" call.
// Exactly one of *GoogleCloudApigeeV1Attribute or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1Attribute.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsAttributesUpdateApiProductAttributeCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1Attribute, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1Attribute{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the value of an API product attribute. **Note**: OAuth access tokens and Key Management Service (KMS) entities (apps, developers, and API products) are cached for 180 seconds (current default). Any custom attributes associated with entities also get cached for at least 180 seconds after entity is accessed during runtime. In this case, the `ExpiresIn` element on the OAuthV2 policy won't be able to expire an access token in less than 180 seconds.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/attributes/{attributesId}",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.apiproducts.attributes.updateApiProductAttribute",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API product. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+/attributes/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1Attribute"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1Attribute"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.rateplans.create":

type OrganizationsApiproductsRateplansCreateCall struct {
	s                           *Service
	parent                      string
	googlecloudapigeev1rateplan *GoogleCloudApigeeV1RatePlan
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Create: Create a rate plan that is associated with an API product in
// an organization. Using rate plans, API product owners can monetize
// their API products by configuring one or more of the following: -
// Billing frequency - Initial setup fees for using an API product -
// Payment funding model (postpaid only) - Fixed recurring or
// consumption-based charges for using an API product - Revenue sharing
// with developer partners An API product can have multiple rate plans
// associated with it but *only one* rate plan can be active at any
// point of time. **Note: From the developer's perspective, they
// purchase API products not rate plans.
//
//   - parent: Name of the API product that is associated with the rate
//     plan. Use the following structure in your request:
//     `organizations/{org}/apiproducts/{apiproduct}`.
func (r *OrganizationsApiproductsRateplansService) Create(parent string, googlecloudapigeev1rateplan *GoogleCloudApigeeV1RatePlan) *OrganizationsApiproductsRateplansCreateCall {
	c := &OrganizationsApiproductsRateplansCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapigeev1rateplan = googlecloudapigeev1rateplan
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsRateplansCreateCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsRateplansCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsRateplansCreateCall) Context(ctx context.Context) *OrganizationsApiproductsRateplansCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsRateplansCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsRateplansCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1rateplan)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/rateplans")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.rateplans.create" call.
// Exactly one of *GoogleCloudApigeeV1RatePlan or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1RatePlan.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsRateplansCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1RatePlan, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1RatePlan{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a rate plan that is associated with an API product in an organization. Using rate plans, API product owners can monetize their API products by configuring one or more of the following: - Billing frequency - Initial setup fees for using an API product - Payment funding model (postpaid only) - Fixed recurring or consumption-based charges for using an API product - Revenue sharing with developer partners An API product can have multiple rate plans associated with it but *only one* rate plan can be active at any point of time. **Note: From the developer's perspective, they purchase API products not rate plans.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/rateplans",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.apiproducts.rateplans.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the API product that is associated with the rate plan. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/rateplans",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1RatePlan"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1RatePlan"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.rateplans.delete":

type OrganizationsApiproductsRateplansDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a rate plan.
//
//   - name: ID of the rate plan. Use the following structure in your
//     request:
//     `organizations/{org}/apiproducts/{apiproduct}/rateplans/{rateplan}`.
func (r *OrganizationsApiproductsRateplansService) Delete(name string) *OrganizationsApiproductsRateplansDeleteCall {
	c := &OrganizationsApiproductsRateplansDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsRateplansDeleteCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsRateplansDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsRateplansDeleteCall) Context(ctx context.Context) *OrganizationsApiproductsRateplansDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsRateplansDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsRateplansDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.rateplans.delete" call.
// Exactly one of *GoogleCloudApigeeV1RatePlan or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1RatePlan.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsRateplansDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1RatePlan, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1RatePlan{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a rate plan.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/rateplans/{rateplansId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.apiproducts.rateplans.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. ID of the rate plan. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}/rateplans/{rateplan}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+/rateplans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1RatePlan"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.rateplans.get":

type OrganizationsApiproductsRateplansGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the details of a rate plan.
//
//   - name: Name of the rate plan. Use the following structure in your
//     request:
//     `organizations/{org}/apiproducts/{apiproduct}/rateplans/{rateplan}`.
func (r *OrganizationsApiproductsRateplansService) Get(name string) *OrganizationsApiproductsRateplansGetCall {
	c := &OrganizationsApiproductsRateplansGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsRateplansGetCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsRateplansGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApiproductsRateplansGetCall) IfNoneMatch(entityTag string) *OrganizationsApiproductsRateplansGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsRateplansGetCall) Context(ctx context.Context) *OrganizationsApiproductsRateplansGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsRateplansGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsRateplansGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.rateplans.get" call.
// Exactly one of *GoogleCloudApigeeV1RatePlan or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1RatePlan.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsRateplansGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1RatePlan, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1RatePlan{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets the details of a rate plan.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/rateplans/{rateplansId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apiproducts.rateplans.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the rate plan. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}/rateplans/{rateplan}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+/rateplans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1RatePlan"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.rateplans.list":

type OrganizationsApiproductsRateplansListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all the rate plans for an API product.
//
//   - parent: Name of the API product. Use the following structure in
//     your request: `organizations/{org}/apiproducts/{apiproduct}` Use
//     `organizations/{org}/apiproducts/-` to return rate plans for all
//     API products within the organization.
func (r *OrganizationsApiproductsRateplansService) List(parent string) *OrganizationsApiproductsRateplansListCall {
	c := &OrganizationsApiproductsRateplansListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Count sets the optional parameter "count": Number of rate plans to
// return in the API call. Use with the `startKey` parameter to provide
// more targeted filtering. The maximum limit is 1000. Defaults to 100.
func (c *OrganizationsApiproductsRateplansListCall) Count(count int64) *OrganizationsApiproductsRateplansListCall {
	c.urlParams_.Set("count", fmt.Sprint(count))
	return c
}

// Expand sets the optional parameter "expand": Flag that specifies
// whether to expand the results. Set to `true` to get expanded details
// about each API. Defaults to `false`.
func (c *OrganizationsApiproductsRateplansListCall) Expand(expand bool) *OrganizationsApiproductsRateplansListCall {
	c.urlParams_.Set("expand", fmt.Sprint(expand))
	return c
}

// OrderBy sets the optional parameter "orderBy": Name of the attribute
// used for sorting. Valid values include: * `name`: Name of the rate
// plan. * `state`: State of the rate plan (`DRAFT`, `PUBLISHED`). *
// `startTime`: Time when the rate plan becomes active. * `endTime`:
// Time when the rate plan expires. **Note**: Not supported by Apigee at
// this time.
func (c *OrganizationsApiproductsRateplansListCall) OrderBy(orderBy string) *OrganizationsApiproductsRateplansListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// StartKey sets the optional parameter "startKey": Name of the rate
// plan from which to start displaying the list of rate plans. If
// omitted, the list starts from the first item. For example, to view
// the rate plans from 51-150, set the value of `startKey` to the name
// of the 51st rate plan and set the value of `count` to 100.
func (c *OrganizationsApiproductsRateplansListCall) StartKey(startKey string) *OrganizationsApiproductsRateplansListCall {
	c.urlParams_.Set("startKey", startKey)
	return c
}

// State sets the optional parameter "state": State of the rate plans
// (`DRAFT`, `PUBLISHED`) that you want to display.
//
// Possible values:
//
//	"STATE_UNSPECIFIED" - State of the rate plan is not specified.
//	"DRAFT" - Rate plan is in draft mode and only visible to API
//
// providers.
//
//	"PUBLISHED" - Rate plan is published and will become visible to
//
// developers for the configured duration (between `startTime` and
// `endTime`).
func (c *OrganizationsApiproductsRateplansListCall) State(state string) *OrganizationsApiproductsRateplansListCall {
	c.urlParams_.Set("state", state)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsRateplansListCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsRateplansListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApiproductsRateplansListCall) IfNoneMatch(entityTag string) *OrganizationsApiproductsRateplansListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsRateplansListCall) Context(ctx context.Context) *OrganizationsApiproductsRateplansListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsRateplansListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsRateplansListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/rateplans")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.rateplans.list" call.
// Exactly one of *GoogleCloudApigeeV1ListRatePlansResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListRatePlansResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApiproductsRateplansListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListRatePlansResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListRatePlansResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all the rate plans for an API product.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/rateplans",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apiproducts.rateplans.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "count": {
	//       "description": "Number of rate plans to return in the API call. Use with the `startKey` parameter to provide more targeted filtering. The maximum limit is 1000. Defaults to 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "expand": {
	//       "description": "Flag that specifies whether to expand the results. Set to `true` to get expanded details about each API. Defaults to `false`.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "orderBy": {
	//       "description": "Name of the attribute used for sorting. Valid values include: * `name`: Name of the rate plan. * `state`: State of the rate plan (`DRAFT`, `PUBLISHED`). * `startTime`: Time when the rate plan becomes active. * `endTime`: Time when the rate plan expires. **Note**: Not supported by Apigee at this time.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the API product. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}` Use `organizations/{org}/apiproducts/-` to return rate plans for all API products within the organization.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "startKey": {
	//       "description": "Name of the rate plan from which to start displaying the list of rate plans. If omitted, the list starts from the first item. For example, to view the rate plans from 51-150, set the value of `startKey` to the name of the 51st rate plan and set the value of `count` to 100.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "state": {
	//       "description": "State of the rate plans (`DRAFT`, `PUBLISHED`) that you want to display.",
	//       "enum": [
	//         "STATE_UNSPECIFIED",
	//         "DRAFT",
	//         "PUBLISHED"
	//       ],
	//       "enumDescriptions": [
	//         "State of the rate plan is not specified.",
	//         "Rate plan is in draft mode and only visible to API providers.",
	//         "Rate plan is published and will become visible to developers for the configured duration (between `startTime` and `endTime`)."
	//       ],
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/rateplans",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListRatePlansResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apiproducts.rateplans.update":

type OrganizationsApiproductsRateplansUpdateCall struct {
	s                           *Service
	name                        string
	googlecloudapigeev1rateplan *GoogleCloudApigeeV1RatePlan
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Update: Updates an existing rate plan.
//
//   - name: Name of the rate plan. Use the following structure in your
//     request:
//     `organizations/{org}/apiproducts/{apiproduct}/rateplans/{rateplan}`.
func (r *OrganizationsApiproductsRateplansService) Update(name string, googlecloudapigeev1rateplan *GoogleCloudApigeeV1RatePlan) *OrganizationsApiproductsRateplansUpdateCall {
	c := &OrganizationsApiproductsRateplansUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1rateplan = googlecloudapigeev1rateplan
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApiproductsRateplansUpdateCall) Fields(s ...googleapi.Field) *OrganizationsApiproductsRateplansUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApiproductsRateplansUpdateCall) Context(ctx context.Context) *OrganizationsApiproductsRateplansUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApiproductsRateplansUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApiproductsRateplansUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1rateplan)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apiproducts.rateplans.update" call.
// Exactly one of *GoogleCloudApigeeV1RatePlan or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1RatePlan.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApiproductsRateplansUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1RatePlan, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1RatePlan{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing rate plan.",
	//   "flatPath": "v1/organizations/{organizationsId}/apiproducts/{apiproductsId}/rateplans/{rateplansId}",
	//   "httpMethod": "PUT",
	//   "id": "apigee.organizations.apiproducts.rateplans.update",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the rate plan. Use the following structure in your request: `organizations/{org}/apiproducts/{apiproduct}/rateplans/{rateplan}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apiproducts/[^/]+/rateplans/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1RatePlan"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1RatePlan"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.create":

type OrganizationsApisCreateCall struct {
	s                 *Service
	parent            string
	googleapihttpbody *GoogleApiHttpBody
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// Create: Creates an API proxy. The API proxy created will not be
// accessible at runtime until it is deployed to an environment. Create
// a new API proxy by setting the `name` query parameter to the name of
// the API proxy. Import an API proxy configuration bundle stored in zip
// format on your local machine to your organization by doing the
// following: * Set the `name` query parameter to the name of the API
// proxy. * Set the `action` query parameter to `import`. * Set the
// `Content-Type` header to `multipart/form-data`. * Pass as a file the
// name of API proxy configuration bundle stored in zip format on your
// local machine using the `file` form field. **Note**: To validate the
// API proxy configuration bundle only without importing it, set the
// `action` query parameter to `validate`. When importing an API proxy
// configuration bundle, if the API proxy does not exist, it will be
// created. If the API proxy exists, then a new revision is created.
// Invalid API proxy configurations are rejected, and a list of
// validation errors is returned to the client.
//
//   - parent: Name of the organization in the following format:
//     `organizations/{org}`.
func (r *OrganizationsApisService) Create(parent string, googleapihttpbody *GoogleApiHttpBody) *OrganizationsApisCreateCall {
	c := &OrganizationsApisCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googleapihttpbody = googleapihttpbody
	return c
}

// Action sets the optional parameter "action": Action to perform when
// importing an API proxy configuration bundle. Set this parameter to
// one of the following values: * `import` to import the API proxy
// configuration bundle. * `validate` to validate the API proxy
// configuration bundle without importing it.
func (c *OrganizationsApisCreateCall) Action(action string) *OrganizationsApisCreateCall {
	c.urlParams_.Set("action", action)
	return c
}

// Name sets the optional parameter "name": Name of the API proxy.
// Restrict the characters used to: A-Za-z0-9._-
func (c *OrganizationsApisCreateCall) Name(name string) *OrganizationsApisCreateCall {
	c.urlParams_.Set("name", name)
	return c
}

// Validate sets the optional parameter "validate": Ignored. All uploads
// are validated regardless of the value of this field. Maintained for
// compatibility with Apigee Edge API.
func (c *OrganizationsApisCreateCall) Validate(validate bool) *OrganizationsApisCreateCall {
	c.urlParams_.Set("validate", fmt.Sprint(validate))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisCreateCall) Fields(s ...googleapi.Field) *OrganizationsApisCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisCreateCall) Context(ctx context.Context) *OrganizationsApisCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleapihttpbody)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apis")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.create" call.
// Exactly one of *GoogleCloudApigeeV1ApiProxyRevision or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1ApiProxyRevision.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApisCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProxyRevision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProxyRevision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an API proxy. The API proxy created will not be accessible at runtime until it is deployed to an environment. Create a new API proxy by setting the `name` query parameter to the name of the API proxy. Import an API proxy configuration bundle stored in zip format on your local machine to your organization by doing the following: * Set the `name` query parameter to the name of the API proxy. * Set the `action` query parameter to `import`. * Set the `Content-Type` header to `multipart/form-data`. * Pass as a file the name of API proxy configuration bundle stored in zip format on your local machine using the `file` form field. **Note**: To validate the API proxy configuration bundle only without importing it, set the `action` query parameter to `validate`. When importing an API proxy configuration bundle, if the API proxy does not exist, it will be created. If the API proxy exists, then a new revision is created. Invalid API proxy configurations are rejected, and a list of validation errors is returned to the client.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.apis.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "action": {
	//       "description": "Action to perform when importing an API proxy configuration bundle. Set this parameter to one of the following values: * `import` to import the API proxy configuration bundle. * `validate` to validate the API proxy configuration bundle without importing it.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Name of the API proxy. Restrict the characters used to: A-Za-z0-9._-",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the organization in the following format: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validate": {
	//       "description": "Ignored. All uploads are validated regardless of the value of this field. Maintained for compatibility with Apigee Edge API.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+parent}/apis",
	//   "request": {
	//     "$ref": "GoogleApiHttpBody"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProxyRevision"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.delete":

type OrganizationsApisDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an API proxy and all associated endpoints, policies,
// resources, and revisions. The API proxy must be undeployed before you
// can delete it.
//
//   - name: Name of the API proxy in the following format:
//     `organizations/{org}/apis/{api}`.
func (r *OrganizationsApisService) Delete(name string) *OrganizationsApisDeleteCall {
	c := &OrganizationsApisDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisDeleteCall) Fields(s ...googleapi.Field) *OrganizationsApisDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisDeleteCall) Context(ctx context.Context) *OrganizationsApisDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.delete" call.
// Exactly one of *GoogleCloudApigeeV1ApiProxy or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1ApiProxy.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProxy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProxy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an API proxy and all associated endpoints, policies, resources, and revisions. The API proxy must be undeployed before you can delete it.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.apis.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API proxy in the following format: `organizations/{org}/apis/{api}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProxy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.get":

type OrganizationsApisGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an API proxy including a list of existing revisions.
//
//   - name: Name of the API proxy in the following format:
//     `organizations/{org}/apis/{api}`.
func (r *OrganizationsApisService) Get(name string) *OrganizationsApisGetCall {
	c := &OrganizationsApisGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisGetCall) Fields(s ...googleapi.Field) *OrganizationsApisGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApisGetCall) IfNoneMatch(entityTag string) *OrganizationsApisGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisGetCall) Context(ctx context.Context) *OrganizationsApisGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.get" call.
// Exactly one of *GoogleCloudApigeeV1ApiProxy or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1ApiProxy.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProxy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProxy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an API proxy including a list of existing revisions.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apis.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the API proxy in the following format: `organizations/{org}/apis/{api}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProxy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.list":

type OrganizationsApisListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists the names of all API proxies in an organization. The
// names returned correspond to the names defined in the configuration
// files for each API proxy.
//
//   - parent: Name of the organization in the following format:
//     `organizations/{org}`.
func (r *OrganizationsApisService) List(parent string) *OrganizationsApisListCall {
	c := &OrganizationsApisListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// IncludeMetaData sets the optional parameter "includeMetaData": Flag
// that specifies whether to include API proxy metadata in the response.
func (c *OrganizationsApisListCall) IncludeMetaData(includeMetaData bool) *OrganizationsApisListCall {
	c.urlParams_.Set("includeMetaData", fmt.Sprint(includeMetaData))
	return c
}

// IncludeRevisions sets the optional parameter "includeRevisions": Flag
// that specifies whether to include a list of revisions in the
// response.
func (c *OrganizationsApisListCall) IncludeRevisions(includeRevisions bool) *OrganizationsApisListCall {
	c.urlParams_.Set("includeRevisions", fmt.Sprint(includeRevisions))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisListCall) Fields(s ...googleapi.Field) *OrganizationsApisListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApisListCall) IfNoneMatch(entityTag string) *OrganizationsApisListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisListCall) Context(ctx context.Context) *OrganizationsApisListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apis")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.list" call.
// Exactly one of *GoogleCloudApigeeV1ListApiProxiesResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListApiProxiesResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApisListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListApiProxiesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListApiProxiesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists the names of all API proxies in an organization. The names returned correspond to the names defined in the configuration files for each API proxy.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apis.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "includeMetaData": {
	//       "description": "Flag that specifies whether to include API proxy metadata in the response.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "includeRevisions": {
	//       "description": "Flag that specifies whether to include a list of revisions in the response.",
	//       "location": "query",
	//       "type": "boolean"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the organization in the following format: `organizations/{org}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/apis",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListApiProxiesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.patch":

type OrganizationsApisPatchCall struct {
	s                           *Service
	name                        string
	googlecloudapigeev1apiproxy *GoogleCloudApigeeV1ApiProxy
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Patch: Updates an existing API proxy.
//
//   - name: API proxy to update in the following format:
//     `organizations/{org}/apis/{api}`.
func (r *OrganizationsApisService) Patch(name string, googlecloudapigeev1apiproxy *GoogleCloudApigeeV1ApiProxy) *OrganizationsApisPatchCall {
	c := &OrganizationsApisPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1apiproxy = googlecloudapigeev1apiproxy
	return c
}

// UpdateMask sets the optional parameter "updateMask": Required. The
// list of fields to update.
func (c *OrganizationsApisPatchCall) UpdateMask(updateMask string) *OrganizationsApisPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisPatchCall) Fields(s ...googleapi.Field) *OrganizationsApisPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisPatchCall) Context(ctx context.Context) *OrganizationsApisPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1apiproxy)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.patch" call.
// Exactly one of *GoogleCloudApigeeV1ApiProxy or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1ApiProxy.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisPatchCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProxy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProxy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing API proxy.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}",
	//   "httpMethod": "PATCH",
	//   "id": "apigee.organizations.apis.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. API proxy to update in the following format: `organizations/{org}/apis/{api}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "Required. The list of fields to update.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1ApiProxy"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProxy"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.deployments.list":

type OrganizationsApisDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all deployments of an API proxy.
//
//   - parent: Name of the API proxy for which to return deployment
//     information in the following format:
//     `organizations/{org}/apis/{api}`.
func (r *OrganizationsApisDeploymentsService) List(parent string) *OrganizationsApisDeploymentsListCall {
	c := &OrganizationsApisDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisDeploymentsListCall) Fields(s ...googleapi.Field) *OrganizationsApisDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApisDeploymentsListCall) IfNoneMatch(entityTag string) *OrganizationsApisDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisDeploymentsListCall) Context(ctx context.Context) *OrganizationsApisDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.deployments.list" call.
// Exactly one of *GoogleCloudApigeeV1ListDeploymentsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListDeploymentsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApisDeploymentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all deployments of an API proxy.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/deployments",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apis.deployments.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the API proxy for which to return deployment information in the following format: `organizations/{org}/apis/{api}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/deployments",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListDeploymentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.keyvaluemaps.create":

type OrganizationsApisKeyvaluemapsCreateCall struct {
	s                              *Service
	parent                         string
	googlecloudapigeev1keyvaluemap *GoogleCloudApigeeV1KeyValueMap
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Create: Creates a key value map in an API proxy.
//
//   - parent: Name of the environment in which to create the key value
//     map. Use the following structure in your request:
//     `organizations/{org}/apis/{api}`.
func (r *OrganizationsApisKeyvaluemapsService) Create(parent string, googlecloudapigeev1keyvaluemap *GoogleCloudApigeeV1KeyValueMap) *OrganizationsApisKeyvaluemapsCreateCall {
	c := &OrganizationsApisKeyvaluemapsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapigeev1keyvaluemap = googlecloudapigeev1keyvaluemap
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisKeyvaluemapsCreateCall) Fields(s ...googleapi.Field) *OrganizationsApisKeyvaluemapsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisKeyvaluemapsCreateCall) Context(ctx context.Context) *OrganizationsApisKeyvaluemapsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisKeyvaluemapsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisKeyvaluemapsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1keyvaluemap)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/keyvaluemaps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.keyvaluemaps.create" call.
// Exactly one of *GoogleCloudApigeeV1KeyValueMap or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1KeyValueMap.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisKeyvaluemapsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1KeyValueMap, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1KeyValueMap{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates a key value map in an API proxy.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.apis.keyvaluemaps.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the environment in which to create the key value map. Use the following structure in your request: `organizations/{org}/apis/{api}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/keyvaluemaps",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueMap"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueMap"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.keyvaluemaps.delete":

type OrganizationsApisKeyvaluemapsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a key value map from an API proxy.
//
//   - name: Name of the key value map. Use the following structure in
//     your request:
//     `organizations/{org}/apis/{api}/keyvaluemaps/{keyvaluemap}`.
func (r *OrganizationsApisKeyvaluemapsService) Delete(name string) *OrganizationsApisKeyvaluemapsDeleteCall {
	c := &OrganizationsApisKeyvaluemapsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisKeyvaluemapsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsApisKeyvaluemapsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisKeyvaluemapsDeleteCall) Context(ctx context.Context) *OrganizationsApisKeyvaluemapsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisKeyvaluemapsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisKeyvaluemapsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.keyvaluemaps.delete" call.
// Exactly one of *GoogleCloudApigeeV1KeyValueMap or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1KeyValueMap.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisKeyvaluemapsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1KeyValueMap, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1KeyValueMap{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a key value map from an API proxy.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps/{keyvaluemapsId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.apis.keyvaluemaps.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the key value map. Use the following structure in your request: `organizations/{org}/apis/{api}/keyvaluemaps/{keyvaluemap}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/keyvaluemaps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueMap"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.keyvaluemaps.entries.create":

type OrganizationsApisKeyvaluemapsEntriesCreateCall struct {
	s                                *Service
	parent                           string
	googlecloudapigeev1keyvalueentry *GoogleCloudApigeeV1KeyValueEntry
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Create: Creates key value entries in a key value map scoped to an
// organization, environment, or API proxy. **Note**: Supported for
// Apigee hybrid 1.8.x and higher.
//
//   - parent: Scope as indicated by the URI in which to create the key
//     value map entry. Use **one** of the following structures in your
//     request: *
//     `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}`
//     . *
//     `organizations/{organization}/environments/{environment}/keyvaluemap
//     s/{keyvaluemap}` *
//     `organizations/{organization}/keyvaluemaps/{keyvaluemap}`.
func (r *OrganizationsApisKeyvaluemapsEntriesService) Create(parent string, googlecloudapigeev1keyvalueentry *GoogleCloudApigeeV1KeyValueEntry) *OrganizationsApisKeyvaluemapsEntriesCreateCall {
	c := &OrganizationsApisKeyvaluemapsEntriesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapigeev1keyvalueentry = googlecloudapigeev1keyvalueentry
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisKeyvaluemapsEntriesCreateCall) Fields(s ...googleapi.Field) *OrganizationsApisKeyvaluemapsEntriesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisKeyvaluemapsEntriesCreateCall) Context(ctx context.Context) *OrganizationsApisKeyvaluemapsEntriesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisKeyvaluemapsEntriesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisKeyvaluemapsEntriesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1keyvalueentry)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.keyvaluemaps.entries.create" call.
// Exactly one of *GoogleCloudApigeeV1KeyValueEntry or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1KeyValueEntry.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisKeyvaluemapsEntriesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1KeyValueEntry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1KeyValueEntry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates key value entries in a key value map scoped to an organization, environment, or API proxy. **Note**: Supported for Apigee hybrid 1.8.x and higher.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps/{keyvaluemapsId}/entries",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.apis.keyvaluemaps.entries.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Scope as indicated by the URI in which to create the key value map entry. Use **one** of the following structures in your request: * `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}`. * `organizations/{organization}/environments/{environment}/keyvaluemaps/{keyvaluemap}` * `organizations/{organization}/keyvaluemaps/{keyvaluemap}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/keyvaluemaps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/entries",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueEntry"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueEntry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.keyvaluemaps.entries.delete":

type OrganizationsApisKeyvaluemapsEntriesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a key value entry from a key value map scoped to an
// organization, environment, or API proxy. **Notes:** * After you
// delete the key value entry, the policy consuming the entry will
// continue to function with its cached values for a few minutes. This
// is expected behavior. * Supported for Apigee hybrid 1.8.x and higher.
//
//   - name: Scope as indicated by the URI in which to delete the key
//     value map entry. Use **one** of the following structures in your
//     request: *
//     `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}/
//     entries/{entry}`. *
//     `organizations/{organization}/environments/{environment}/keyvaluemap
//     s/{keyvaluemap}/entries/{entry}` *
//     `organizations/{organization}/keyvaluemaps/{keyvaluemap}/entries/{en
//     try}`.
func (r *OrganizationsApisKeyvaluemapsEntriesService) Delete(name string) *OrganizationsApisKeyvaluemapsEntriesDeleteCall {
	c := &OrganizationsApisKeyvaluemapsEntriesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisKeyvaluemapsEntriesDeleteCall) Fields(s ...googleapi.Field) *OrganizationsApisKeyvaluemapsEntriesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisKeyvaluemapsEntriesDeleteCall) Context(ctx context.Context) *OrganizationsApisKeyvaluemapsEntriesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisKeyvaluemapsEntriesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisKeyvaluemapsEntriesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.keyvaluemaps.entries.delete" call.
// Exactly one of *GoogleCloudApigeeV1KeyValueEntry or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1KeyValueEntry.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisKeyvaluemapsEntriesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1KeyValueEntry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1KeyValueEntry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes a key value entry from a key value map scoped to an organization, environment, or API proxy. **Notes:** * After you delete the key value entry, the policy consuming the entry will continue to function with its cached values for a few minutes. This is expected behavior. * Supported for Apigee hybrid 1.8.x and higher.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps/{keyvaluemapsId}/entries/{entriesId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.apis.keyvaluemaps.entries.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Scope as indicated by the URI in which to delete the key value map entry. Use **one** of the following structures in your request: * `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}/entries/{entry}`. * `organizations/{organization}/environments/{environment}/keyvaluemaps/{keyvaluemap}/entries/{entry}` * `organizations/{organization}/keyvaluemaps/{keyvaluemap}/entries/{entry}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/keyvaluemaps/[^/]+/entries/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueEntry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.keyvaluemaps.entries.get":

type OrganizationsApisKeyvaluemapsEntriesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get the key value entry value for a key value map scoped to an
// organization, environment, or API proxy. **Note**: Supported for
// Apigee hybrid 1.8.x and higher.
//
//   - name: Scope as indicated by the URI in which to fetch the key value
//     map entry/value. Use **one** of the following structures in your
//     request: *
//     `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}/
//     entries/{entry}`. *
//     `organizations/{organization}/environments/{environment}/keyvaluemap
//     s/{keyvaluemap}/entries/{entry}` *
//     `organizations/{organization}/keyvaluemaps/{keyvaluemap}/entries/{en
//     try}`.
func (r *OrganizationsApisKeyvaluemapsEntriesService) Get(name string) *OrganizationsApisKeyvaluemapsEntriesGetCall {
	c := &OrganizationsApisKeyvaluemapsEntriesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisKeyvaluemapsEntriesGetCall) Fields(s ...googleapi.Field) *OrganizationsApisKeyvaluemapsEntriesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApisKeyvaluemapsEntriesGetCall) IfNoneMatch(entityTag string) *OrganizationsApisKeyvaluemapsEntriesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisKeyvaluemapsEntriesGetCall) Context(ctx context.Context) *OrganizationsApisKeyvaluemapsEntriesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisKeyvaluemapsEntriesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisKeyvaluemapsEntriesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.keyvaluemaps.entries.get" call.
// Exactly one of *GoogleCloudApigeeV1KeyValueEntry or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1KeyValueEntry.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisKeyvaluemapsEntriesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1KeyValueEntry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1KeyValueEntry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Get the key value entry value for a key value map scoped to an organization, environment, or API proxy. **Note**: Supported for Apigee hybrid 1.8.x and higher.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps/{keyvaluemapsId}/entries/{entriesId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apis.keyvaluemaps.entries.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Scope as indicated by the URI in which to fetch the key value map entry/value. Use **one** of the following structures in your request: * `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}/entries/{entry}`. * `organizations/{organization}/environments/{environment}/keyvaluemaps/{keyvaluemap}/entries/{entry}` * `organizations/{organization}/keyvaluemaps/{keyvaluemap}/entries/{entry}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/keyvaluemaps/[^/]+/entries/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueEntry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.keyvaluemaps.entries.list":

type OrganizationsApisKeyvaluemapsEntriesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists key value entries for key values maps scoped to an
// organization, environment, or API proxy. **Note**: Supported for
// Apigee hybrid 1.8.x and higher.
//
//   - parent: Scope as indicated by the URI in which to list key value
//     maps. Use **one** of the following structures in your request: *
//     `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}`
//     . *
//     `organizations/{organization}/environments/{environment}/keyvaluemap
//     s/{keyvaluemap}` *
//     `organizations/{organization}/keyvaluemaps/{keyvaluemap}`.
func (r *OrganizationsApisKeyvaluemapsEntriesService) List(parent string) *OrganizationsApisKeyvaluemapsEntriesListCall {
	c := &OrganizationsApisKeyvaluemapsEntriesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// key value entries to return. If unspecified, at most 100 entries will
// be returned.
func (c *OrganizationsApisKeyvaluemapsEntriesListCall) PageSize(pageSize int64) *OrganizationsApisKeyvaluemapsEntriesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token. If
// provides, must be a valid key value entry returned from a previous
// call that can be used to retrieve the next page.
func (c *OrganizationsApisKeyvaluemapsEntriesListCall) PageToken(pageToken string) *OrganizationsApisKeyvaluemapsEntriesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisKeyvaluemapsEntriesListCall) Fields(s ...googleapi.Field) *OrganizationsApisKeyvaluemapsEntriesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApisKeyvaluemapsEntriesListCall) IfNoneMatch(entityTag string) *OrganizationsApisKeyvaluemapsEntriesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisKeyvaluemapsEntriesListCall) Context(ctx context.Context) *OrganizationsApisKeyvaluemapsEntriesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisKeyvaluemapsEntriesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisKeyvaluemapsEntriesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/entries")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.keyvaluemaps.entries.list" call.
// Exactly one of *GoogleCloudApigeeV1ListKeyValueEntriesResponse or
// error will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListKeyValueEntriesResponse.ServerResponse.Header
// or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApisKeyvaluemapsEntriesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListKeyValueEntriesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListKeyValueEntriesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists key value entries for key values maps scoped to an organization, environment, or API proxy. **Note**: Supported for Apigee hybrid 1.8.x and higher.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps/{keyvaluemapsId}/entries",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apis.keyvaluemaps.entries.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. Maximum number of key value entries to return. If unspecified, at most 100 entries will be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token. If provides, must be a valid key value entry returned from a previous call that can be used to retrieve the next page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Scope as indicated by the URI in which to list key value maps. Use **one** of the following structures in your request: * `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}`. * `organizations/{organization}/environments/{environment}/keyvaluemaps/{keyvaluemap}` * `organizations/{organization}/keyvaluemaps/{keyvaluemap}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/keyvaluemaps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/entries",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListKeyValueEntriesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsApisKeyvaluemapsEntriesListCall) Pages(ctx context.Context, f func(*GoogleCloudApigeeV1ListKeyValueEntriesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "apigee.organizations.apis.keyvaluemaps.entries.update":

type OrganizationsApisKeyvaluemapsEntriesUpdateCall struct {
	s                                *Service
	name                             string
	googlecloudapigeev1keyvalueentry *GoogleCloudApigeeV1KeyValueEntry
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// Update: Update key value entry scoped to an organization,
// environment, or API proxy for an existing key.
//
//   - name: Scope as indicated by the URI in which to create the key
//     value map entry. Use **one** of the following structures in your
//     request: *
//     `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}`
//     . *
//     `organizations/{organization}/environments/{environment}/keyvaluemap
//     s/{keyvaluemap}` *
//     `organizations/{organization}/keyvaluemaps/{keyvaluemap}`.
func (r *OrganizationsApisKeyvaluemapsEntriesService) Update(name string, googlecloudapigeev1keyvalueentry *GoogleCloudApigeeV1KeyValueEntry) *OrganizationsApisKeyvaluemapsEntriesUpdateCall {
	c := &OrganizationsApisKeyvaluemapsEntriesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1keyvalueentry = googlecloudapigeev1keyvalueentry
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisKeyvaluemapsEntriesUpdateCall) Fields(s ...googleapi.Field) *OrganizationsApisKeyvaluemapsEntriesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisKeyvaluemapsEntriesUpdateCall) Context(ctx context.Context) *OrganizationsApisKeyvaluemapsEntriesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisKeyvaluemapsEntriesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisKeyvaluemapsEntriesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1keyvalueentry)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.keyvaluemaps.entries.update" call.
// Exactly one of *GoogleCloudApigeeV1KeyValueEntry or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1KeyValueEntry.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header.
// Use googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisKeyvaluemapsEntriesUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1KeyValueEntry, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1KeyValueEntry{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update key value entry scoped to an organization, environment, or API proxy for an existing key.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/keyvaluemaps/{keyvaluemapsId}/entries/{entriesId}",
	//   "httpMethod": "PUT",
	//   "id": "apigee.organizations.apis.keyvaluemaps.entries.update",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Scope as indicated by the URI in which to create the key value map entry. Use **one** of the following structures in your request: * `organizations/{organization}/apis/{api}/keyvaluemaps/{keyvaluemap}`. * `organizations/{organization}/environments/{environment}/keyvaluemaps/{keyvaluemap}` * `organizations/{organization}/keyvaluemaps/{keyvaluemap}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/keyvaluemaps/[^/]+/entries/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueEntry"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1KeyValueEntry"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.revisions.delete":

type OrganizationsApisRevisionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an API proxy revision and all policies, resources,
// endpoints, and revisions associated with it. The API proxy revision
// must be undeployed before you can delete it.
//
//   - name: API proxy revision in the following format:
//     `organizations/{org}/apis/{api}/revisions/{rev}`.
func (r *OrganizationsApisRevisionsService) Delete(name string) *OrganizationsApisRevisionsDeleteCall {
	c := &OrganizationsApisRevisionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisRevisionsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsApisRevisionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisRevisionsDeleteCall) Context(ctx context.Context) *OrganizationsApisRevisionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisRevisionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisRevisionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.revisions.delete" call.
// Exactly one of *GoogleCloudApigeeV1ApiProxyRevision or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1ApiProxyRevision.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApisRevisionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProxyRevision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProxyRevision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an API proxy revision and all policies, resources, endpoints, and revisions associated with it. The API proxy revision must be undeployed before you can delete it.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/revisions/{revisionsId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.apis.revisions.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. API proxy revision in the following format: `organizations/{org}/apis/{api}/revisions/{rev}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/revisions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProxyRevision"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.revisions.get":

type OrganizationsApisRevisionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets an API proxy revision. To download the API proxy
// configuration bundle for the specified revision as a zip file, set
// the `format` query parameter to `bundle`. If you are using curl,
// specify `-o filename.zip` to save the output to a file; otherwise, it
// displays to `stdout`. Then, develop the API proxy configuration
// locally and upload the updated API proxy configuration revision, as
// described in updateApiProxyRevision (updateApiProxyRevision).
//
//   - name: API proxy revision in the following format:
//     `organizations/{org}/apis/{api}/revisions/{rev}`.
func (r *OrganizationsApisRevisionsService) Get(name string) *OrganizationsApisRevisionsGetCall {
	c := &OrganizationsApisRevisionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Format sets the optional parameter "format": Format used when
// downloading the API proxy configuration revision. Set to `bundle` to
// download the API proxy configuration revision as a zip file.
func (c *OrganizationsApisRevisionsGetCall) Format(format string) *OrganizationsApisRevisionsGetCall {
	c.urlParams_.Set("format", format)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisRevisionsGetCall) Fields(s ...googleapi.Field) *OrganizationsApisRevisionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApisRevisionsGetCall) IfNoneMatch(entityTag string) *OrganizationsApisRevisionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisRevisionsGetCall) Context(ctx context.Context) *OrganizationsApisRevisionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisRevisionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisRevisionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.revisions.get" call.
// Exactly one of *GoogleApiHttpBody or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *GoogleApiHttpBody.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsApisRevisionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleApiHttpBody, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleApiHttpBody{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Gets an API proxy revision. To download the API proxy configuration bundle for the specified revision as a zip file, set the `format` query parameter to `bundle`. If you are using curl, specify `-o filename.zip` to save the output to a file; otherwise, it displays to `stdout`. Then, develop the API proxy configuration locally and upload the updated API proxy configuration revision, as described in [updateApiProxyRevision](updateApiProxyRevision).",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/revisions/{revisionsId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apis.revisions.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "format": {
	//       "description": "Format used when downloading the API proxy configuration revision. Set to `bundle` to download the API proxy configuration revision as a zip file.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. API proxy revision in the following format: `organizations/{org}/apis/{api}/revisions/{rev}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/revisions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleApiHttpBody"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.revisions.updateApiProxyRevision":

type OrganizationsApisRevisionsUpdateApiProxyRevisionCall struct {
	s                 *Service
	name              string
	googleapihttpbody *GoogleApiHttpBody
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// UpdateApiProxyRevision: Updates an existing API proxy revision by
// uploading the API proxy configuration bundle as a zip file from your
// local machine. You can update only API proxy revisions that have
// never been deployed. After deployment, an API proxy revision becomes
// immutable, even if it is undeployed. Set the `Content-Type` header to
// either `multipart/form-data` or `application/octet-stream`.
//
//   - name: API proxy revision to update in the following format:
//     `organizations/{org}/apis/{api}/revisions/{rev}`.
func (r *OrganizationsApisRevisionsService) UpdateApiProxyRevision(name string, googleapihttpbody *GoogleApiHttpBody) *OrganizationsApisRevisionsUpdateApiProxyRevisionCall {
	c := &OrganizationsApisRevisionsUpdateApiProxyRevisionCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googleapihttpbody = googleapihttpbody
	return c
}

// Validate sets the optional parameter "validate": Ignored. All uploads
// are validated regardless of the value of this field. Maintained for
// compatibility with Apigee Edge API.
func (c *OrganizationsApisRevisionsUpdateApiProxyRevisionCall) Validate(validate bool) *OrganizationsApisRevisionsUpdateApiProxyRevisionCall {
	c.urlParams_.Set("validate", fmt.Sprint(validate))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisRevisionsUpdateApiProxyRevisionCall) Fields(s ...googleapi.Field) *OrganizationsApisRevisionsUpdateApiProxyRevisionCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisRevisionsUpdateApiProxyRevisionCall) Context(ctx context.Context) *OrganizationsApisRevisionsUpdateApiProxyRevisionCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisRevisionsUpdateApiProxyRevisionCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisRevisionsUpdateApiProxyRevisionCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googleapihttpbody)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.revisions.updateApiProxyRevision" call.
// Exactly one of *GoogleCloudApigeeV1ApiProxyRevision or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1ApiProxyRevision.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApisRevisionsUpdateApiProxyRevisionCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ApiProxyRevision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ApiProxyRevision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an existing API proxy revision by uploading the API proxy configuration bundle as a zip file from your local machine. You can update only API proxy revisions that have never been deployed. After deployment, an API proxy revision becomes immutable, even if it is undeployed. Set the `Content-Type` header to either `multipart/form-data` or `application/octet-stream`.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/revisions/{revisionsId}",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.apis.revisions.updateApiProxyRevision",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. API proxy revision to update in the following format: `organizations/{org}/apis/{api}/revisions/{rev}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/revisions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "validate": {
	//       "description": "Ignored. All uploads are validated regardless of the value of this field. Maintained for compatibility with Apigee Edge API.",
	//       "location": "query",
	//       "type": "boolean"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleApiHttpBody"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ApiProxyRevision"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.apis.revisions.deployments.list":

type OrganizationsApisRevisionsDeploymentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all deployments of an API proxy revision.
//
//   - parent: Name of the API proxy revision for which to return
//     deployment information in the following format:
//     `organizations/{org}/apis/{api}/revisions/{rev}`.
func (r *OrganizationsApisRevisionsDeploymentsService) List(parent string) *OrganizationsApisRevisionsDeploymentsListCall {
	c := &OrganizationsApisRevisionsDeploymentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsApisRevisionsDeploymentsListCall) Fields(s ...googleapi.Field) *OrganizationsApisRevisionsDeploymentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsApisRevisionsDeploymentsListCall) IfNoneMatch(entityTag string) *OrganizationsApisRevisionsDeploymentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsApisRevisionsDeploymentsListCall) Context(ctx context.Context) *OrganizationsApisRevisionsDeploymentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsApisRevisionsDeploymentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsApisRevisionsDeploymentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/deployments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.apis.revisions.deployments.list" call.
// Exactly one of *GoogleCloudApigeeV1ListDeploymentsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListDeploymentsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsApisRevisionsDeploymentsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListDeploymentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListDeploymentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all deployments of an API proxy revision.",
	//   "flatPath": "v1/organizations/{organizationsId}/apis/{apisId}/revisions/{revisionsId}/deployments",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.apis.revisions.deployments.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the API proxy revision for which to return deployment information in the following format: `organizations/{org}/apis/{api}/revisions/{rev}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/apis/[^/]+/revisions/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/deployments",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListDeploymentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.create":

type OrganizationsAppgroupsCreateCall struct {
	s                           *Service
	parent                      string
	googlecloudapigeev1appgroup *GoogleCloudApigeeV1AppGroup
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Create: Creates an AppGroup. Once created, user can register apps
// under the AppGroup to obtain secret key and password. At creation
// time, the AppGroup's state is set as `active`.
//
//   - parent: Name of the Apigee organization in which the AppGroup is
//     created. Use the following structure in your request:
//     `organizations/{org}`.
func (r *OrganizationsAppgroupsService) Create(parent string, googlecloudapigeev1appgroup *GoogleCloudApigeeV1AppGroup) *OrganizationsAppgroupsCreateCall {
	c := &OrganizationsAppgroupsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapigeev1appgroup = googlecloudapigeev1appgroup
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsCreateCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsCreateCall) Context(ctx context.Context) *OrganizationsAppgroupsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1appgroup)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/appgroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.create" call.
// Exactly one of *GoogleCloudApigeeV1AppGroup or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1AppGroup.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAppgroupsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1AppGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1AppGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an AppGroup. Once created, user can register apps under the AppGroup to obtain secret key and password. At creation time, the AppGroup's state is set as `active`.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.appgroups.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the Apigee organization in which the AppGroup is created. Use the following structure in your request: `organizations/{org}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/appgroups",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1AppGroup"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1AppGroup"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.delete":

type OrganizationsAppgroupsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an AppGroup. All app and API keys associations with
// the AppGroup are also removed. **Warning**: This API will permanently
// delete the AppGroup and related artifacts. **Note**: The delete
// operation is asynchronous. The AppGroup app is deleted immediately,
// but its associated resources, such as apps and API keys, may take
// anywhere from a few seconds to a few minutes to be deleted.
//
//   - name: Name of the AppGroup. Use the following structure in your
//     request: `organizations/{org}/appgroups/{app_group_name}`.
func (r *OrganizationsAppgroupsService) Delete(name string) *OrganizationsAppgroupsDeleteCall {
	c := &OrganizationsAppgroupsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsDeleteCall) Context(ctx context.Context) *OrganizationsAppgroupsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.delete" call.
// Exactly one of *GoogleCloudApigeeV1AppGroup or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1AppGroup.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAppgroupsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1AppGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1AppGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an AppGroup. All app and API keys associations with the AppGroup are also removed. **Warning**: This API will permanently delete the AppGroup and related artifacts. **Note**: The delete operation is asynchronous. The AppGroup app is deleted immediately, but its associated resources, such as apps and API keys, may take anywhere from a few seconds to a few minutes to be deleted.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups/{appgroupsId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.appgroups.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the AppGroup. Use the following structure in your request: `organizations/{org}/appgroups/{app_group_name}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/appgroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1AppGroup"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.get":

type OrganizationsAppgroupsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the AppGroup details for the provided AppGroup name in
// the request URI.
//
//   - name: Name of the AppGroup. Use the following structure in your
//     request: `organizations/{org}/appgroups/{app_group_name}`.
func (r *OrganizationsAppgroupsService) Get(name string) *OrganizationsAppgroupsGetCall {
	c := &OrganizationsAppgroupsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsGetCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsAppgroupsGetCall) IfNoneMatch(entityTag string) *OrganizationsAppgroupsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsGetCall) Context(ctx context.Context) *OrganizationsAppgroupsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.get" call.
// Exactly one of *GoogleCloudApigeeV1AppGroup or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1AppGroup.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAppgroupsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1AppGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1AppGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the AppGroup details for the provided AppGroup name in the request URI.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups/{appgroupsId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.appgroups.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the AppGroup. Use the following structure in your request: `organizations/{org}/appgroups/{app_group_name}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/appgroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1AppGroup"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.list":

type OrganizationsAppgroupsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all AppGroups in an organization. A maximum of 1000
// AppGroups are returned in the response if PageSize is not specified,
// or if the PageSize is greater than 1000.
//
//   - parent: Name of the Apigee organization. Use the following
//     structure in your request: `organizations/{org}`.
func (r *OrganizationsAppgroupsService) List(parent string) *OrganizationsAppgroupsListCall {
	c := &OrganizationsAppgroupsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": The filter expression to
// be used to get the list of AppGroups, where filtering can be done on
// status, channelId or channelUri of the app group. Examples:
// filter=status=active", filter=channelId=, filter=channelUri=
func (c *OrganizationsAppgroupsListCall) Filter(filter string) *OrganizationsAppgroupsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": Count of AppGroups a
// single page can have in the response. If unspecified, at most 1000
// AppGroups will be returned. The maximum value is 1000; values above
// 1000 will be coerced to 1000.
func (c *OrganizationsAppgroupsListCall) PageSize(pageSize int64) *OrganizationsAppgroupsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": The starting index
// record for listing the AppGroups.
func (c *OrganizationsAppgroupsListCall) PageToken(pageToken string) *OrganizationsAppgroupsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsListCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsAppgroupsListCall) IfNoneMatch(entityTag string) *OrganizationsAppgroupsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsListCall) Context(ctx context.Context) *OrganizationsAppgroupsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/appgroups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.list" call.
// Exactly one of *GoogleCloudApigeeV1ListAppGroupsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListAppGroupsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsAppgroupsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListAppGroupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListAppGroupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all AppGroups in an organization. A maximum of 1000 AppGroups are returned in the response if PageSize is not specified, or if the PageSize is greater than 1000.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.appgroups.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "The filter expression to be used to get the list of AppGroups, where filtering can be done on status, channelId or channelUri of the app group. Examples: filter=status=active\", filter=channelId=, filter=channelUri=",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "Count of AppGroups a single page can have in the response. If unspecified, at most 1000 AppGroups will be returned. The maximum value is 1000; values above 1000 will be coerced to 1000.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "The starting index record for listing the AppGroups.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the Apigee organization. Use the following structure in your request: `organizations/{org}`.",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/appgroups",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListAppGroupsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsAppgroupsListCall) Pages(ctx context.Context, f func(*GoogleCloudApigeeV1ListAppGroupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "apigee.organizations.appgroups.update":

type OrganizationsAppgroupsUpdateCall struct {
	s                           *Service
	name                        string
	googlecloudapigeev1appgroup *GoogleCloudApigeeV1AppGroup
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// Update: Updates an AppGroup. This API replaces the existing AppGroup
// details with those specified in the request. Include or exclude any
// existing details that you want to retain or delete, respectively.
// Note that the state of the AppGroup should be updated using `action`,
// and not via AppGroup.
//
//   - name: Name of the AppGroup. Use the following structure in your
//     request: `organizations/{org}/appgroups/{app_group_name}`.
func (r *OrganizationsAppgroupsService) Update(name string, googlecloudapigeev1appgroup *GoogleCloudApigeeV1AppGroup) *OrganizationsAppgroupsUpdateCall {
	c := &OrganizationsAppgroupsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1appgroup = googlecloudapigeev1appgroup
	return c
}

// Action sets the optional parameter "action": Activate or de-activate
// the AppGroup by setting the action as `active` or `inactive`. The
// `Content-Type` header must be set to `application/octet-stream`, with
// empty body.
func (c *OrganizationsAppgroupsUpdateCall) Action(action string) *OrganizationsAppgroupsUpdateCall {
	c.urlParams_.Set("action", action)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsUpdateCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsUpdateCall) Context(ctx context.Context) *OrganizationsAppgroupsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1appgroup)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.update" call.
// Exactly one of *GoogleCloudApigeeV1AppGroup or error will be non-nil.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudApigeeV1AppGroup.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAppgroupsUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1AppGroup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1AppGroup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates an AppGroup. This API replaces the existing AppGroup details with those specified in the request. Include or exclude any existing details that you want to retain or delete, respectively. Note that the state of the AppGroup should be updated using `action`, and not via AppGroup.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups/{appgroupsId}",
	//   "httpMethod": "PUT",
	//   "id": "apigee.organizations.appgroups.update",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "action": {
	//       "description": "Activate or de-activate the AppGroup by setting the action as `active` or `inactive`. The `Content-Type` header must be set to `application/octet-stream`, with empty body.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. Name of the AppGroup. Use the following structure in your request: `organizations/{org}/appgroups/{app_group_name}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/appgroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1AppGroup"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1AppGroup"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.apps.create":

type OrganizationsAppgroupsAppsCreateCall struct {
	s                              *Service
	parent                         string
	googlecloudapigeev1appgroupapp *GoogleCloudApigeeV1AppGroupApp
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Create: Creates an app and associates it with an AppGroup. This API
// associates the AppGroup app with the specified API product and
// auto-generates an API key for the app to use in calls to API proxies
// inside that API product. The `name` is the unique ID of the app that
// you can use in API calls.
//
//   - parent: Name of the AppGroup. Use the following structure in your
//     request: `organizations/{org}/appgroups/{app_group_name}`.
func (r *OrganizationsAppgroupsAppsService) Create(parent string, googlecloudapigeev1appgroupapp *GoogleCloudApigeeV1AppGroupApp) *OrganizationsAppgroupsAppsCreateCall {
	c := &OrganizationsAppgroupsAppsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudapigeev1appgroupapp = googlecloudapigeev1appgroupapp
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsAppsCreateCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsAppsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsAppsCreateCall) Context(ctx context.Context) *OrganizationsAppgroupsAppsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsAppsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsAppsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1appgroupapp)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.apps.create" call.
// Exactly one of *GoogleCloudApigeeV1AppGroupApp or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1AppGroupApp.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAppgroupsAppsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1AppGroupApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1AppGroupApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Creates an app and associates it with an AppGroup. This API associates the AppGroup app with the specified API product and auto-generates an API key for the app to use in calls to API proxies inside that API product. The `name` is the unique ID of the app that you can use in API calls.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups/{appgroupsId}/apps",
	//   "httpMethod": "POST",
	//   "id": "apigee.organizations.appgroups.apps.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. Name of the AppGroup. Use the following structure in your request: `organizations/{org}/appgroups/{app_group_name}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/appgroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/apps",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1AppGroupApp"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1AppGroupApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.apps.delete":

type OrganizationsAppgroupsAppsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an AppGroup app. **Note**: The delete operation is
// asynchronous. The AppGroup app is deleted immediately, but its
// associated resources, such as app keys or access tokens, may take
// anywhere from a few seconds to a few minutes to be deleted.
//
//   - name: Name of the AppGroup app. Use the following structure in your
//     request:
//     `organizations/{org}/appgroups/{app_group_name}/apps/{app}`.
func (r *OrganizationsAppgroupsAppsService) Delete(name string) *OrganizationsAppgroupsAppsDeleteCall {
	c := &OrganizationsAppgroupsAppsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsAppsDeleteCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsAppsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsAppsDeleteCall) Context(ctx context.Context) *OrganizationsAppgroupsAppsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsAppsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsAppsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.apps.delete" call.
// Exactly one of *GoogleCloudApigeeV1AppGroupApp or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1AppGroupApp.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAppgroupsAppsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1AppGroupApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1AppGroupApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Deletes an AppGroup app. **Note**: The delete operation is asynchronous. The AppGroup app is deleted immediately, but its associated resources, such as app keys or access tokens, may take anywhere from a few seconds to a few minutes to be deleted.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups/{appgroupsId}/apps/{appsId}",
	//   "httpMethod": "DELETE",
	//   "id": "apigee.organizations.appgroups.apps.delete",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the AppGroup app. Use the following structure in your request: `organizations/{org}/appgroups/{app_group_name}/apps/{app}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/appgroups/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1AppGroupApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.apps.get":

type OrganizationsAppgroupsAppsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Returns the details for an AppGroup app.
//
//   - name: Name of the AppGroup app. Use the following structure in your
//     request:
//     `organizations/{org}/appgroups/{app_group_name}/apps/{app}`.
func (r *OrganizationsAppgroupsAppsService) Get(name string) *OrganizationsAppgroupsAppsGetCall {
	c := &OrganizationsAppgroupsAppsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsAppsGetCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsAppsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsAppgroupsAppsGetCall) IfNoneMatch(entityTag string) *OrganizationsAppgroupsAppsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsAppsGetCall) Context(ctx context.Context) *OrganizationsAppgroupsAppsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsAppsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsAppsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.apps.get" call.
// Exactly one of *GoogleCloudApigeeV1AppGroupApp or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1AppGroupApp.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAppgroupsAppsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1AppGroupApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1AppGroupApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Returns the details for an AppGroup app.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups/{appgroupsId}/apps/{appsId}",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.appgroups.apps.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. Name of the AppGroup app. Use the following structure in your request: `organizations/{org}/appgroups/{app_group_name}/apps/{app}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/appgroups/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1AppGroupApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.apps.list":

type OrganizationsAppgroupsAppsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all apps created by an AppGroup in an Apigee
// organization. Optionally, you can request an expanded view of the
// AppGroup apps. Lists all AppGroupApps in an AppGroup. A maximum of
// 1000 AppGroup apps are returned in the response if PageSize is not
// specified, or if the PageSize is greater than 1000.
//
//   - parent: Name of the AppGroup. Use the following structure in your
//     request: `organizations/{org}/appgroups/{app_group_name}`.
func (r *OrganizationsAppgroupsAppsService) List(parent string) *OrganizationsAppgroupsAppsListCall {
	c := &OrganizationsAppgroupsAppsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number
// entries to return. If unspecified, at most 1000 entries will be
// returned.
func (c *OrganizationsAppgroupsAppsListCall) PageSize(pageSize int64) *OrganizationsAppgroupsAppsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Page token. If
// provides, must be a valid AppGroup app returned from a previous call
// that can be used to retrieve the next page.
func (c *OrganizationsAppgroupsAppsListCall) PageToken(pageToken string) *OrganizationsAppgroupsAppsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsAppsListCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsAppsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *OrganizationsAppgroupsAppsListCall) IfNoneMatch(entityTag string) *OrganizationsAppgroupsAppsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsAppsListCall) Context(ctx context.Context) *OrganizationsAppgroupsAppsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsAppsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsAppsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/apps")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.apps.list" call.
// Exactly one of *GoogleCloudApigeeV1ListAppGroupAppsResponse or error
// will be non-nil. Any non-2xx status code is an error. Response
// headers are in either
// *GoogleCloudApigeeV1ListAppGroupAppsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *OrganizationsAppgroupsAppsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1ListAppGroupAppsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1ListAppGroupAppsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Lists all apps created by an AppGroup in an Apigee organization. Optionally, you can request an expanded view of the AppGroup apps. Lists all AppGroupApps in an AppGroup. A maximum of 1000 AppGroup apps are returned in the response if PageSize is not specified, or if the PageSize is greater than 1000.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups/{appgroupsId}/apps",
	//   "httpMethod": "GET",
	//   "id": "apigee.organizations.appgroups.apps.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "Optional. Maximum number entries to return. If unspecified, at most 1000 entries will be returned.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "Optional. Page token. If provides, must be a valid AppGroup app returned from a previous call that can be used to retrieve the next page.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. Name of the AppGroup. Use the following structure in your request: `organizations/{org}/appgroups/{app_group_name}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/appgroups/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+parent}/apps",
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1ListAppGroupAppsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OrganizationsAppgroupsAppsListCall) Pages(ctx context.Context, f func(*GoogleCloudApigeeV1ListAppGroupAppsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "apigee.organizations.appgroups.apps.update":

type OrganizationsAppgroupsAppsUpdateCall struct {
	s                              *Service
	name                           string
	googlecloudapigeev1appgroupapp *GoogleCloudApigeeV1AppGroupApp
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// Update: Updates the details for an AppGroup app. In addition, you can
// add an API product to an AppGroup app and automatically generate an
// API key for the app to use when calling APIs in the API product. If
// you want to use an existing API key for the API product, add the API
// product to the API key using the UpdateAppGroupAppKey API. Using this
// API, you cannot update the app name, as it is the primary key used to
// identify the app and cannot be changed. This API replaces the
// existing attributes with those specified in the request. Include or
// exclude any existing attributes that you want to retain or delete,
// respectively.
//
//   - name: Name of the AppGroup app. Use the following structure in your
//     request:
//     `organizations/{org}/appgroups/{app_group_name}/apps/{app}`.
func (r *OrganizationsAppgroupsAppsService) Update(name string, googlecloudapigeev1appgroupapp *GoogleCloudApigeeV1AppGroupApp) *OrganizationsAppgroupsAppsUpdateCall {
	c := &OrganizationsAppgroupsAppsUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudapigeev1appgroupapp = googlecloudapigeev1appgroupapp
	return c
}

// Action sets the optional parameter "action": Approve or revoke the
// consumer key by setting this value to `approve` or `revoke`. The
// `Content-Type` header must be set to `application/octet-stream`, with
// empty body.
func (c *OrganizationsAppgroupsAppsUpdateCall) Action(action string) *OrganizationsAppgroupsAppsUpdateCall {
	c.urlParams_.Set("action", action)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *OrganizationsAppgroupsAppsUpdateCall) Fields(s ...googleapi.Field) *OrganizationsAppgroupsAppsUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *OrganizationsAppgroupsAppsUpdateCall) Context(ctx context.Context) *OrganizationsAppgroupsAppsUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *OrganizationsAppgroupsAppsUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OrganizationsAppgroupsAppsUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/"+internal.Version)
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.googlecloudapigeev1appgroupapp)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "apigee.organizations.appgroups.apps.update" call.
// Exactly one of *GoogleCloudApigeeV1AppGroupApp or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *GoogleCloudApigeeV1AppGroupApp.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *OrganizationsAppgroupsAppsUpdateCall) Do(opts ...googleapi.CallOption) (*GoogleCloudApigeeV1AppGroupApp, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudApigeeV1AppGroupApp{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Updates the details for an AppGroup app. In addition, you can add an API product to an AppGroup app and automatically generate an API key for the app to use when calling APIs in the API product. If you want to use an existing API key for the API product, add the API product to the API key using the UpdateAppGroupAppKey API. Using this API, you cannot update the app name, as it is the primary key used to identify the app and cannot be changed. This API replaces the existing attributes with those specified in the request. Include or exclude any existing attributes that you want to retain or delete, respectively.",
	//   "flatPath": "v1/organizations/{organizationsId}/appgroups/{appgroupsId}/apps/{appsId}",
	//   "httpMethod": "PUT",
	//   "id": "apigee.organizations.appgroups.apps.update",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "action": {
	//       "description": "Approve or revoke the consumer key by setting this value to `approve` or `revoke`. The `Content-Type` header must be set to `application/octet-stream`, with empty body.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "name": {
	//       "description": "Required. Name of the AppGroup app. Use the following structure in your request: `organizations/{org}/appgroups/{app_group_name}/apps/{app}`",
	//       "location": "path",
	//       "pattern": "^organizations/[^/]+/appgroups/[^/]+/apps/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v1/{+name}",
	//   "request": {
	//     "$ref": "GoogleCloudApigeeV1AppGroupApp"
	//   },
	//   "response": {
	//     "$ref": "GoogleCloudApigeeV1AppGroupApp"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "apigee.organizations.appgroups.apps.keys.create":

type OrganizationsAppgroupsAppsKeysCreateCall struct {
	s                                 *Service
	parent                            string
	googlecloudapigeev1appgroupappkey *GoogleCloudApigeeV1AppGroupAppKey
	urlParams_                        gensupport.URLParams
	ctx_                              context.Context
	header_                           http.Header
}

// Create: Creates a custom consumer key and secret for a AppGroup app.
// This is particularly useful if you want to migrate existing consumer
// keys and secrets to Apigee from another system. Consumer keys and
// secrets can contain letters, numbers, underscores, and hyphens. No
// other specia